<?php
/**
 * Widget BookingForm.
 *
 * @since 1.0.0
 *
 * @package MEC_FES_Builder
 */

namespace MEC_FES_Builder\Widgets;

defined( 'ABSPATH' ) || exit;

use MEC\FES\FormBuilder;

/**
 * BookingForm class
 *
 * @version 1.0.0
 */
class BookingForm extends FESBuilderBase {

    /**
     * Wrap css selector
     *
     * @since 1.0.0
     *
     * @var string
     */
    public $fes_base_selector = '{{WRAPPER}}';

    /**
     * Return widget name
     *
     * @since 1.0.0
     *
     * @return string
     */
    public function get_name(){

        return 'mec-fes-booking-form';
    }

    /**
     * Return widget title
     *
     * @since 1.0.0
     *
     * @return string
     */
    public function get_title(){

        return __( 'Booking Form', MECFBTEXTDOMAIN );
    }

    /**
     * Return icon class css
     *
     * @since 1.0.0
     *
     * @return void
     */
	public function get_icon() {

        return 'eicon-product-price';
    }

    /**
     * Return categories
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_categories() {

        return array( 'FES_Builder' );
    }

    /**
     * Return scripts
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_script_depends() {

        $scripts = array();
        if( class_exists( \MEC_Waiting_List\MEC_Waiting_Base::class ) ){

            $scripts[] = 'waiting-list-backend-js';
        }

        return $scripts;
    }

    /**
     * Return styles
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_style_depends() {

        $styles = array();
        if( class_exists( \MEC_Waiting_List\MEC_Waiting_Base::class ) ){

            $styles[] = 'waiting-list-backend-css';
        }

        return $styles;
    }

    /**
     * Register controls
     *
     * @since 1.0.0
     *
     * @return void
     */
	protected function register_controls() {

        $base_selector = $this->fes_base_selector;

        $this->register_box_styles();
        $this->register_header_styles(
            'header_',
            "{$base_selector} h4",
            "{$base_selector} h4:hover",
            __( 'Header', MECFBTEXTDOMAIN )
        );
        $this->register_header_styles(
            'subtitle_',
            "{$base_selector} .mec-form-subtitle",
            "{$base_selector} .mec-form-subtitle:hover",
            __( 'Subtitle', MECFBTEXTDOMAIN )
        );

        $this->register_checkbox_styles();
        $this->register_checkbox_label_styles();

        $this->register_label_styles(
            'label_',
            "{$base_selector} #mec_reg_form_fields .mec_reg_field_type, {$base_selector} #mec_bfixed_form_fields .mec_bfixed_field_type, {$base_selector} #mec_waiting_form_fields .mec_waiting_field_type",
            "{$base_selector} #mec_reg_form_fields .mec_reg_field_type:hover, {$base_selector} #mec_bfixed_form_fields .mec_bfixed_field_type:hover, {$base_selector} #mec_waiting_form_fields .mec_waiting_field_type:hover",
            __( 'Label', MECFBTEXTDOMAIN )
        );

        $this->register_icon_styles(
            'label_icon_',
            "{$base_selector} #mec_reg_form_fields .mec_reg_field_sort::before, {$base_selector} #mec_bfixed_form_fields .mec_bfixed_field_sort::before, {$base_selector} #mec_waiting_form_fields .mec_waiting_field_sort::before",
            "{$base_selector} #mec_reg_form_fields .mec_reg_field_sort::before:hover, {$base_selector} #mec_bfixed_form_fields .mec_bfixed_field_sort::before:hover, {$base_selector} #mec_waiting_form_fields .mec_waiting_field_sort::before:hover",
            __( 'Label icon', MECFBTEXTDOMAIN )
        );

        $this->register_input_styles();
        $this->register_select_styles();

        $this->register_button_styles(
            'remove_field_button_',
            "{$base_selector} ul#mec_reg_form_fields li .mec_reg_field_remove, {$base_selector} .mec_bfixed_field_remove, {$base_selector} .mec_waiting_field_remove",
            "{$base_selector} ul#mec_reg_form_fields li .mec_reg_field_remove:hover, {$base_selector} .mec_bfixed_field_remove:hover, {$base_selector} .mec_waiting_field_remove:hover",
            __( 'Remove field button', MECFBTEXTDOMAIN )
        );

        $this->register_button_styles(
            'add_field_button_',
            "{$base_selector} #mec_reg_form_field_types button, {$base_selector} #mec_bfixed_form_field_types button, {$base_selector} #mec_waiting_form_field_types button",
            "{$base_selector} #mec_reg_form_field_types .button:hover, {$base_selector} #mec_bfixed_form_field_types button:hover, {$base_selector} #mec_waiting_form_field_types button:hover",
            __( 'Add field button', MECFBTEXTDOMAIN )
        );

        $this->register_button_styles(
            'add_field_button_used_',
            "{$base_selector} #mec_reg_form_field_types .button.red, {$base_selector} #mec_bfixed_form_field_types .button.red, {$base_selector} #mec_waiting_form_field_types .button.red",
            "{$base_selector} #mec_reg_form_field_types .button.red:hover, {$base_selector} #mec_bfixed_form_field_types .button.red:hover, {$base_selector} #mec_waiting_form_field_types .button.red:hover",
            __( 'Add field button(Email and Name)', MECFBTEXTDOMAIN )
        );

        $this->register_icon_styles(
            'add_field_button_icon_',
            "{$base_selector} #mec_reg_form_field_types button::before, {$base_selector} #mec_bfixed_form_field_types button::before, {$base_selector} #mec_waiting_form_field_types button::before",
            "{$base_selector} #mec_reg_form_field_types button::before:hover, {$base_selector} #mec_bfixed_form_field_types button::before:hover, {$base_selector} #mec_waiting_form_field_types button::before:hover",
            __( 'Add field button icon', MECFBTEXTDOMAIN )
        );

        $this->register_button_styles(
            'add_option_field_button_',
            "{$base_selector} button.mec-reg-field-add-option, {$base_selector} button.mec-bfixed-field-add-option, {$base_selector} button.mec-waiting-field-add-option",
            "{$base_selector} button.mec-reg-field-add-option:hover, {$base_selector} button.mec-bfixed-field-add-option:hover, {$base_selector} button.mec-waiting-field-add-option:hover",
            __( 'Add option field button', MECFBTEXTDOMAIN )
        );

        $this->register_icon_styles(
            'add_option_field_button_icon_',
            "{$base_selector} button.mec-reg-field-add-option::before, {$base_selector} button.mec-bfixed-field-add-option::before, {$base_selector} button.mec-waiting-field-add-option::before",
            "{$base_selector} button.mec-reg-field-add-option::before:hover, {$base_selector} button.mec-bfixed-field-add-option::before:hover, {$base_selector} button.mec-waiting-field-add-option::before:hover",
            __( 'Add option field button icon', MECFBTEXTDOMAIN )
        );

        $this->register_label_styles(
            'label_bp_',
            "{$base_selector} .mec_bfixed_notification_placeholder",
            "{$base_selector} .mec_bfixed_notification_placeholder:hover",
            __( 'Notification placeholder', MECFBTEXTDOMAIN )
        );

    }

    /**
     * Render widget output
     *
     * @since 1.0.0
     *
     * @return void
     */
	protected function render() {

        $settings = $this->get_settings_for_display();

        $post = $this->get_post();

        $this->wrap_start();

        $atts = array(
            'is_edit_mode' => $this->is_edit_mode(),
        );

        FormBuilder::booking_form( $post, $atts );

        $this->wrap_end();
    }
}

