<?php
/**
 * Widget DateTime.
 *
 * @since 1.0.0
 *
 * @package MEC_FES_Builder
 */

namespace MEC_FES_Builder\Widgets;

defined( 'ABSPATH' ) || exit;

use MEC\FES\FormBuilder;

/**
 * DateTime class
 *
 * @version 1.0.0
 */
class DateTime extends FESBuilderBase {

    /**
     * Wrap css selector
     *
     * @since 1.0.0
     *
     * @var string
     */
    public $fes_base_selector = '{{WRAPPER}} #mec-date-time';

    /**
     * Return widget name
     *
     * @since 1.0.0
     *
     * @return string
     */
    public function get_name(){

        return 'mec-fes-datetime';
    }

    /**
     * Return widget title
     *
     * @since 1.0.0
     *
     * @return string
     */
    public function get_title(){

        return __( 'Date Time', MECFBTEXTDOMAIN );
    }

    /**
     * Return icon class css
     *
     * @since 1.0.0
     *
     * @return void
     */
	public function get_icon() {

        return 'mec-fa-calendar';
    }

    /**
     * Return categories
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_categories() {

        return array( 'FES_Builder' );
    }

    /**
     * Return scripts
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_script_depends() {

        return array();
    }

    /**
     * Return styles
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_style_depends() {

        return array();
    }

    /**
     * Register controls
     *
     * @since 1.0.0
     *
     * @return void
     */
	protected function register_controls() {

        $time_format = \MEC\Settings\Settings::getInstance()->get_settings('time_format');
        $datepicker_format = \MEC\Settings\Settings::getInstance()->get_settings('datepicker_format');

        $base_selector = $this->fes_base_selector;

        $this->start_controls_section(
			'general_section',
			array(
				'label'     => __( 'General'),
				'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
			)
		);

        $current_time = current_time('timestamp', 0);
        $this->add_control(
			'time_format',
			array(
                'label' => __( 'Time format', MECFBTEXTDOMAIN ),
                'type'    => \Elementor\Controls_Manager::SELECT,
                'options' => array(
                    '12' => __( '12 hours format with AM/PM', MECFBTEXTDOMAIN ),
                    '24' => __( '24 hours format', MECFBTEXTDOMAIN ),
                ),
                'default' => $time_format,
            )
		);

        $this->add_control(
			'datepicker_format',
			array(
                'label' => __( 'Time format', MECFBTEXTDOMAIN ),
                'type'    => \Elementor\Controls_Manager::SELECT,
                'options' => array(
                    'yy-mm-dd&Y-m-d' => date('Y-m-d', $current_time) . ' ' . esc_html__('(Y-m-d)', MECFBTEXTDOMAIN),
                    'dd-mm-yy&d-m-Y' => date('d-m-Y', $current_time) . ' ' . esc_html__('(d-m-Y)', MECFBTEXTDOMAIN),
                    'yy/mm/dd&Y/m/d' => date('Y/m/d', $current_time) . ' ' . esc_html__('(Y/m/d)', MECFBTEXTDOMAIN),
                    'mm/dd/yy&m/d/Y' => date('m/d/Y', $current_time) . ' ' . esc_html__('(m/d/Y)', MECFBTEXTDOMAIN),
                    'yy.mm.dd&Y.m.d' => date('Y.m.d', $current_time) . ' ' . esc_html__('(Y.m.d)', MECFBTEXTDOMAIN),
                    'dd.mm.yy&d.m.Y' => date('d.m.Y', $current_time) . ' ' . esc_html__('(d.m.Y)', MECFBTEXTDOMAIN),
                ),
                'default' => $datepicker_format,
            )
		);

		$this->end_controls_section();

        $this->register_box_styles();
        $this->register_header_styles();
        $this->register_header_styles(
            'sub_header_',
            "{$base_selector} #mec_meta_box_repeat_form h4",
            "{$base_selector} #mec_meta_box_repeat_form h4:hover",
            __( 'Repeating header', MECFBTEXTDOMAIN )
        );
        $this->register_label_styles(
            'label_',
            "{$base_selector} label:not([type=checkbox]~label):not([type=radio]~label):not(.label-checkbox)",
            "{$base_selector} label:not([type=checkbox]~label):not([type=radio]~label):not(.label-checkbox):hover",
            null,
            '',
            array()
        );
        $this->register_icon_styles();
        $this->register_input_styles();
        $this->register_select_styles();

        $this->register_checkbox_label_styles();
        $this->register_checkbox_styles();

        $this->register_radio_label_styles();
        $this->register_radio_styles();

        $this->register_paragraph_styles(
            'description_',
            "{$base_selector} .description",
            "{$base_selector} .description:hover",
            __( 'Description', MECFBTEXTDOMAIN )
        );

        $this->register_button_styles();

        $this->register_ul_styles(
            'primary_ul_',
            "{$base_selector} #mec-advanced-wraper .mec-form-row > ul",
            "{$base_selector} #mec-advanced-wraper .mec-form-row > ul:hover",
            __( 'Week row', MECFBTEXTDOMAIN )
        );

        $this->register_li_styles(
            'week_label_',
            "{$base_selector} #mec-advanced-wraper .mec-form-row > ul > li:first-child",
            "{$base_selector} #mec-advanced-wraper .mec-form-row > ul > li:first-child:hover",
            __( 'Week label', MECFBTEXTDOMAIN )
        );

        $this->register_li_styles(
            'week_day_',
            "{$base_selector} #mec-advanced-wraper .mec-form-row > ul > ul > li",
            "{$base_selector} #mec-advanced-wraper .mec-form-row > ul > ul > li:hover",
            __( 'Week day', MECFBTEXTDOMAIN )
        );

        $this->register_li_styles(
            'week_day_active_',
            "{$base_selector} #mec-advanced-wraper .mec-form-row > ul > ul > li.mec-active",
            "{$base_selector} #mec-advanced-wraper .mec-form-row > ul > ul > li.mec-active:hover",
            __( 'Week day active', MECFBTEXTDOMAIN ),
            '',
            array(
                'week_day_active_color' => array(
                    'important' => true,
                ),
                'week_day_active_hover_color' => array(
                    'important' => true,
                ),
            )
        );

        $this->register_general_styles(
            'advanced_days_week_',
            "{$base_selector} #mec-advanced-wraper .mec-form-row > ul > ul > li",
            "{$base_selector} #mec-advanced-wraper .mec-form-row > ul > ul > li:hover",
            __( 'Advanced Days Week', MECFBTEXTDOMAIN )
        );

        $this->register_general_styles(
            'tooltip_box_',
            "{$base_selector} .mec-tooltip .box",
            "{$base_selector} ..mec-tooltip .box:hover",
            __( 'Tooltip Box', MECFBTEXTDOMAIN )
        );
        $this->register_general_styles(
            'tooltip_title_',
            "{$base_selector} .mec-tooltip .box h5",
            "{$base_selector} ..mec-tooltip .box h5:hover",
            __( 'Tooltip Title', MECFBTEXTDOMAIN )
        );
        $this->register_general_styles(
            'tooltip_content_',
            "{$base_selector} .mec-tooltip .box p",
            "{$base_selector} ..mec-tooltip .box p:hover",
            __( 'Tooltip Content', MECFBTEXTDOMAIN )
        );
    }

    /**
     * Render widget output
     *
     * @since 1.0.0
     *
     * @return void
     */
	protected function render() {

        $settings = $this->get_settings_for_display();

        $post = $this->get_post();

        $this->wrap_start();

        $time_format = \MEC\Settings\Settings::getInstance()->get_settings('time_format');
        $datepicker_format = \MEC\Settings\Settings::getInstance()->get_settings('datepicker_format');

        $atts = array(
            'is_edit_mode' => $this->is_edit_mode(),
            'time_format' => $settings['time_format'] ?? $time_format,
            'datepicker_format' => $settings['datepicker_format'] ?? $datepicker_format,
        );

        FormBuilder::datetime( $post, $atts );

        $this->wrap_end();
    }
}
