<?php
/**
 * Widget Description.
 *
 * @since 1.0.0
 *
 * @package MEC_FES_Builder
 */

namespace MEC_FES_Builder\Widgets;

defined( 'ABSPATH' ) || exit;

use MEC\FES\FormBuilder;

/**
 * Description class
 *
 * @version 1.0.0
 */
class Description extends FESBuilderBase {

    /**
     * Wrap css selector
     *
     * @since 1.0.0
     *
     * @var string
     */
    public $fes_base_selector = '{{WRAPPER}} .mec-form-row';

    /**
     * Return widget name
     *
     * @since 1.0.0
     *
     * @return string
     */
    public function get_name(){

        return 'mec-fes-description';
    }

    /**
     * Return widget title
     *
     * @since 1.0.0
     *
     * @return string
     */
    public function get_title(){

        return __( 'Description', MECFBTEXTDOMAIN );
    }

    /**
     * Return icon class css
     *
     * @since 1.0.0
     *
     * @return void
     */
	public function get_icon() {

        return 'mec-fa-align-justify';
    }

    /**
     * Return categories
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_categories() {

        return array( 'FES_Builder' );
    }

    /**
     * Return scripts
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_script_depends() {

        return array();
    }

    /**
     * Return styles
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_style_depends() {

        return array();
    }

    /**
     * Register controls
     *
     * @since 1.0.0
     *
     * @return void
     */
	protected function register_controls() {
        $base_selector = $this->fes_base_selector;

        $this->start_controls_section(
			'content_section',
			array(
				'label' => esc_html__('General', MECFBTEXTDOMAIN),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            )
		);

		$this->option_required();

        $this->add_control(
			'textarea_rows',
			array(
                'label' => __( 'Rows', MECFBTEXTDOMAIN ),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'default' => 15,
            )
		);

		$this->end_controls_section();

        $this->register_box_styles(
            'editor_box_',
            "{$base_selector} .mec-fes-editor",
            "{$base_selector} .mec-fes-editor:hover",
            __( 'Editor box', MECFBTEXTDOMAIN )
        );

        $this->register_general_styles(
            'editor_tools_box_',
            "{$base_selector} .wp-editor-tools",
            "{$base_selector} .wp-editor-tools:hover",
            __( 'Editor Tools box', MECFBTEXTDOMAIN )
        );

        $this->register_general_styles(
            'editor_tools_button_',
            "{$base_selector} .wp-editor-tools .wp-media-buttons button",
            "{$base_selector} .wp-editor-tools .wp-media-buttons button:hover",
            __( 'Editor Tools button', MECFBTEXTDOMAIN )
        );

        $this->register_general_styles(
            'editor_tools_tabs_',
            "{$base_selector} .wp-editor-tools .wp-editor-tabs button",
            "{$base_selector} .wp-editor-tools .wp-editor-tabs button:hover",
            __( 'Editor Tools Tabs', MECFBTEXTDOMAIN )
        );

        $this->register_general_styles(
            'editor_toolbar_box_',
            "{$base_selector} .mce-tinymce .mce-toolbar-grp",
            "{$base_selector} .mce-tinymce .mce-toolbar-grp:hover",
            __( 'Editor Toolbar Box', MECFBTEXTDOMAIN )
        );

        $this->register_general_styles(
            'editor_toolbar_icon_',
            "{$base_selector} .mce-tinymce .mce-toolbar-grp .mce-ico",
            "{$base_selector} .mce-tinymce .mce-toolbar-grp .mce-ico:hover",
            __( 'Editor Toolbar Icon', MECFBTEXTDOMAIN )
        );

    }

    /**
     * Render widget output
     *
     * @since 1.0.0
     *
     * @return void
     */
	protected function render() {

        $settings = $this->get_settings_for_display();

        $post = $this->get_post();

        $atts = array(
            'required' => 'yes' === $settings['required'] ? true : false,
            'is_edit_mode' => $this->is_edit_mode(),
            'textarea_rows' => $settings['textarea_rows'] ?? 15,
        );

        $this->wrap_start();

        FormBuilder::editor( $post, $atts );

        $this->wrap_end();
    }
}
