<?php
/**
 * Widget DiscountPerUserRoles.
 *
 * @since 1.0.0
 *
 * @package MEC_FES_Builder
 */

namespace MEC_FES_Builder\Widgets;

defined( 'ABSPATH' ) || exit;

use MEC\FES\FormBuilder;

/**
 * DiscountPerUserRoles class
 *
 * @version 1.0.0
 */
class DiscountPerUserRoles extends FESBuilderBase {

    /**
     * Wrap css selector
     *
     * @since 1.0.0
     *
     * @var string
     */
    public $fes_base_selector = '{{WRAPPER}} #mec-discount-per-user-roles';

    /**
     * Return widget name
     *
     * @since 1.0.0
     *
     * @return string
     */
    public function get_name(){

        return 'mec-fes-discount-per-user-roles';
    }

    /**
     * Return widget title
     *
     * @since 1.0.0
     *
     * @return string
     */
    public function get_title(){

        return __( 'Discount Per User Roles', MECFBTEXTDOMAIN );
    }

    /**
     * Return icon class css
     *
     * @since 1.0.0
     *
     * @return void
     */
	public function get_icon() {

        return 'eicon-user-preferences';
    }

    /**
     * Return categories
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_categories() {

        return array( 'FES_Builder' );
    }

    /**
     * Return scripts
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_script_depends() {

        return array();
    }

    /**
     * Return styles
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_style_depends() {

        return array();
    }

    /**
     * Register controls
     *
     * @since 1.0.0
     *
     * @return void
     */
	protected function register_controls() {

        $base_selector = $this->fes_base_selector;
        $selector = "{$base_selector} .mec-form-row label";
        $hover_selector = "{$base_selector} .mec-form-row label:hover";

        $this->register_box_styles();
        $this->register_header_styles();
        $this->register_label_styles(
            'label_',
            $selector,
            $hover_selector
        );
        $this->register_input_styles();
    }

    /**
     * Render widget output
     *
     * @since 1.0.0
     *
     * @return void
     */
	protected function render() {

        $settings = $this->get_settings_for_display();

        $post = $this->get_post();

        $this->wrap_start();

        $atts = array(
            'is_edit_mode' => $this->is_edit_mode(),
        );

        FormBuilder::discount_per_user_roles( $post, $atts );

        $this->wrap_end();
    }
}
