<?php
/**
 * Widget EventColor.
 *
 * @since 1.0.0
 *
 * @package MEC_FES_Builder
 */

namespace MEC_FES_Builder\Widgets;

defined( 'ABSPATH' ) || exit;

use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use MEC\FES\FormBuilder;

/**
 * EventColor class
 *
 * @version 1.0.0
 */
class EventColor extends FESBuilderBase {

    /**
     * Wrap css selector
     *
     * @since 1.0.0
     *
     * @var string
     */
    public $fes_base_selector = '{{WRAPPER}} #mec-event-color';

    /**
     * Return widget name
     *
     * @since 1.0.0
     *
     * @return string
     */
    public function get_name(){

        return 'mec-fes-event-color';
    }

    /**
     * Return widget title
     *
     * @since 1.0.0
     *
     * @return string
     */
    public function get_title(){

        return __( 'Event Color', MECFBTEXTDOMAIN );
    }

    /**
     * Return icon class css
     *
     * @since 1.0.0
     *
     * @return void
     */
	public function get_icon() {

        return 'eicon-global-colors';
    }

    /**
     * Return categories
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_categories() {

        return array( 'FES_Builder' );
    }

    /**
     * Return scripts
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_script_depends() {

        return array();
    }

    /**
     * Return styles
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_style_depends() {

        return array();
    }

    /**
     * Register controls
     *
     * @since 1.0.0
     *
     * @return void
     */
	protected function register_controls() {

        $this->register_box_styles();
        $this->register_header_styles();
        $this->register_color_styles();
    }

    /**
	 * Register Color Controls for Styles
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function register_color_styles() {

		$group_id      = 'color_';
		$base_selector = $this->fes_base_selector;
		$section_label = __( 'Color', MECFBTEXTDOMAIN );
		$description   = '';

		$selector       = "{$base_selector} .mec-available-color-row > span";
		$hover_selector = "{$base_selector} .mec-available-color-row > span.color-selected";

		$rewrite_settings_fields = array(
            $group_id . 'typography'       => false,
			$group_id . 'hover_typography' => false,
			$group_id . 'color'            => false,
			$group_id . 'hover_color'      => false,
            $group_id . 'background'       => false,
			$group_id . 'hover_background' => false,
        );

		$this->fes_register_styles_controls(
			$group_id,
			$section_label,
			$description,
			$selector,
			$hover_selector,
			$rewrite_settings_fields
		);


        $this->start_controls_section(
            'color_border_selected_section',
            array(
                'label' 	=> __( 'Color Border Selected', MECFBTEXTDOMAIN ),
                'tab'   	=> \Elementor\Controls_Manager::TAB_STYLE,
            )
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' 		=> 'event_color_border_selected',
                'label' 	=> __('Box Shadow', MECFBTEXTDOMAIN),
                'selector' 	=> "{$base_selector} .mec-available-color-row span.color-selected",
            ]
        );

        $this->end_controls_section();
	}

    /**
     * Render widget output
     *
     * @since 1.0.0
     *
     * @return void
     */
	protected function render() {

        $settings = $this->get_settings_for_display();

        $post = $this->get_post();

        $this->wrap_start();

        $atts = array(
            'is_edit_mode' => $this->is_edit_mode(),
        );

        FormBuilder::color( $post, $atts );

        $this->wrap_end();
    }
}
