<?php
/**
 * Widget EventGallery.
 *
 * @since 1.0.0
 *
 * @package MEC_FES_Builder
 */

namespace MEC_FES_Builder\Widgets;

defined( 'ABSPATH' ) || exit;

use MEC\FES\FormBuilder;

/**
 * EventGallery class
 *
 * @version 1.0.0
 */
class EventGallery extends FESBuilderBase {

    /**
     * Wrap css selector
     *
     * @since 1.0.0
     *
     * @var string
     */
    public $fes_base_selector = '{{WRAPPER}} #mec-event-gallery';

    /**
     * Return widget name
     *
     * @since 1.0.0
     *
     * @return string
     */
    public function get_name(){

        return 'mec-fes-event-gallery';
    }

    /**
     * Return widget title
     *
     * @since 1.0.0
     *
     * @return string
     */
    public function get_title(){

        return __( 'Event Gallery', MECFBTEXTDOMAIN );
    }

    /**
     * Return icon class css
     *
     * @since 1.0.0
     *
     * @return void
     */
	public function get_icon() {

        return 'eicon-image-rollover';
    }

    /**
     * Return categories
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_categories() {

        return array( 'FES_Builder' );
    }

    /**
     * Return scripts
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_script_depends() {

        return array();
    }

    /**
     * Return styles
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_style_depends() {

        return array();
    }

    /**
     * Register controls
     *
     * @since 1.0.0
     *
     * @return void
     */
	protected function register_controls() {

        $base_selector = $this->fes_base_selector;

        $this->register_box_styles();
        $this->register_header_styles();
        $this->register_input_styles(
            'file_input_',
            "{$base_selector} #mec_event_gallery_image_uploader",
            "{$base_selector} #mec_event_gallery_image_uploader:hover",
            __( 'File input', MECFBTEXTDOMAIN )
        );
        $this->register_paragraph_styles(
            'description_',
            "{$base_selector} .description",
            "{$base_selector} .description:hover",
            __( 'Description', MECFBTEXTDOMAIN )
        );

        $this->register_ul_styles(
            'images_wrap_',
            "{$base_selector} #mec_meta_box_event_gallery",
            "{$base_selector} #mec_meta_box_event_gallery:hover",
            __( 'Images box', MECFBTEXTDOMAIN )
        );

        $this->register_li_styles(
            'week_label_',
            "{$base_selector} #mec_meta_box_event_gallery img",
            "{$base_selector} #mec_meta_box_event_gallery img:hover",
            __( 'Image', MECFBTEXTDOMAIN )
        );

        // $this->register_icon_styles(
        //     'remove_icon_',
        //     "{$base_selector} #mec_meta_box_event_gallery .mec-event-gallery-delete::before",
        //     "{$base_selector} #mec_meta_box_event_gallery .mec-event-gallery-delete::before:hover",
        //     __( 'Remove icon', MECFBTEXTDOMAIN )
        // );
    }

    /**
     * Render widget output
     *
     * @since 1.0.0
     *
     * @return void
     */
	protected function render() {

        $settings = $this->get_settings_for_display();

        $post = $this->get_post();

        $this->wrap_start();

        $atts = array(
            'is_edit_mode' => $this->is_edit_mode(),
        );

        wp_enqueue_media();

        FormBuilder::event_gallery( $post, $atts );

        $this->wrap_end();
    }
}
