<?php
/**
 * FES Builder Widget Base.
 *
 * @since 1.0.0
 *
 * @package MEC_FES_Builder
 */

namespace MEC_FES_Builder\Widgets;

defined( 'ABSPATH' ) || exit;

/**
 * FESBuilderBase class
 *
 * @version 1.0.0
 */
abstract class FESBuilderBase extends WidgetBase {

    /**
     * Wrap css selector
     *
     * @since 1.0.0
     *
     * @var string
     */
    public $fes_base_selector = '{{WRAPPER}}';

    /**
     * Return last event
     *
     * @since 1.0.0
     *
	 * @return WP_Post
	 */
	public function get_last_event(){

		global $MEC_FES_Last_Event;
		if(!$MEC_FES_Last_Event){

            $events = get_posts(array(
                'post_type' => 'mec-events',
                'posts_per_page' => 1,
                'numberposts' => 1,
            ));

			$MEC_FES_Last_Event = current( $events );
		}

		return $MEC_FES_Last_Event;
	}

    /**
	 * Get Event ID
     *
     * @since 1.0.0
	 *
	 * @return int|false
	 */
    public function get_event_id(){

        $editor_mode = $this->is_edit_mode();

        $event_id = false;
        if( $editor_mode ){

			$last_event = $this->get_last_event();
			$event_id = isset( $last_event->ID ) ? $last_event->ID : 0;
		}elseif( 'mec-events' === get_post_type()){//TODO: develop for front

			$event_id = get_the_ID();
		}

		return apply_filters( 'mec_fes_builder_get_event_id_for_widget', $event_id, $editor_mode );
    }

    /**
     * Return post
     *
     * @since 1.0.0
     *
     * @return \WP_Post
     */
    public function get_post(){

        if( $this->is_edit_mode() ){

            $event_id = $this->get_event_id();

        }else{

			$event_id = isset($_GET['post_id']) ? sanitize_text_field($_GET['post_id']) : -1;
        }

		if( $event_id > 0 && 'mec-events' === get_post_type( $event_id ) ){

			$post = get_post( $event_id );
		}else{

			$post = new \stdClass();
			$post->ID = -1;
		}

		return $post;
    }

    /**
     * Wrap start
     *
     * @since 1.0.0
     *
     * @return void
     */
    public function wrap_start(){
        if( !$this->is_edit_mode() ){

            return;
        }

        echo '<div class="mec-fes-form">';
    }

    /**
     * Wrap end
     *
     * @since 1.0.0
     *
     * @return void
     */
    public function wrap_end(){

        if( !$this->is_edit_mode() ){

            return;
        }

        echo '</div>';
    }

	/**
	 * Register Box Controls for Styles
	 *
	 * @param string $group_id
	 * @param string $selector
	 * @param string $hover_selector
	 * @param string $section_label
	 * @param string $description
	 * @param array|null $rewrite_settings_fields
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function register_general_styles( $group_id, $selector, $hover_selector, $section_label, $description = '', $rewrite_settings_fields = null ) {

		if( is_null( $rewrite_settings_fields ) ){

			$rewrite_settings_fields = array();
		}

		$this->fes_register_styles_controls(
			$group_id,
			$section_label,
			$description,
			$selector,
			$hover_selector,
			$rewrite_settings_fields
		);
	}


    /**
	 * Register Box Controls for Styles
	 *
	 * @param string $group_id
	 * @param string|null $selector
	 * @param string|null $hover_selector
	 * @param string|null $section_label
	 * @param string $description
	 * @param array|null $rewrite_settings_fields
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function register_box_styles( $group_id = 'box_', $selector = null, $hover_selector = null, $section_label = null, $description = '', $rewrite_settings_fields = null ) {

		$base_selector = $this->fes_base_selector;

		if( is_null( $section_label ) ){

			$section_label = __( 'Box', MECFBTEXTDOMAIN );
		}

		if( is_null( $selector ) ){

			$selector = $base_selector;
		}

		if( is_null( $hover_selector ) ){

			$hover_selector = $selector . ':hover';
		}

		if( is_null( $rewrite_settings_fields ) ){

			$rewrite_settings_fields = array(
				$group_id . 'text_align'       => array(
					'type' => 'text_align',
				),
				$group_id . 'typography'       => false,
				$group_id . 'hover_typography' => false,
				$group_id . 'color'            => false,
				$group_id . 'hover_color'      => false,
			);
		}

		$this->fes_register_styles_controls(
			$group_id,
			$section_label,
			$description,
			$selector,
			$hover_selector,
			$rewrite_settings_fields
		);
	}

    /**
	 * Register Header Controls for Styles
	 *
	 * @param string $group_id
	 * @param string|null $selector
	 * @param string|null $hover_selector
	 * @param string|null $section_label
	 * @param string $description
	 * @param array|null $rewrite_settings_fields
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function register_header_styles( $group_id = 'header_', $selector = null, $hover_selector = null, $section_label = null, $description = '', $rewrite_settings_fields = null ) {

		$base_selector = $this->fes_base_selector;

		if( is_null( $section_label ) ){

			$section_label = __( 'Header', MECFBTEXTDOMAIN );
		}

		if( is_null( $selector ) ){

			$selector = $base_selector . ' > h4';
		}

		if( is_null( $hover_selector ) ){

			$hover_selector = $base_selector . ' > h4:hover';
		}

		if( is_null( $rewrite_settings_fields ) ){

			$rewrite_settings_fields = array(

				$group_id . 'show_hide' => array(
					'type' => 'show_hide',
				)
			);
		}

		$this->fes_register_styles_controls(
			$group_id,
			$section_label,
			$description,
			$selector,
			$hover_selector,
			$rewrite_settings_fields
		);
	}

    /**
	 * Register Input Label Controls for Styles
	 *
	 * @param string $group_id
	 * @param string|null $selector
	 * @param string|null $hover_selector
	 * @param string|null $section_label
	 * @param string $description
	 * @param array|null $rewrite_settings_fields
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function register_input_label_styles( $group_id = 'input_label_', $selector = null, $hover_selector = null, $section_label = null, $description = '', $rewrite_settings_fields = null ) {

		$base_selector = $this->fes_base_selector;

		if( is_null( $section_label ) ){

			$section_label = __( 'Input Label', MECFBTEXTDOMAIN );
		}

		if( is_null( $selector ) ){

			$selector = $base_selector . ' > label';
		}

		if( is_null( $hover_selector ) ){

			$hover_selector = $base_selector . ' > label:hover';
		}

		if( is_null( $rewrite_settings_fields ) ){

			$rewrite_settings_fields = array();
		}

		$this->fes_register_styles_controls(
			$group_id,
			$section_label,
			$description,
			$selector,
			$hover_selector,
			$rewrite_settings_fields
		);
	}

    /**
	 * Register Input Controls for Styles
	 *
	 * @param string $group_id
	 * @param string|null $selector
	 * @param string|null $hover_selector
	 * @param string|null $section_label
	 * @param string $description
	 * @param array|null $rewrite_settings_fields
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function register_input_styles( $group_id = 'input_', $selector = null, $hover_selector = null, $section_label = null, $description = '', $rewrite_settings_fields = null ) {

		$base_selector = $this->fes_base_selector;

		if( is_null( $section_label ) ){

			$section_label = __( 'Input', MECFBTEXTDOMAIN );
		}

		if( is_null( $selector ) ){

			$selector = "{$base_selector} input:not([type=radio]):not([type=checkbox])";
		}

		if( is_null( $hover_selector ) ){

			$hover_selector = "{$base_selector} input:not([type=radio]):not([type=checkbox]):hover";
		}

		if( is_null( $rewrite_settings_fields ) ){

			$rewrite_settings_fields = array(
				$group_id . 'width' => array(
					'type' => 'width',
				),
				$group_id . 'min_width' => array(
					'type' => 'min_width',
				),
				$group_id . 'max_width' => array(
					'type' => 'max_width',
				),
				$group_id . 'height' => array(
					'type' => 'height',
				),
				$group_id . 'min_height' => array(
					'type' => 'min_height',
				),
				$group_id . 'max_height' => array(
					'type' => 'max_height',
				),
			);
		}

		$this->fes_register_styles_controls(
			$group_id,
			$section_label,
			$description,
			$selector,
			$hover_selector,
			$rewrite_settings_fields
		);
	}

	/**
	 * Register Paragraph Controls for Styles
	 *
	 * @param string $group_id
	 * @param string|null $selector
	 * @param string|null $hover_selector
	 * @param string|null $section_label
	 * @param string $description
	 * @param array|null $rewrite_settings_fields
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function register_paragraph_styles( $group_id = 'paragraph_', $selector = null, $hover_selector = null, $section_label = null, $description = '', $rewrite_settings_fields = null ) {

		$base_selector = $this->fes_base_selector;

		if( is_null( $section_label ) ){

			$section_label = __( 'Paragraph', MECFBTEXTDOMAIN );
		}

		if( is_null( $selector ) ){

			$selector = "{$base_selector} p";
		}

		if( is_null( $hover_selector ) ){

			$hover_selector = "{$base_selector} p:hover";
		}

		if( is_null( $rewrite_settings_fields ) ){

			$rewrite_settings_fields = array(
				$group_id.'color' => array(
					'important' => true,
				),
				$group_id.'hover_color' => array(
					'important' => true,
				),
			);
		}

		$this->fes_register_styles_controls(
			$group_id,
			$section_label,
			$description,
			$selector,
			$hover_selector,
			$rewrite_settings_fields
		);
	}

	/**
	 * Register Button Controls for Styles
	 *
	 * @param string $group_id
	 * @param string|null $selector
	 * @param string|null $hover_selector
	 * @param string|null $section_label
	 * @param string $description
	 * @param array|null $rewrite_settings_fields
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function register_button_styles( $group_id = 'button_', $selector = null, $hover_selector = null, $section_label = null, $description = '', $rewrite_settings_fields = null ) {

		$base_selector = $this->fes_base_selector;

		if( is_null( $section_label ) ){

			$section_label = __( 'Button', MECFBTEXTDOMAIN );
		}

		if( is_null( $selector ) ){

			$selector = "{$base_selector} button";
		}

		if( is_null( $hover_selector ) ){

			$hover_selector = "{$base_selector} button:hover";
		}

		if( is_null( $rewrite_settings_fields ) ){

			$rewrite_settings_fields = array(
				$group_id . 'width' => array(
					'type' => 'width',
				),
				$group_id . 'min_width' => array(
					'type' => 'min_width',
				),
				$group_id . 'max_width' => array(
					'type' => 'max_width',
				),
				$group_id . 'height' => array(
					'type' => 'height',
				),
				$group_id . 'min_height' => array(
					'type' => 'min_height',
				),
				$group_id . 'max_height' => array(
					'type' => 'max_height',
				),
			);
		}

		$this->fes_register_styles_controls(
			$group_id,
			$section_label,
			$description,
			$selector,
			$hover_selector,
			$rewrite_settings_fields
		);
	}

	/**
	 * Register Label Controls for Styles
	 *
	 * @param string $group_id
	 * @param string|null $selector
	 * @param string|null $hover_selector
	 * @param string|null $section_label
	 * @param string $description
	 * @param array|null $rewrite_settings_fields
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function register_label_styles( $group_id = 'label_', $selector = null, $hover_selector = null, $section_label = null, $description = '', $rewrite_settings_fields = null ) {

		$base_selector = $this->fes_base_selector;

		if( is_null( $section_label ) ){

			$section_label = __( 'Label', MECFBTEXTDOMAIN );
		}

		if( is_null( $selector ) ){

			$selector = $base_selector . ' .mec-form-row > label';
		}

		if( is_null( $hover_selector ) ){

			$hover_selector = $base_selector . ' .mec-form-row > label:hover';
		}

		if( is_null( $rewrite_settings_fields ) ){

			$rewrite_settings_fields = array();
		}

		$this->fes_register_styles_controls(
			$group_id,
			$section_label,
			$description,
			$selector,
			$hover_selector,
			$rewrite_settings_fields
		);
	}

	/**
	 * Register Checkbox Label Controls for Styles
	 *
	 * @param string $group_id
	 * @param string|null $selector
	 * @param string|null $hover_selector
	 * @param string|null $section_label
	 * @param string $description
	 * @param array|null $rewrite_settings_fields
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function register_checkbox_label_styles( $group_id = 'checkbox_label_', $selector = null, $hover_selector = null, $section_label = null, $description = '', $rewrite_settings_fields = null ) {

		$base_selector = $this->fes_base_selector;

		if( is_null( $section_label ) ){

			$section_label = __( 'Checkbox label', MECFBTEXTDOMAIN );
		}

		if( is_null( $selector ) ){

			$selector = "{$base_selector} [type=checkbox]~label, {$base_selector} .label-checkbox";
		}

		if( is_null( $hover_selector ) ){

			$hover_selector = "{$base_selector} [type=checkbox]~label:hover, {$base_selector} .label-checkbox:hover";
		}

		if( is_null( $rewrite_settings_fields ) ){

			$rewrite_settings_fields = array();
		}

		$this->fes_register_styles_controls(
			$group_id,
			$section_label,
			$description,
			$selector,
			$hover_selector,
			$rewrite_settings_fields
		);
	}

	/**
	 * Register Radio Button Label Controls for Styles
	 *
	 * @param string $group_id
	 * @param string|null $selector
	 * @param string|null $hover_selector
	 * @param string|null $section_label
	 * @param string $description
	 * @param array|null $rewrite_settings_fields
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function register_radio_label_styles( $group_id = 'radio_label_', $selector = null, $hover_selector = null, $section_label = null, $description = '', $rewrite_settings_fields = null ) {

		$base_selector = $this->fes_base_selector;

		if( is_null( $section_label ) ){

			$section_label = __( 'Radio button label', MECFBTEXTDOMAIN );
		}

		if( is_null( $selector ) ){

			$selector = "{$base_selector} [type=radio]~label, {$base_selector} .label-radio";
		}

		if( is_null( $hover_selector ) ){

			$hover_selector = "{$base_selector} [type=radio]~label:hover, {$base_selector} .label-radio:hover";
		}

		if( is_null( $rewrite_settings_fields ) ){

			$rewrite_settings_fields = array();
		}

		$this->fes_register_styles_controls(
			$group_id,
			$section_label,
			$description,
			$selector,
			$hover_selector,
			$rewrite_settings_fields
		);
	}

    /**
	 * Register Checkbox Controls for Styles
	 *
	 * @param string $group_id
	 * @param string|null $selector
	 * @param string|null $hover_selector
	 * @param string|null $section_label
	 * @param string $description
	 * @param array|null $rewrite_settings_fields
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function register_checkbox_styles( $group_id = 'checkbox_', $selector = null, $hover_selector = null, $section_label = null, $description = '', $rewrite_settings_fields = null ) {

		$base_selector = $this->fes_base_selector;

		if( is_null( $section_label ) ){

			$section_label = __( 'Checkbox', MECFBTEXTDOMAIN );
		}

		if( is_null( $selector ) ){

			$selector = "{$base_selector} input[type=checkbox]";
		}

		if( is_null( $hover_selector ) ){

			$hover_selector = "{$base_selector} input[type=checkbox]:checked";
		}

		if( is_null( $rewrite_settings_fields ) ){

			$rewrite_settings_fields = array(
				$group_id . 'typography' => false,
				$group_id . 'background' => false,
				$group_id . 'color' => false,
				$group_id . 'hover_typography' => false,
				$group_id . 'hover_background' => false,
				$group_id . 'hover_color' => false,

				$group_id . 'checkbox_color' => array(
					'type' => 'checkbox_color',
					'important' => true,
					'selector' => $selector,
				),
				$group_id . 'hover_checkbox_color' => array(
					'type' => 'checkbox_color',
					'important' => true,
					'selector' => $hover_selector,
				),
			);
		}

		$this->fes_register_styles_controls(
			$group_id,
			$section_label,
			$description,
			$selector,
			$hover_selector,
			$rewrite_settings_fields
		);
	}

	/**
	 * Register Radio Controls for Styles
	 *
	 * @param string $group_id
	 * @param string|null $selector
	 * @param string|null $hover_selector
	 * @param string|null $section_label
	 * @param string $description
	 * @param array|null $rewrite_settings_fields
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function register_radio_styles( $group_id = 'radio_', $selector = null, $hover_selector = null, $section_label = null, $description = '', $rewrite_settings_fields = null ) {

		$base_selector = $this->fes_base_selector;

		if( is_null( $section_label ) ){

			$section_label = __( 'Radio Button', MECFBTEXTDOMAIN );
		}

		if( is_null( $selector ) ){

			$selector = "{$base_selector} input[type=radio]";
		}

		if( is_null( $hover_selector ) ){

			$hover_selector = "{$base_selector} input[type=radio]:checked";
		}

		if( is_null( $rewrite_settings_fields ) ){

			$rewrite_settings_fields = array(
				$group_id . 'typography' => false,
				$group_id . 'background' => false,
				$group_id . 'color' => false,
				$group_id . 'hover_typography' => false,
				$group_id . 'hover_background' => false,
				$group_id . 'hover_color' => false,

				$group_id . 'radio_color' => array(
					'type' => 'radio_color',
					'important' => true,
					'selector' => $selector,
				),
				$group_id . 'hover_radio_color' => array(
					'type' => 'radio_color',
					'important' => true,
					'selector' => $hover_selector,
				),
			);
		}

		$this->fes_register_styles_controls(
			$group_id,
			$section_label,
			$description,
			$selector,
			$hover_selector,
			$rewrite_settings_fields
		);
	}

    /**
	 * Register Textarea Controls for Styles
	 *
	 * @param string $group_id
	 * @param string|null $selector
	 * @param string|null $hover_selector
	 * @param string|null $section_label
	 * @param string $description
	 * @param array|null $rewrite_settings_fields
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function register_textarea_styles( $group_id = 'textarea_', $selector = null, $hover_selector = null, $section_label = null, $description = '', $rewrite_settings_fields = null ) {

		$base_selector = $this->fes_base_selector;

		if( is_null( $section_label ) ){

			$section_label = __( 'Textarea Input', MECFBTEXTDOMAIN );
		}

		if( is_null( $selector ) ){

			$selector = "{$base_selector} .mec-form-row textarea";
		}

		if( is_null( $hover_selector ) ){

			$hover_selector = "{$base_selector} .mec-form-row textarea:hover";
		}

		if( is_null( $rewrite_settings_fields ) ){

			$rewrite_settings_fields = array(
				$group_id . 'width' => array(
					'type' => 'width',
				),
				$group_id . 'min_width' => array(
					'type' => 'min_width',
				),
				$group_id . 'max_width' => array(
					'type' => 'max_width',
				),
				$group_id . 'height' => array(
					'type' => 'height',
				),
				$group_id . 'min_height' => array(
					'type' => 'min_height',
				),
				$group_id . 'max_height' => array(
					'type' => 'max_height',
				),
			);
		}

		$this->fes_register_styles_controls(
			$group_id,
			$section_label,
			$description,
			$selector,
			$hover_selector,
			$rewrite_settings_fields
		);
	}

    /**
	 * Register select Controls for Styles
	 *
	 * @param string $group_id
	 * @param string|null $selector
	 * @param string|null $hover_selector
	 * @param string|null $section_label
	 * @param string $description
	 * @param array|null $rewrite_settings_fields
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function register_select_styles( $group_id = 'select_', $selector = null, $hover_selector = null, $section_label = null, $description = '', $rewrite_settings_fields = null ) {

		$base_selector = $this->fes_base_selector;

		if( is_null( $section_label ) ){

			$section_label = __( 'Dropdown', MECFBTEXTDOMAIN );
		}

		if( is_null( $selector ) ){

			$selector = "{$base_selector} select, {$base_selector} .select2";
		}

		if( is_null( $hover_selector ) ){

			$hover_selector = "{$base_selector} select:hover, {$base_selector} .select2:hover";
		}

		if( is_null( $rewrite_settings_fields ) ){

			$rewrite_settings_fields = array(
				$group_id . 'width' => array(
					'type' => 'width',
				),
				$group_id . 'min_width' => array(
					'type' => 'min_width',
				),
				$group_id . 'max_width' => array(
					'type' => 'max_width',
				),
				$group_id . 'height' => array(
					'type' => 'height',
				),
				$group_id . 'min_height' => array(
					'type' => 'min_height',
				),
				$group_id . 'max_height' => array(
					'type' => 'max_height',
				),
			);
		}

		$this->fes_register_styles_controls(
			$group_id,
			$section_label,
			$description,
			$selector,
			$hover_selector,
			$rewrite_settings_fields
		);
	}

	/**
	 * Register Icon Controls for Styles
	 *
	 * @param string $group_id
	 * @param string|null $selector
	 * @param string|null $hover_selector
	 * @param string|null $section_label
	 * @param string $description
	 * @param array|null $rewrite_settings_fields
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function register_icon_styles( $group_id = 'icon_', $selector = null, $hover_selector = null, $section_label = null, $description = '', $rewrite_settings_fields = null ) {

		$base_selector = $this->fes_base_selector;

		if( is_null( $section_label ) ){

			$section_label = __( 'Icon', MECFBTEXTDOMAIN );
		}

		if( is_null( $selector ) ){

			$selector = "{$base_selector} .mec-dashicons::before";
		}

		if( is_null( $hover_selector ) ){

			$hover_selector = "{$base_selector} .mec-dashicons::before:hover";
		}

		if( is_null( $rewrite_settings_fields ) ){

			$rewrite_settings_fields = array(
				$group_id . 'typography'       => false,
				$group_id . 'hover_typography' => false,

				// $group_id . 'float'            => array(
				// 	'type' => 'float',
				// ),
				// $group_id . 'display'          => array(
				// 	'type' => 'display',
				// ),

				$group_id . 'font_size'        => array(
					'type' => 'font_size',
				),
				$group_id . 'hover_font_size'  => array(
					'type' => 'font_size',
				),

				$group_id . 'opacity'          => array(
					'type' => 'opacity',
				),
				$group_id . 'hover_opacity'    => array(
					'type' => 'opacity',
				),
			);
		}

		$this->fes_register_styles_controls(
			$group_id,
			$section_label,
			$description,
			$selector,
			$hover_selector,
			$rewrite_settings_fields
		);
	}

	/**
	 * Register UL Controls for Styles
	 *
	 * @param string $group_id
	 * @param string|null $selector
	 * @param string|null $hover_selector
	 * @param string|null $section_label
	 * @param string $description
	 * @param array|null $rewrite_settings_fields
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function register_ul_styles( $group_id = 'ul_', $selector = null, $hover_selector = null, $section_label = null, $description = '', $rewrite_settings_fields = null ) {

		$base_selector = $this->fes_base_selector;

		if( is_null( $section_label ) ){

			$section_label = __( 'List box', MECFBTEXTDOMAIN );
		}

		if( is_null( $selector ) ){

			$selector = $base_selector . ' .mec-form-row > ul';
		}

		if( is_null( $hover_selector ) ){

			$hover_selector = $base_selector . ' .mec-form-row > ul:hover';
		}

		if( is_null( $rewrite_settings_fields ) ){

			$rewrite_settings_fields = array();
		}

		$this->fes_register_styles_controls(
			$group_id,
			$section_label,
			$description,
			$selector,
			$hover_selector,
			$rewrite_settings_fields
		);
	}

	/**
	 * Register LI Controls for Styles
	 *
	 * @param string $group_id
	 * @param string|null $selector
	 * @param string|null $hover_selector
	 * @param string|null $section_label
	 * @param string $description
	 * @param array|null $rewrite_settings_fields
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function register_li_styles( $group_id = 'li_', $selector = null, $hover_selector = null, $section_label = null, $description = '', $rewrite_settings_fields = null ) {

		$base_selector = $this->fes_base_selector;

		if( is_null( $section_label ) ){

			$section_label = __( 'List item', MECFBTEXTDOMAIN );
		}

		if( is_null( $selector ) ){

			$selector = $base_selector . ' .mec-form-row ul li';
		}

		if( is_null( $hover_selector ) ){

			$hover_selector = $base_selector . ' .mec-form-row ul li:hover';
		}

		if( is_null( $rewrite_settings_fields ) ){

			$rewrite_settings_fields = array();
		}

		$this->fes_register_styles_controls(
			$group_id,
			$section_label,
			$description,
			$selector,
			$hover_selector,
			$rewrite_settings_fields
		);
	}

	/**
	 * Register required option content
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function option_required(){

		$this->switcher(array(
			'name' => 'required',
			'label' => __( 'Required', MECFBTEXTDOMAIN ),
			'type' => 'switcher',
			'return_value' => 'yes',
			'default' => 'no',
		));
	}
}
