<?php
/**
 * Widget FeaturedImage.
 *
 * @since 1.0.0
 *
 * @package MEC_FES_Builder
 */

namespace MEC_FES_Builder\Widgets;

defined( 'ABSPATH' ) || exit;

use MEC\FES\FormBuilder;

/**
 * FeaturedImage class
 *
 * @version 1.0.0
 */
class FeaturedImage extends FESBuilderBase {

    /**
     * Wrap css selector
     *
     * @since 1.0.0
     *
     * @var string
     */
    public $fes_base_selector = '{{WRAPPER}} #mec-featured-image';

    /**
     * Return widget name
     *
     * @since 1.0.0
     *
     * @return string
     */
    public function get_name(){

        return 'mec-fes-featured-image';
    }

    /**
     * Return widget title
     *
     * @since 1.0.0
     *
     * @return string
     */
    public function get_title(){

        return __( 'Featured Image', MECFBTEXTDOMAIN );
    }

    /**
     * Return icon class css
     *
     * @since 1.0.0
     *
     * @return void
     */
	public function get_icon() {

        return 'eicon-image-rollover';
    }

    /**
     * Return categories
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_categories() {

        return array( 'FES_Builder' );
    }

    /**
     * Return scripts
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_script_depends() {

        return array();
    }

    /**
     * Return styles
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_style_depends() {

        return array();
    }

    /**
     * Register controls
     *
     * @since 1.0.0
     *
     * @return void
     */
	protected function register_controls() {

        $base_selector = $this->fes_base_selector;

        $this->start_controls_section(
			'content_section',
			array(
				'label' => esc_html__('General', MECFBTEXTDOMAIN),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            )
		);

		$this->option_required();

        $this->switcher(array(
			'name' => 'featured_image_caption',
			'label' => __( 'Featured image caption', MECFBTEXTDOMAIN ),
			'type' => 'switcher',
		));

		$this->end_controls_section();



        $this->register_box_styles();
        $this->register_header_styles();
        $this->register_input_styles(
            'file_input_',
            "{$base_selector} #mec_featured_image_file",
            "{$base_selector} #mec_featured_image_file:hover",
            __( 'File input', MECFBTEXTDOMAIN )
        );
        $this->register_input_styles(
            'input_',
            "{$base_selector} #mec_fes_thumbnail_caption",
            "{$base_selector} #mec_fes_thumbnail_caption:hover",
            __( 'Input', MECFBTEXTDOMAIN )
        );
    }

    /**
     * Render widget output
     *
     * @since 1.0.0
     *
     * @return void
     */
	protected function render() {

        $settings = $this->get_settings_for_display();

        $post = $this->get_post();

        $atts = array(
            'required' => 'yes' === $settings['required'] ? true : false,
            'featured_image_caption' => 'yes' === $settings['featured_image_caption'] ? true : false,
            'is_edit_mode' => $this->is_edit_mode(),
        );

        $this->wrap_start();

        FormBuilder::thumbnail( $post, $atts );

        $this->wrap_end();
    }
}
