<?php
/**
 * Widget HourlySchedule.
 *
 * @since 1.0.0
 *
 * @package MEC_FES_Builder
 */

namespace MEC_FES_Builder\Widgets;

defined( 'ABSPATH' ) || exit;

use MEC\FES\FormBuilder;

/**
 * HourlySchedule class
 *
 * @version 1.0.0
 */
class HourlySchedule extends FESBuilderBase {

    /**
     * Wrap css selector
     *
     * @since 1.0.0
     *
     * @var string
     */
    public $fes_base_selector = '{{WRAPPER}} #mec-hourly-schedule';

    /**
     * Return widget name
     *
     * @since 1.0.0
     *
     * @return string
     */
    public function get_name(){

        return 'mec-fes-hourly-schedule';
    }

    /**
     * Return widget title
     *
     * @since 1.0.0
     *
     * @return string
     */
    public function get_title(){

        return __( 'Hourly Schedule', MECFBTEXTDOMAIN );
    }

    /**
     * Return icon class css
     *
     * @since 1.0.0
     *
     * @return void
     */
	public function get_icon() {

        return 'mec-fa-clock-o';
    }

    /**
     * Return categories
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_categories() {

        return array( 'FES_Builder' );
    }

    /**
     * Return scripts
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_script_depends() {

        return array();
    }

    /**
     * Return styles
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_style_depends() {

        return array();
    }

    /**
     * Register controls
     *
     * @since 1.0.0
     *
     * @return void
     */
	protected function register_controls() {

        $base_selector = $this->fes_base_selector;

        $this->register_box_styles();
        $this->register_header_styles();
        $this->register_button_styles(
            'add_day_button_',
            "{$base_selector} .mec-add-hourly-schedule-day-button",
            "{$base_selector} .mec-add-hourly-schedule-day-button:hover",
            __( 'Add day button', MECFBTEXTDOMAIN )
        );

        $this->register_label_styles(
            'add_day_description_',
            "{$base_selector} .mec-add-hourly-schedule-day-button~span",
            "{$base_selector} .mec-add-hourly-schedule-day-button~span:hover",
            __( 'Add day description', MECFBTEXTDOMAIN )
        );

        $this->register_header_styles(
            'sub_header_',
            "{$base_selector} > div h4",
            "{$base_selector} > div h4:hover",
            __( 'Subheader', MECFBTEXTDOMAIN )
        );

        $this->register_input_styles(
            'day_title_input_',
            "{$base_selector} .mec_add_hourly_schedule_day_title",
            "{$base_selector} .mec_add_hourly_schedule_day_title:hover",
            __( 'Day title input', MECFBTEXTDOMAIN )
        );

        $this->register_button_styles(
            'remove_day_hourly_schedule_button_',
            "{$base_selector} .mec-hourly-schedule-remove-day-button",
            "{$base_selector} .mec-hourly-schedule-remove-day-button:hover",
            __( 'Remove day button', MECFBTEXTDOMAIN )
        );

        $this->register_button_styles(
            'add_hourly_schedule_button_',
            "{$base_selector} .mec-add-hourly-schedule-button",
            "{$base_selector} .mec-add-hourly-schedule-button:hover",
            __( 'Hourly schedule add button', MECFBTEXTDOMAIN )
        );

        $this->register_label_styles(
            'add_hourly_schedule_description_',
            "{$base_selector} .mec-add-hourly-schedule-button~span",
            "{$base_selector} .mec-add-hourly-schedule-button~span:hover",
            __( 'Hourly schedule add description', MECFBTEXTDOMAIN )
        );

        $this->register_button_styles(
            'remove_hourly_schedule_button_',
            "{$base_selector} .mec-remove-hourly-schedule-button",
            "{$base_selector} .mec-remove-hourly-schedule-button:hover",
            __( 'Hourly schedule remove button', MECFBTEXTDOMAIN )
        );

        $this->register_input_styles(
            'hourly_schedule_input_',
            "{$base_selector} .mec-hourly-schedule-raw input:not([type=checkbox]):not([type=radio])",
            "{$base_selector} .mec-hourly-schedule-raw input:not([type=checkbox]):not([type=radio]):hover",
            __( 'Hourly schedule input', MECFBTEXTDOMAIN )
        );

        $this->register_checkbox_styles(
            'hourly_schedule_checkbox_',
            "{$base_selector} .mec-hourly-schedule-form-speakers input[type=checkbox]",
            "{$base_selector} .mec-hourly-schedule-form-speakers input[type=checkbox]:checked",
            __( 'Hourly schedule checkbox', MECFBTEXTDOMAIN )
        );

        $this->register_checkbox_label_styles(
            'hourly_schedule_checkbox_label_',
            "{$base_selector} .mec-hourly-schedule-form-speakers label",
            "{$base_selector} .mec-hourly-schedule-form-speakers label:hover",
            __( 'Hourly schedule checkbox label', MECFBTEXTDOMAIN )
        );
    }

    /**
     * Render widget output
     *
     * @since 1.0.0
     *
     * @return void
     */
	protected function render() {

        $settings = $this->get_settings_for_display();

        $post = $this->get_post();


        $this->wrap_start();

        $atts = array(
            'is_edit_mode' => $this->is_edit_mode(),
        );

        FormBuilder::hourly_schedule( $post, $atts );

        $this->wrap_end();
    }
}
