<?php
/**
 * Widget Links.
 *
 * @since 1.0.0
 *
 * @package MEC_FES_Builder
 */

namespace MEC_FES_Builder\Widgets;

defined( 'ABSPATH' ) || exit;

use MEC\FES\FormBuilder;

/**
 * Links class
 *
 * @version 1.0.0
 */
class Links extends FESBuilderBase {

    /**
     * Wrap css selector
     *
     * @since 1.0.0
     *
     * @var string
     */
    public $fes_base_selector = '{{WRAPPER}} #mec-event-links';

    /**
     * Return widget name
     *
     * @since 1.0.0
     *
     * @return string
     */
    public function get_name(){

        return 'mec-fes-links';
    }

    /**
     * Return widget title
     *
     * @since 1.0.0
     *
     * @return string
     */
    public function get_title(){

        return __( 'Links', MECFBTEXTDOMAIN );
    }

    /**
     * Return icon class css
     *
     * @since 1.0.0
     *
     * @return void
     */
	public function get_icon() {

        return 'eicon-link';
    }

    /**
     * Return categories
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_categories() {

        return array( 'FES_Builder' );
    }

    /**
     * Return scripts
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_script_depends() {

        return array();
    }

    /**
     * Return styles
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_style_depends() {

        return array();
    }

    /**
     * Register controls
     *
     * @since 1.0.0
     *
     * @return void
     */
	protected function register_controls() {

        $this->start_controls_section(
			'content_section',
			array(
				'label' => esc_html__('General', MECFBTEXTDOMAIN),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            )
		);

        $this->switcher(array(
			'name' => 'event_link_required',
			'label' => __( 'Event link required', MECFBTEXTDOMAIN ),
			'type' => 'switcher',
			'return_value' => 'yes',
			'default' => 'no',
		));

        $this->switcher(array(
			'name' => 'more_info_required',
			'label' => __( 'More info required', MECFBTEXTDOMAIN ),
			'type' => 'switcher',
			'return_value' => 'yes',
			'default' => 'no',
		));

		$this->end_controls_section();

        $this->register_box_styles();
        $this->register_header_styles();
        $this->register_label_styles();
        $this->register_input_styles();
        $this->register_select_styles();
        $this->register_paragraph_styles();
    }

    /**
     * Render widget output
     *
     * @since 1.0.0
     *
     * @return void
     */
	protected function render() {

        $settings = $this->get_settings_for_display();

        $post = $this->get_post();

        $atts = array(
            'event_link_required' => 'yes' === $settings['event_link_required'] ? true : false,
            'more_info_required' => 'yes' === $settings['more_info_required'] ? true : false,
            'is_edit_mode' => $this->is_edit_mode(),
        );

        $this->wrap_start();

        FormBuilder::event_links( $post, $atts );

        $this->wrap_end();
    }
}
