<?php
/**
 * Widget Occurrences.
 *
 * @since 1.0.0
 *
 * @package MEC_FES_Builder
 */

namespace MEC_FES_Builder\Widgets;

defined( 'ABSPATH' ) || exit;

use MEC\FES\FormBuilder;

/**
 * Occurrences class
 *
 * @version 1.0.0
 */
class Occurrences extends FESBuilderBase {

    /**
     * Wrap css selector
     *
     * @since 1.0.0
     *
     * @var string
     */
    public $fes_base_selector = '{{WRAPPER}} #mec-occurrences';

    /**
     * Return widget name
     *
     * @since 1.0.0
     *
     * @return string
     */
    public function get_name(){

        return 'mec-fes-occurrences';
    }

    /**
     * Return widget title
     *
     * @since 1.0.0
     *
     * @return string
     */
    public function get_title(){

        return __( 'Occurrences', MECFBTEXTDOMAIN );
    }

    /**
     * Return icon class css
     *
     * @since 1.0.0
     *
     * @return void
     */
	public function get_icon() {

        return 'eicon-calendar';
    }

    /**
     * Return categories
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_categories() {

        return array( 'FES_Builder' );
    }

    /**
     * Return scripts
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_script_depends() {

        return array();
    }

    /**
     * Return styles
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_style_depends() {

        return array();
    }

    /**
     * Register controls
     *
     * @since 1.0.0
     *
     * @return void
     */
	protected function register_controls() {

        $base_selector = $this->fes_base_selector;

        $this->register_box_styles();
        $this->register_box_styles(
            'item_',
            "{$base_selector} .mec-occurrences-list .mec_occurrences_item",
            "{$base_selector} .mec-occurrences-list .mec_occurrences_item:hover",
            __( 'Item', MECFBTEXTDOMAIN )
        );
        $this->register_header_styles();
        $this->register_header_styles(
            'sub_header_',
            "{$base_selector} .mec-occurrences-list h4",
            "{$base_selector} .mec-occurrences-list h4:hover",
            __( 'Subheader', MECFBTEXTDOMAIN )
        );
        $this->register_label_styles(
            'label_',
            "{$base_selector} label:not([type=checkbox]~label):not([type=radio]~label):not(.label-checkbox):not(.label-radio)",
            "{$base_selector} label:not([type=checkbox]~label):not([type=radio]~label):not(.label-checkbox):not(.label-radio):hover",
            null,
            '',
            array()
        );
        $this->register_select_styles();
        $this->register_input_styles();
        $this->register_textarea_styles();
        $this->register_button_styles();

        $this->register_checkbox_styles();
        $this->register_checkbox_label_styles();

        $this->register_radio_styles();
        $this->register_radio_label_styles();

        $this->register_paragraph_styles(
            'description_',
            "{$base_selector} .description",
            "{$base_selector} .description:hover",
            __( 'Description', MECFBTEXTDOMAIN )
        );

        $this->register_general_styles(
            'button_delete_',
            "{$base_selector} .mec-occurrences-wrapper ul.mec-occurrences-list li.mec_occurrences_item h3 span.mec-occurrences-delete-button",
            "{$base_selector} .mec-occurrences-wrapper ul.mec-occurrences-list li.mec_occurrences_item h3 span.mec-occurrences-delete-button:hover",
            __( 'Button Delete', MECFBTEXTDOMAIN )
        );

        $this->register_general_styles(
            'tooltip_box_',
            "{$base_selector} .mec-tooltip .box",
            "{$base_selector} ..mec-tooltip .box:hover",
            __( 'Tooltip Box', MECFBTEXTDOMAIN )
        );
        $this->register_general_styles(
            'tooltip_title_',
            "{$base_selector} .mec-tooltip .box h5",
            "{$base_selector} ..mec-tooltip .box h5:hover",
            __( 'Tooltip Title', MECFBTEXTDOMAIN )
        );
        $this->register_general_styles(
            'tooltip_content_',
            "{$base_selector} .mec-tooltip .box p",
            "{$base_selector} ..mec-tooltip .box p:hover",
            __( 'Tooltip Content', MECFBTEXTDOMAIN )
        );
    }

    /**
     * Render widget output
     *
     * @since 1.0.0
     *
     * @return void
     */
	protected function render() {

        $settings = $this->get_settings_for_display();

        $post = $this->get_post();

        $this->wrap_start();

        $atts = array(
            'is_edit_mode' => $this->is_edit_mode(),
        );

        FormBuilder::occurrences( $post, $atts );

        $this->wrap_end();
    }
}
