<?php
/**
 * Widget OrganizerPayment.
 *
 * @since 1.0.0
 *
 * @package MEC_FES_Builder
 */

namespace MEC_FES_Builder\Widgets;

defined( 'ABSPATH' ) || exit;

use MEC\FES\FormBuilder;

/**
 * OrganizerPayment class
 *
 * @version 1.0.0
 */
class OrganizerPayment extends FESBuilderBase {

    /**
     * Wrap css selector
     *
     * @since 1.0.0
     *
     * @var string
     */
    public $fes_base_selector = '{{WRAPPER}} #mec-organizer-payments';

    /**
     * Return widget name
     *
     * @since 1.0.0
     *
     * @return string
     */
    public function get_name(){

        return 'mec-fes-organizer-payment';
    }

    /**
     * Return widget title
     *
     * @since 1.0.0
     *
     * @return string
     */
    public function get_title(){

        return __( 'Organizer Payment', MECFBTEXTDOMAIN );
    }

    /**
     * Return icon class css
     *
     * @since 1.0.0
     *
     * @return void
     */
	public function get_icon() {

        return 'eicon-image-rollover';
    }

    /**
     * Return categories
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_categories() {

        return array( 'FES_Builder' );
    }

    /**
     * Return scripts
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_script_depends() {

        return array();
    }

    /**
     * Return styles
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_style_depends() {

        return array();
    }

    /**
     * Register controls
     *
     * @since 1.0.0
     *
     * @return void
     */
	protected function register_controls() {

        $base_selector = $this->fes_base_selector;

        $this->register_box_styles();
        $this->register_header_styles(
            'header_',
            $base_selector . ' .mec-booking-tab-content > h4',
            $base_selector . ' .mec-booking-tab-content > h4:hover'
        );

        $this->register_header_styles(
            'subheader_',
            $base_selector . ' #mec_organizer_gateways_form_container h4',
            $base_selector . ' #mec_organizer_gateways_form_container h4:hover',
            __( 'Sub header', MECFBTEXTDOMAIN )
        );

        $this->register_label_styles(
            'button_',
            $base_selector . ' #mec_organizer_gateways_form_container a.button',
            $base_selector . ' #mec_organizer_gateways_form_container a.button:hover',
            __( 'Button', MECFBTEXTDOMAIN )
        );
    }

    /**
     * Render widget output
     *
     * @since 1.0.0
     *
     * @return void
     */
	protected function render() {

        $settings = $this->get_settings_for_display();

        $post = $this->get_post();

        $this->wrap_start();

        $atts = array(
            'is_edit_mode' => $this->is_edit_mode(),
        );

        wp_enqueue_media();

        do_action( 'mec_organizer_payment_fields', $post, $atts, $settings );

        $this->wrap_end();
    }
}
