<?php
/**
 * Widget Organizers.
 *
 * @since 1.0.0
 *
 * @package MEC_FES_Builder
 */

namespace MEC_FES_Builder\Widgets;

defined( 'ABSPATH' ) || exit;

use MEC\FES\FormBuilder;

/**
 * Organizers class
 *
 * @version 1.0.0
 */
class Organizers extends FESBuilderBase {

    /**
     * Wrap css selector
     *
     * @since 1.0.0
     *
     * @var string
     */
    public $fes_base_selector = '{{WRAPPER}} #mec-organizer';

    /**
     * Return widget name
     *
     * @since 1.0.0
     *
     * @return string
     */
    public function get_name(){

        return 'mec-fes-organizers';
    }

    /**
     * Return widget title
     *
     * @since 1.0.0
     *
     * @return string
     */
    public function get_title(){

        return __( 'Organizers', MECFBTEXTDOMAIN );
    }

    /**
     * Return icon class css
     *
     * @since 1.0.0
     *
     * @return void
     */
	public function get_icon() {

        return 'eicon-person';
    }

    /**
     * Return categories
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_categories() {

        return array( 'FES_Builder' );
    }

    /**
     * Return scripts
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_script_depends() {

        return array();
    }

    /**
     * Return styles
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_style_depends() {

        return array();
    }

    /**
     * Register controls
     *
     * @since 1.0.0
     *
     * @return void
     */
	protected function register_controls() {

        $base_selector = $this->fes_base_selector;

        $this->register_box_styles();
        $this->register_header_styles();
        $this->register_input_styles();
        $this->register_paragraph_styles(
            'description_',
            "{$base_selector} .description",
            "{$base_selector} .description:hover",
            __( 'Description', MECFBTEXTDOMAIN )
        );

        $this->register_select_styles();

        $this->register_input_styles(
            'file_input_',
            "{$base_selector} #mec_fes_organizer_thumbnail_file",
            "{$base_selector} #mec_fes_organizer_thumbnail_file:hover",
            __( 'File input', MECFBTEXTDOMAIN )
        );

        $this->register_general_styles(
            'header_other_organizers_',
            "{$base_selector} #mec-additional-organizer-wrap h4",
            "{$base_selector} #mec-additional-organizer-wrap h4:hover",
            __( 'Header Other Organizers', MECFBTEXTDOMAIN )
        );

        $this->register_general_styles(
            'select_other_organizers_',
            "{$base_selector} #mec-additional-organizer-wrap .mec-select2-dropdown",
            "{$base_selector} #mec-additional-organizer-wrap .mec-select2-dropdown:hover",
            __( 'Select Other Organizers', MECFBTEXTDOMAIN )
        );

        $this->register_general_styles(
            'button_add_other_organizers_',
            "{$base_selector} #mec-additional-organizer-wrap #mec_additional_organizers_add",
            "{$base_selector} #mec-additional-organizer-wrap #mec_additional_organizers_add:hover",
            __( 'Button Add Other Organizers', MECFBTEXTDOMAIN )
        );

        $this->register_general_styles(
            'list_other_organizers_',
            "{$base_selector} #mec-additional-organizer-wrap .mec-additional-organizers-list",
            "{$base_selector} #mec-additional-organizer-wrap .mec-additional-organizers-list:hover",
            __( 'List Other Organizers', MECFBTEXTDOMAIN )
        );

        $this->register_general_styles(
            'item_other_organizers_',
            "{$base_selector} #mec-additional-organizer-wrap .mec-additional-organizers-list li",
            "{$base_selector} #mec-additional-organizer-wrap .mec-additional-organizers-list li:hover",
            __( 'Item Other Organizers', MECFBTEXTDOMAIN )
        );

        $this->register_general_styles(
            'button_remove_other_organizers_',
            "{$base_selector} #mec-additional-organizer-wrap .mec-additional-organizers-list .mec-additional-organizer-remove",
            "{$base_selector} #mec-additional-organizer-wrap .mec-additional-organizers-list .mec-additional-organizer-remove:hover",
            __( 'Button Remove Other Organizers', MECFBTEXTDOMAIN )
        );

        $this->register_general_styles(
            'tooltip_box_',
            "{$base_selector} .mec-tooltip .box",
            "{$base_selector} ..mec-tooltip .box:hover",
            __( 'Tooltip Box', MECFBTEXTDOMAIN )
        );
        $this->register_general_styles(
            'tooltip_title_',
            "{$base_selector} .mec-tooltip .box h5",
            "{$base_selector} ..mec-tooltip .box h5:hover",
            __( 'Tooltip Title', MECFBTEXTDOMAIN )
        );
        $this->register_general_styles(
            'tooltip_content_',
            "{$base_selector} .mec-tooltip .box p",
            "{$base_selector} ..mec-tooltip .box p:hover",
            __( 'Tooltip Content', MECFBTEXTDOMAIN )
        );
    }

    /**
     * Render widget output
     *
     * @since 1.0.0
     *
     * @return void
     */
	protected function render() {

        $settings = $this->get_settings_for_display();

        $post = $this->get_post();

        $atts = array(
            'is_edit_mode' => $this->is_edit_mode(),
        );

        if( $this->is_edit_mode() ){
            ?>
            <script>
                jQuery(document).ready(function ($) {

                    // Organizer Select2
                    jQuery(".mec-additional-organizers select").select2();
                    jQuery("#mec_organizer_id").select2();
                });
            </script>
            <?php
        }

        $this->wrap_start();

        FormBuilder::organizers( $post, $atts );

        $this->wrap_end();
    }
}
