<?php
/**
 * Widget RSVP.
 *
 * @since 1.0.0
 *
 * @package MEC_FES_Builder
 */

namespace MEC_FES_Builder\Widgets;

defined( 'ABSPATH' ) || exit;

use MEC_RSVP\RSVP\EventMetaBox as RSVPEventMetaBox;

/**
 * RSVP class
 *
 * @version 1.0.0
 */
class RSVP extends FESBuilderBase {

    /**
     * Wrap css selector
     *
     * @since 1.0.0
     *
     * @var string
     */
    public $fes_base_selector = '{{WRAPPER}} #mec-rsvp';

    /**
     * Return widget name
     *
     * @since 1.0.0
     *
     * @return string
     */
    public function get_name(){

        return 'mec-fes-rsvp';
    }

    /**
     * Return widget title
     *
     * @since 1.0.0
     *
     * @return string
     */
    public function get_title(){

        return __( 'RSVP', MECFBTEXTDOMAIN );
    }

    /**
     * Return icon class css
     *
     * @since 1.0.0
     *
     * @return void
     */
	public function get_icon() {

        return 'eicon-kit-details';
    }

    /**
     * Return categories
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_categories() {

        return array( 'FES_Builder' );
    }

    /**
     * Return scripts
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_script_depends() {

        return array();
    }

    /**
     * Return styles
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_style_depends() {

        return array();
    }

    /**
     * Register controls
     *
     * @since 1.0.0
     *
     * @return void
     */
	protected function register_controls() {

        $base_selector = $this->fes_base_selector;

        $this->register_box_styles();
        $this->register_header_styles();
        $this->register_header_styles(
            'subtitle_',
            "{$base_selector} .mec-rsvp-option-container h4",
            "{$base_selector} .mec-rsvp-option-container h4:hover",
            __( 'Subheader', MECFBTEXTDOMAIN )
        );
        $this->register_checkbox_label_styles();
        $this->register_checkbox_styles();
        $this->register_label_styles(
            'label_',
            "{$base_selector} label:not([type=checkbox]~label):not([type=radio]~label):not(.label-checkbox)",
            "{$base_selector} label:not([type=checkbox]~label):not([type=radio]~label):not(.label-checkbox):hover",
            null,
            '',
            array()
        );
        $this->register_select_styles();
        $this->register_input_styles();
    }

    /**
     * Render widget output
     *
     * @since 1.0.0
     *
     * @return void
     */
	protected function render() {

        $settings = $this->get_settings_for_display();

        $post = $this->get_post();

        $this->wrap_start();

        if( class_exists( RSVPEventMetaBox::class ) ){

            RSVPEventMetaBox::getInstance()->fes_enqueue();
            RSVPEventMetaBox::getInstance()->meta_box_rsvp_options( $post );
        }

        $this->wrap_end();
    }
}
