<?php
/**
 * Widget Seat.
 *
 * @since 1.0.0
 *
 * @package MEC_FES_Builder
 */

namespace MEC_FES_Builder\Widgets;

defined( 'ABSPATH' ) || exit;

use MEC\FES\FormBuilder;

/**
 * Seat class
 *
 * @version 1.0.0
 */
class Seat extends FESBuilderBase {

    /**
     * Wrap css selector
     *
     * @since 1.0.0
     *
     * @var string
     */
    public $fes_base_selector = '{{WRAPPER}} #mec-seat';

    /**
     * Return widget name
     *
     * @since 1.0.0
     *
     * @return string
     */
    public function get_name(){

        return 'mec-fes-seat';
    }

    /**
     * Return widget title
     *
     * @since 1.0.0
     *
     * @return string
     */
    public function get_title(){

        return __( 'Seat', MECFBTEXTDOMAIN );
    }

    /**
     * Return icon class css
     *
     * @since 1.0.0
     *
     * @return void
     */
	public function get_icon() {

        return 'eicon-thumbnails-half';
    }

    /**
     * Return categories
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_categories() {

        return array( 'FES_Builder' );
    }

    /**
     * Return scripts
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_script_depends() {

        return array( 'mec-seat-backend-script', 'mec-seat-layout-backend' );
    }

    /**
     * Return styles
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_style_depends() {

        return array( 'mec-seat-backend-style', 'mec-font-icons', 'mec-seat-layout-backend' );
    }

    /**
     * Register controls
     *
     * @since 1.0.0
     *
     * @return void
     */
	protected function register_controls() {

        $base_selector = $this->fes_base_selector;

        $this->register_box_styles();
        $this->register_header_styles(
            'header_',
            "{$base_selector} .mec-form-title",
            "{$base_selector} .mec-form-title:hover",
            __( 'header', MECFBTEXTDOMAIN )
        );
        $this->register_header_styles(
            'subtitle_',
            "{$base_selector} .title"
                . ", #mec-seat-seats-settings-wrap .title",
            "{$base_selector} .title:hover"
                . ", #mec-seat-seats-settings-wrap .title:hover",
            __( 'Subheader', MECFBTEXTDOMAIN )
        );

        $this->register_button_styles(
            'open_seats_button_',
            "{$base_selector} #mec-seat-open-seats-settings",
            "{$base_selector} #mec-seat-open-seats-settings:hover",
            __( 'Open seats button', MECFBTEXTDOMAIN )
        );

        $this->register_checkbox_styles(
            'checkbox_',
            "{$base_selector} input[type=checkbox]"
                . ", #mec-seat-seats-settings-wrap input[type=checkbox]"
                . ", #mec-seat-popup-seat-data input[type=checkbox]",
            "{$base_selector} input[type=checkbox]:checked"
                . ", #mec-seat-seats-settings-wrap input[type=checkbox]:checked"
                . ", #mec-seat-popup-seat-data input[type=checkbox]:checked"
                ,
        );
        $this->register_checkbox_label_styles(
            'checkbox_label_',
            "{$base_selector} [type=checkbox]~label, {$base_selector} .label-checkbox"
                . ", #mec-seat-seats-settings-wrap [type=checkbox]~label, #mec-seat-seats-settings-wrap .label-checkbox"
                . ", #mec-seat-popup-seat-data [type=checkbox]~label, #mec-seat-popup-seat-data .label-checkbox",
            "{$base_selector} [type=checkbox]~label:hover, {$base_selector} .label-checkbox:hover"
                . ", #mec-seat-seats-settings-wrap [type=checkbox]~label:hover, #mec-seat-seats-settings-wrap .label-checkbox:hover"
                . ", #mec-seat-popup-seat-data [type=checkbox]~label:hover, #mec-seat-popup-seat-data .label-checkbox:hover"
        );

        $this->register_label_styles(
            'label_',
            "{$base_selector} label:not([type=checkbox]~label):not([type=radio]~label):not(.label-checkbox), {$base_selector} .mec-label"
                . ", #mec-seat-seats-settings-wrap label:not([type=checkbox]~label):not([type=radio]~label):not(.label-checkbox), #mec-seat-seats-settings-wrap .mec-label"
                . ", #mec-seat-popup-seat-data label:not([type=checkbox]~label):not([type=radio]~label):not(.label-checkbox), #mec-seat-popup-seat-data .mec-label",
            "{$base_selector} label:not([type=checkbox]~label):not([type=radio]~label):not(.label-checkbox):hover, {$base_selector} .mec-label:hover"
                . ", #mec-seat-seats-settings-wrap label:not([type=checkbox]~label):not([type=radio]~label):not(.label-checkbox):hover, #mec-seat-seats-settings-wrap .mec-label:hover"
                . ", #mec-seat-popup-seat-data label:not([type=checkbox]~label):not([type=radio]~label):not(.label-checkbox):hover, #mec-seat-popup-seat-data .mec-label:hover"
        );

        $this->register_input_styles(
            'input_',
            "{$base_selector} input:not([type=radio]):not([type=radio])"
                . ", #mec-seat-seats-settings-wrap input:not([type=radio]):not([type=radio])"
                . ", #mec-seat-popup-seat-data input:not([type=radio]):not([type=radio])",
             "{$base_selector} input:not([type=radio]):not([type=radio]):hover"
                .", #mec-seat-seats-settings-wrap input:not([type=radio]):not([type=radio]):hover"
                .", #mec-seat-popup-seat-data input:not([type=radio]):not([type=radio]):hover"
        );

        $this->register_icon_styles(
            'move_section_button_',
            "#mec-seat-seats-settings-wrap .mec-seat-areas .mec-move-row::before",
            "#mec-seat-seats-settings-wrap .mec-seat-areas .mec-move-row:hover::before",
            __( 'Move area button', MECFBTEXTDOMAIN )
        );

        $this->register_icon_styles(
            'edit_section_button_',
            "#mec-seat-seats-settings-wrap .mec-seat-areas .mec-edit-row svg",
            "#mec-seat-seats-settings-wrap .mec-seat-areas .mec-edit-row:hover svg",
            __( 'Edit area button', MECFBTEXTDOMAIN )
        );

        $this->register_icon_styles(
            'remove_section_button_',
            "#mec-seat-seats-settings-wrap .mec-seat-areas .mec-remove-row svg",
            "#mec-seat-seats-settings-wrap .mec-seat-areas .mec-remove-row:hover svg",
            __( 'Remove area button', MECFBTEXTDOMAIN )
        );

        $this->register_button_styles(
            'add_section_button_',
            "#mec-seat-seats-settings-wrap #mec-seat-add-area",
            "#mec-seat-seats-settings-wrap #mec-seat-add-area:hover",
            __( 'Add area button', MECFBTEXTDOMAIN )
        );


        $this->register_button_styles(
            'save_section_button_',
            '.lity-content .mec-seat-popup.mec-fes-form .mec-save-button'
                . ', .lity-content #mec-seat-seats-settings-wrap.mec-fes-form #mec-seat-save-seats-settings'
                . ', .lity-content .mec-seat-popup-seat-data.mec-fes-form #mec-seat-update-seat'
                . ', .lity-content .mec-area-item-popup.mec-fes-form #mec-seat-update-area',
            '.lity-content .mec-seat-popup.mec-fes-form .mec-save-button:hover'
                . ', .lity-content #mec-seat-seats-settings-wrap.mec-fes-form #mec-seat-save-seats-settings:hover'
                . ', .lity-content .mec-seat-popup-seat-data.mec-fes-form #mec-seat-update-seat:hover'
                . ', .lity-content .mec-area-item-popup.mec-fes-form #mec-seat-update-area:hover',
            __( 'Save options button', MECFBTEXTDOMAIN )
        );

        // save button

        $this->register_box_styles(
            'seat_demo_box_',
            "{$base_selector} .mec-seat-demo ul"
                . ", #mec-seat-seats-settings-wrap .mec-seat-demo ul",
            "{$base_selector} .mec-seat-demo ul:hover"
                . ", #mec-seat-seats-settings-wrap .mec-seat-demo ul:hover",
            __( 'Seat demo box', MECFBTEXTDOMAIN )
        );
#mec-seat-popup-seat-data
        $this->register_button_styles(
            'set_general_settings_button_',
            "{$base_selector} #mec-seat-set-general-settings"
                . ", #mec-seat-seats-settings-wrap #mec-seat-set-general-settings",
            "{$base_selector} #mec-seat-set-general-settings:hover"
                . ", #mec-seat-seats-settings-wrap #mec-seat-set-general-settings:hover",
            __( 'Set general settings button', MECFBTEXTDOMAIN )
        );

        $this->register_textarea_styles(
            'textarea_',
            "{$base_selector} textarea"
                . ", #mec-seat-seats-settings-wrap textarea"
                . ", #mec-seat-popup-seat-data textarea",
            "{$base_selector} textarea:hover"
                . ", #mec-seat-seats-settings-wrap textarea:hover"
                . ", #mec-seat-popup-seat-data textarea:hover"
        );

        $this->register_select_styles(
            'select_',
            "{$base_selector} select, {$base_selector} .select2"
                . ", #mec-seat-seats-settings-wrap select, #mec-seat-seats-settings-wrap .select2"
                . ", #mec-seat-popup-seat-data select, #mec-seat-popup-seat-data .select2",
            "{$base_selector} select:hover, {$base_selector} .select2:hover"
                . ", #mec-seat-seats-settings-wrap select:hover, #mec-seat-seats-settings-wrap .select2:hover"
                . ", #mec-seat-popup-seat-data select:hover, #mec-seat-popup-seat-data .select2:hover"
        );

        $this->register_button_styles(
            'import_export_button_',
            "{$base_selector} .mec-seat-import-layout, {$base_selector} .mec-seat-export-layout",
            "{$base_selector} .mec-seat-import-layout:hover, {$base_selector} .mec-seat-export-layout:hover",
            __( 'Import/Export button', MECFBTEXTDOMAIN )
        );

    }

    /**
     * Render widget output
     *
     * @since 1.0.0
     *
     * @return void
     */
	protected function render() {

        $settings = $this->get_settings_for_display();

        $post = $this->get_post();

        $this->wrap_start();

        do_action( 'mec_custom_fes_form_metabox_details', $post );

        $this->wrap_end();
    }
}
