<?php
/**
 * Widget SubmitButton.
 *
 * @since 1.0.0
 *
 * @package MEC_FES_Builder
 */

namespace MEC_FES_Builder\Widgets;

defined( 'ABSPATH' ) || exit;

use MEC\FES\FormBuilder;

/**
 * SubmitButton class
 *
 * @version 1.0.0
 */
class SubmitButton extends FESBuilderBase {

    /**
     * Wrap css selector
     *
     * @since 1.0.0
     *
     * @var string
     */
    public $fes_base_selector = '{{WRAPPER}}';

    /**
     * Return widget name
     *
     * @since 1.0.0
     *
     * @return string
     */
    public function get_name(){

        return 'mec-fes-submit-button';
    }

    /**
     * Return widget title
     *
     * @since 1.0.0
     *
     * @return string
     */
    public function get_title(){

        return __( 'Submit Button', MECFBTEXTDOMAIN );
    }

    /**
     * Return icon class css
     *
     * @since 1.0.0
     *
     * @return void
     */
	public function get_icon() {

        return 'eicon-button';
    }

    /**
     * Return categories
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_categories() {

        return array( 'FES_Builder' );
    }

    /**
     * Return scripts
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_script_depends() {

        return array();
    }

    /**
     * Return styles
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_style_depends() {

        return array();
    }

    /**
     * Register controls
     *
     * @since 1.0.0
     *
     * @return void
     */
	protected function register_controls() {

        $this->register_button_styles();
    }

    /**
     * Render widget output
     *
     * @since 1.0.0
     *
     * @return void
     */
	protected function render() {

        $settings = $this->get_settings_for_display();

        $post = $this->get_post();

        $this->wrap_start();

        $atts = array(
            'is_edit_mode' => $this->is_edit_mode(),
        );

        FormBuilder::submit_button( $post, $atts );

        $this->wrap_end();
    }
}
