<?php
/**
 * Widget ThankyouPage.
 *
 * @since 1.0.0
 *
 * @package MEC_FES_Builder
 */

namespace MEC_FES_Builder\Widgets;

defined( 'ABSPATH' ) || exit;

use MEC\FES\FormBuilder;

/**
 * ThankyouPage class
 *
 * @version 1.0.0
 */
class ThankyouPage extends FESBuilderBase {

    /**
     * Wrap css selector
     *
     * @since 1.0.0
     *
     * @var string
     */
    public $fes_base_selector = '{{WRAPPER}} #mec-thankyou-page';

    /**
     * Return widget name
     *
     * @since 1.0.0
     *
     * @return string
     */
    public function get_name(){

        return 'mec-fes-thankyou-page';
    }

    /**
     * Return widget title
     *
     * @since 1.0.0
     *
     * @return string
     */
    public function get_title(){

        return __( 'Thankyou Page', MECFBTEXTDOMAIN );
    }

    /**
     * Return icon class css
     *
     * @since 1.0.0
     *
     * @return void
     */
	public function get_icon() {

        return 'eicon-single-post';
    }

    /**
     * Return categories
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_categories() {

        return array( 'FES_Builder' );
    }

    /**
     * Return scripts
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_script_depends() {

        return array();
    }

    /**
     * Return styles
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_style_depends() {

        return array();
    }

    /**
     * Register controls
     *
     * @since 1.0.0
     *
     * @return void
     */
	protected function register_controls() {

        $base_selector = $this->fes_base_selector;

        $this->register_box_styles();
        $this->register_header_styles();
        $this->register_checkbox_styles();
        $this->register_checkbox_label_styles(
            'checkbox_label_',
            "{$base_selector} .mec_bookings_thankyou_page_inherit",
            "{$base_selector} .mec_bookings_thankyou_page_inherit:hover",
            __( 'Checkbox label', MECFBTEXTDOMAIN )
        );

        $this->register_select_styles();

        $this->register_input_styles();
        $this->register_label_styles(
            'label_',
            "{$base_selector} #mec_booking_thankyou_page_options label",
            "{$base_selector} #mec_booking_thankyou_page_options label:hover"

        );
    }

    /**
     * Render widget output
     *
     * @since 1.0.0
     *
     * @return void
     */
	protected function render() {

        $settings = $this->get_settings_for_display();

        $post = $this->get_post();

        $this->wrap_start();

        $atts = array(
            'is_edit_mode' => $this->is_edit_mode(),
        );

        FormBuilder::thankyou_page( $post, $atts );

        $this->wrap_end();
    }
}
