<?php
/**
 * Widget TicketVariations.
 *
 * @since 1.0.0
 *
 * @package MEC_FES_Builder
 */

namespace MEC_FES_Builder\Widgets;

defined( 'ABSPATH' ) || exit;

use MEC\FES\FormBuilder;

/**
 * TicketVariations class
 *
 * @version 1.0.0
 */
class TicketVariations extends FESBuilderBase {

    /**
     * Wrap css selector
     *
     * @since 1.0.0
     *
     * @var string
     */
    public $fes_base_selector = '{{WRAPPER}} #mec-ticket-variations';

    /**
     * Return widget name
     *
     * @since 1.0.0
     *
     * @return string
     */
    public function get_name(){

        return 'mec-fes-ticket-variations';
    }

    /**
     * Return widget title
     *
     * @since 1.0.0
     *
     * @return string
     */
    public function get_title(){

        return __( 'Ticket Variations', MECFBTEXTDOMAIN );
    }

    /**
     * Return icon class css
     *
     * @since 1.0.0
     *
     * @return void
     */
	public function get_icon() {

        return 'eicon-product-stock';
    }

    /**
     * Return categories
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_categories() {

        return array( 'FES_Builder' );
    }

    /**
     * Return scripts
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_script_depends() {

        return array();
    }

    /**
     * Return styles
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_style_depends() {

        return array();
    }

    /**
     * Register controls
     *
     * @since 1.0.0
     *
     * @return void
     */
	protected function register_controls() {

        $base_selector = $this->fes_base_selector;

        $this->register_box_styles();
        $this->register_box_styles(
            'item_row_',
            "{$base_selector} .mec_ticket_variation_row",
            "{$base_selector} .mec_ticket_variation_row:hover",
            __( 'Item', MECFBTEXTDOMAIN )
        );
        $this->register_header_styles();
        $this->register_checkbox_styles();
        $this->register_checkbox_label_styles(
            'checkbox_label_',
            "{$base_selector} .ticket_variations_global_inheritance_label",
            "{$base_selector} .ticket_variations_global_inheritance_label:hover",
            __( 'Checkbox label', MECFBTEXTDOMAIN )
        );

        $this->register_button_styles(
            'add_ticket_variations_button_',
            "{$base_selector} #mec_add_ticket_variation_button",
            "{$base_selector} #mec_add_ticket_variation_button:hover",
            __( 'Add button', MECFBTEXTDOMAIN )
        );

        $this->register_button_styles(
            'remove_ticket_variations_button_',
            "{$base_selector} .mec_remove_ticket_variation_button",
            "{$base_selector} .mec_remove_ticket_variation_button:hover",
            __( 'Remove button', MECFBTEXTDOMAIN )
        );

        $this->register_input_styles();

        $this->register_general_styles(
            'button_remove_',
            "{$base_selector} .mec_remove_ticket_variation_button",
            "{$base_selector} .mec_remove_ticket_variation_button:hover",
            __( 'Button Remove', MECFBTEXTDOMAIN )
        );

        $this->register_general_styles(
            'tooltip_box_',
            "{$base_selector} .mec-tooltip .box",
            "{$base_selector} ..mec-tooltip .box:hover",
            __( 'Tooltip Box', MECFBTEXTDOMAIN )
        );
        $this->register_general_styles(
            'tooltip_title_',
            "{$base_selector} .mec-tooltip .box h5",
            "{$base_selector} ..mec-tooltip .box h5:hover",
            __( 'Tooltip Title', MECFBTEXTDOMAIN )
        );
        $this->register_general_styles(
            'tooltip_content_',
            "{$base_selector} .mec-tooltip .box p",
            "{$base_selector} ..mec-tooltip .box p:hover",
            __( 'Tooltip Content', MECFBTEXTDOMAIN )
        );
    }

    /**
     * Render widget output
     *
     * @since 1.0.0
     *
     * @return void
     */
	protected function render() {

        $settings = $this->get_settings_for_display();

        $post = $this->get_post();

        $this->wrap_start();

        $atts = array(
            'is_edit_mode' => $this->is_edit_mode(),
        );

        FormBuilder::ticket_variations( $post, $atts );

        $this->wrap_end();
    }
}
