<?php
/**
 * Widget Tickets.
 *
 * @since 1.0.0
 *
 * @package MEC_FES_Builder
 */

namespace MEC_FES_Builder\Widgets;

defined( 'ABSPATH' ) || exit;

use MEC\FES\FormBuilder;

/**
 * Tickets class
 *
 * @version 1.0.0
 */
class Tickets extends FESBuilderBase {

    /**
     * Wrap css selector
     *
     * @since 1.0.0
     *
     * @var string
     */
    public $fes_base_selector = '{{WRAPPER}} #mec-tickets';

    /**
     * Return widget name
     *
     * @since 1.0.0
     *
     * @return string
     */
    public function get_name(){

        return 'mec-fes-tickets';
    }

    /**
     * Return widget title
     *
     * @since 1.0.0
     *
     * @return string
     */
    public function get_title(){

        return __( 'Tickets', MECFBTEXTDOMAIN );
    }

    /**
     * Return icon class css
     *
     * @since 1.0.0
     *
     * @return void
     */
	public function get_icon() {

        return 'eicon-product-meta';
    }

    /**
     * Return categories
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_categories() {

        return array( 'FES_Builder' );
    }

    /**
     * Return scripts
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_script_depends() {

        return array();
    }

    /**
     * Return styles
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_style_depends() {

        return array();
    }

    /**
     * Register controls
     *
     * @since 1.0.0
     *
     * @return void
     */
	protected function register_controls() {

        $base_selector = $this->fes_base_selector;

        $settings = \MEC\Settings\Settings::getInstance()->get_settings();

        // Ticket Times Status
        $ticket_times_status = (isset($settings['disable_ticket_times']) and $settings['disable_ticket_times']) ? false : true;

        // Variations Per Ticket
        $variations_per_ticket_status = (isset($settings['ticket_variations_per_ticket']) and $settings['ticket_variations_per_ticket']) ? true : false;

        $this->register_box_styles();
        $this->register_box_styles(
            'ticket_box_',
            "{$base_selector} .mec_ticket_row",
            "{$base_selector} .mec_ticket_row:hover",
            __( 'Ticket box', MECFBTEXTDOMAIN )
        );
        $this->register_header_styles();
        $this->register_header_styles(
            'sub_header_',
            "{$base_selector} .mec_ticket_row h4",
            "{$base_selector} .mec_ticket_row h4:hover",
            __( 'Subheader', MECFBTEXTDOMAIN )
        );
        $this->register_button_styles(
            'add_ticket_button_',
            "{$base_selector} #mec_add_ticket_button",
            "{$base_selector} #mec_add_ticket_button:hover",
            __( 'Add button', MECFBTEXTDOMAIN )
        );

        $this->register_button_styles(
            'remove_ticket_button_',
            "{$base_selector} .mec_ticket_remove_button",
            "{$base_selector} .mec_ticket_remove_button:hover",
            __( 'Remove button', MECFBTEXTDOMAIN )
        );

        $this->register_label_styles(
            'label_',
            "{$base_selector} label:not([type=checkbox]~label):not([type=radio]~label):not(.label-checkbox), {$base_selector} .mec-label",
            "{$base_selector} label:not([type=checkbox]~label):not([type=radio]~label):not(.label-checkbox):hover, {$base_selector} .mec-label:hover",
            null,
            '',
            array()
        );

        $this->register_checkbox_label_styles();
        $this->register_checkbox_styles();

        $this->register_input_styles();
        $this->register_textarea_styles();
        $this->register_select_styles();

        if( $ticket_times_status ){

            $this->register_box_styles(
                'price_per_date_item_box_',
                "{$base_selector} .mec_new_ticket_price_raw",
                "{$base_selector} .mec_new_ticket_price_raw:hover",
                __( 'Price per date item box', MECFBTEXTDOMAIN )
            );

            $this->register_button_styles(
                'price_per_date_add_button_',
                "{$base_selector} .mec_add_price_date_button",
                "{$base_selector} .mec_add_price_date_button:hover",
                __( 'Price per date add button', MECFBTEXTDOMAIN )
            );

            $this->register_button_styles(
                'price_per_date_remove_button_',
                "{$base_selector} .mec_ticket_price_remove_button",
                "{$base_selector} .mec_ticket_price_remove_button:hover",
                __( 'Price per date remove button', MECFBTEXTDOMAIN )
            );
        }


        if( $variations_per_ticket_status ){

            $this->register_box_styles(
                'variations_per_ticket_item_box_',
                "{$base_selector} .mec-box mec_ticket_variation_row",
                "{$base_selector} .mec-box mec_ticket_variation_row:hover",
                __( 'Variations per ticket item box', MECFBTEXTDOMAIN )
            );

            $this->register_button_styles(
                'variations_per_ticket_add_button_',
                "{$base_selector} .mec_add_variation_per_ticket_button",
                "{$base_selector} .mec_add_variation_per_ticket_button:hover",
                __( 'Variations per ticket add button', MECFBTEXTDOMAIN )
            );

            $this->register_button_styles(
                'variations_per_ticket_remove_button_',
                "{$base_selector} .mec_remove_ticket_variation_button",
                "{$base_selector} .mec_remove_ticket_variation_button:hover",
                __( 'Variations per ticket remove button', MECFBTEXTDOMAIN )
            );
        }

        //mec_ticket_price_remove_button
    }

    /**
     * Render widget output
     *
     * @since 1.0.0
     *
     * @return void
     */
	protected function render() {

        $settings = $this->get_settings_for_display();

        $post = $this->get_post();

        $this->wrap_start();

        $atts = array(
            'is_edit_mode' => $this->is_edit_mode(),
        );

        FormBuilder::tickets( $post, $atts );

        $this->wrap_end();
    }
}
