<?php
/** no direct access **/
defined('MECEXEC') or die();

/**
 * Webnus MEC Full Calendar class.
 * @author Webnus <info@webnus.net>
 */
class MEC_skin_full_calendar extends MEC_skins
{
    /**
     * @var string
     */
    public $skin = 'full_calendar';

    public $include_local_time;
    public $reason_for_cancellation;
    public $display_label;
    public $default_view;
    public $monthly_style;
    public $yearly;
    public $monthly;
    public $weekly;
    public $daily;
    public $list;
    public $list_date_end;
    public $list_maximum_date;
    public $grid;
    public $grid_date_end;
    public $grid_maximum_date;
    public $tile;

    /**
     * Constructor method
     * @author Webnus <info@webnus.net>
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Registers skin actions into WordPress
     * @author Webnus <info@webnus.net>
     */
    public function actions()
    {
        $this->factory->action('wp_ajax_mec_full_calendar_switch_skin', array($this, 'switch_skin'));
        $this->factory->action('wp_ajax_nopriv_mec_full_calendar_switch_skin', array($this, 'switch_skin'));
    }

    /**
     * Initialize the skin
     * @author Webnus <info@webnus.net>
     * @param array $atts
     */
    public function initialize($atts)
    {
        $this->atts = $atts;

        // Skin Options
        $this->skin_options = (isset($this->atts['sk-options']) and isset($this->atts['sk-options'][$this->skin])) ? $this->atts['sk-options'][$this->skin] : [];

        // Icons
        $this->icons = $this->main->icons(
            isset($this->atts['icons']) && is_array($this->atts['icons']) ? $this->atts['icons'] : []
        );

        $this->style = $this->skin_options['style'] ?? 'classic';

        // Search Form Options
        $this->sf_options = (isset($this->atts['sf-options']) and isset($this->atts['sf-options'][$this->skin])) ? $this->atts['sf-options'][$this->skin] : [];

        // Next/Previous Month
        $this->next_previous_button = isset($this->skin_options['next_previous_button']) && $this->skin_options['next_previous_button'];

        // Search Form Status
        $this->sf_status = $this->atts['sf_status'] ?? true;
        $this->sf_display_label = $this->atts['sf_display_label'] ?? false;
        $this->sf_dropdown_method = $this->atts['sf_dropdown_method'] ?? '1';
        $this->sf_reset_button = $this->atts['sf_reset_button'] ?? false;
        $this->sf_refine = $this->atts['sf_refine'] ?? false;

        // Show Only Expired Events
        $this->show_only_expired_events = (isset($this->atts['show_only_past_events']) and trim($this->atts['show_only_past_events'])) ? '1' : '0';

        // Show Past Events
        $this->args['mec-past-events'] = $this->atts['show_past_events'] ?? '0';

        // Show Ongoing Events
        $this->show_ongoing_events = (isset($this->atts['show_only_ongoing_events']) and trim($this->atts['show_only_ongoing_events'])) ? '1' : '0';

        // Include Ongoing Events
        $this->include_ongoing_events = (isset($this->atts['show_ongoing_events']) and trim($this->atts['show_ongoing_events'])) ? '1' : '0';

        // Include Local Time
        $this->include_local_time = (isset($this->skin_options['include_local_time']) and trim($this->skin_options['include_local_time'])) ? '1' : '0';

        // Start Date
        $this->start_date = $this->get_start_date();

        // Generate an ID for the skin
        $this->id = $this->atts['id'] ?? mt_rand(100, 999);

        // Booking Button
        $this->booking_button = isset($this->skin_options['booking_button']) ? (int) $this->skin_options['booking_button'] : 0;

        // SED Method
        $this->sed_method = $this->get_sed_method();

        // Image popup
        $this->image_popup = $this->skin_options['image_popup'] ?? '0';

        // reason_for_cancellation
        $this->reason_for_cancellation = $this->skin_options['reason_for_cancellation'] ?? false;

        // display_label
        $this->display_label = $this->skin_options['display_label'] ?? false;

        // Default View of Full Calendar
        $this->default_view = $this->skin_options['default_view'] ?? 'list';

        // Default style for Monthly View
        $this->monthly_style = $this->skin_options['monthly_style'] ?? 'clean';
        if(isset($this->skin_options[$this->monthly_style]) and !$this->skin_options[$this->monthly_style]) $this->monthly_style = 'clean';

        $this->yearly = (isset($this->skin_options['yearly']) and $this->getPRO()) ? $this->skin_options['yearly'] : false;
        $this->monthly = $this->skin_options['monthly'] ?? true;
        $this->weekly = $this->skin_options['weekly'] ?? true;
        $this->daily = $this->skin_options['daily'] ?? true;
        $this->list = $this->skin_options['list'] ?? true;
        $this->grid = $this->skin_options['grid'] ?? true;
        $this->tile = $this->skin_options['tile'] ?? true;

        // If all the skins are disabled
        if(!$this->monthly and !$this->weekly and !$this->daily and !$this->list and !$this->yearly and !$this->grid and !$this->tile)
        {
            $this->monthly = true;
            $this->list = true;
        }

        // Validate Default View
        if(isset($this->{$this->default_view}) and !$this->{$this->default_view}) $this->default_view = 'list';

        // Set the ID
        if(!isset($this->atts['id'])) $this->atts['id'] = $this->id;

        do_action('mec-full-calendar-initialize-end', $this);
    }

    public function get_start_date()
    {
        // Default date
        $date = current_time('Y-m-d');

        if(isset($this->skin_options['start_date_type']) and $this->skin_options['start_date_type'] == 'today') $date = current_time('Y-m-d');
        elseif(isset($this->skin_options['start_date_type']) and $this->skin_options['start_date_type'] == 'tomorrow') $date = date('Y-m-d', strtotime('Tomorrow'));
        elseif(isset($this->skin_options['start_date_type']) and $this->skin_options['start_date_type'] == 'yesterday') $date = date('Y-m-d', strtotime('Yesterday'));
        elseif(isset($this->skin_options['start_date_type']) and $this->skin_options['start_date_type'] == 'start_last_month') $date = date('Y-m-d', strtotime('first day of last month'));
        elseif(isset($this->skin_options['start_date_type']) and $this->skin_options['start_date_type'] == 'start_current_month') $date = date('Y-m-d', strtotime('first day of this month'));
        elseif(isset($this->skin_options['start_date_type']) and $this->skin_options['start_date_type'] == 'start_next_month') $date = date('Y-m-d', strtotime('first day of next month'));
        elseif(isset($this->skin_options['start_date_type']) and $this->skin_options['start_date_type'] == 'date') $date = date('Y-m-d', strtotime($this->skin_options['start_date']));

        // Hide past events
        if(isset($this->atts['show_past_events']) and !trim($this->atts['show_past_events']))
        {
            $today = current_time('Y-m-d');
            if(strtotime($date) < strtotime($today)) $date = $today;
        }

        // Show only expired events
        if(isset($this->show_expired_events) and $this->show_expired_events)
        {
            $now = date('Y-m-d H:i:s', current_time('timestamp'));
            if(strtotime($date) > strtotime($now)) $date = $now;
        }

        return $date;
    }

    public function search()
    {
    }

    public function prepare_skin_options( $skin, $atts ) {

        switch($skin)
        {
            case 'yearly':

                $start_date_type = $this->skin_options['start_date_type'] ?? 'start_current_year';

                if($start_date_type == 'start_current_month') $start_date_type = 'start_current_year';
                elseif($start_date_type == 'start_next_month') $start_date_type = 'start_next_year';
                else $start_date_type = 'date';

                $atts['sk-options']['yearly_view']['start_date_type'] = $start_date_type;
                $atts['sk-options']['yearly_view']['start_date'] = (isset($this->skin_options['start_date']) and trim($this->skin_options['start_date'])) ? $this->skin_options['start_date'] : current_time('Y-01-01');
                $atts['sk-options']['yearly_view']['style'] = 'modern';
                $atts['sk-options']['yearly_view']['sed_method'] = $this->skin_options['sed_method'] ?? '0';
                $atts['sk-options']['yearly_view']['image_popup'] = $this->skin_options['image_popup'] ?? '0';
                $atts['sk-options']['yearly_view']['display_price'] = $this->skin_options['display_price'] ?? 0;
                $atts['sk-options']['yearly_view']['limit'] = $this->skin_options['limit'] ?? 12;
                $atts['sk-options']['yearly_view']['modern_date_format1'] = $this->skin_options['date_format_yearly_1'] ?? 'l';
                $atts['sk-options']['yearly_view']['modern_date_format2'] = $this->skin_options['date_format_yearly_2'] ?? 'F j';
                $atts['sk-options']['yearly_view']['display_label'] = $this->skin_options['display_label'] ?? false;
                $atts['sk-options']['yearly_view']['reason_for_cancellation'] = $this->skin_options['reason_for_cancellation'] ?? false;
                $atts['sk-options']['yearly_view']['include_local_time'] = $this->include_local_time;
                $atts['sk-options']['yearly_view']['booking_button'] = $this->skin_options['booking_button'] ?? 0;
                $atts['sk-options']['yearly_view']['image_size'] = $this->skin_options['image_size'] ?? 'default';
                $atts['sk-options']['yearly_view']['from_fc'] = 1;
                $atts['sf_status'] = false;

                $atts = apply_filters('mec-full-calendar-load-skin-yearly', $atts, $this, 'yearly_view');

                break;

            case 'monthly':

                $start_date_type = $this->skin_options['start_date_type'] ?? 'today';
                if($start_date_type == 'today') $start_date_type = 'start_current_month';

                $atts['sk-options']['monthly_view']['start_date_type'] = $start_date_type;
                $atts['sk-options']['monthly_view']['start_date'] = $this->skin_options['start_date'] ?? '';
                $atts['sk-options']['monthly_view']['style'] = $this->monthly_style;
                $atts['sk-options']['monthly_view']['sed_method'] = $this->skin_options['sed_method'] ?? '0';
                $atts['sk-options']['monthly_view']['image_popup'] = $this->skin_options['image_popup'] ?? '0';
                $atts['sk-options']['monthly_view']['display_price'] = $this->skin_options['display_price'] ?? 0;
                $atts['sk-options']['monthly_view']['limit'] = $this->skin_options['limit'] ?? 12;
                $atts['sk-options']['monthly_view']['display_label'] = $this->skin_options['display_label'] ?? false;
                $atts['sk-options']['monthly_view']['mobile_clean_style'] = $this->skin_options['mobile_clean_style'] ?? false;
                $atts['sk-options']['monthly_view']['reason_for_cancellation'] = $this->skin_options['reason_for_cancellation'] ?? false;
                $atts['sk-options']['monthly_view']['include_local_time'] = $this->include_local_time;
                $atts['sk-options']['monthly_view']['activate_first_date'] = $this->skin_options['activate_first_date'] ?? '0';
                $atts['sk-options']['monthly_view']['activate_current_day'] = $this->skin_options['activate_current_day'] ?? '1';
                $atts['sk-options']['monthly_view']['display_all'] = $this->skin_options['display_all'] ?? 0;
                $atts['sk-options']['monthly_view']['booking_button'] = $this->skin_options['booking_button'] ?? 0;
                $atts['sk-options']['monthly_view']['image_size'] = $this->skin_options['image_size'] ?? 'default';
                $atts['sk-options']['monthly_view']['from_fc'] = 1;
                $atts['sf_status'] = false;

                $atts = apply_filters('mec-full-calendar-load-skin-monthly', $atts, $this, 'monthly_view');

                break;

            case 'weekly':

                $start_date_type = $this->skin_options['start_date_type'] ?? 'today';
                if($start_date_type == 'today') $start_date_type = 'start_current_week';

                $atts['sk-options']['weekly_view']['start_date_type'] = $start_date_type;
                $atts['sk-options']['weekly_view']['start_date'] = $this->skin_options['start_date'] ?? '';
                $atts['sk-options']['weekly_view']['sed_method'] = $this->skin_options['sed_method'] ?? '0';
                $atts['sk-options']['weekly_view']['image_popup'] = $this->skin_options['image_popup'] ?? '0';
                $atts['sk-options']['weekly_view']['display_price'] = $this->skin_options['display_price'] ?? 0;
                $atts['sk-options']['weekly_view']['limit'] = $this->skin_options['limit'] ?? 12;
                $atts['sk-options']['weekly_view']['display_label'] = $this->skin_options['display_label'] ?? false;
                $atts['sk-options']['weekly_view']['reason_for_cancellation'] = $this->skin_options['reason_for_cancellation'] ?? false;
                $atts['sk-options']['weekly_view']['include_local_time'] = $this->include_local_time;
                $atts['sk-options']['weekly_view']['booking_button'] = $this->skin_options['booking_button'] ?? 0;
                $atts['sk-options']['weekly_view']['image_size'] = $this->skin_options['image_size'] ?? 'default';
                $atts['sk-options']['weekly_view']['from_fc'] = 1;
                $atts['sf_status'] = false;

                $atts = apply_filters('mec-full-calendar-load-skin-weekly', $atts, $this, 'weekly_view');

                break;

            case 'daily':

                $atts['sk-options']['daily_view']['start_date_type'] = $this->skin_options['start_date_type'] ?? '';
                $atts['sk-options']['daily_view']['start_date'] = $this->skin_options['start_date'] ?? '';
                $atts['sk-options']['daily_view']['sed_method'] = $this->skin_options['sed_method'] ?? '0';
                $atts['sk-options']['daily_view']['image_popup'] = $this->skin_options['image_popup'] ?? '0';
                $atts['sk-options']['daily_view']['display_price'] = $this->skin_options['display_price'] ?? 0;
                $atts['sk-options']['daily_view']['limit'] = $this->skin_options['limit'] ?? 12;
                $atts['sk-options']['daily_view']['display_label'] = $this->skin_options['display_label'] ?? false;
                $atts['sk-options']['daily_view']['reason_for_cancellation'] = $this->skin_options['reason_for_cancellation'] ?? false;
                $atts['sk-options']['daily_view']['include_local_time'] = $this->include_local_time;
                $atts['sk-options']['daily_view']['booking_button'] = $this->skin_options['booking_button'] ?? 0;
                $atts['sk-options']['daily_view']['image_size'] = $this->skin_options['image_size'] ?? 'default';
                $atts['sk-options']['daily_view']['from_fc'] = 1;
                $atts['sf_status'] = false;

                $atts = apply_filters('mec-full-calendar-load-skin-daily', $atts, $this, 'daily_view');

                break;

            case 'grid':

                // Maximum Date Range.
                $end_date_type = (isset($this->skin_options['end_date_type_grid']) and trim($this->skin_options['end_date_type_grid'])) ? trim($this->skin_options['end_date_type_grid']) : 'date';

                if($end_date_type === 'today') $maximum_date = current_time('Y-m-d');
                elseif($end_date_type === 'tomorrow') $maximum_date = date('Y-m-d', strtotime('Tomorrow'));
                else $maximum_date = (isset($this->skin_options['maximum_date_range_grid']) and trim($this->skin_options['maximum_date_range_grid'])) ? trim($this->skin_options['maximum_date_range_grid']) : '';

                $atts['sk-options']['grid']['start_date_type'] = $this->skin_options['start_date_type'] ?? '';
                $atts['sk-options']['grid']['start_date'] = $this->skin_options['start_date'] ?? '';
                $atts['sk-options']['grid']['end_date_type'] = $end_date_type;
                $atts['sk-options']['grid']['maximum_date_range'] = $maximum_date;
                $atts['sk-options']['grid']['order_method'] = ((isset($this->skin_options['order_method_grid']) and trim($this->skin_options['order_method_grid'])) ? $this->skin_options['order_method_grid'] : 'ASC');
                $atts['sk-options']['grid']['style'] = 'modern';
                $atts['sk-options']['grid']['sed_method'] = $this->skin_options['sed_method'] ?? '0';
                $atts['sk-options']['grid']['image_popup'] = $this->skin_options['image_popup'] ?? '0';
                $atts['sk-options']['grid']['display_price'] = $this->skin_options['display_price'] ?? 0;
                $atts['sk-options']['grid']['limit'] = $this->skin_options['limit'] ?? 12;
                $atts['sk-options']['grid']['modern_date_format1'] = 'd';
                $atts['sk-options']['grid']['modern_date_format2'] = 'F';
                $atts['sk-options']['grid']['modern_date_format3'] = 'l';
                $atts['sk-options']['grid']['count'] = '3';
                $atts['sk-options']['grid']['display_label'] = $this->skin_options['display_label'] ?? false;
                $atts['sk-options']['grid']['reason_for_cancellation'] = $this->skin_options['reason_for_cancellation'] ?? false;
                $atts['sk-options']['grid']['include_local_time'] = $this->include_local_time;
                $atts['sk-options']['grid']['booking_button'] = $this->skin_options['booking_button'] ?? 0;
                $atts['sk-options']['grid']['image_size'] = $this->skin_options['image_size'] ?? 'default';
                $atts['sk-options']['grid']['from_fc'] = 1;
                $atts['sf_status'] = false;

                $atts = apply_filters('mec-full-calendar-load-skin-grid', $atts, $this, 'grid');

                break;

            case 'tile':

                $atts['sk-options']['tile']['start_date_type'] = $this->skin_options['start_date_type'] ?? '';
                $atts['sk-options']['tile']['start_date'] = $this->skin_options['start_date'] ?? '';
                $atts['sk-options']['tile']['style'] = 'clean';
                $atts['sk-options']['tile']['sed_method'] = $this->skin_options['sed_method'] ?? '0';
                $atts['sk-options']['tile']['image_popup'] = $this->skin_options['image_popup'] ?? '0';
                $atts['sk-options']['tile']['display_price'] = $this->skin_options['display_price'] ?? 0;
                $atts['sk-options']['tile']['limit'] = $this->skin_options['limit'] ?? 12;
                $atts['sk-options']['tile']['clean_date_format1'] = 'j';
                $atts['sk-options']['tile']['clean_date_format2'] = 'M';
                $atts['sk-options']['tile']['display_label'] = $this->skin_options['display_label'] ?? false;
                $atts['sk-options']['tile']['reason_for_cancellation'] = $this->skin_options['reason_for_cancellation'] ?? false;
                $atts['sk-options']['tile']['include_local_time'] = $this->include_local_time;
                $atts['sk-options']['tile']['booking_button'] = $this->skin_options['booking_button'] ?? 0;
                $atts['sk-options']['tile']['image_size'] = $this->skin_options['image_size'] ?? 'default';
                $atts['sk-options']['tile']['from_fc'] = 1;
                $atts['sf_status'] = false;

                $atts = apply_filters('mec-full-calendar-load-skin-tile', $atts, $this, 'tile');

                break;

            case 'list':
            default:

                // Maximum Date Range.
                $end_date_type = (isset($this->skin_options['end_date_type_list']) and trim($this->skin_options['end_date_type_list'])) ? trim($this->skin_options['end_date_type_list']) : 'date';

                if($end_date_type === 'today') $maximum_date = current_time('Y-m-d');
                elseif($end_date_type === 'tomorrow') $maximum_date = date('Y-m-d', strtotime('Tomorrow'));
                else $maximum_date = (isset($this->skin_options['maximum_date_range_list']) and trim($this->skin_options['maximum_date_range_list'])) ? trim($this->skin_options['maximum_date_range_list']) : '';

                $atts['sk-options']['list']['start_date_type'] = $this->skin_options['start_date_type'] ?? '';
                $atts['sk-options']['list']['start_date'] = $this->skin_options['start_date'] ?? '';
                $atts['sk-options']['list']['end_date_type'] = $end_date_type;
                $atts['sk-options']['list']['maximum_date_range'] = $maximum_date;
                $atts['sk-options']['list']['order_method'] = ((isset($this->skin_options['order_method_list']) and trim($this->skin_options['order_method_list'])) ? $this->skin_options['order_method_list'] : 'ASC');
                $atts['sk-options']['list']['style'] = 'standard';
                $atts['sk-options']['list']['sed_method'] = $this->skin_options['sed_method'] ?? '0';
                $atts['sk-options']['list']['image_popup'] = $this->skin_options['image_popup'] ?? '0';
                $atts['sk-options']['list']['display_price'] = $this->skin_options['display_price'] ?? 0;
                $atts['sk-options']['list']['limit'] = $this->skin_options['limit'] ?? 12;
                $atts['sk-options']['list']['standard_date_format1'] = $this->skin_options['date_format_list'] ?? 'd M';
                $atts['sk-options']['list']['display_label'] = $this->skin_options['display_label'] ?? false;
                $atts['sk-options']['list']['reason_for_cancellation'] = $this->skin_options['reason_for_cancellation'] ?? false;
                $atts['sk-options']['list']['include_local_time'] = $this->include_local_time;
                $atts['sk-options']['list']['booking_button'] = $this->skin_options['booking_button'] ?? 0;
                $atts['sk-options']['list']['image_size'] = $this->skin_options['image_size'] ?? 'default';
                $atts['sk-options']['list']['from_fc'] = 1;
                $atts['sf_status'] = false;

                $atts = apply_filters('mec-full-calendar-load-skin-list', $atts, $this, 'list');

                break;
        }

        return $atts;
    }

    public function load_skin($skin = 'list') {

        $atts = $this->atts;

        $atts = $this->prepare_skin_options( $skin, $atts );

        switch($skin)
        {
            case 'yearly':

                $output = $this->render->vyear($atts);

                break;
            case 'monthly':

                // Month Rotation
                $atts['auto_month_rotation'] = 0;

                $output = $this->render->vmonth($atts);

                break;
            case 'weekly':

                $output = $this->render->vweek($atts);

                break;

            case 'daily':

                $output = $this->render->vday($atts);

                break;

            case 'grid':

                $output = $this->render->vgrid($atts);

                break;

            case 'tile':

                $output = $this->render->vtile($atts);

                break;

            case 'list':
            default:

                $output = $this->render->vlist($atts);

                break;
        }

        return $output;
    }

    /**
     * Load skin for AJAX request
     * @author Webnus <info@webnus.net>
     * @return void
     */
    public function switch_skin()
    {
        $this->sf = (isset($_REQUEST['sf']) and is_array($_REQUEST['sf'])) ? $this->main->sanitize_deep_array($_REQUEST['sf']) : [];
        $apply_sf_date = isset($_REQUEST['apply_sf_date']) ? sanitize_text_field($_REQUEST['apply_sf_date']) : 1;
        $atts = $this->sf_apply(((isset($_REQUEST['atts']) and is_array($_REQUEST['atts'])) ? $this->main->sanitize_deep_array($_REQUEST['atts']) : array()), $this->sf, $apply_sf_date);

        $skin = isset($_REQUEST['skin']) ? sanitize_text_field($_REQUEST['skin']) : 'list';

        // Single Event Display
        $atts['sed_method'] = isset($_REQUEST['sed']) ? sanitize_text_field($_REQUEST['sed']) : 0;
        $atts['image_popup'] = isset($_REQUEST['image']) ? sanitize_text_field($_REQUEST['image']) : 0;

        // Initialize the skin
        $this->initialize($atts);

        // Return the output
        $output = $this->load_skin($skin);

        echo $output;
        exit;
    }
}
