<?php

namespace MEC_Core\Books;

use MEC_Core\PostBase;

class Book extends PostBase{

    public function __construct($data){

        $this->type = 'book';
        parent::__construct($data);
    }

    /**
     * @return int
     */
    public function get_event_id(){

        return (int)$this->get_meta('mec_event_id');
    }

    /**
     * @return array //TODO: Convert to Attendee[]
     */
    public function get_attendees(){

        return $this->get_meta('mec_attendees');
    }

    /**     
     * @return string $start_timestamp:$end_timestamp
     */
    public function get_attention_time($type = null){

        $data = $this->get_meta('mec_attention_time');
        if(!is_null($type)){

            $data = explode(':',$data);
        }

        if('start' === $type){

            $data = isset($data[0]) ? $data[0] : '';
        }elseif('end' === $type){

            $data = isset($data[1]) ? $data[1] : '';
        }

        return $data;
    }

    /**     
     * @return int -1 , 0 , 1
     */
    public function get_confirm_status(){

        return $this->get_meta('mec_confirmed');
    }

    /**     
     * @return int -1 , 0 , 1
     */
    public function get_verification_status(){

        return $this->get_meta('mec_verified');
    }

    public function get_price(){

        return $this->get_meta('mec_price');
    }

    public function get_location_id(){

        return $this->get_meta('mec_booking_location');
    }

    public function get_location_term(){

        $location_id = $this->get_location_id();        
        $location = get_term($location_id,'mec_location',ARRAY_A);

        return $location;
    }

    /**
     * @return array
     */
    public function get_tickets_ids(){
        
        $ids = array();
        $tickets = get_post_meta($this->ID, 'mec_ticket_id', true);
        $tickets = explode(',',$tickets);


        foreach($tickets as $ticket_id){

            if(empty($ticket_id) || isset($ids[$ticket_id])){

                continue;
            }

            $ids[$ticket_id] = $ticket_id;
        }

        return $ids;
    }
}