<?php

namespace MEC_Core;

abstract class PostBase{

    /**
     * @var int
     */
    public $ID;

    /**
     * @var string
     */
    public $type;

    /**
     * @var array
     */
    public $data;

    public function __construct($data){

        if(is_a($data,'\WP_Post')){

            $this->ID = $data->ID;
            $this->data['title'] = $data->title;
        }elseif(is_array($data)){

            $this->ID = $data['ID'];
            $this->data = $data;
        }
        
    }

    /**     
     * @param string $key
     * @param mixed $default
     * @return mixed
     */
    public function get_data($key,$default = null){
        
        $v = isset($this->data[$key]) ? $this->data[$key] : $default;

        return apply_filters('mec_'.$this->type.'_get_data',$v,$key,$this->data,$default);
    }

    public function get_cached_all_data(){

        return $this->data;
    }

    public function to_array(){

        return $this->get_cached_all_data();
    }

    /**
     * @param string $key
     * @return mixed
     */
    public function get_meta($key,$return_cached = true){

        $data = $this->get_data($key);
        if(is_null($data) || !$return_cached){

            $data = get_post_meta($this->ID,$key,true);
            $this->data[$key] = $data;
        }
        return $data;
    }

}