<?php

namespace MEC_Zapier\Core;
// don't load directly.
if (!defined('ABSPATH')) {
    header('Status: 403 Forbidden');
    header('HTTP/1.1 403 Forbidden');
    exit;
}
/**
 * Loader.
 *
 * @author      author
 * @package     package
 * @since       1.0.0
 */
class Loader
{

    /**
     * Instance of this class.
     *
     * @since   1.0.0
     * @access  public
     * @var     MEC_Zapier
     */
    public static $instance;

    /**
     * The directory of the file.
     *
     * @access  public
     * @var     string
     */
    public static $dir;

    /**
     * Provides access to a single instance of a module using the singleton pattern.
     *
     * @since   1.0.0
     * @return  object
     */
    public static function instance()
    {
        if (self::$instance === null) {
            self::$instance = new self();
        }

        return self::$instance;
    }


    public function __construct()
    {
        self::settingUp();
        self::preLoad();
        self::setHooks();
        self::registerAutoloadFiles();
        self::loadInits();
    }

    /**
     * Global Variables.
     *
     * @since   1.0.0
     */
    public static function settingUp()
    {
        self::$dir     = MECZAPIERDIR . 'core';
    }

    /**
     * Hooks
     *
     * @since     1.0.0
     */
    public static function setHooks()
    {
        add_action('admin_init', function () {
            \MEC_Zapier\Autoloader::load('MEC_Zapier\Core\checkLicense\ZapierAddonUpdateActivation');
        });
    }

    /**
     * preLoad
     *
     * @since     1.0.0
     */
    public static function preLoad()
    {
        include_once self::$dir . DS . 'autoloader' . DS . 'autoloader.php';
    }

    /**
     * Register Autoload Files
     *
     * @since     1.0.0
     */
    public static function registerAutoloadFiles()
    {
        if (!class_exists('\MEC_Zapier\Autoloader')) {
            return;
        }

        \MEC_Zapier\Autoloader::addClasses(
            [
                'MEC_Zapier\\Core\\SetOptions\\SetOptions' => self::$dir . '/setOptions/set-options.php',
                'MEC_Zapier\\Core\\SetRoutes\\SetRoutes' => self::$dir . '/setRoutes/set-routes.php',
                'MEC_Zapier\\Core\\SetRoutes\\SetRoutesV2' => self::$dir . '/setRoutes/set-routes-v2.php',
                'MEC_Zapier\\Core\\checkLicense\\ZapierAddonUpdateActivation' => self::$dir . '/checkLicense/update-activation.php',

                'MEC_Core\\PostBase' => self::$dir . '/PostBase.php',
                'MEC_Core\\Singleton' => self::$dir . '/Singleton.php',
                'MEC_Core\\Books\\Book' => self::$dir . '/Books/Book.php',
                'MEC_Core\\Tickets\\Tickets' => self::$dir . '/Tickets/Tickets.php',
                'MEC_Core\\Tickets\\Ticket' => self::$dir . '/Tickets/Ticket.php',
            ]
        );
    }

    /**
     * Load Init
     *
     * @since     1.0.0
     */
    public static function loadInits()
    {
        \MEC_Zapier\Autoloader::load('MEC_Zapier\Core\SetOptions\SetOptions');
        \MEC_Zapier\Autoloader::load('MEC_Zapier\Core\SetRoutes\SetRoutes');
        \MEC_Zapier\Autoloader::load('MEC_Zapier\Core\SetRoutes\SetRoutesV2');
    }
} //Loader

Loader::instance();
