<?php

namespace MEC_Zapier\Core\SetOptions;

// don't load directly.
if (!defined('ABSPATH')) {
    header('Status: 403 Forbidden');
    header('HTTP/1.1 403 Forbidden');
    exit;
}

/**
 * SetOptions.
 *
 * @author      author
 * @package     package
 * @since       1.0.0
 */
class SetOptions
{

    /**
     * Instance of this class.
     *
     * @since   1.0.0
     * @access  public
     * @var     MEC_Zapier
     */
    public static $instance;

    /**
     * The directory of the file.
     *
     * @access  public
     * @var     string
     */
    public static $dir;

    /**
     * The Args
     *
     * @access  public
     * @var     array
     */
    public static $args;

    /**
     * Provides access to a single instance of a module using the singleton pattern.
     *
     * @since   1.0.0
     * @return  object
     */
    public static function instance()
    {
        if (self::$instance === null) {
            self::$instance = new self();
        }

        return self::$instance;
    }


    public function __construct()
    {
        self::settingUp($this);
        self::setHooks($this);
        self::init();
    }

    /**
     * Set Hooks.
     *
     * @since   1.0.0
     */
    public static function setHooks($This)
    {
        add_action( 'init', array($This,'createApiKey'));
        add_filter( 'mec-settings-items-settings', [$This,'add_settings_content'], '', 1 );
        add_action( 'mec-settings-page-before-form-end', [$This,'add_zapier_integration_settings_content'], '', 1 );
    }

    /**
     * add zapier integration settings left menu item
     *
     * @since   1.0.0
     */
    public function add_settings_content($activated){
        $activated['Zapier Integration']= 'zapierintegration_option';
        return $activated;

    }

    /**
     * add user dashboard settings content
     *
     * @since   1.0.0
     */
    public function add_zapier_integration_settings_content($settings) {
        $pages = get_pages();
        $getZapierKey = get_option('mecZapierKey');
        $namespace = 'mec-zapier/v1';
        $namespace_v2 = 'mec-zapier/v2';
        $apiPath = 'api/';

        $main = new \MEC_Main();
        $settings = $main->get_settings();
        ?>
        <div id="zapierintegration_option" class="mec-options-fields">
            <h4 class="mec-form-subtitle"><?php _e('Zapier Integration', 'mec-zapier'); ?></h4>
            <div class="mec-form-row">
                <label class="mec-col-2" for="zapier-api-url"><?php _e('API URL V2', 'mec-zapier'); ?></label>
                <div class="mec-col-5">
                    <input id="zapier-api-url" style="width:280px;" type="text" readonly value="<?php echo site_url(). '/wp-json/'.$namespace_v2 .'/'. $apiPath  ; ?>" />
                    <span class="mec-tooltip zapier-api-url-tooltip">
                        <div class="box top">
                            <h5 class="title"><?php echo esc_html__('Copy to clipboard', 'mec-zapier'); ?></h5>
                        </div>
                        <i onmouseout="outFunc()" onclick="copyApiUrl()" title="" style="font-size: 20px;margin-left: 10px;vertical-align: middle;margin-top: -4px;display: inline-block;color: #40d9f1;" class="sl-docs"></i>
                    </span>
                </div>
            </div>
            <div class="mec-form-row">
                <label class="mec-col-2" for="zapier-api-v2-key"><?php _e('API Key', 'mec-zapier'); ?></label>
                <div class="mec-col-5">
                    <input id="zapier-api-v2-key"  style="width:280px;" type="text" readonly value="<?php echo $getZapierKey; ?>" />
                    <span class="mec-tooltip zapier-api-key-tooltip">
                        <div class="box top">
                            <h5 class="title"><?php echo esc_html__('Copy to clipboard', 'mec-zapier'); ?></h5>
                        </div>
                        <i onmouseout="outFunc()" onclick="copyApiKey()" title="" style="font-size: 20px;margin-left: 10px;vertical-align: middle;margin-top: -4px;display: inline-block;color: #40d9f1;" class="sl-docs"></i>
                    </span>
                </div>
            </div>
            <div class="mec-form-row">
                <div class="mec-col-12">
                    <label for="mec_settings_api_v2_set_settings_status">
                        <?php $set_settings_status = isset($settings['api_v2']['set_settings_status']) ? 'yes' === $settings['api_v2']['set_settings_status'] : false; ?>
                        <input type="checkbox" name="mec[settings][api_v2][set_settings_status]" id="mec_settings_api_v2_set_settings_status" <?php checked(true,$set_settings_status) ?> value="yes">
                        <?php esc_html_e('Enable Set Settings Zap with Test Data','mec-zapier') ?>
                    </label>
                    <p style="color:red"><?php esc_html_e('Please disable this option after registering the Zap settings','mec-zapier') ?></p>
                </div>
            </div>

            <div class="mec-form-row">
                <label class="mec-col-3" for="mec_settings_api_v2_max_attendees"><?php esc_html_e('Max Attendees', 'mec-zapier'); ?></label>
                <div class="mec-col-9">
                    <?php $max_attendees = isset($settings['api_v2']['max_attendees']) && is_numeric($settings['api_v2']['max_attendees']) ? (int)$settings['api_v2']['max_attendees'] : ''; ?>
                    <input type="number" id="mec_settings_api_v2_max_attendees" name="mec[settings][api_v2][max_attendees]" value="<?php echo $max_attendees  ?>" placeholder="<?php esc_attr_e('10', 'mec'); ?>"/>
                </div>
            </div>

            <div class="mec-form-row">
                <label class="mec-col-3" for="mec_settings_api_v2_max_tickets"><?php esc_html_e('Max Tickets', 'mec-zapier'); ?></label>
                <div class="mec-col-9">
                    <?php $max_tickets = isset($settings['api_v2']['max_tickets']) && is_numeric($settings['api_v2']['max_tickets']) ? (int)$settings['api_v2']['max_tickets'] : ''; ?>
                    <input type="number" id="mec_settings_api_v2_max_tickets" name="mec[settings][api_v2][max_tickets]" value="<?php echo $max_tickets ?>" placeholder="<?php esc_attr_e('10', 'mec'); ?>"/>
                </div>
            </div>

            <div class="mec-form-row">
                <label class="mec-col-3" for="mec_settings_api_v2_max_event_occurrences"><?php esc_html_e('Max Event Occurrences', 'mec-zapier'); ?></label>
                <div class="mec-col-9">
                    <?php $max_tickets = isset($settings['api_v2']['max_event_occurrences']) && is_numeric($settings['api_v2']['max_event_occurrences']) ? (int)$settings['api_v2']['max_event_occurrences'] : ''; ?>
                    <input type="number" id="mec_settings_api_v2_max_event_occurrences" name="mec[settings][api_v2][max_event_occurrences]" value="<?php echo $max_tickets ?>" placeholder="<?php _e('10', 'mec'); ?>"/>
                </div>
            </div>

            <div class="mec-form-row">
                <label class="mec-col-3" for="mec_settings_api_v2_max_terms"><?php esc_html_e('Max Terms', 'mec-zapier'); ?></label>
                <div class="mec-col-9">
                    <?php $max_tickets = isset($settings['api_v2']['max_terms']) && is_numeric($settings['api_v2']['max_terms']) ? (int)$settings['api_v2']['max_terms'] : ''; ?>
                    <input type="number" id="mec_settings_api_v2_max_terms" name="mec[settings][api_v2][max_terms]" value="<?php echo $max_tickets ?>" placeholder="<?php esc_attr_e('2', 'mec'); ?>"/>
                </div>
            </div>
            <!-- End API V2 Settings -->

            <div class="mec-form-row">
                <label class="mec-col-2" for="mec_settings_user_dashboard_page"><?php _e('API URL V1', 'mec-zapier'); ?></label>
                <div class="mec-col-5">
                    <input id="zapier-api-url" style="width:280px;" type="text" readonly value="<?php echo site_url(). '/wp-json/'.$namespace .'/'. $apiPath  ; ?>" />
                    <span class="mec-tooltip zapier-api-url-tooltip">
                        <div class="box top">
                            <h5 class="title"><?php echo esc_html__('Copy to clipboard', 'mec-zapier'); ?></h5>
                        </div>
                        <i onmouseout="outFunc()" onclick="copyApiUrl()" title="" style="font-size: 20px;margin-left: 10px;vertical-align: middle;margin-top: -4px;display: inline-block;color: #40d9f1;" class="sl-docs"></i>
                    </span>
                </div>
            </div>
            <div class="mec-form-row">
                <label class="mec-col-2" for="mec_settings_user_dashboard_page"><?php _e('API Key', 'mec-zapier'); ?></label>
                <div class="mec-col-5">
                    <input id="zapier-api-key"  style="width:280px;" type="text" readonly value="<?php echo $getZapierKey; ?>" />
                    <span class="mec-tooltip zapier-api-key-tooltip">
                        <div class="box top">
                            <h5 class="title"><?php echo esc_html__('Copy to clipboard', 'mec-zapier'); ?></h5>
                        </div>
                        <i onmouseout="outFunc()" onclick="copyApiKey()" title="" style="font-size: 20px;margin-left: 10px;vertical-align: middle;margin-top: -4px;display: inline-block;color: #40d9f1;" class="sl-docs"></i>
                    </span>
                </div>
            </div>
            <style>
                #zapierintegration_option .mec-tooltip {
                    cursor: pointer;
                    top: -2px;
                    display: inline-block;
                }
                #zapierintegration_option .mec-tooltip .box:before {
                    background-color: #3a3f44!important;
                }
                #zapierintegration_option .mec-tooltip .box h5 {
                    margin-bottom: 0;
                    border-radius: 6px;
                }
                #zapierintegration_option .mec-tooltip .box.top {
                    margin-top: -10px;
                }
                #zapierintegration_option .mec-tooltip:hover .box {
                    padding: 20px 20px 0;
                }
                #zapierintegration_option a i {
                    cursor: pointer;
                }
                #zapierintegration_option a i:hover {
                    color:#000
                }
            </style>
            <script>
            function outFunc(){
                jQuery("#zapierintegration_option .mec-tooltip h5").text("<?php echo esc_html('Copy to clipboard', 'mec-zapier'); ?>");
            }
            function copyApiUrl() {
                var copyText = document.getElementById("zapier-api-url");
                copyText.select();
                copyText.setSelectionRange(0, 99999)
                document.execCommand("copy");
                jQuery("#zapierintegration_option .mec-tooltip.zapier-api-url-tooltip h5").text("<?php echo esc_html('Copied' , 'mec-zapier'); ?>");
            }
            function copyApiKey() {
                var copyText = document.getElementById("zapier-api-key");
                copyText.select();
                copyText.setSelectionRange(0, 99999)
                document.execCommand("copy");
                jQuery("#zapierintegration_option .mec-tooltip.zapier-api-key-tooltip h5").text("<?php echo esc_html('Copied' , 'mec-zapier'); ?>");
            }
            </script>
        </div>
        <?php
    }

    /**
     * Create API key
     *
     * @since   1.0.0
     */
    public function createApiKey()
    {
        $getZapierKey = get_option('mecZapierKey');
        $apiKey = '';
        if ( !isset($getZapierKey) || empty($getZapierKey) ){
            $apiKey = implode('', str_split(substr(strtolower(md5(microtime().rand(1000, 9999))), 0, 30), 6));
            update_option('mecZapierKey' , $apiKey);
        }
        return true;
    }

    /**
     * Global Variables.
     *
     * @since   1.0.0
     */
    public static function settingUp($This)
    {
    }

    /**
     * Register Autoload Files
     *
     * @since     1.0.0
     */
    public function init()
    {
        if (!class_exists('\MEC_Zapier\Autoloader')) {
            return;
        }
    }
} //SetOptions
