<?php

namespace MEC_Zapier\Core\SetRoutes;

// don't load directly.
if (!defined('ABSPATH')) {
    header('Status: 403 Forbidden');
    header('HTTP/1.1 403 Forbidden');
    exit;
}

/**
 * SetRoutes.
 *
 * @author      author
 * @package     package
 * @since       1.0.0
 */
class SetRoutes
{

    /**
     * Instance of this class.
     *
     * @since   1.0.0
     * @access  public
     * @var     MEC_Zapier
     */
    public static $instance;

    /**
     * The directory of the file.
     *
     * @access  public
     * @var     string
     */
    public static $dir;

    /**
     * The Args
     *
     * @access  public
     * @var     array
     */
    public static $args;

    /**
     * Provides access to a single instance of a module using the singleton pattern.
     *
     * @since   1.0.0
     * @return  object
     */
    public static function instance()
    {
        if (self::$instance === null) {
            self::$instance = new self();
        }

        return self::$instance;
    }


    public function __construct()
    {
        self::settingUp();
        self::setHooks($this);
        self::init();
    }

    /**
     * Set Hooks.
     *
     * @since   1.0.0
     */
    public static function setHooks($This)
    {
        add_action( 'rest_api_init', array($This,'mecZapierRoute'));
    }

    /**
     * Global Variables.
     *
     * @since   1.0.0
     */
    public static function settingUp()
    {
    }

    /**
     * API Route
     *
     * @since     1.0.0
     */
    public function mecZapierRoute()
    {
        $namespace = 'mec-zapier/v1';
        $apiPath = 'api/';

        register_rest_route( $namespace, $apiPath, array(
            'methods' => 'GET',
            'permission_callback' => '__return_true',
            'callback' => array($this,'mecZapierCallback'),
        ) );


    }

    /**
     * API Callback
     *
     * @since     1.0.0
     */
    public function mecZapierCallback($request)
    {
        $api_key = $request->get_param( 'api_key' );
        $task = $request->get_param( 'task' );
        if ( $api_key != get_option('mecZapierKey') & empty( $task )) {

            return new \WP_Error( 'invalid_key', 'Invalid API Key', array( 'status' => 404 ) );

        } elseif ( $api_key == get_option('mecZapierKey') & empty( $task ) ){

            return new \WP_REST_Response(array('url'=>site_url(), 'zapier_desc' =>'MEC Zapier Integration'), 200);

        } elseif ( $api_key != get_option('mecZapierKey') & !empty( $task ) ) {

            return new \WP_Error( 'invalid_key', 'Invalid API Key', array( 'status' => 404 ) );

        } elseif ( $api_key == get_option('mecZapierKey') & !empty( $task ) ) {
            $dateFormat = get_option( 'date_format' );
            $timeFormat = get_option( 'time_format' );
            switch ($task) {
                case 'new_event':
                    $dataInformation = array();
                    $recentEvent = new \WP_Query( array(
                        'posts_per_page' => 1, // Number of recent posts thumbnails to display
                        'post_type'=>'mec-events',
                        'post_status' => 'publish', // Show only the published posts
                        'orderby' => 'date',
                        'no_found_rows'  => true,
                    ));
                    if ( $recentEvent->have_posts() ) :
                        while( $recentEvent->have_posts() ) : $recentEvent->the_post();
                            // Start Time
                            $startHour = get_post_meta( get_the_ID(), 'mec_start_time_hour', true);
                            $startMinutes = get_post_meta( get_the_ID(), 'mec_start_time_minutes', true);
                            $startMinutes = ($startMinutes == '0' || $startMinutes == '5') ? '0'.$startMinutes : $startMinutes;
                            $startAMPM = get_post_meta( get_the_ID(), 'mec_start_time_ampm', true);
                            $eventStartTime = $startHour .':'. $startMinutes . $startAMPM;
                            $eventStartDate = get_post_meta( get_the_ID(), 'mec_start_date', true );

                            $eventStart = $eventStartDate . ' ' . $eventStartTime;

                            // End Time
                            $endHour = get_post_meta( get_the_ID(), 'mec_end_time_hour', true);
                            $endMinutes = get_post_meta( get_the_ID(), 'mec_end_time_minutes', true);
                            $endMinutes = ($endMinutes == '0' || $endMinutes == '5') ? '0'.$endMinutes : $endMinutes;
                            $endAMPM = get_post_meta( get_the_ID(), 'mec_end_time_ampm', true);
                            $eventEndTime = $endHour .':'. $endMinutes . $endAMPM;
                            $eventEndDate = get_post_meta( get_the_ID(), 'mec_end_date', true );

                            $eventEnd = $eventEndDate . ' ' . $eventEndTime;

                            $dataInformation['id'] = get_the_ID();
                            $dataInformation['event_title'] = get_the_title();
                            $dataInformation['event_link'] = get_the_permalink();
                            $dataInformation['event_thumbnail_link'] = get_the_post_thumbnail_url() ? get_the_post_thumbnail_url() : 'null';
                            $dataInformation['event_start'] = date_i18n( DATE_ISO8601, strtotime( $eventStart ) );
                            $dataInformation['event_end'] = date_i18n( DATE_ISO8601, strtotime( $eventEnd ) );
                            $dataInformation['event_read_more'] = get_post_meta( get_the_ID(), 'mec_read_more', true);
                            $dataInformation['event_more_info'] = get_post_meta( get_the_ID(), 'mec_more_info', true);
                            $dataInformation['event_cost'] = get_post_meta( get_the_ID(), 'mec_cost', true );
                            $dataInformation['event_excerpt'] = get_the_excerpt();
                        endwhile;
                        wp_reset_postdata();
                    endif;
                    break;
                case 'modified_event':
                    $dataInformation = array();
                    $recentlyUpdatedEvent = new \WP_Query( array(
                        'post_type'      => 'mec-events',
                        'posts_per_page' => 1,
                        'orderby'        => 'modified',
                        'no_found_rows'  => true, // speed up query when we don't need pagination
                    ) );
                    if ( $recentlyUpdatedEvent->have_posts() ) :
                        while( $recentlyUpdatedEvent->have_posts() ) : $recentlyUpdatedEvent->the_post();
                            if ( get_the_modified_date().get_the_modified_time() == get_the_date().get_the_time() ) return array($dataInformation);
                            $startHour = get_post_meta( get_the_ID(), 'mec_start_time_hour', true);
                            $startMinutes = get_post_meta( get_the_ID(), 'mec_start_time_minutes', true);
                            $startMinutes = ($startMinutes == '0' || $startMinutes == '5') ? '0'.$startMinutes : $startMinutes;
                            $startAMPM = get_post_meta( get_the_ID(), 'mec_start_time_ampm', true);
                            $eventStartTime = $startHour .':'. $startMinutes . $startAMPM;
                            $eventStartDate = get_post_meta( get_the_ID(), 'mec_start_date', true );

                            $eventStart = $eventStartDate . ' ' . $eventStartTime;

                            // End Time
                            $endHour = get_post_meta( get_the_ID(), 'mec_end_time_hour', true);
                            $endMinutes = get_post_meta( get_the_ID(), 'mec_end_time_minutes', true);
                            $endMinutes = ($endMinutes == '0' || $endMinutes == '5') ? '0'.$endMinutes : $endMinutes;
                            $endAMPM = get_post_meta( get_the_ID(), 'mec_end_time_ampm', true);
                            $eventEndTime = $endHour .':'. $endMinutes . $endAMPM;
                            $eventEndDate = get_post_meta( get_the_ID(), 'mec_end_date', true );

                            $eventEnd = $eventEndDate . ' ' . $eventEndTime;

                            $dataInformation['id'] = get_the_ID();
                            $dataInformation['event_title'] = get_the_title();
                            $dataInformation['event_link'] = get_the_permalink();
                            $dataInformation['event_thumbnail_link'] = get_the_post_thumbnail_url() ? get_the_post_thumbnail_url() : 'null';
                            $dataInformation['event_start'] = date_i18n( DATE_ISO8601, strtotime( $eventStart ) );
                            $dataInformation['event_end'] = date_i18n( DATE_ISO8601, strtotime( $eventEnd ) );
                            $dataInformation['event_read_more'] = get_post_meta( get_the_ID(), 'mec_read_more', true);
                            $dataInformation['event_more_info'] = get_post_meta( get_the_ID(), 'mec_more_info', true);
                            $dataInformation['event_cost'] = get_post_meta( get_the_ID(), 'mec_cost', true );
                            $dataInformation['event_excerpt'] = get_the_excerpt();
                        endwhile;
                        wp_reset_postdata();
                    endif;
                    break;
                case 'new_booking':
                    $dataInformation = array();
                    $recentBooking = wp_get_recent_posts(array(
                        'numberposts' => 1, // Number of recent posts thumbnails to display
                        'post_type'=>'mec-books',
                        'post_status' => 'publish', // Show only the published posts
                        'orderby' => 'ID',
	                    'order' => 'DESC',
                    ));
                    foreach($recentBooking as $booking) :
                        $mecFeaturesBook = new \MEC_feature_books();
                        $mecMain = new \MEC_main();
                        // Event
                        $eventId = get_post_meta($booking['ID'], 'mec_event_id', true);
                        $price = get_post_meta($booking['ID'], 'mec_price', true);
                        $eventTitle = get_the_title($eventId);
                        // Price
                        $bookPrice = get_post_meta($booking['ID'], 'mec_price', true);

                        $confirmStatus = get_post_meta($booking['ID'], 'mec_confirmed', true);
                        if ( $confirmStatus == '1') $confirmStatus = 'Confirmed';
                        elseif ($confirmStatus == '0')$confirmStatus = 'Pending';
                        elseif( $confirmStatus == '-1')$confirmStatus = 'Rejected';

                        $varifyStatus = get_post_meta($booking['ID'], 'mec_verified', true);
                        if ( $varifyStatus == '1') $varifyStatus = 'Verified';
                        elseif ($varifyStatus == '0')$varifyStatus = 'Waiting';
                        elseif( $varifyStatus == '-1')$varifyStatus = 'Canceled';

                        $attendees = $mecFeaturesBook->book->get_attendees($booking['ID']);

                        $dataInformation['id'] = $booking['ID'];
                        $dataInformation['booking_title'] = $attendees[0]['email'];
                        $dataInformation['booking_email'] = $attendees[0]['email'];
                        $dataInformation['booking_name'] = $attendees[0]['name'];
                        $dataInformation['booking_date'] = date_i18n( DATE_ISO8601, strtotime( get_the_date('', $booking['ID']) ) );
                        $dataInformation['booking_order_time'] = date_i18n( DATE_ISO8601, strtotime(get_post_meta($booking['ID'], 'mec_booking_time', true) ) );
                        $dataInformation['booking_event_title'] = $eventTitle;
                        $dataInformation['booking_attendees'] = $mecFeaturesBook->book->get_total_attendees($booking['ID']);
                        $dataInformation['booking_price'] = $mecMain->render_price(($price ? $price : 0));
                        $dataInformation['booking_price_label'] = get_post_meta($booking['ID'], 'mec_gateway_label', true);
                        $dataInformation['booking_confirmation_status'] = $confirmStatus;
                        $dataInformation['booking_verification_status'] = $varifyStatus;
                        $dataInformation['booking_transaction_id'] = get_post_meta($booking['ID'], 'mec_transaction_id', true);
                    endforeach;
                    wp_reset_query();
                    break;
                case 'canceled_event':
                    $dataInformation = array();
                    $recentlyUpdatedEvent = new \WP_Query( array(
                        'post_type'      => 'mec-events',
                        'posts_per_page' => 1,
                        'orderby'        => 'modified',
                        'no_found_rows'  => true, // speed up query when we don't need pagination
                        'meta_query' => array(
                            array(
                                'key' => 'mec_event_status',
                                'value' => 'EventCancelled'
                            )
                        )
                    ) );
                    if ( $recentlyUpdatedEvent->have_posts() ) :
                        while( $recentlyUpdatedEvent->have_posts() ) : $recentlyUpdatedEvent->the_post();
                            if ( get_the_modified_date().get_the_modified_time() == get_the_date().get_the_time() ) return array($dataInformation);
                            $startHour = get_post_meta( get_the_ID(), 'mec_start_time_hour', true);
                            $startMinutes = get_post_meta( get_the_ID(), 'mec_start_time_minutes', true);
                            $startMinutes = ($startMinutes == '0' || $startMinutes == '5') ? '0'.$startMinutes : $startMinutes;
                            $startAMPM = get_post_meta( get_the_ID(), 'mec_start_time_ampm', true);
                            $eventStartTime = $startHour .':'. $startMinutes . $startAMPM;
                            $eventStartDate = get_post_meta( get_the_ID(), 'mec_start_date', true );

                            $eventStart = $eventStartDate . ' ' . $eventStartTime;

                            // End Time
                            $endHour = get_post_meta( get_the_ID(), 'mec_end_time_hour', true);
                            $endMinutes = get_post_meta( get_the_ID(), 'mec_end_time_minutes', true);
                            $endMinutes = ($endMinutes == '0' || $endMinutes == '5') ? '0'.$endMinutes : $endMinutes;
                            $endAMPM = get_post_meta( get_the_ID(), 'mec_end_time_ampm', true);
                            $eventEndTime = $endHour .':'. $endMinutes . $endAMPM;
                            $eventEndDate = get_post_meta( get_the_ID(), 'mec_end_date', true );

                            $eventEnd = $eventEndDate . ' ' . $eventEndTime;

                            $dataInformation['id'] = get_the_ID();
                            $dataInformation['event_title'] = get_the_title();
                            $dataInformation['event_link'] = get_the_permalink();
                            $dataInformation['event_thumbnail_link'] = get_the_post_thumbnail_url() ? get_the_post_thumbnail_url() : 'null';
                            $dataInformation['event_start'] = date_i18n( DATE_ISO8601, strtotime( $eventStart ) );
                            $dataInformation['event_end'] = date_i18n( DATE_ISO8601, strtotime( $eventEnd ) );
                            $dataInformation['event_read_more'] = get_post_meta( get_the_ID(), 'mec_read_more', true);
                            $dataInformation['event_more_info'] = get_post_meta( get_the_ID(), 'mec_more_info', true);
                            $dataInformation['event_reason_cancellation'] = get_post_meta( get_the_ID(), 'mec_cancelled_reason', true);
                            $dataInformation['event_cost'] = get_post_meta( get_the_ID(), 'mec_cost', true );
                            $dataInformation['event_excerpt'] = get_the_excerpt();
                        endwhile;
                        wp_reset_postdata();
                    endif;
                    break;
                default:
                    $dataInformation = array('Please enter valid task.');
                    break;
            }

            return array($dataInformation);

        }
    }

    /**
     * Register Autoload Files
     *
     * @since     1.0.0
     */
    public function init()
    {
        if (!class_exists('\MEC_Zapier\Autoloader')) {
            return;
        }
    }
} //SetRoutes
