<?php
/**
*	Plugin Name: MEC Zapier Integration
*	Plugin URI: http://webnus.net/modern-events-calendar/
*	Description: This plugin makes it possible to Integration with Zapier
*	Author: Webnus
*	Version: 2.1.5
*	Text Domain: mec-zapier
*	Domain Path: /languages
*	Author URI: http://webnus.net
**/
namespace MEC_Zapier;

// don't load directly.
if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit;
}
/**
 * Base.
 *
 * @author     author
 * @package     package
 * @since     1.0.0
 */
class Base {

	/**
	 * Instance of this class.
	 *
	 * @since   1.0.0
	 * @access  public
	 * @var     MEC_Zapier
	 */
	public static $instance;

	/**
	 * Provides access to a single instance of a module using the singleton pattern.
	 *
	 * @since   1.0.0
	 * @return  object
	 */
	public static function instance() {
		if ( self::$instance === null ) {
			self::$instance = new self();
		}

		return self::$instance;
	}


	public function __construct() {
		self::settingUp();
		self::preLoad();
		self::setHooks($this);

		do_action( 'MEC_Zapier_init' );
	}

	/**
	 * Global Variables.
	 *
	 * @since   1.0.0
	 */
	public static function settingUp() {
		define('MECZAPIERVERSION' , '2.1.5');
		define('MECZAPIERDIR' , plugin_dir_path(__FILE__));
		define('MECZAPIERURL' , plugin_dir_url(__FILE__));
		define('MECZAPIERDASSETS' , MECZAPIERURL . '/assets/' );
		define('MECZAPIERNAME' , 'Zapier Integration');
		define('MECZAPIERSLUG' , 'mec-zapier');
		define('MECZAPIEROPTIONS' , 'mec_zapier_options');
		define('MECZAPIERTEXTDOMAIN' , 'mec-zapier');
		define('MECZAPIERMAINFILEPATH' ,__FILE__);
		define('MECZAPIERABSPATH', dirname(__FILE__));

		if ( ! defined( 'DS' ) ) {
			define( 'DS', DIRECTORY_SEPARATOR );
		}
	}

	/**
	 * Set Hooks
	 *
	 * @since     1.0.0
	 */
	public static function setHooks($This) {
	}

	/**
	 * preLoad
	 *
	 * @since     1.0.0
	 */
	public static function preLoad() {
		include_once MECZAPIERDIR . DS . 'core' . DS . 'autoloader.php';
	}

	/**
	 * Load Plugin Text Domain
	 */
	public function load_plugin_textdomain(): void {

		load_plugin_textdomain(
			'mec-zapier',
			false,
			dirname( plugin_basename( __FILE__ ) ) . '/languages'
		);
	}

	public function init(){

		$this->load_plugin_textdomain();
	}

} //Base

Base::instance()->init();
