<?php

namespace MEC_RSVP;

use MEC\Singleton;
use MEC_RSVP\RSVP\AdminListTable;
use MEC_RSVP\RSVP\EventMetaBox;
use MEC_RSVP\RSVP\ImportExport;
use MEC_RSVP\RSVP\MetaBoxDetail;
use MEC_RSVP\RSVP\NotificationsSettings;
use MEC_RSVP\RSVP\SendInvitationPage;
use MEC_RSVP\RSVP\SendRSVPMailPage;
use MEC_RSVP\Settings\SettingsPage;
use MEC_RSVP\StatusProvider\StatusProvider;

class Admin extends Singleton{

    public function init(){

        if(mec_rsvp_is_enabled()){

			AdminListTable::getInstance()->init();
			StatusProvider::getInstance()->init();

            add_action('admin_menu',[$this,'add_menu']);

            add_action('add_meta_boxes',[$this,'add_meta_boxes']);
            add_action('mec_occurrences_fields', [ $this, 'add_custom_attendees_count_for_each_occurrences' ], 20, 3 );
            MetaBoxDetail::getInstance()->init();
            EventMetaBox::getInstance()->init();


            if(wp_doing_ajax()){

                $this->ajax_handler();
            }

            $is_settings_page = isset($_GET['page']) && 'MEC-settings' === $_GET['page'];
            $is_create_or_edit_page_events = ('mec-events' == get_post_type()) || (isset($_GET['post_type']) && 'mec-events' === $_GET['post_type']);
            global $pagenow;
            if( $is_settings_page || $is_create_or_edit_page_events || 'post.php' === $pagenow ){

                NotificationsSettings::getInstance()->init();
            }

            add_action('current_screen',[__CLASS__,'rsvp_badge']);

            add_action( 'admin_enqueue_scripts', [ __CLASS__, 'enqueue' ] );

            if( isset($_GET['page']) && 'MEC-ix' === $_GET['page'] ) {

                ImportExport::getInstance()->init();
            }
		}

        SettingsPage::getInstance()->init();
    }

    public function add_menu(){

        add_submenu_page(
            'edit.php?post_type=mec_rsvp',
            __('MEC - Send RSVP Invitation', 'mec-rsvp'),
            __('RSVP Invitation', 'mec-rsvp'),
            apply_filters( 'mec_rsvp_menu_cap', 'manage_options', 'mec_rsvp_invitation' ),
            'mec_rsvp_invitation',
            array(SendInvitationPage::class, 'display_page')
        );

        add_submenu_page(
            'edit.php?post_type=mec_rsvp',
            __('MEC - Send Mail', 'mec-rsvp'),
            __('Send Mail', 'mec-rsvp'),
            apply_filters( 'mec_rsvp_menu_cap', 'manage_options', 'mec_rsvp_mail' ),
            'mec_rsvp_mail',
            array(SendRSVPMailPage::class, 'display_page')
        );
    }

    public function ajax_handler(){

        add_action('wp_ajax_mec_rsvp_send_invitation_emails',[SendInvitationPage::class,'send_invitation_emails_by_ajax']);

        add_action( 'wp_ajax_mec_rsvp_event_answers', [ SendRSVPMailPage::class, 'get_report_answers_by_ajax' ] );
        add_action( 'wp_ajax_mec_rsvp_send_mail', [ SendRSVPMailPage::class, 'send_rsvp_mail_by_ajax' ] );
    }

    public function add_meta_boxes(){

        $post_type = get_post_type();
        $post_type = empty($post_type) && isset($_GET['post_type']) ? $_GET['post_type'] : $post_type;

        if( 'mec_rsvp' === $post_type ){

            add_meta_box(
                'mec-rsvp-detail',
                __('Detail','mec-rsvp'),
                [MetaBoxDetail::getInstance(),'meta_box_rsvp_info']
            );
        }

        if( 'mec-events' === $post_type ){
            add_meta_box(
                'mec-rsvp-options',
                __('RSVP Options','mec-rsvp'),
                [EventMetaBox::getInstance(),'render'],
                null,
                'normal',
                'high'
            );
        }
    }

    public function add_custom_attendees_count_for_each_occurrences( $occurrence_id, $event_id, $data ){

        $data = (array)json_decode($data['params']);
        ?>
            <h4><?php _e( 'Minimum attendees to start the event', 'mec-rsvp' ); ?></h4>
            <div class="mec-form-row">
                <?php
                    $rsvp_min_attendees_global = isset($data['rsvp_min_attendees_global']) ? (bool)$data['rsvp_min_attendees_global'] : true;
                    $rsvp_min_attendees = isset($data['rsvp_min_attendees']) ? (int)$data['rsvp_min_attendees'] : false;
                ?>
                <label class="mec-col-4" for="mec_settings_rsvp_min_attendees_<?php echo $occurrence_id; ?>" id="mec_settings_rsvp_min_attendees_<?php echo $occurrence_id; ?>_label">
                    <input type="hidden" name="mec[occurrences][<?php echo $occurrence_id; ?>][rsvp_min_attendees_global]" value="0"/>
                    <input id="mec_settings_rsvp_min_attendees_<?php echo $occurrence_id; ?>" <?php checked(true,$rsvp_min_attendees_global) ?> type="checkbox" value="1" name="mec[occurrences][<?php echo $occurrence_id; ?>][rsvp_min_attendees_global]" onchange="jQuery(this).parent().parent().find('input[type=number]').toggle();"/>
                    <?php _e('Inherit from global options', 'mec-rsvp'); ?>
                </label>
                <input class="mec-col-4" <?php echo $rsvp_min_attendees_global ? 'style="display: none;"' : ''; ?> type="number" name="mec[occurrences][<?php echo $occurrence_id; ?>][rsvp_min_attendees]" id="mec_rsvp_min_attendees" value="<?php echo esc_attr($rsvp_min_attendees); ?>" placeholder="<?php _e('12', 'mec-rsvp'); ?>"/>
            </div>
        <?php

    }

    public static function rsvp_badge($screen){

        $user_id = get_current_user_id();
        $user_last_view_date = get_user_meta($user_id, 'user_last_view_date', true);
        $count = 0;

        if(!trim($user_last_view_date)){

            update_user_meta($user_id, 'user_last_view_date', date('YmdHis', current_time('timestamp', 0)));
            return;
        }

        $args = array(
            'post_type' => 'mec_rsvp',
            'post_status' => 'any',
            'meta_query' => array(
                array(
                    'key' => 'mec_create_datetime',
                    'value' => $user_last_view_date,
                    'compare' => '>=',
                ),
            ),
            'fields' => 'ids',
        );

        $rsvps_ids = get_posts($args);

        if(!is_array($rsvps_ids)){

            return;
        }

        $count = count($rsvps_ids);
        if($count != 0){
            if(isset($screen->id) and $screen->id == 'edit-mec_rsvp'){
                update_user_meta($user_id, 'user_last_view_date', date('YmdHis', current_time('timestamp', 0)));
                return;
            }

            // Append Booking Badge To Booking Menu.
            global $menu;

            $badge = ' <span class="update-plugins count-%%count%%"><span class="plugin-count">%%count%%</span></span>';
            $menu_item = wp_list_filter(
                $menu,
                array(
                    2 =>'edit.php?post_type=mec_rsvp'
                )
            );

            if(is_array($menu_item) and count($menu_item)){
                $menu[key($menu_item)][0] .= str_replace('%%count%%', esc_attr($count), $badge);
            }
        }
    }

    public static function enqueue(){

        wp_enqueue_style('mec-font-icons');
        wp_enqueue_style( 'mec-rsvp-backend-style', MEC_RSVP_PU_CSS.'/backend.css', ['mec-font-icons'], '1.0.0' );
    }

}
