<?php

namespace MEC_RSVP\Conversation;

use MEC\Singleton;
use MEC_RSVP\RSVP\EventRSVP;
use MEC_RSVP\User;

class Conversation extends Singleton {

	public function init() {

		add_action( 'init', array( $this, 'register_post_type' ) );
		add_action( 'save_post_mec-events', [ __CLASS__ , 'create_rsvp_conversation' ], 99 );
		add_action( 'edit_post_mec-events', [ __CLASS__ , 'create_rsvp_conversation' ], 99 );

		add_filter( 'mec_before_booking_form', [ __CLASS__ , 'add_conversation_box' ], 99 );

		add_filter( 'comment_post_redirect', [ __CLASS__, 'redirect_after_add_conversation' ], 10, 2 );
		add_filter( 'comments_template', [ __CLASS__, 'get_template' ] );

	}

	public function register_post_type() {

		$args = array(
			'labels' => [
				'name' => __( 'Conversation', 'mec-rsvp' ),
        		'singular_name' => __( 'Conversation', 'mec-rsvp' )
			],
			'public'	=> false,
			'supports' => array(
				'comments'
			)
		);

		$args = apply_filters( 'mec_conversation_register_post_type_args', $args );

		register_post_type( 'mec-conversation', $args );
	}

	public static function create_rsvp_conversation($event_id) {

		if(!isset($_POST)) return;
		if(wp_is_post_revision($event_id)) return;

		$conversation_id = get_post_meta($event_id,'mec_conversation_id',true);
		$conversation_id = false;
		if(!$conversation_id){

			$post_arr = array(
				'post_status' => 'publish',
				'post_type' => 'mec-conversation',
				'comment_status' => 'open',
				'post_title' => "#{$event_id}",
				'meta_input' => array(
					'mec_event_id' => $event_id,
				)
			);

			$conversation_id = wp_insert_post( $post_arr );

			if(is_numeric($conversation_id)){

				update_post_meta( $event_id, 'mec_conversation_id', $conversation_id );
			}
		}
	}

	public static function add_conversation_box($event_id){

		if('mec-events' !== get_post_type()){

			return;
		}

		if(!is_user_logged_in()){

			return;
		}

		if(!$event_id){

			$event_id = get_the_ID();
		}
		$can = EventRSVP::getInstance()->can_display_rsvp_display_conversation($event_id);
		if(!$can){

			return;
		}

		$user_id = get_current_user_id();
		if(!$user_id){

			return;
		}
		$user = get_user_by( 'id', $user_id );
		$current_user_has_this_rsvp = User::instance()->has_rsvp($user->user_email, $event_id);
		if(!$current_user_has_this_rsvp){

			return;
		}

		$conversation_id = get_post_meta( $event_id, 'mec_conversation_id', true );

		if(!$conversation_id){

			return;
		}

		$q_args = array(
			'p' => $conversation_id,
			'post_type' => 'mec-conversation'
		);

		query_posts( $q_args );
		ob_start();
		while( have_posts() ) : the_post();


			comments_template();

		endwhile;
		$conversation_html = ob_get_clean();
		wp_reset_postdata();
		wp_reset_query();

		echo $conversation_html;
	}

	public static function get_template($theme_template){

		if( 'mec-conversation' !== get_post_type() ){

			return $theme_template;
		}

		return __DIR__ . '/template-conversations.php';
	}

	public static function redirect_after_add_conversation( $url, $comment_data){

		$conversation_id = $comment_data->comment_post_ID;
		if( 'mec-conversation' !== get_post_type($conversation_id) ){

			return $url;
		}

		// $event_id = get_post_meta( $conversation_id, 'mec_event_id', true );

		return wp_get_referer().'#comment-'.$comment_data->comment_ID;
	}


}
