<?php

defined( 'MECEXEC' ) or die();

?>

<div id="comments" class="comments-area rsvp-conversation-wrap">
    <h4 class="rsvp-conversation-title"><?php esc_html_e('RSVP Conversation','mec-rsvp'); ?></h4>
    <?php if ( have_comments() ) : ?>
        <ol class="comment-list">
            <?php
                wp_list_comments( array(
                    'style'       => 'ol',
                    'short_ping'  => true,
                    'avatar_size' => 50,
                ) );
            ?>
        </ol>

        <?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : ?>
            <nav class="navigation comment-navigation" role="navigation">
                <h1 class="screen-reader-text section-heading"><?php _e( 'Comment navigation', 'mec-rsvp' ); ?></h1>
                <div class="nav-previous"><?php previous_comments_link( __( '&larr; Older Comments', 'mec-rsvp' ) ); ?></div>
                <div class="nav-next"><?php next_comments_link( __( 'Newer Comments &rarr;', 'mec-rsvp' ) ); ?></div>
            </nav>
        <?php endif;  ?>

    <?php else : ?>
        <p class="no-comments"><?php _e( 'No message found.' , 'mec-rsvp' ); ?></p>
    <?php endif; ?>

    <?php
        $args = array(
            'must_log_in' => __('must be logged in to send message','mec-rsvp'),
            'label_submit' => __('Send Message','mec-rsvp'),
            'comment_field' => sprintf(
                '<p class="comment-form-comment">%s %s</p>',
                sprintf(
                    '<label for="comment">%s</label>',
                    _x( 'Message', 'mec-rsvp' )
                ),
                '<textarea id="comment" name="comment" cols="45" rows="8" maxlength="65525" required="required"></textarea>'
            ),

        );

        comment_form($args);
    ?>

</div>