<?php
namespace MEC_RSVP\RSVP;

use MEC\Events\Event;
use MEC\Singleton;

class AdminListTable extends Singleton {

	public function init() {

		add_action( 'pre_get_posts', array( $this, 'filter_query' ) );
		add_filter( 'manage_mec_rsvp_posts_columns', array( $this, 'filter_columns' ) );
		add_filter( 'manage_edit-mec_rsvp_sortable_columns', array( $this, 'filter_sortable_columns' ) );
		add_action( 'manage_mec_rsvp_posts_custom_column', array( $this, 'filter_columns_content' ), 10, 2 );

		add_action( 'restrict_manage_posts', array( $this, 'add_filters' ) );
		add_action( 'wp_ajax_mec_rsvp_filters_occurrence', array( $this, 'add_occurrence_filter_ajax' ) );

		add_filter( 'bulk_actions-edit-mec_rsvp', array( $this, 'add_bulk_actions' ) );
		add_filter( 'handle_bulk_actions-edit-mec_rsvp', array( $this,'do_bulk_actions'), 10, 3 );

	}

	public function filter_columns( $columns ) {

		unset( $columns['title'] );
		unset( $columns['date'] );
		unset( $columns['author'] );

		$columns['id']        = __( 'ID', 'mec-rsvp' );
		$columns['title']     = __( 'Title', 'mec-rsvp' );
		$columns['event_id']  = __( 'Event ID', 'mec-rsvp' );
		$columns['attendees'] = __( 'Attendees', 'mec-rsvp' );
		$columns['event']     = __( 'Event', 'mec-rsvp' );
		$columns['date']      = __( 'Date', 'mec-rsvp' );
		$columns['answer']    = __( 'Response', 'mec-rsvp' );
		$columns['creation_by_invite']    = __( 'Creation by invite', 'mec-rsvp' );

		return $columns;
	}

	public function filter_sortable_columns( $columns ) {

		$columns['id']       = 'id';
		$columns['event_id'] = 'event_id';
		$columns['date']     = 'date';

		return $columns;
	}

	public function get_rsvp( $rsvp_id ) {

		global $MEC_RSVP;
		if ( ! is_a( $MEC_RSVP, RSVP::class ) || $rsvp_id !== $MEC_RSVP->get_id() ) {

			$MEC_RSVP = new RSVP( $rsvp_id );
		}

		return $MEC_RSVP;
	}

	public function get_main() {

		global $MEC_Main;
		if ( ! is_a( $MEC_Main, \MEC_main::class ) ) {

			$MEC_Main = new \MEC_Main();
		}

		return $MEC_Main;
	}

	public function filter_columns_content( $column_name, $post_id ) {
		$rsvp = $this->get_rsvp( $post_id );
		switch ( $column_name ) {
			case 'id':

				echo $post_id;

				break;
			case 'event_id':
				echo $rsvp->get_event_id();

				break;

			case 'event':
				$event_id = $rsvp->get_event_id();
				$event    = new Event( $event_id );

				$title = $event->get_title();

				$tickets    = $event->get_tickets();
				$ticket_ids = $rsvp->get_tickets_ids();

				if ( $event_id ) {

					echo '<a href="' . $this->get_main()->add_qs_var( 'mec_event_id', $event_id ) . '">' . $title . '</a>';
				}

				foreach ( $ticket_ids as $ticket_id ) {

					if ( isset( $tickets[ $ticket_id ]['name'] ) ) {

						$link = $this->get_main()->add_qs_vars(
							array(
								'mec_ticket_id' => $ticket_id,
								'mec_event_id'  => $event_id,
							)
						);
						echo ' - <a title="' . $this->get_main()->m( 'ticket', __( 'Ticket', 'mec-rsvp' ) ) . '" href="' . $link . '">' . $tickets[ $ticket_id ]['name'] . '</a>';
					}
				}

				break;

			case 'attendees':
				$attendees = $rsvp->get_attendees();
				$attendees_count = $rsvp->get_attendees_count();
				if ( empty( $attendees ) || ! is_array( $attendees ) ) {
					echo '-';
					return;
				}

				$unique_attendees = array();
				foreach ( $attendees as $attendee ) {
					if ( ! isset( $unique_attendees[ $attendee['email'] ] ) ) {
						$unique_attendees[ $attendee['email'] ] = $attendee;
					} else {
						if(isset($unique_attendees[ $attendee['email'] ]['count'])){

							$unique_attendees[ $attendee['email'] ]['count'] += 1;
						}else{
							$unique_attendees[ $attendee['email'] ]['count'] = 2;
						}
					}
				}

				echo '<strong>' . $attendees_count . '</strong>';
				echo '<div class="mec-rsvp-attendees-tooltip">';
				echo '<ul>';

				foreach ( $unique_attendees as $unique_attendee ) {
					echo '<li>';
					echo '<div class="mec-rsvp-attendees-tooltip-name">' . $unique_attendee['name'] . ( isset($unique_attendee['count']) && $unique_attendee['count'] > 1 ? ' (' . $unique_attendee['count'] . ')' : '' ) . '</div>';
					echo '<div class="mec-rsvp-attendees-tooltip-email"><a href="mailto:' . $unique_attendee['email'] . '">' . $unique_attendee['email'] . '</a></div>';
					echo '</li>';
				}

				echo '</ul>';
				echo '</div>';

				break;
			case 'answer':

				echo $rsvp->get_answer_text();

				break;
			case 'creation_by_invite' :

				$text =  $rsvp->get_creation_type();
				echo $text ? 'yes' : '-';

				break;
		}

	}

	/**
	 * @param WP_Query $query
	 */
	public function filter_query( $query ) {

		if ( !is_admin() || !$query->is_main_query() || 'mec_rsvp' !== $query->get( 'post_type' ) ) {
			return;
		}

		$meta_query = array();
		$orderby    = $query->get( 'orderby' );

		switch ( $orderby ) {
			case 'event_id':
				$query->set( 'meta_key', 'mec_event_id' );
				$query->set( 'orderby', 'mec_event_id' );
				break;
			case 'creator':
				$query->set( 'orderby', 'user_id' );
				$query->set( 'orderby', 'mec_verified' );
				break;
			case 'id':
			default:
				$query->set( 'orderby', 'ID' );
		}

		// Filter by Event ID
		if ( isset( $_REQUEST['mec_event_id'] ) and trim( $_REQUEST['mec_event_id'] ) ) {
			$meta_query[] = array(
				'key'     => 'mec_event_id',
				'value'   => sanitize_text_field( $_REQUEST['mec_event_id'] ),
				'compare' => '=',
				'type'    => 'numeric',
			);
		}

		if ( isset( $_REQUEST['mec_rsvp_answer'] ) and trim( $_REQUEST['mec_rsvp_answer'] ) ) {
			$meta_query[] = array(
				'key'     => 'mec_answer',
				'value'   => sanitize_text_field( $_REQUEST['mec_rsvp_answer'] ),
				'compare' => '=',
			);
		}

		if ( isset( $_REQUEST['mec_creation_by_invite'] ) and trim( $_REQUEST['mec_creation_by_invite'] ) ) {

			$creation_by_invite = sanitize_text_field( $_REQUEST['mec_creation_by_invite'] );
			$meta_query[] = array(
				'key'     => 'mec_creation_by_invite',
				'compare' => 'yes' === $creation_by_invite ? 'EXISTS' : 'NOT EXISTS',
			);
		}

		// Filter by Occurrence
		if ( isset( $_REQUEST['mec_occurrence'] ) and trim( $_REQUEST['mec_occurrence'] ) ) {
			$date_query = array(
				array(
					'year'     => date( 'Y', $_REQUEST['mec_occurrence'] ),
					'monthnum' => date( 'm', $_REQUEST['mec_occurrence'] ),
					'day'      => date( 'd', $_REQUEST['mec_occurrence'] ),
					'hour'     => date( 'H', $_REQUEST['mec_occurrence'] ),
					'minute'   => date( 'i', $_REQUEST['mec_occurrence'] ),
				),
			);

			$query->set( 'date_query', $date_query );
		}

		// Filter by ID
		if ( isset( $_REQUEST['id'] ) and trim( $_REQUEST['id'] ) != '' ) {
			$meta_query[] = array(
				'orderby' => 'ID',
			);
		}

		if ( count( $meta_query ) ) {
			$query->set( 'meta_query', $meta_query );
		}

	}

	public function add_filters( $post_type ) {
		if ( 'mec_rsvp' !== $post_type ) {
			return;
		}

		$query = new \WP_Query(
			array(
				'post_type'      => $this->get_main()->get_main_post_type(),
				'posts_per_page' => -1,
				'post_status'    => array( 'publish' ),
			)
		);

		$mec_event_id = isset( $_REQUEST['mec_event_id'] ) ? sanitize_text_field( $_REQUEST['mec_event_id'] ) : '';

		echo '<select name="mec_event_id" id="mec_filter_event_id">';
		echo '<option value="">' . __( 'Event', 'mec-rsvp' ) . '</option>';

		if ( $query->have_posts() ) {
			while ( $query->have_posts() ) {
				$query->the_post();

				$ID = get_the_ID();
				if ( $this->get_main()->get_original_event( $ID ) !== $ID ) {
					$ID = $this->get_main()->get_original_event( $ID );
				}

				echo '<option value="' . $ID . '" ' . ( $mec_event_id == $ID ? 'selected="selected"' : '' ) . '>' . get_the_title() . '</option>';

			}
		}

		echo '</select>';

		echo "<script>
        jQuery(document).ready(function()
        {
            jQuery('#mec_filter_event_id').on('change', function()
            {
                jQuery('#mec_filter_occurrence').remove();

                var event_id = jQuery(this).val();
                jQuery.ajax(
                {
                    type: 'POST',
                    url: ajaxurl,
                    data: 'action=mec_rsvp_filters_occurrence&event_id='+event_id,
                    dataType: 'json',
                    success: function(data)
                    {
                        jQuery('#mec_filter_event_id').after(data.html);
                    },
                    error: function(jqXHR, textStatus, errorThrown)
                    {
                    }
                });
            });
        });
        </script>";

		if ( $mec_event_id ) {
			echo $this->add_occurrence_filter( $mec_event_id );
		}

		$mec_order_date = isset( $_REQUEST['mec_order_date'] ) ? sanitize_text_field( $_REQUEST['mec_order_date'] ) : '';

		echo '<select name="mec_order_date">';
		echo '<option value="">' . __( 'Order Date', 'mec-rsvp' ) . '</option>';
		echo '<option value="today" ' . ( $mec_order_date == 'today' ? 'selected="selected"' : '' ) . '>' . __( 'Today', 'mec-rsvp' ) . '</option>';
		echo '<option value="yesterday" ' . ( $mec_order_date == 'yesterday' ? 'selected="selected"' : '' ) . '>' . __( 'Yesterday', 'mec-rsvp' ) . '</option>';
		echo '<option value="current_month" ' . ( $mec_order_date == 'current_month' ? 'selected="selected"' : '' ) . '>' . __( 'Current Month', 'mec-rsvp' ) . '</option>';
		echo '<option value="last_month" ' . ( $mec_order_date == 'last_month' ? 'selected="selected"' : '' ) . '>' . __( 'Last Month', 'mec-rsvp' ) . '</option>';
		echo '<option value="current_year" ' . ( $mec_order_date == 'current_year' ? 'selected="selected"' : '' ) . '>' . __( 'Current Year', 'mec-rsvp' ) . '</option>';
		echo '<option value="last_year" ' . ( $mec_order_date == 'last_year' ? 'selected="selected"' : '' ) . '>' . __( 'Last Year', 'mec-rsvp' ) . '</option>';
		echo '</select>';

		$locations = get_terms( 'mec_location', array( 'hide_empty' => true ) );
		if ( ! is_array( $locations ) ) {
			$locations = array();
		}

		$mec_rsvp_location = isset( $_REQUEST['mec_rsvp_location'] ) ? sanitize_text_field( $_REQUEST['mec_rsvp_location'] ) : '';

		echo '<select name="mec_rsvp_location">';
		echo '<option value="">' . __( 'Location', 'mec-rsvp' ) . '</option>';
		foreach ( $locations as $key => $value ) {
			echo '<option value="' . $value->term_id . '" ' . ( $mec_rsvp_location == $value->term_id ? 'selected="selected"' : '' ) . '>' . $value->name . '</option>';
		}
		echo '</select>';


		$mec_rsvp_answer = isset( $_REQUEST['mec_rsvp_answer'] ) ? sanitize_text_field( $_REQUEST['mec_rsvp_answer'] ) : '';
		$answers = array(
			'yes' => __('Yes','mec-rsvp'),
			'no' => __('No','mec-rsvp'),
			'maybe' => __('Maybe','mec-rsvp'),
		);
		echo '<select name="mec_rsvp_answer">';
		echo '<option value="">' . __( 'Response', 'mec-rsvp' ) . '</option>';
		foreach ( $answers as $key => $value ) {
			echo '<option value="' . $key . '" ' . ( $mec_rsvp_answer == $key ? 'selected="selected"' : '' ) . '>' . $value . '</option>';
		}
		echo '</select>';


		$mec_creation_by_invite = isset( $_REQUEST['mec_creation_by_invite'] ) ? sanitize_text_field( $_REQUEST['mec_creation_by_invite'] ) : '';
		$creation_by_invite_options = array(
			'yes' => __('Yes','mec-rsvp'),
			'no' => __('No','mec-rsvp'),
		);
		echo '<select name="mec_creation_by_invite">';
			echo '<option value="">' . __( 'Type of creation', 'mec-rsvp' ) . '</option>';
			foreach ( $creation_by_invite_options as $key => $value ) {
				echo '<option value="' . $key . '" ' . ( $mec_creation_by_invite == $key ? 'selected="selected"' : '' ) . '>' . $value . '</option>';
			}
		echo '</select>';
	}

	public function add_occurrence_filter( $event_id ) {
		$output  = '<select name="mec_occurrence" id="mec_filter_occurrence">';
		$output .= '<option value="">' . __( 'Occurrence', 'mec-rsvp' ) . '</option>';

		$q        = new \WP_Query();
		$rsvps = $q->query(
			array(
				'post_type'      => 'mec-rsvp',
				'posts_per_page' => -1,
				'post_status'    => array( 'future', 'publish' ),
				'orderby'        => 'post_date',
				'order'          => 'ASC',
				'meta_query'     => array(
					array(
						'key'   => 'mec_event_id',
						'value' => $event_id,
					),
				),
			)
		);

		if ( ! count( $rsvps ) ) {
			return '';
		}

		$dates = array();
		foreach ( $rsvps as $rsvp ) {
			$dates[ strtotime( $rsvp->post_date ) ] = $rsvp->post_date;
		}

		$occurrence      = isset( $_REQUEST['mec_occurrence'] ) ? sanitize_text_field( $_REQUEST['mec_occurrence'] ) : '';
		$datetime_format = get_option( 'date_format' ) . ' ' . get_option( 'time_format' );

		foreach ( $dates as $timestamp => $date ) {
			$output .= '<option value="' . $timestamp . '" ' . ( $occurrence == $timestamp ? 'selected="selected"' : '' ) . '>' . date( $datetime_format, $timestamp ) . '</option>';
		}

		$output .= '</select>';
		return $output;
	}

	public function add_occurrence_filter_ajax() {
		$event_id = isset( $_REQUEST['event_id'] ) ? sanitize_text_field( $_REQUEST['event_id'] ) : 0;

		$html = $this->add_occurrence_filter( $event_id );
		echo json_encode( array( 'html' => $html ) );
		exit;
	}

	public function add_bulk_actions( $bulk_actions ) {

		$bulk_actions['csv-export']      = __( 'CSV Export', 'mec-rsvp' );
		$bulk_actions['ms-excel-export'] = __( 'MS Excel Export', 'mec-rsvp' );

		return $bulk_actions;
	}

	public function do_bulk_actions( $redirect, $action, $object_ids ) {

		switch ( $action ) {
			case 'ms-excel-export':

                ImportExport::getInstance()->export_rsvps($object_ids, 'ms-excel');

                break;

            case 'csv-export':

				ImportExport::getInstance()->export_rsvps($object_ids, 'csv');

                break;
		}

		return $redirect;
	}

}
