<?php

namespace MEC_RSVP\RSVP;

use MEC\Settings\Settings;
use MEC\Singleton;

class AjaxProcessHandler extends Singleton{

	/**
	 * @var int
	 */
	private $event_id;

    /**
	 * @use in Base
	 */
	public function init() {

		/** RSVP Form start */
		add_action( 'wp_ajax_mec-rsvp-get-body-form-step1', [ $this, 'get_html_form_step1_by_ajax' ] );
		add_action( 'wp_ajax_nopriv_mec-rsvp-get-body-form-step1', [ $this, 'get_html_form_step1_by_ajax' ] );

		/**
		 * step 2 - display attendees form
		 */
		add_action( 'wp_ajax_mec-rsvp-get-attendees-form', [ $this, 'get_html_attendees_form_by_ajax' ] );
		add_action( 'wp_ajax_nopriv_mec-rsvp-get-attendees-form', [ $this, 'get_html_attendees_form_by_ajax' ] );

		/**
		 * Add RSVP
		 */
		add_action( 'wp_ajax_mec-add-rsvp', [ $this, 'add_rsvp_by_ajax' ] );
		add_action( 'wp_ajax_nopriv_mec-add-rsvp', [ $this, 'add_rsvp_by_ajax' ] );
		/** RSVP Form end */

		/** RSVP Edit Form start */
		add_action( 'wp_ajax_mec-rsvp-search-form-by-email', [ $this, 'get_rsvps_filtered_by_email_by_ajax' ] );
		add_action( 'wp_ajax_nopriv_mec-rsvp-search-form-by-email', [ $this, 'get_rsvps_filtered_by_email_by_ajax' ] );

		add_action( 'wp_ajax_mec-get-rsvp-form-for-edit', [ $this, 'get_rsvp_form_for_edit_by_ajax' ] );
		add_action( 'wp_ajax_nopriv_mec-get-rsvp-form-for-edit', [ $this, 'get_rsvp_form_for_edit_by_ajax' ] );
		/** RSVP Edit Form end */

		/** RSVP Attendees load more - start */
		add_action( 'wp_ajax_mec-get-more-attendees', [ $this, 'get_more_attendees_by_ajax' ] );
		add_action( 'wp_ajax_nopriv_mec-get-more-attendees', [ $this, 'get_more_attendees_by_ajax' ] );
		/** RSVP Attendees load more - end */

	}

	public function validate_for_display_form( $event_id, $event_date, $email, $attendees_count = 1, $attendees = null, $rsvp_id = 0 ){

		if(!$event_id){

			wp_send_json(array(
				'success'=> false,
				'error_message_html'=> '<div class="mec-error">'. __('The event is unknown.','mec-rsvp') .'</div>',
			));
		}

		if(empty($event_date)){

			wp_send_json(array(
				'success'=> false,
				'error_message_html'=> '<div class="mec-error">'. __('Please select a date first.','mec-rsvp') .'</div>',
			));
		}

		if( empty($email) && !is_email($email) ){

			wp_send_json(array(
				'success'=> false,
				'error_message_html'=> '<div class="mec-error">'. __('Please enter the email correctly.','mec-rsvp') .'</div>',
			));
		}

		$exclude_rsvp_ids = $rsvp_id ? [$rsvp_id] : [];

		$max_attendees_in_each_rsvp = EventRSVP::getInstance()->get_total_attendees_in_each_rsvp_limit( $event_id, $event_date );

		if($max_attendees_in_each_rsvp && $attendees_count > $max_attendees_in_each_rsvp){

			$message = sprintf(
				__('You can participate in %1s RSVPs at max.','mec-rsvp'),
				$max_attendees_in_each_rsvp
			);

			wp_send_json(array(
				'success'=> false,
				'error_message_html'=> '<div class="mec-error">'. $message .'</div>',
			));
		}

		//if is new rsvp
		if( is_null( $attendees ) ){

			$settings_rsvp_first_for_all = (bool)Settings::getInstance()->get_settings('rsvp_first_for_all');
			$c_attendees_count = $settings_rsvp_first_for_all ? $attendees_count : 1;

			$allowed = EventRSVP::getInstance()->is_allowed_email_for_create_rsvp( $event_id, $event_date, $email, $c_attendees_count, $exclude_rsvp_ids );
			if( is_wp_error( $allowed ) || !$allowed ){

				$message = is_wp_error( $allowed ) ? $allowed->get_error_message() : __('A RSVP has already been registered with this email.','mec-rsvp');
				wp_send_json(array(
					'success'=> false,
					'error_message_html'=> '<div class="mec-error">'. $message .'</div>',
				));
			}
		}


		$max_attendees = EventRSVP::getInstance()->get_total_rsvp_limit( $event_id, $event_date );
		if( $max_attendees ){

			$total_attendees_event = EventRSVP::getInstance()->get_total_attendees( $event_id,$event_date, $exclude_rsvp_ids );
			$attendees_count = !is_null($attendees) && is_array($attendees) ? count($attendees) : $attendees_count;
			if( ($total_attendees_event + $attendees_count) > $max_attendees ){

				$left_over = absint($max_attendees - $total_attendees_event);

				if(!$left_over){

					$message = sprintf(
						__('Attendee limit has been reached. You cannot submit RSVP.','mec-rsvp'),
						$left_over
					);
				}else{

					$message = sprintf(
						__('You cannot submit RSVP. You can enter 1s% attendee at max.','mec-rsvp'),
						$left_over
					);
				}

				wp_send_json(array(
					'success'=> false,
					'error_message_html'=> '<div class="mec-error">'. $message .'</div>',
				));
			}
		}

		if( !is_null($attendees) && is_array($attendees) && count($attendees) > 1 ){

			$attendees_count = count($attendees);
			$total_emails = array_count_values(array_column($attendees,'mec_email'));
			foreach( $total_emails as $attendee_email => $total_attendees ){

				$email = isset($attendee_email) && is_email( $attendee_email ) ? sanitize_email($attendee_email) : false;
				if(!$email){

					$messages[] = '<div class="mec-error">'. sprintf(
						__('The email %1s is not correct','mec-rsvp'),
						$attendee_email
					) .'</div>';

					continue;
				}

				$allowed = EventRSVP::getInstance()->is_allowed_email_for_create_rsvp( $event_id, $event_date, $email, $total_attendees, $exclude_rsvp_ids );
				if( is_wp_error( $allowed ) || !$allowed ){

					$message = is_wp_error( $allowed ) ? $allowed->get_error_message() : __('A RSVP has already been registered with this email.','mec-rsvp');

					$messages[] = '<div class="mec-error">' . $message .'</div>';
				}
			}

			if(!empty($messages)){

				wp_send_json(array(
					'success'=> false,
					'error_message_html'=> implode('',$messages)
				));
			}
		}
	}

	public function check_google_recaptcha(){

		// Google recaptcha
		if(\MEC\Base::get_main()->get_recaptcha_status('rsvp') ) {

			$g_recaptcha_response = isset($_REQUEST['g-recaptcha-response']) ? $_REQUEST['g-recaptcha-response'] : NULL;
			if(!\MEC\Base::get_main()->get_recaptcha_response($g_recaptcha_response)){

				wp_send_json(array(
					'success'=> false,
					'error_message_html'=> '<div class="mec-error">' . __('Captcha is invalid. Please try again.', 'mec-rsvp') . '</div>',
				));

				die();
			}
		}
	}

	public function get_redirect_thankyou_page_script(){

		$page_id = Settings::getInstance()->get_settings('rsvp_thankyou_page');
		if(!$page_id){

			return;
		}

		$redirect_to = get_permalink($page_id);
		$interval = Settings::getInstance()->get_settings('rsvp_thankyou_page_time');

		$script = '';
		if($redirect_to){


			$script = '<script>setTimeout(function(){window.location.href="'.$redirect_to.'"},'.(int)$interval.')</script>';
		}

		return $script;
	}

	public function send_verification_code($email){

		$code = time() * mt_rand(10000,9999999);
		$code = substr($code,0,6);

		$sended = wp_mail(
			$email,
			'Verification code',
			__('Your verification code is:','mec-rsvp').' '.$code
		);

		$expire = 10 * 60;
		set_transient('mec-verification-code-'.$email,$code,$expire);
	}

	public function get_html_form_step1_by_ajax(){

		$r = array( 'success' => false );

		$nonce = isset( $_POST['nonce'] ) ? sanitize_text_field( $_POST['nonce'] ) : false;
		if ( !$nonce || !wp_verify_nonce( $nonce, 'mec_rsvp_step_1_nf' ) ) {

			$r['error_message_html'] = '<div class="mec-error">' . __( 'Processing failed. Please refresh the page and try again later', 'mec-rsvp' ) . '</span>';
			wp_send_json( $r );
		}

		$event_id       = isset( $_POST['event_id'] ) ? $_POST['event_id'] : 0;
		$event_date  	= isset( $_POST['event_date'] ) && $_POST['event_date'] ? sanitize_text_field( $_POST['event_date'] ) : '';
		$this->event_id = $event_id;

		if(empty($event_date)){

			wp_send_json(array(
				'success'=> false,
				'error_message_html'=> '<div class="mec-error">'. __('Please select a date first.','mec-rsvp') .'</div>',
			));

			die();
		}

		$r['html']       = DisplayForm::getInstance()->get_html_step1_body_form( $event_id, $event_date );
		$r['success']    = true;


		wp_send_json( $r );
	}

	/**
	 * @used    step 2
	 * @hooked  wp_ajax_mec-rsvp-get-attendees-form , wp_ajax_nopriv_mec-rsvp-get-attendees-form
	 */
	public function get_html_attendees_form_by_ajax() {

		$r = array( 'success' => false );

		// Check Google recaptcha
		$this->check_google_recaptcha();

		if ( isset( $_POST['_mec_nonce_s1'] ) && wp_verify_nonce( $_POST['_mec_nonce_s1'], 'mec_rsvp_step_1_nf' ) ) {

			$rsvp_vars       = isset( $_POST['rsvp'] ) ? $_POST['rsvp'] : array();
			$group_id        = isset( $rsvp_vars['answer'] ) ? sanitize_text_field( $rsvp_vars['answer'] ) : '';
			$event_id        = isset( $_POST['event_id'] ) ? $_POST['event_id'] : 0;
			$event_date 			 = isset( $rsvp_vars['event_date'] ) && $rsvp_vars['event_date'] ? sanitize_text_field( $rsvp_vars['event_date'] ) : '';
			$attendees_count = isset( $rsvp_vars['attendees_count'] ) && absint( $rsvp_vars['attendees_count'] ) > 0 ? absint( $rsvp_vars['attendees_count'] ) : 1;
			$email        = isset( $rsvp_vars['email'] ) && is_email($rsvp_vars['email']) ? sanitize_email( $rsvp_vars['email'] ) : null;

			$rsvp_id        = isset( $rsvp_vars['rsvp_id'] ) ? $rsvp_vars['rsvp_id'] : null;
			$rsvp_nonce 	= isset( $rsvp_vars['rsvp_nonce'] ) ? sanitize_text_field($rsvp_vars['rsvp_nonce']) : 0;
			if( !is_null($rsvp_id) && $rsvp_id ){

				if( !$rsvp_nonce || !wp_verify_nonce( $rsvp_nonce, 'mec-rsvp-edit-na'.$rsvp_id.$event_date )){

					$r['error_message_html'] = '<div class="mec-error">' . __( 'Processing failed. Please refresh the page and try again later', 'mec-rsvp' ) . '</span>';

					wp_send_json( $r );
				}
			}

			$r['html']       = DisplayForm::getInstance()->get_html_attendees_form( $group_id, $event_id, $attendees_count, $event_date, $email, $rsvp_id );
			$r['success']    = true;
		} else {
			$r['error_message_html'] = '<div class="mec-error">' . __( 'Processing failed. Please refresh the page and try again later', 'mec-rsvp' ) . '</span>';
		}

		wp_send_json( $r );
	}

	/**
	 * @used    step 2
	 * @hooked  wp_ajax_mec-rsvp-get-attendees-form , wp_ajax_nopriv_mec-rsvp-get-attendees-form
	 */
	public function add_rsvp_by_ajax() {

		$r = array( 'success' => false );

		$rsvp_vars       = isset( $_POST['rsvp'] ) ? $_POST['rsvp'] : array();
		$event_id        = isset( $_POST['event_id'] ) ? $_POST['event_id'] : 0;
		$event_date 	 = isset( $rsvp_vars['event_date'] ) && $rsvp_vars['event_date'] ? sanitize_text_field( $rsvp_vars['event_date'] ) : '';
		$rsvp_id        = isset( $rsvp_vars['rsvp_id'] ) ? $rsvp_vars['rsvp_id'] : 0;
		$email = isset( $rsvp_vars['email'] ) && is_email($rsvp_vars['email']) ? sanitize_email( $rsvp_vars['email'] ) : '';

		$attendees = isset($rsvp_vars['attendees']) ? $rsvp_vars['attendees'] : false;
		$this->validate_for_display_form( $event_id, $event_date, $email, $attendees_count = 1, $attendees, $rsvp_id);

		$nonce = isset( $_POST['_mec_nonce_s2'] ) ? sanitize_text_field( $_POST['_mec_nonce_s2'] ) : false;

		if ( !$nonce || !wp_verify_nonce( $nonce, 'mec_rsvp_step_2_nf'.$event_id.$event_date ) ) {

			$r['error_message_html'] = '<div class="mec-error">' . __( 'Processing failed. Please refresh the page and try again later', 'mec-rsvp' ) . '</span>';
				wp_send_json( $r );
		}

		$rsvp_creation_by_invite = isset( $_POST['rsvp_creation_by_invite'] ) ? $_POST['rsvp_creation_by_invite'] : 0;
		if($rsvp_creation_by_invite){
			$rsvp_vars['creation_by_invite'] = 'yes';
		}
		$rsvp_vars['event_id'] = $event_id;

		$f_rsvp_id      = isset( $rsvp_vars['rsvp_id'] ) && is_numeric($rsvp_vars['rsvp_id']) ? (int)$rsvp_vars['rsvp_id'] : 0;
		$f_rsvp_nonce   = isset( $rsvp_vars['rsvp_edit_nonce'] ) ? sanitize_text_field($rsvp_vars['rsvp_edit_nonce']) : 0;
		$f_rsvp_action 	= 'mec-rsvp-form-edit-na'.$f_rsvp_id.$event_date;
		if ( $f_rsvp_id && (!$f_rsvp_nonce || !wp_verify_nonce( $f_rsvp_nonce, $f_rsvp_action )) ) {

			$r['error_message_html'] = '<div class="mec-error">' . __( 'Processing failed. Please refresh the page and try again later', 'mec-rsvp' ) . '</span>';
			wp_send_json( $r );
			die();
		}

		if($f_rsvp_id){
			$rsvp_vars['ID'] = $f_rsvp_id;
			$rsvp_id = RSVPs::getInstance()->add_or_update_rsvp($rsvp_vars);
		}else{
			$rsvp_id = RSVPs::getInstance()->add_rsvp($rsvp_vars);
		}

		if($rsvp_id){
			//display result
			if(!$f_rsvp_id){

				$html = '<div id="mec-events-meta-group-booking-'.$rsvp_id.'" class="mec-events-meta-group mec-success">
						<div class="">
						'. __('Thank you for RSVP. please check your email.','mec-rsvp').'
						</div>
						<div id="mec_rsvp_message-'.$rsvp_id.'" class="mec-util-hidden" style="display: none;"></div>
					</div>';

				$html .= $this->get_redirect_thankyou_page_script();
			}else{

				$html = '<div id="mec-events-meta-group-booking-'.$rsvp_id.'" class="mec-events-meta-group mec-success">
						<div class="">
						'. __('RSVP has been modified. please check your email.','mec-rsvp').'
						</div>
						<div id="mec_rsvp_message-'.$rsvp_id.'" class="mec-util-hidden" style="display: none;"></div>
					</div>';
			}

		}
		$r['html'] = $html;
		$r['success']    = true;

		wp_send_json( $r );
	}

	public function get_rsvps_filtered_by_email_by_ajax(){

		$r = array(
			'success' => false,
		);

		$nonce = isset( $_POST['nonce'] ) ? sanitize_text_field( $_POST['nonce'] ) : false;
		if ( !$nonce || !wp_verify_nonce( $nonce, 'mec-rsvp-search-form-by-email' ) ) {

			$r['error_message_html'] = '<div class="mec-error">' . __( 'Processing failed. Please refresh the page and try again later', 'mec-rsvp' ) . '</span>';
			wp_send_json( $r );
		}

		$event_id = isset($_POST['event_id']) && is_numeric($_POST['event_id']) ? (int)$_POST['event_id'] : false;
		$email = isset($_POST['email']) ? sanitize_email($_POST['email']) : false;
		$verification_code = isset($_POST['verification_code']) ? sanitize_text_field($_POST['verification_code']) : false;

		if(!$event_id){

			return;
		}



		$can_modification_without_email_verification = EventRSVP::getInstance()->can_rsvp_modification_without_email_verification($event_id);
		if(!$can_modification_without_email_verification){

			if(!is_email($email)){

				$r['error_message_html'] = '<div class="mec-error">' . __( 'The email you entered is incorrect', 'mec-rsvp' ) . '</span>';
				wp_send_json( $r );
			}

			$saved_code = get_transient('mec-verification-code-'.$email);
			if(!$verification_code || !$saved_code){

				if(!$saved_code){

					$this->send_verification_code($email);
				}
				$r['success'] = 'need_verification';
				wp_send_json( $r );
			}else{

				if($verification_code !== $saved_code){

					$r['error_message_html'] = '<div class="mec-error">' . __( 'The code you entered is incorrect', 'mec-rsvp' ) . '</span>';
					wp_send_json( $r );
				}
			}
		}

		$atts = array(
			'event_id' => $event_id,
			'email' => $email,
		);

		$html = ShortcodeRSVPList::display_rsvps($atts);

		$r['html'] = $html;
		$r['success'] = true;

		wp_send_json( $r );
	}

	public function get_rsvp_form_for_edit_by_ajax(){

		$r = array(
			'success' => false,
		);

		$event_id = isset($_POST['event_id']) && is_numeric($_POST['event_id']) ? (int)$_POST['event_id'] : 0;

		if(!$event_id){

			return;
		}

		$can_display = EventRSVP::getInstance()->can_display_rsvp_form($event_id);
		if(!$can_display){

			return;
		}

		$r['success'] = true;
		$r['html'] = DisplayForm::getInstance()->output( $event_id );

		wp_send_json( $r );
	}

	public function get_more_attendees_by_ajax(){

		$event_id = isset($_POST['event_id']) ? (int)$_POST['event_id'] : 0;
		$event_date = isset($_POST['event_date']) ? (int)$_POST['event_date'] : 0;
		$answer_id = isset($_POST['answer']) && !empty($_POST['answer']) ? sanitize_text_field($_POST['answer']) : 0;
		$offset = isset($_POST['offset']) ? (int)$_POST['offset'] : 0;

		if(!$event_id || !$event_date || !$answer_id ){

			return;
		}

		$html = DisplayForm::getInstance()->get_attendees_html( $event_id, $event_date, $answer_id, $offset );

		wp_send_json( $html );
	}
}