<?php

namespace MEC_RSVP\RSVP;

use MEC\Events\Event;
use MEC\Settings\Settings;
use MEC\Singleton;
use MEC_RSVP\Settings\SettingsPage;

class EventMetaBox extends Singleton {

    public function enqueue(){

        ?>
        <style>
            .mec-add-rsvp-tabs-wrap,.mec-add-event-tabs-wrap,.mec-create-shortcode-tabs-wrap {
                display: flex;
                display: -webkit-box;
                display: -webkit-flex;
                display: -ms-flexbox;
            }

            .mec-add-rsvp-tabs-left,.mec-add-event-tabs-left {
                min-width: 200px;
            }

            @media(max-width: 1366px) {
                .mec-add-rsvp-tabs-left,.mec-add-event-tabs-left {
                    min-width:137px;
                }
            }

            .mec-add-rsvp-tabs-left,.mec-add-event-tabs-left,.mec-create-shortcode-tabs-left {
                flex: 1;
            }

            .mec-add-rsvp-tabs-right,.mec-add-event-tabs-right,.mec-create-shortcode-tabs-right {
                flex: 6;
            }

            a.mec-add-rsvp-tabs-link,a.mec-add-event-tabs-link,a.mec-create-shortcode-tabs-link {
                display: block;
            }

            .mec-rsvp-tab-content,.mec-create-shortcode-tab-content,.mec-event-tab-content {
                display: none;
                transition: all .3s ease;
            }

            .mec-rsvp-tab-content.mec-tab-active,.mec-create-shortcode-tab-content.mec-tab-active,.mec-event-tab-content.mec-tab-active {
                display: block;
            }

            .mec-add-rsvp-tabs-wrap,.mec-add-event-tabs-wrap {
                background: #fff;
                margin: -6px -12px -12px;
            }

            .mec-create-shortcode-tabs-wrap {
                margin: -30px -22px -42px;
            }

            .mec-add-rsvp-tabs-left,.mec-add-event-tabs-left,.mec-create-shortcode-tabs-left {
                background: #f7f8f9;
            }

            .mec-add-rsvp-tabs-left a,.mec-add-event-tabs-left a,.mec-create-shortcode-tabs-left a {
                display: block;
                position: relative;
                outline: 0;
                padding: 13px 4px 13px 20px;
                background: #e3e5e7;
                background: 0 0;
                border: solid;
                border-width: 1px 0 1px 0;
                border-color: transparent;
                color: #3f454a;
                font-size: 13px;
                font-weight: 600;
                text-decoration: none;
                border-radius: 0;
                transition: all 0.2s ease;
            }

            .mec-add-rsvp-tabs-left a:first-of-type,.mec-add-event-tabs-left a:first-of-type,.mec-create-shortcode-tabs-left a:first-of-type {
                border-top: none;
            }

            .mec-add-rsvp-tabs-left a:hover,.mec-add-event-tabs-left a:hover,.mec-create-shortcode-tabs-left a:hover {
                background: #fff;
                color: #07bbe9;
            }

            .mec-add-rsvp-tabs-left a:focus,.mec-add-event-tabs-left a:focus,.mec-create-shortcode-tabs-left a:focus {
                box-shadow: none;
                outline: unset;
            }

            .mec-add-rsvp-tabs-left a.mec-tab-active,.mec-add-event-tabs-left a.mec-tab-active,.mec-create-shortcode-tabs-left a.mec-tab-active {
                background: #ecf9fd;
                color: #07bbe9;
                border-color: #ccecf4;
                position: relative;
                padding-left: 22px;
            }

            .inside div div > a.mec-tab-active:after,.inside div div > a.mec-tab-active:before {
                position: absolute;
                z-index: 9999;
                content: " ";
                height: 0;
                width: 0;
                border: 8px solid transparent;
                border-right-color: #fff;
                right: -1px;
                top: 13px;
            }

            .inside div div > a.mec-tab-active:before {
                border-right-color: #d7d8d9;
                right: 0;
            }

            .mec-add-rsvp-tabs-right,.mec-add-event-tabs-right,.mec-create-shortcode-tabs-right {
                padding: 0 30px 40px;
                border-left: 1px solid #e2e2e2;
            }

            .mec-rsvp-tab-content.mec-tab-active,.mec-create-shortcode-tab-content.mec-tab-active,.mec-event-tab-content.mec-tab-active {
                animation: fadeEffect2 .31s;
            }

            @media(max-width: 1366px) {
                .mec-add-rsvp-tabs-right,.mec-add-event-tabs-right,.mec-create-shortcode-tabs-right {
                    padding:0 15px 20px;
                }

                .mec-form-row select {
                    min-width: 60px;
                }
            }

            @media (min-width: 1199px) and (max-width:1280px) {
                .mec-add-rsvp-tabs-right,.mec-add-event-tabs-right,.mec-create-shortcode-tabs-right {
                    padding:0 0 0 10px;
                }

                #mec_meta_box_hourly_schedule_days {
                    padding: 0 40px 0 0;
                }

                #mec_meta_box_hourly_schedule_days .mec-form-row.mec-box {
                    margin-right: -40px;
                }

                #mec_comment,#mec_cost,#mec_countdown_method,#mec_event_timezone,#mec_public,#mec_repeat_type {
                    min-width: 220px;
                    width: 220px;
                }

                #mec_meta_box_hourly_schedule_days .mec-box.mec-form-row input[type=text] {
                    max-width: 120px;
                }

                .mec-form-row .mec-time-picker select {
                    min-width: 60px;
                }

                #mec_countdown_method,#mec_repeat_type {
                    min-width: 220px;
                    width: 220px;
                }

                #mec_exceptions_in_days_container .mec-col-4 {
                    width: 25%;
                }

                #mec_exceptions_in_days_container .mec-col-3 {
                    width: 50%;
                }

                #mec_exceptions_in_days_container .mec-col-5 {
                    width: 20%;
                }

                #mec_exceptions_in_days_container input[type=text] {
                    width: 95%;
                }

                #mec_repeat_certain_weekdays_container label:not(.mec-col-3) {
                    display: block;
                    padding-left: 25%;
                }
            }

            @media (max-width: 1023px) {
                .post-type-mec-events h4 {
                    margin-top:20px
                }

                .post-type-mec-events .mec-form-row {
                    padding-bottom: 20px
                }

                .post-type-mec-events .mec-form-row .mec-form-row {
                    padding: 0
                }

                .post-type-mec-events .mec-form-row .mec-col-1,.post-type-mec-events .mec-form-row .mec-col-10,.post-type-mec-events .mec-form-row .mec-col-11,.post-type-mec-events .mec-form-row .mec-col-12,.post-type-mec-events .mec-form-row .mec-col-2,.post-type-mec-events .mec-form-row .mec-col-3,.post-type-mec-events .mec-form-row .mec-col-4,.post-type-mec-events .mec-form-row .mec-col-5,.post-type-mec-events .mec-form-row .mec-col-6,.post-type-mec-events .mec-form-row .mec-col-7,.post-type-mec-events .mec-form-row .mec-col-8,.post-type-mec-events .mec-form-row .mec-col-9 {
                    display: block;
                    width: 100%;
                    margin: 20px 0 0 0;
                    max-width: 285px
                }

                .post-type-mec-events .mec-add-rsvp-tabs-left,.post-type-mec-events .mec-add-event-tabs-left {
                    min-width: 180px
                }

                .post-type-mec-events .mec-add-rsvp-tabs-left a,.post-type-mec-events .mec-add-event-tabs-left a,.post-type-mec-events .mec-create-shortcode-tabs-left a {
                    padding-left: 10px
                }

                #mec_repeat_type,.post-type-mec-events #mec_settings_fes_thankyou_page_url,.post-type-mec-events .mec-form-row .mec-col-4 input[type=number],.post-type-mec-events .mec-form-row .mec-col-4 input[type=text],.post-type-mec-events .mec-form-row .mec-col-4 select,.post-type-mec-events .mec-form-row .mec-col-4 textarea {
                    width: 100%;
                    max-width: 255px
                }

                #mec-exceptional-days .mec-certain-day>div,#mec_exceptions_in_days_container .mec-certain-day>div {
                    width: 100%;
                    max-width: 255px;
                    padding: 12px;
                    margin: 20px 10px 0 0;
                    border-radius: 8px
                }

                .mec-certain-day .mec-in-days-day,.mec-certain-day>div .mec-not-in-days-day {
                    line-height: 21px;
                    font-size: 10px
                }

                #mec_repeat_certain_weekdays_container label {
                    display: block;
                    margin: 20px 0 20px 0
                }
            }

            @media (max-width: 640px) {
                .mec-add-rsvp-tabs-wrap,.mec-add-event-tabs-wrap,.mec-create-shortcode-tabs-wrap {
                    display:block
                }

                .post-type-mec-events .mec-add-rsvp-tabs-left,.post-type-mec-events .mec-add-event-tabs-left {
                    min-width: 100%;
                    width: 100%!important;
                    display: block!important;
                    float: unset;
                    margin: 0;
                    flex: unset;
                    height: auto
                }

                .post-type-mec-events .mec-add-rsvp-tabs-right,.post-type-mec-events .mec-add-event-tabs-right,.post-type-mec-events .mec-create-shortcode-tabs-right {
                    display: block;
                    min-width: 100%;
                    width: 100%;
                    margin: 0;
                    flex: unset
                }

                .post-type-mec-events .mec-add-rsvp-tabs-left a,.post-type-mec-events .mec-add-event-tabs-left a,.post-type-mec-events .mec-create-shortcode-tabs-left a {
                    font-size: 14px;
                    padding: 14px 10px 14px 15px;
                    line-height: 1.2;
                    letter-spacing: 0
                }

                .mec-add-rsvp-tabs-right,.mec-add-event-tabs-right,.mec-create-shortcode-tabs-right {
                    padding-left: 10px;
                    padding-right: 10px
                }

                #mec_tickets .mec-box {
                    max-width: 290px
                }
            }
        </style>

        <script>
            jQuery(document).ready(function($){

                function mec_rsvp_status_change(status){

                    if(true === status){

                        $('.mec-add-rsvp-tabs-left .mec-add-rsvp-tabs-link').show();
                        $('#mec-rsvp .mec-rsvp-option-container').show();
                    }else{

                        $('.mec-add-rsvp-tabs-left .mec-add-rsvp-tabs-link:not(:first-child)').hide();
                        $('#mec-rsvp .mec-rsvp-option-container').hide();
                    }

                }

                jQuery(".mec-add-rsvp-tabs-link").on("click", function(e){

                    e.preventDefault();
                    var href = jQuery(this).attr("data-href");
                    jQuery(".mec-rsvp-tab-content,.mec-add-rsvp-tabs-link").removeClass("mec-tab-active");
                    jQuery(this).addClass("mec-tab-active");
                    jQuery("#" + href ).addClass("mec-tab-active");
                });

                $('.mec_rsvp_status').on('change',function(e){

                    var rsvp_status = $(this).is(':checked');
                    mec_rsvp_status_change(rsvp_status);

                    $("input[type=checkbox].rsvp_form_fields_global_inheritance").trigger('change');
                });
                var rsvp_status = $('.mec_rsvp_status').is(':checked');
                mec_rsvp_status_change(rsvp_status);


                $("input[type=checkbox].rsvp_form_fields_global_inheritance").on('change',function(){

                    var status = $(this).is(":checked");
                    var rsvp_status = $('.mec_rsvp_status').is(':checked');

                    if(true !== status && true === rsvp_status){
                        $('.mec-rsvp-forms').show();
                    }else{
                        $('.mec-rsvp-forms').hide();
                    }
                });

                $("input[type=checkbox].rsvp_form_fields_global_inheritance").trigger('change');
            });
        </script>
        <?php
    }

    public function render($event) {

        $this->init();

        $this->enqueue();
        ?>
        <div class="mec-add-rsvp-tabs-wrap">
            <div class="mec-add-rsvp-tabs-left">
                <a class="mec-add-rsvp-tabs-link mec-tab-active" data-href="mec_meta_box_rsvp_options_form_1" href="#"><?php echo esc_html__('RSVP Options','mec-rsvp'); ?></a>
                <a class="mec-add-rsvp-tabs-link" data-href="mec_meta_box_rsvp_options_form_2" href="#"><?php echo esc_html__('Limits','mec-rsvp'); ?></a>
                <?php
                    $form_types = SettingsPage::getInstance()->get_form_types();
                    foreach($form_types as $form_id => $form_title){
                        $class = ('general' !== $form_id) ? 'mec-rsvp-forms' : '';
                        echo '<a class="mec-add-rsvp-tabs-link '.$class.'" data-href="mec-reg-fields-rsvp_'.$form_id.'" href="#">'. $form_title.'</a>';
                    }
                ?>
                <?php if(isset($settings['downloadable_file_status']) and $settings['downloadable_file_status']): ?>
                <a class="mec-add-rsvp-tabs-link" data-href="mec-downloadable-file" href="#"><?php echo esc_html__('Downloadable File','mec-rsvp'); ?></a>
                <?php endif; ?>
                <a class="mec-add-rsvp-tabs-link" data-href="mec_meta_box_rsvp_options_form_attendees" href="#"><?php echo esc_html__('Attendee List','mec-rsvp'); ?></a>
                <?php do_action('add_event_rsvp_sections_left_menu'); ?>
            </div>
            <div class="mec-add-rsvp-tabs-right">
                <?php do_action('mec_event_rsvp_options_metabox', $event); ?>
            </div>
        </div>
        <?php
    }

    public function ajax_handler(){

        add_action('wp_ajax_mec_event_rsvps',[ __CLASS__,'mec_event_rsvps']);
    }

    public function init() {

		add_action( 'mec_event_rsvp_options_metabox', [$this,'meta_box_rsvp_options'] );
        add_action( 'mec_event_rsvp_options_metabox', [$this,'meta_box_attendees'] );
        add_action( 'mec_event_rsvp_options_metabox', [$this,'meta_box_rsvp_forms'] );

        add_action( 'save_post_mec-events', [$this,'save_event'] );
        add_action( 'edit_post_mec-events', [$this,'save_event'] );

		if(wp_doing_ajax()){

			$this->ajax_handler();
		}
	}

    public function fes_enqueue(){

        ?>
        <script>
            jQuery(document).ready(function($){
                function mec_rsvp_status_change(status){

                    if(true === status){
                        $('#mec-rsvp .mec-rsvp-tab-content:nth-child(n+2)').show();
                        $('#mec-rsvp .mec-rsvp-option-container').show();
                    }else{

                        $('#mec-rsvp .mec-rsvp-tab-content:nth-child(n+2)').hide();
                        $('#mec-rsvp .mec-rsvp-option-container').hide();
                    }
                }

                $('.mec_rsvp_status').on('change',function(e){

                    var rsvp_status = $(this).is(':checked');
                    mec_rsvp_status_change(rsvp_status);

                    $("input[type=checkbox].rsvp_form_fields_global_inheritance").trigger('change');
                });
                var rsvp_status = $('.mec_rsvp_status').is(':checked');
                mec_rsvp_status_change(rsvp_status);
            });
        </script>
        <?php
    }

    public function fes_init(){



        add_action( 'mec_fes_metabox_details', [$this,'fes_enqueue'], 99 );
        add_action( 'mec_fes_metabox_details', [$this,'meta_box_rsvp_options'], 99 );
    }

    public function save_event($event_id){

        if(!isset($_POST['mec_rsvp_nonce'])) return;
        if(!wp_verify_nonce(sanitize_text_field($_POST['mec_rsvp_nonce']), 'mec_rsvp_data')) return;
        if(defined('DOING_AUTOSAVE') and DOING_AUTOSAVE) return;

        $_mec = isset($_POST['mec']) ? $_POST['mec'] : [];

        $rsvp_status_for_this_event = isset($_POST['mec_rsvp_status']) ? $_POST['mec_rsvp_status'] : "0";
        update_post_meta($event_id,'mec_rsvp_status',$rsvp_status_for_this_event);

        $rsvp_options = isset($_POST['mec']['rsvp']) ? $_POST['mec']['rsvp'] : array();
        update_post_meta( $event_id, 'mec_rsvp', $rsvp_options );

        /** Forms Options start */
        $rsvp_form_fields_global_inheritance = isset($_POST['mec']['rsvp_form_fields_global_inheritance']) ? (int)$_POST['mec']['rsvp_form_fields_global_inheritance'] : 1;
        update_post_meta( $event_id, 'mec_rsvp_form_fields_global_inheritance', $rsvp_form_fields_global_inheritance );

        $form_types = SettingsPage::getInstance()->get_form_types();
        $field_groups = array(
            'reg',
            'bfixed'
        );

        foreach($form_types as $form_id => $form_title){
            foreach($field_groups as $field_group){
                $k = "rsvp_{$form_id}_{$field_group}_fields";
                $fields = isset($_POST['mec'][$k]) ? $_POST['mec'][$k] : array();

                $status_key = "form_rsvp_{$form_id}_status";
                $status = isset($_mec['rsvp_forms_status'][$status_key]) ? $_mec['rsvp_forms_status'][$status_key] : 'default';
                $rsvp_forms_options[$status_key] = $status;
                $rsvp_forms_options[$k] = $fields;

            }
        }
        update_post_meta($event_id,'mec_rsvp_forms_options',$rsvp_forms_options);
        /** Forms Options end */

    }

    public static function mec_event_rsvps(){

        $event_id = isset($_POST['id']) ? sanitize_text_field($_POST['id']) : 0;
        $backend = isset($_POST['backend']) ? sanitize_text_field($_POST['backend']) : 0;

        $occurrence = isset($_POST['occurrence']) ? sanitize_text_field($_POST['occurrence']) : NULL;
        $occurrence = explode(':', $occurrence)[0];
        if($occurrence == 'all'){
            $occurrence = strtotime('+100 years');
        }

        $rsvps = EventRSVP::getInstance()->get_rsvps_by_event_id($event_id, $occurrence);

        $html = '';
        if(count($rsvps)){
            $html .= '<div class="w-clearfix">
                <div class="w-col-xs-3 name">
                    <span>'.__('Title', 'mec-rsvp').'</span>
                </div>
                <div class="w-col-xs-3 email">
                    <span>'.__('Attendees', 'mec-rsvp').'</span>
                </div>
                <div class="w-col-xs-3 response">
                    <span>'.__('Response', 'mec-rsvp').'</span>
                </div>
            </div>';

            /** @var WP_Post $rsvp */

            $index = $key = 0;
            foreach($rsvps as $rsvp){
                $key++;
                $rsvp = new RSVP($rsvp);
                $rsvp_title = $rsvp->get_title();
                $attendees = $rsvp->get_attendees();
                $attendees_count = $rsvp->get_attendees_count();

                $answer_text = $rsvp->get_answer_text();

                $unique_attendees = array();
                foreach($attendees as $attendee){

                    if(!isset($unique_attendees[$attendee['email']])) $unique_attendees[$attendee['email']] = $attendee;
                    else $unique_attendees[$attendee['email']]['count'] += 1;
                }

                $attendees_html = '<strong>'.$attendees_count.'</strong>';
                $attendees_html .= '<div class="mec-rsvp-attendees-tooltip">';
                $attendees_html .= '<ul>';

                foreach($unique_attendees as $unique_attendee){
                    $attendees_html .= '<li>';
                    $attendees_html .= '<div class="mec-rsvp-attendees-tooltip-name">'.$unique_attendee['name'].((isset($unique_attendee['count']) and $unique_attendee['count'] > 1) ? ' ('.$unique_attendee['count'].')' : '').'</div>';
                    $attendees_html .= '<div class="mec-rsvp-attendees-tooltip-email"><a href="mailto:'.$unique_attendee['email'].'">'.$unique_attendee['email'].'</a></div>';
                    $attendees_html .= '</li>';
                }

                $attendees_html .= '</ul>';
                $attendees_html .= '</div>';

                $event_id = $rsvp->get_event_id();

                $title = $backend ? '<a href="'.get_edit_post_link($rsvp->ID).'" target="_blank">'.$rsvp_title.'</a>' : $rsvp_title;
                $html .= '<div class="w-clearfix">';
                $html .= '<div class="w-col-xs-3">'.$title.'</div>';
                $html .= '<div class="w-col-xs-3">'.$attendees_html.'</div>';
                $html .= '<div class="w-col-xs-3">'.$answer_text.'</div>';
                $html .= '</div>';

                $index++;
            }
        }else{
            $html .= '<p>'.__("No RSVPs Found!", 'mec-rsvp').'</p>';
        }

        echo json_encode(array('html' => $html));
        exit;
    }

    public function meta_box_rsvp_options($post){

        $FES = (boolean) !is_admin();

        $event = new Event($post);
        $settings = Settings::getInstance()->get_settings();

        $rsvp_status_for_this_event = (bool)get_post_meta($event->ID,'mec_rsvp_status',true);
        $rsvp_options = get_post_meta($post->ID, 'mec_rsvp', true);
        if(!is_array($rsvp_options)) {
            $rsvp_options = array();
        }

        $rsvp_limit = isset($rsvp_options['rsvp_limit']) ? $rsvp_options['rsvp_limit'] : '';
        $rsvp_limit_unlimited = isset($rsvp_options['rsvp_limit_unlimited']) ? $rsvp_options['rsvp_limit_unlimited'] : true;
        $rsvps_user_limit = isset($rsvp_options['rsvps_user_limit']) ? $rsvp_options['rsvps_user_limit'] : '';
        $rsvps_user_limit_unlimited = isset($rsvp_options['rsvps_user_limit_unlimited']) ? $rsvp_options['rsvps_user_limit_unlimited'] : true;
        $rsvps_all_occurrences = isset($rsvp_options['rsvps_all_occurrences']) ? $rsvp_options['rsvps_all_occurrences'] : 0;
        $rsvps_all_occurrences_multiple = isset($rsvp_options['rsvps_all_occurrences_multiple']) ? $rsvp_options['rsvps_all_occurrences_multiple'] : 0;

        wp_nonce_field('mec_rsvp_data', 'mec_rsvp_nonce');
        ?>
        <div id="mec-rsvp">
            <div class="mec-meta-box-fields mec-rsvp-tab-content mec-tab-active" id="mec_meta_box_rsvp_options_form_1">

                <?php if(!$FES or ($FES and (!isset($settings['fes_section_rsvp_tbl']) or (isset($settings['fes_section_rsvp_tbl']) and $settings['fes_section_rsvp_tbl'])))): ?>
                <h4 class="mec-title"><?php _e('RSVP Status', 'mec-rsvp'); ?></h4>
                <div class="mec-form-row mec-rsvp-primary-option">
                    <label for="mec_rsvp_status" class="label-checkbox">
                        <input id="mec_rsvp_status" class="mec_rsvp_status" value="1" type="checkbox" name="mec_rsvp_status" <?php checked(true,$rsvp_status_for_this_event) ?> /> <?php _e( 'Enable RSVP module', 'mec-rsvp' ); ?>
                    </label>
                </div>

                <div class="mec-rsvp-option-container">
                    <h4 class="mec-title"><?php _e('Total RSVP limit', 'mec-rsvp'); ?></h4>
                    <div class="mec-form-row">
                        <label class="mec-col-6 label-checkbox" onchange="jQuery('#mec_rsvp_limit').toggle()" for="mec_rsvp_limit_unlimited" id="mec_rsvp_limit_unlimited_label">
                            <input type="hidden" name="mec[rsvp][rsvp_limit_unlimited]" value="0"/>
                            <input id="mec_rsvp_limit_unlimited"
                                <?php
                                if ($rsvp_limit_unlimited == 1) {
                                    echo 'checked="checked"';
                                }
                                ?>
                                type="checkbox" value="1" name="mec[rsvp][rsvp_limit_unlimited]"/>
                            <?php _e('Unlimited', 'mec-rsvp'); ?>
                            <span class="mec-tooltip">
                                <div class="box">
                                    <h5 class="title"><?php _e('Total rsvp limit', 'mec-rsvp'); ?></h5>
                                    <div class="content">
                                        <p>
                                            <?php esc_attr_e('If you want to set a limit total attendees, uncheck this checkbox and put a limitation number.', 'mec-rsvp'); ?>
                                            <a href="https://webnus.net/dox/modern-events-calendar/total-rsvp-limits/" target="_blank"><?php _e('Read More', 'mec-rsvp'); ?></a>
                                            <a href="https://webnus.net/dox/modern-events-calendar/add-a-rsvp-system/" target="_blank"><?php _e('Read About A RSVP System', 'mec-rsvp'); ?></a>
                                        </p>
                                    </div>
                                </div>
                                <i title="" class="dashicons-before dashicons-editor-help"></i>
                            </span>
                        </label>
                        <input class="mec-col-6 <?php echo ($rsvp_limit_unlimited == 1) ? 'mec-util-hidden' : ''; ?>" style="<?php echo ($rsvp_limit_unlimited == 1) ? 'display:none;' : ''; ?>" type="text" name="mec[rsvp][rsvp_limit]" id="mec_rsvp_limit"
                            value="<?php echo esc_attr($rsvp_limit); ?>" placeholder="<?php _e('100', 'mec-rsvp'); ?>"/>
                    </div>
                    <?php endif; ?>

                    <?php if(!$FES or ($FES and (!isset($settings['fes_section_rsvp_tbl']) or (isset($settings['fes_section_rsvp_tbl']) and $settings['fes_section_rsvp_tbl'])))): ?>
                    <h4 class="title"><?php _e( 'Display Options', 'mec-rsvp' ); ?></h4>
                    <div class="mec-form-row">
                        <script>
                            jQuery(document).ready(function($){

                                function mec_settings_rsvp_attendees_list(){

                                    var target = $('#mec_settings_rsvp_attendees_list_global');
                                    if($(target).is(':checked')){
                                        $('.mec_settings_rsvp_attendees_list').prop('disabled',true);
                                        $('.mec_settings_rsvp_attendees_list').parent().hide();
                                        $(target).prop('disabled',false);
                                        $(target).parent().show();
                                    }else{

                                        $('.mec_settings_rsvp_attendees_list').prop('disabled',false);
                                        $('.mec_settings_rsvp_attendees_list').parent().show();
                                    }
                                }
                                $('#mec_settings_rsvp_attendees_list_global').on('change',mec_settings_rsvp_attendees_list);
                                mec_settings_rsvp_attendees_list();
                            });
                        </script>
                        <label class="mec-col-6" for="mec_settings_rsvp_attendees_list"><?php _e( 'Display Attendees List in RSVP Form', 'mec-rsvp' ); ?></label>
                        <div class="mec-col-6">
                            <?php
                                $answers = array(
                                    'global'    => __( 'Global', 'mec-rsvp' ),
                                    'yes'       => __( 'Yes', 'mec-rsvp' ),
                                    'no'        => __( 'No', 'mec-rsvp' ),
                                    'maybe'     => __( 'Maybe', 'mec-rsvp' ),
                                );

                                $display_attendees_settings = isset($rsvp_options['rsvp_attendees_list']) && is_array($rsvp_options['rsvp_attendees_list']) && !empty($rsvp_options['rsvp_attendees_list']) ? $rsvp_options['rsvp_attendees_list'] : ['global'];
                                foreach($answers as $answer_id => $answer_text){

                                    $checked = in_array($answer_id,$display_attendees_settings,true);
                                    echo '<label class="label-checkbox"><input type="checkbox" class="mec_settings_rsvp_attendees_list" id="mec_settings_rsvp_attendees_list_'.$answer_id.'" name="mec[rsvp][rsvp_attendees_list]['.$answer_id.']" value="'.$answer_id.'" '.checked(true,$checked,false).'/>'.$answer_text.'</label>';
                                }
                            ?>

                        </div>
                    </div>
                    <div style="height:25px"></div>
                    <div class="mec-form-row">
                        <div class="mec-col-6">
                            <label><?php esc_html_e('Display form only for logged in users','mec-rsvp'); ?></label>
                        </div>
                        <div class="mec-col-6">
                            <select class="mec-col-12" name="mec[rsvp][rsvp_display_form_only_for_logged_in_users]" id="mec_rsvp_display_form_only_for_logged_in_users">
                                <option value="global" <?php if(isset($rsvp_options['rsvp_display_form_only_for_logged_in_users']) and 'global' == $rsvp_options['rsvp_display_form_only_for_logged_in_users']) echo 'selected="selected"'; ?>><?php _e('Inherit from global options', 'mec-rsvp'); ?></option>
                                <option value="0" <?php if(isset($rsvp_options['rsvp_display_form_only_for_logged_in_users']) and '0' == $rsvp_options['rsvp_display_form_only_for_logged_in_users']) echo 'selected="selected"'; ?>><?php _e('Disabled', 'mec-rsvp'); ?></option>
                                <option value="1" <?php if(isset($rsvp_options['rsvp_display_form_only_for_logged_in_users']) and '1' == $rsvp_options['rsvp_display_form_only_for_logged_in_users']) echo 'selected="selected"'; ?>><?php _e('Enabled', 'mec-rsvp'); ?></option>
                            </select>
                        </div>
                    </div>
                    <div class="mec-form-row">
                        <div class="mec-col-6">
                            <label><?php esc_html_e('Display RSVP report in RSVP from','mec-rsvp'); ?></label>
                        </div>
                        <div class="mec-col-6">
                            <select class="mec-col-12" name="mec[rsvp][rsvp_display_rsvp_report]" id="mec_rsvp_display_rsvp_report">
                                <option value="global" <?php if(isset($rsvp_options['rsvp_display_rsvp_report']) and 'global' == $rsvp_options['rsvp_display_rsvp_report']) echo 'selected="selected"'; ?>><?php _e('Inherit from global options', 'mec-rsvp'); ?></option>
                                <option value="0" <?php if(isset($rsvp_options['rsvp_display_rsvp_report']) and '0' == $rsvp_options['rsvp_display_rsvp_report']) echo 'selected="selected"'; ?>><?php _e('Disabled', 'mec-rsvp'); ?></option>
                                <option value="1" <?php if(isset($rsvp_options['rsvp_display_rsvp_report']) and '1' == $rsvp_options['rsvp_display_rsvp_report']) echo 'selected="selected"'; ?>><?php _e('Enabled', 'mec-rsvp'); ?></option>
                            </select>
                        </div>
                    </div>
                    <div class="mec-form-row">
                        <div class="mec-col-6">
                            <label><?php esc_html_e('Display RSVP conversation','mec-rsvp'); ?></label>
                        </div>
                        <div class="mec-col-6">
                            <select class="mec-col-12" name="mec[rsvp][rsvp_display_conversation]" id="mec_rsvp_display_conversation">
                                <option value="global" <?php if(isset($rsvp_options['rsvp_display_conversation']) and 'global' == $rsvp_options['rsvp_display_conversation']) echo 'selected="selected"'; ?>><?php _e('Inherit from global options', 'mec-rsvp'); ?></option>
                                <option value="0" <?php if(isset($rsvp_options['rsvp_display_conversation']) and '0' == $rsvp_options['rsvp_display_conversation']) echo 'selected="selected"'; ?>><?php _e('Disabled', 'mec-rsvp'); ?></option>
                                <option value="1" <?php if(isset($rsvp_options['rsvp_display_conversation']) and '1' == $rsvp_options['rsvp_display_conversation']) echo 'selected="selected"'; ?>><?php _e('Enabled', 'mec-rsvp'); ?></option>
                            </select>
                        </div>
                    </div>
                    <div class="mec-form-row">
                        <div class="mec-col-6">
                            <label><?php esc_html_e('Enable RSVP modification in event page','mec-rsvp'); ?></label>
                        </div>
                        <div class="mec-col-6">
                            <select class="mec-col-12" name="mec[rsvp][rsvp_display_rsvp_modification]" id="mec_rsvp_display_rsvp_modification">
                                <option value="global" <?php if(isset($rsvp_options['rsvp_display_rsvp_modification']) and 'global' == $rsvp_options['rsvp_display_rsvp_modification']) echo 'selected="selected"'; ?>><?php _e('Inherit from global options', 'mec-rsvp'); ?></option>
                                <option value="0" <?php if(isset($rsvp_options['rsvp_display_rsvp_modification']) and '0' == $rsvp_options['rsvp_display_rsvp_modification']) echo 'selected="selected"'; ?>><?php _e('Disabled', 'mec-rsvp'); ?></option>
                                <option value="1" <?php if(isset($rsvp_options['rsvp_display_rsvp_modification']) and '1' == $rsvp_options['rsvp_display_rsvp_modification']) echo 'selected="selected"'; ?>><?php _e('Enabled', 'mec-rsvp'); ?></option>
                            </select>
                        </div>
                    </div>
                    <div class="mec-form-row">
                        <div class="mec-col-6">
                            <label><?php esc_html_e('Enable RSVP modification without email verification','mec-rsvp'); ?></label>
                        </div>
                        <div class="mec-col-6">
                            <select class="mec-col-12" name="mec[rsvp][rsvp_modification_without_email_verification]" id="mec_rsvp_modification_without_email_verification">
                                <option value="global" <?php if(isset($rsvp_options['rsvp_modification_without_email_verification']) and 'global' == $rsvp_options['rsvp_modification_without_email_verification']) echo 'selected="selected"'; ?>><?php _e('Inherit from global options', 'mec-rsvp'); ?></option>
                                <option value="0" <?php if(isset($rsvp_options['rsvp_modification_without_email_verification']) and '0' == $rsvp_options['rsvp_modification_without_email_verification']) echo 'selected="selected"'; ?>><?php _e('Disabled', 'mec-rsvp'); ?></option>
                                <option value="1" <?php if(isset($rsvp_options['rsvp_modification_without_email_verification']) and '1' == $rsvp_options['rsvp_modification_without_email_verification']) echo 'selected="selected"'; ?>><?php _e('Enabled', 'mec-rsvp'); ?></option>
                            </select>
                        </div>
                    </div>

                    <div class="mec-form-row">
                        <div class="mec-col-6">
                            <label><?php esc_html_e('RSVP modification location','mec-rsvp'); ?></label>
                        </div>
                        <?php
                        $modification_form_location = isset($rsvp_options['rsvp_display_rsvp_modification_location']) ? $rsvp_options['rsvp_display_rsvp_modification_location'] : 'global';
                        ?>
                        <div class="mec-col-6">
                            <select class="mec-col-12" name="mec[rsvp][rsvp_display_rsvp_modification_location]">
                                <option value="global" <?php selected( 'global', $modification_form_location ); ?>><?php _e('Inherit from global options', 'mec-rsvp'); ?></option>
                                <option value="top" <?php selected( 'top', $modification_form_location ) ?>><?php esc_html_e( 'Top', 'mec-rsvp' ) ?></option>
                                <option value="bottom" <?php selected( 'bottom', $modification_form_location ) ?>><?php esc_html_e( 'Bottom', 'mec-rsvp' ) ?></option>
                            </select>
                        </div>
                    </div>

                    <h4><?php _e( 'Minimum attendees to start the event', 'mec-rsvp' ); ?></h4>
                    <div class="mec-form-row">
                        <?php
                            $rsvp_min_attendees_global = isset($rsvp_options['rsvp_min_attendees_global']) ? (bool)$rsvp_options['rsvp_min_attendees_global'] : true;
                            $rsvp_min_attendees = isset($rsvp_options['rsvp_min_attendees']) ? (int)$rsvp_options['rsvp_min_attendees'] : false;
                        ?>
                        <label class="mec-col-6 label-checkbox" for="mec_settings_rsvp_min_attendees" id="mec_settings_rsvp_min_attendees_label">
                            <input type="hidden" name="mec[rsvp][rsvp_min_attendees_global]" value="0"/>
                            <input id="mec_settings_rsvp_min_attendees" <?php checked(true,$rsvp_min_attendees_global) ?> type="checkbox" value="1" name="mec[rsvp][rsvp_min_attendees_global]" onchange="jQuery(this).parent().parent().find('input[type=number]').toggle();"/>
                            <?php _e('Inherit from global options', 'mec-rsvp'); ?>
                        </label>
                        <input class="mec-col-6" <?php echo $rsvp_min_attendees_global ? 'style="display: none;"' : ''; ?> type="number" name="mec[rsvp][rsvp_min_attendees]" id="mec_rsvp_min_attendees" value="<?php echo esc_attr($rsvp_min_attendees); ?>" placeholder="<?php _e('12', 'mec-rsvp'); ?>"/>
                    </div>
                </div>
                <?php endif; ?>

                <?php if(!$FES or ($FES and (!isset($settings['fes_section_rsvp_io']) or (isset($settings['fes_section_rsvp_io']) and $settings['fes_section_rsvp_io'])))): ?>
                <div class="mec-rsvp-option-container">
                    <h4 class="mec-title"><?php _e('Show RSVP Form Interval', 'mec-rsvp'); ?></h4>
                    <div class="mec-form-row">
                        <?php
                            $show_rsvp_form_interval_global = isset($rsvp_options['show_rsvp_form_interval_global']) ? (bool)$rsvp_options['show_rsvp_form_interval_global'] : true;
                            $show_rsvp_form_interval = (isset($rsvp_options['show_rsvp_form_interval']) and trim($rsvp_options['show_rsvp_form_interval']) != '') ? $rsvp_options['show_rsvp_form_interval'] : '';
                        ?>
                        <label class="mec-col-6 label-checkbox" for="mec_settings_rsvp_show_rsvp_form_interval_global" id="mec_settings_rsvp_min_attendees_label">
                            <input type="hidden" name="mec[rsvp][show_rsvp_form_interval_global]" value="0"/>
                            <input id="mec_settings_rsvp_show_rsvp_form_interval_global" <?php checked(true,$show_rsvp_form_interval_global) ?> type="checkbox" value="1" name="mec[rsvp][show_rsvp_form_interval_global]" onchange="jQuery(this).parent().parent().find('input[type=number] , .mec-tooltip').toggle();"/>
                            <?php _e('Inherit from global options', 'mec-rsvp'); ?>
                        </label>
                        <input class="mec-col-6" <?php echo $show_rsvp_form_interval_global ? 'style="display: none;"' : ''; ?> type="number" id="mec_rsvp_show_rsvp_form_interval" name="mec[rsvp][show_rsvp_form_interval]" value="<?php echo $show_rsvp_form_interval; ?>" placeholder="<?php esc_attr_e('Minutes (e.g 5)', 'mec-rsvp'); ?>" />
                        <span class="mec-tooltip" <?php echo $show_rsvp_form_interval_global ? 'style="display: none;"' : ''; ?>>
                            <div class="box">
                                <h5 class="title"><?php _e('Show RSVP Form Interval', 'mec-rsvp'); ?></h5>
                                <div class="content"><p><?php esc_attr_e("You can show RSVP form only at certain times before event start. If you set this option to 30 then RSVP form will open only 30 minutes before starting the event! One day is 1440 minutes.", 'mec-rsvp'); ?></p></div>
                            </div>
                            <i title="" class="dashicons-before dashicons-editor-help"></i>
                        </span>
                    </div>
                </div>
                <?php endif; ?>

                <?php if(!$FES or ($FES and (!isset($settings['fes_section_rsvp_aa']) or (isset($settings['fes_section_rsvp_aa']) and $settings['fes_section_rsvp_aa'])))): ?>
                <div class="mec-rsvp-option-container">
                    <h4><?php _e('Automatic Approval', 'mec-rsvp'); ?></h4>
                    <div class="mec-form-row">
                        <label class="mec-col-6" for="mec_rsvp_auto_verify"><?php _e('Email Verification', 'mec-rsvp'); ?></label>
                        <div class="mec-col-6">
                            <select class="mec-col-12" name="mec[rsvp][auto_verify]" id="mec_rsvp_auto_verify">
                                <option value="global" <?php if(isset($rsvp_options['auto_verify']) and 'global' == $rsvp_options['auto_verify']) echo 'selected="selected"'; ?>><?php _e('Inherit from global options', 'mec-rsvp'); ?></option>
                                <option value="0" <?php if(isset($rsvp_options['auto_verify']) and '0' == $rsvp_options['auto_verify']) echo 'selected="selected"'; ?>><?php _e('Disabled', 'mec-rsvp'); ?></option>
                                <option value="1" <?php if(isset($rsvp_options['auto_verify']) and '1' == $rsvp_options['auto_verify']) echo 'selected="selected"'; ?>><?php _e('Enabled', 'mec-rsvp'); ?></option>
                            </select>
                        </div>
                    </div>
                    <div class="mec-form-row">
                        <label class="mec-col-6" for="mec_rsvp_auto_confirm"><?php _e('RSVP Confirmation', 'mec-rsvp'); ?></label>
                        <div class="mec-col-6">
                            <select class="mec-col-12" name="mec[rsvp][auto_confirm]" id="mec_rsvp_auto_confirm">
                                <option value="global" <?php if(isset($rsvp_options['auto_confirm']) and 'global' == $rsvp_options['auto_confirm']) echo 'selected="selected"'; ?>><?php _e('Inherit from global options', 'mec-rsvp'); ?></option>
                                <option value="0" <?php if(isset($rsvp_options['auto_confirm']) and '0' == $rsvp_options['auto_confirm']) echo 'selected="selected"'; ?>><?php _e('Disabled', 'mec-rsvp'); ?></option>
                                <option value="1" <?php if(isset($rsvp_options['auto_confirm']) and '1' == $rsvp_options['auto_confirm']) echo 'selected="selected"'; ?>><?php _e('Enabled', 'mec-rsvp'); ?></option>
                            </select>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
            </div>

            <?php if(!$FES or ($FES and (!isset($settings['fes_section_rsvp_tubl']) or (isset($settings['fes_section_rsvp_tubl']) and $settings['fes_section_rsvp_tubl'])))): ?>
            <div class="mec-meta-box-fields mec-rsvp-tab-content" id="mec_meta_box_rsvp_options_form_2">
                <h4 class="mec-title"><label for="mec_rsvp_limit"><?php _e('Total attendees in each RSVP limit', 'mec-rsvp'); ?></label></h4>
                <div class="mec-form-row">
                    <?php
                        $global_total_attendees_in_each_limit = Settings::getInstance()->get_settings('rsvp_total_attendees_in_each_rsvp_limit');
                        $total_attendees_in_each_rsvp_limit_unlimited = isset($rsvp_options['rsvp_total_attendees_in_each_rsvp_limit_unlimited']) ? (bool)$rsvp_options['rsvp_total_attendees_in_each_rsvp_limit_unlimited'] : empty($global_total_attendees_in_each_limit);
                        $total_attendees_in_each_limit = (isset($rsvp_options['rsvp_total_attendees_in_each_rsvp_limit']) and trim($rsvp_options['rsvp_total_attendees_in_each_rsvp_limit']) != '') ? $rsvp_options['rsvp_total_attendees_in_each_rsvp_limit'] : $global_total_attendees_in_each_limit;
                    ?>
                    <label class="mec-col-6 label-checkbox" onchange="jQuery('#mec_rsvp_total_attendees_in_each_rsvp_limit').toggle()" for="mec_rsvp_total_attendees_in_each_rsvp_limit_unlimited" id="mec_rsvp_total_attendees_in_each_rsvp_limit_unlimited_label">
                        <input type="hidden" name="mec[rsvp][rsvp_total_attendees_in_each_rsvp_limit_unlimited]" value="0"/>
                        <input id="mec_rsvp_total_attendees_in_each_rsvp_limit_unlimited"
                            <?php
                            if ($total_attendees_in_each_rsvp_limit_unlimited == 1) {
                                echo 'checked="checked"';
                            }
                            ?>
                            type="checkbox" value="1" name="mec[rsvp][rsvp_total_attendees_in_each_rsvp_limit_unlimited]"/>
                        <?php _e('Unlimited', 'mec-rsvp'); ?>
                        <span class="mec-tooltip">
                            <div class="box">
                                <h5 class="title"><?php _e('Total attendees in each RSVP limit', 'mec-rsvp'); ?></h5>
                                <div class="content">
                                    <p>
                                        <?php esc_attr_e('If you want to set a limit on total attendees in each RSVP, uncheck this checkbox and put a limitation number.', 'mec-rsvp'); ?>
                                    </p>
                                </div>
                            </div>
                            <i title="" class="dashicons-before dashicons-editor-help"></i>
                        </span>
                    </label>
                    <input class="mec-col-6 <?php echo ($total_attendees_in_each_rsvp_limit_unlimited == 1) ? 'mec-util-hidden' : ''; ?>" type="text" name="mec[rsvp][rsvp_total_attendees_in_each_rsvp_limit]" id="mec_rsvp_total_attendees_in_each_rsvp_limit"
                        value="<?php echo esc_attr($total_attendees_in_each_limit); ?>" placeholder="<?php echo $global_total_attendees_in_each_limit; ?>"/>
                </div>

                <h4 class="mec-title"><label><?php _e('RSVP Limit By Email', 'mec-rsvp'); ?></label></h4>
                <div class="mec-form-row">
                    <?php
                        $global_rsvp_limit_by_email = Settings::getInstance()->get_settings('rsvp_limit_by_email');
                        $rsvp_limit_by_email_global = isset($rsvp_options['rsvp_limit_by_email_global']) ? (bool)$rsvp_options['rsvp_limit_by_email_global'] : true;
                        $rsvp_limit_by_email = ( isset( $rsvp_options['rsvp_limit_by_email'] ) and trim( $rsvp_options['rsvp_limit_by_email'] ) != '' ) ? $rsvp_options['rsvp_limit_by_email'] : '';
                    ?>
                    <label class="mec-col-6 label-checkbox" for="mec_settings_rsvp_limit_by_email" id="mec_settings_rsvp_limit_by_email_label">
                        <input type="hidden" name="mec[rsvp][rsvp_limit_by_email_global]" value="0"/>
                        <input id="mec_settings_rsvp_limit_by_email" <?php checked(true,$rsvp_limit_by_email_global) ?> type="checkbox" value="1" name="mec[rsvp][rsvp_limit_by_email_global]" onchange="jQuery(this).parent().parent().find('input[type=number]').toggle();"/>
                        <?php _e('Inherit from global options', 'mec-rsvp'); ?>
                        <span class="mec-tooltip">
                            <div class="box left">
                                <h5 class="title"><?php _e( 'RSVP Limit By Email', 'mec-rsvp' ); ?></h5>
                                <div class="content"><p><?php esc_html_e( "Total number of RSVP recorded with one email per event.", 'mec-rsvp' ); ?></p></div>
                            </div>
                            <i title="" class="dashicons-before dashicons-editor-help"></i>
                        </span>
                    </label>
                    <div class="mec-col-6">
                        <input type="number" id="mec_settings_rsvp_limit_by_email" name="mec[rsvp][rsvp_limit_by_email]" value="<?php echo $rsvp_limit_by_email; ?>" placeholder="<?php echo $global_rsvp_limit_by_email; ?>" <?php echo $rsvp_limit_by_email_global ? 'style="display: none;"' : ''; ?>/>
                    </div>
                </div>
                <h4 class="mec-title"><label for="mec_rsvps_user_limit"><?php _e('Total User RSVP Limit By IP', 'mec-rsvp'); ?></label></h4>
                <div class="mec-form-row">
                    <label class="mec-col-6 label-checkbox" for="mec_rsvps_user_limit_unlimited" id="mec_rsvps_user_limit_unlimited_label">
                        <input type="hidden" name="mec[rsvp][rsvps_user_limit_unlimited]" value="0"/>
                        <input id="mec_rsvps_user_limit_unlimited"
                            <?php
                            if ($rsvps_user_limit_unlimited == 1) {
                                echo 'checked="checked"';
                            }
                            ?>
                                type="checkbox" value="1" name="mec[rsvp][rsvps_user_limit_unlimited]" onchange="jQuery(this).parent().parent().find('input[type=text]').toggle();"/>
                        <?php _e('Inherit from global options', 'mec-rsvp'); ?>
                    </label>
                    <input class="mec-col-6" <?php echo ($rsvps_user_limit_unlimited == 1) ? 'style="display: none;"' : ''; ?> type="text" name="mec[rsvp][rsvps_user_limit]" id="mec_rsvps_user_limit"
                            value="<?php echo esc_attr($rsvps_user_limit); ?>" placeholder="<?php _e('12', 'mec-rsvp'); ?>"/>
                </div>
            </div>
            <?php endif; ?>
        </div>
        <?php
    }

    public function meta_box_attendees($post){
        $draft = (isset($post->post_status) and $post->post_status != 'auto-draft') ? false : true;
        if($draft) return;

        $limit = 100;
        $now = current_time('timestamp', 0);
        $_6months_ago = strtotime('-6 Months', $now);

        $occ = new \MEC_feature_occurrences();
        $occurrences = $occ->get_dates($post->ID, $now, $limit);

        $date_format = get_option('date_format');
        $time_format = get_option('time_format');
        $datetime_format = $date_format.' '.$time_format;

        do_action('mec_events_meta_box_attendees_start', $post);
        ?>
        <div class="mec-meta-box-fields mec-rsvp-tab-content" id="mec_meta_box_rsvp_options_form_attendees">
            <h4 class="mec-meta-box-header"><?php _e('Attendees', 'mec-rsvp'); ?></h4>
            <div class="mec-rsvp-attendees-wrapper mec-attendees-wrapper">
                <div>
                    <select id="mec_rsvp_att_occurrences_dropdown" title="<?php esc_attr_e('Occurrence', 'mec-rsvp'); ?>">
                        <option class="mec-load-occurrences" value="<?php echo $_6months_ago.':'.$_6months_ago; ?>"><?php esc_html_e('Previous Occurrences', 'mec-rsvp'); ?></option>
                        <?php $i = 1; foreach($occurrences as $occurrence): ?>
                        <option value="<?php echo $occurrence->tstart.':'.$occurrence->tend; ?>" <?php echo ($i === 1 ? 'selected="selected"' : ''); ?>><?php echo (date_i18n($datetime_format, $occurrence->tstart)); ?></option>
                        <?php $i++; endforeach; ?>
                        <?php if(count($occurrences) >= $limit and isset($occurrence)): ?>
                        <option class="mec-load-occurrences" value="<?php echo $occurrence->tstart.':'.$occurrence->tend; ?>"><?php esc_html_e('Next Occurrences', 'mec-rsvp'); ?></option>
                        <?php endif; ?>
                    </select>
                </div>
                <div class="mec-attendees-list attendees">
                </div>
            </div>
        </div>
        <script>
        jQuery(document).ready(function()
        {
            mec_rsvp_attendees_trigger_load_dates();
            setTimeout(function()
            {
                jQuery('#mec_rsvp_att_occurrences_dropdown').trigger('change');
            }, 500);
        });

        function mec_rsvp_attendees_trigger_load_dates()
        {
            jQuery('#mec_rsvp_att_occurrences_dropdown').off('change').on('change', function(){
                var $dropdown = jQuery(this);
                var value = $dropdown.val();
                var $attendees = jQuery('.mec-rsvp-attendees-wrapper .mec-attendees-list');

                // Load Dates
                if($dropdown.find(jQuery('option[value="'+value+'"]')).hasClass('mec-load-occurrences')){
                    // Disable the Form
                    $dropdown.attr('disabled', 'disabled');

                    jQuery.ajax({
                        url: "<?php echo admin_url('admin-ajax.php', NULL); ?>",
                        type: "POST",
                        data: "action=mec_occurrences_dropdown&id=<?php echo $post->ID; ?>&_wpnonce=<?php echo wp_create_nonce('mec_occurrences_dropdown'); ?>&date="+value,
                        dataType: "json"
                    })
                    .done(function(response)
                    {
                        if(response.success) $dropdown.html(response.html);

                        // New Trigger
                        mec_rsvp_attendees_trigger_load_dates();

                        setTimeout(function()
                        {
                            jQuery('#mec_rsvp_att_occurrences_dropdown').trigger('change');
                        }, 500);

                        // Enable the Form
                        $dropdown.removeAttr('disabled');
                    });
                }
                // Load Attendees
                else
                {
                    // Disable the Form
                    $dropdown.attr('disabled', 'disabled');

                    jQuery.ajax(
                    {
                        url: "<?php echo admin_url('admin-ajax.php', NULL); ?>",
                        type: "POST",
                        data: "action=mec_event_rsvps&id=<?php echo $post->ID; ?>&occurrence="+value+"&backend=<?php echo (is_admin() ? 1 : 0); ?>",
                        dataType: "json"
                    })
                    .done(function(response)
                    {
                        if(response.html) $attendees.html(response.html);

                        // Enable the Form
                        $dropdown.removeAttr('disabled');
                    });
                }
            });
        }
        </script>
        <?php
        do_action('mec_events_meta_box_attendees_end', $post);
    }

    public function meta_box_rsvp_forms($post){

        $event_id = $post->ID;
        $form_types = SettingsPage::getInstance()->get_form_types();
        $settings = get_post_meta($event_id,'mec_rsvp',true);

        $global_inheritance = get_post_meta($event_id, 'mec_rsvp_form_fields_global_inheritance', true);
        if(trim($global_inheritance) == ''){

            $global_inheritance = 1;
        }

        $forms_options = get_post_meta( $event_id, 'mec_rsvp_forms_options', true );

        foreach ( $form_types as $group_id => $title ):
            $group_id = 'rsvp_'.$group_id;
            ?>
            <div id="mec-reg-fields-<?php echo $group_id ?>" class="mec-meta-box-fields mec-rsvp-tab-content mec-options-fields">

                <h4 class="mec-form-subtitle"><?php echo esc_html( $title ); ?></h4>

                <?php
                if ( 'rsvp_general' !== $group_id ):
                    $status_key = 'form_'.$group_id.'_status';
                    $status = isset($forms_options[$status_key]) ? $forms_options[$status_key] : '';
                    $status = !empty($status) ? $status : 'default';
                    ?>
                    <div class="mec-form-status-box mec-form-row" style="margin: 10px 0;">
                        <label style="margin-right:17px;">
                            <input style="margin-right:1px;" class="mec-form-status" type="radio" name="mec[rsvp_forms_status][<?php echo $status_key ?>]" <?php checked($status,'default') ?> value="default" />
                            <?php esc_html_e( 'Inherit from Main RSVP Form', 'mec-rsvp' ) ?>
                        </label>
                        <label style="margin-right:17px;">
                            <input style="margin-right:1px;" class="mec-form-status" type="radio" name="mec[rsvp_forms_status][<?php echo $status_key ?>]" <?php checked($status,'enable') ?> value="enable" />
                            <?php esc_html_e( 'Enable Custom Form', 'mec-rsvp' ) ?>
                        </label>
                    </div>
                <?php else: ?>
                    <div class="mec-form-row">
                        <label class="label-checkbox">
                            <input type="hidden" name="mec[rsvp_form_fields_global_inheritance]" value="0"/>
                            <input value="1" type="checkbox"
                                name="mec[rsvp_form_fields_global_inheritance]" class="rsvp_form_fields_global_inheritance"
                                <?php
                                if ($global_inheritance) {
                                    echo 'checked="checked"';
                                }
                                ?>
                            /> <?php _e('Inherit from global options', 'mec-rsvp'); ?>
                        </label>
                    </div>
                <?php endif; ?>

                <div class="mec-rsvp-fields mec-rsvp-forms">
                    <div class="mec-rsvp-per-attendee-fields">
                        <h5 class="mec-form-subtitle"><?php _e( 'Per Attendee Fields', 'mec-rsvp' ); ?></h5>
                        <?php
                        $form_key = $group_id .'_reg_fields';
                        $fields = isset($forms_options[$form_key]) ? $forms_options[$form_key] : null;
                        \MEC\Forms\SettingsForm::getInstance()->display_settings_form_fields( $group_id, $fields )
                        ?>
                    </div>
                    <div class="mec-rsvp-fixed-fields">
                        <h5 class="mec-form-subtitle"><?php _e( 'Fixed Fields', 'mec-rsvp' ); ?></h5>
                        <?php
                        $form_key = $group_id .'_bfixed_fields';
                        $fields = isset($forms_options[$form_key]) ? $forms_options[$form_key] : null;
                        \MEC\Forms\SettingsForm::getInstance()->display_settings_form_fixed_fields( $group_id, $fields );
                        ?>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
        <script>
            jQuery(document).ready(function ($) {
                function mec_custom_form_status(status_element) {
                    var status = $(status_element).val();
                    var form = $(status_element).parents('.mec-options-fields');
                    switch (status) {
                        case 'enable':
                            $(form).find('.mec-rsvp-fields').css('display','block');
                            break;
                        case 'default':
                        default:
                            $(form).find('.mec-rsvp-fields').css('display','none');
                            break;
                    }
                }



                $('.mec-form-status').on('change',function (e) {
                    mec_custom_form_status(e.currentTarget);
                });

                $.each($('.mec-form-status:checked'),function(i,v){
                    mec_custom_form_status($(v));
                });

            });
        </script>
        <?php
    }
}