<?php


namespace MEC_RSVP\RSVP;

use MEC\Attendees\Attendees;
use MEC\Settings\Settings;
use MEC\Singleton;

class EventRSVP extends Singleton {

	public function get_rsvp_options($event_id){

		$rsvp_options = get_post_meta($event_id, 'mec_rsvp', true);

		return is_array($rsvp_options) ? $rsvp_options : [];
	}

	public function get_event_answers($event_id, $event_date = null){

		global $wpdb;

		$total_count = "SELECT `post_id`,SUM(`count`) as `total_count` FROM `{$wpdb->prefix}mec_attendees` WHERE `event_id` = %1d && `occurrence` = %2s && `verification` = '1' && `confirmation` = '1' group by `event_id`,`post_id`";
		$total_count = $wpdb->prepare( $total_count, $event_id, $event_date );

		$answers_filtered_by_status = "SELECT `post_id`,`meta_value` as answer FROM `{$wpdb->postmeta}` WHERE (`meta_key` = 'mec_answer')";

		$sql = "SELECT tbl1.*,tbl2.answer FROM ({$total_count}) as tbl1 INNER JOIN ({$answers_filtered_by_status}) as tbl2 on tbl1.post_id = tbl2.post_id";

		return $wpdb->get_results($sql,ARRAY_A);
	}

	public function get_attendees($event_id, $event_date, $answer, $limit = 10, $offset = 0){

		global $wpdb;

		$total_count = "SELECT * FROM `{$wpdb->prefix}mec_attendees` WHERE `event_id` = %1d && `occurrence` = %2s && `verification` = '1' && `confirmation` = '1'";
		$total_count = $wpdb->prepare( $total_count, $event_id, $event_date );

		$compare_answer = '';
		if( 'all' !== $answer ){

			$compare_answer =  " && `meta_value` = '%s'";
		}
		$answers_filtered_by_status = "SELECT `post_id`,`meta_value` as answer FROM `{$wpdb->postmeta}` WHERE (`meta_key` = 'mec_answer' {$compare_answer})";

		if( 'all' !== $answer ){

			$answers_filtered_by_status = $wpdb->prepare( $answers_filtered_by_status, $answer );
		}

		$limit_offset = '';
		if( !empty( $limit ) ){

			$limit_offset .= " LIMIT {$limit}";
		}

		if( !empty( $offset ) ){

			$limit_offset .= " OFFSET {$offset}";
		}

		$sql = "SELECT tbl1.*,tbl2.answer FROM ({$total_count}) as tbl1 INNER JOIN ({$answers_filtered_by_status}) as tbl2 on tbl1.post_id = tbl2.post_id ORDER BY attendee_id {$limit_offset}";

		$rows = $wpdb->get_results( $sql, ARRAY_A );

		$attendees = [];
        if(!empty($rows) && is_array($rows)){

            foreach( $rows as $row ){

                $attendee_id = $row['attendee_id'];
                $data = maybe_serialize($row['data']);

                $attendee = [
                    'attendee_id' => $attendee_id,
                    'first_name' => $row['first_name'],
					'last_name' => $row['last_name'],
					'name' => $row['first_name'] .' '.$row['last_name'],
                    'email' => $row['email'],
                    'count' => $row['count'],
                    'data' => is_array($data) ? $data : [],
                ];

                $attendees[$attendee_id] = $attendee;
            }
        }

		return $attendees;
	}

	public function get_rsvp_reports( $event_id, $event_date = null ){

		$rows = $this->get_event_answers($event_id, $event_date);

		$rsvp_ids_group_by_answer = array();

		foreach($rows as $row){

			$rsvp_id = $row['post_id'];
			$answer = $row['answer'];
			$attendees_count = $row['total_count'];

			$rsvp_ids_group_by_answer[$answer][$rsvp_id] = $attendees_count;
		}

		return $rsvp_ids_group_by_answer;
	}

	public function get_rsvps_emails_for_event( $event_id, $event_date = null, $return_cache = true ){

		$cache_key = $event_id .'-'.$event_date;
		$group_id = 'mec-rsvp-emails-for-event';
		$transient = $group_id .'-'.$cache_key;

		$cache_data = get_transient( $transient );

		if($return_cache && !empty($cache_data)){

			return $cache_data;
		}

		$emails = Attendees::getInstance()->get_attendees_emails( null, $event_id, $event_date );

		set_transient( $transient, $emails, 0 );

		return $emails;
	}

	public function get_rsvps_by_event_id($event_id, $timestamp, $limit = '-1', $user_id = NULL){

		if(!$event_id){

			return array();
		}

        $rsvp_options = $this->get_rsvp_options($event_id);

        $rsvp_all_occurrences = isset($rsvp_options['rsvps_all_occurrences']) ? (int) $rsvp_options['rsvps_all_occurrences'] : 0;

		$q_args = array(
            'post_type'=> 'mec_rsvp',
            'posts_per_page'=> $limit,
            'post_status'=>array('future', 'publish'),
            'meta_query'=>array(
				'relation' => 'AND',
				array(
					'key'=>'mec_event_id',
					'value'=> $event_id,
					'compare' => '='
				),
                array(
                    'key' => 'mec_confirmed',
                    'value'=>1,
					'compare' => '='
                ),
                array(
                    'key' => 'mec_verified',
                    'value'=>1,
					'compare' => '='
				),
            )
		);

		if($user_id){

			$q_args['author'] = $user_id;
		}

		if(!$rsvp_all_occurrences){

			$q_args['meta_query']['mec_event_date'] = array(
				'key'=> 'mec_event_date',
				'value'=> is_numeric($timestamp) ? $timestamp : strtotime($timestamp),
				'compare' => '='
			);

        }else{

			$q_args['meta_query']['mec_event_date'] = array(
				'key'=> 'mec_event_date',
				'value'=> date('Y-m-d', $timestamp),
				'compare' => 'like'
			);
        }

        return get_posts($q_args);
    }

	public function get_auto_verification_status($event_id){

        $options = $this->get_rsvp_options($event_id);

        $event_auto_verify = (isset($options['auto_verify']) and trim($options['auto_verify']) != '') ? $options['auto_verify'] : 'global';
        if(is_numeric($event_auto_verify)) {
			$event_auto_verify = (int) $event_auto_verify;
		}

        if($event_auto_verify == 'global'){

            $auto_verify = Settings::getInstance()->get_settings('rsvp_auto_verify');
        } else {
            $auto_verify = $event_auto_verify;
        }

        return (bool)$auto_verify;
    }

    public function get_auto_confirmation_status($event_id){

        $options = $this->get_rsvp_options($event_id);

        $event_auto_confirm = (isset($options['auto_confirm']) and trim($options['auto_confirm']) != '') ? $options['auto_confirm'] : 'global';
        if(is_numeric($event_auto_confirm)) {
			$event_auto_confirm = (int) $event_auto_confirm;
		}

        if($event_auto_confirm == 'global'){

            $auto_confirm = Settings::getInstance()->get_settings('rsvp_auto_confirm');
        } else {
            $auto_confirm = $event_auto_confirm;
        }

        return (bool)$auto_confirm;
    }

	public function get_minimum_attendees_to_start_event($event_id,$occurrence_timestamp = null){

		$rsvp_min_attendees = Settings::getInstance()->get_settings('rsvp_min_attendees');

		$rsvp_options = $this->get_rsvp_options($event_id);

		$rsvp_min_attendees_global = isset($rsvp_options['rsvp_min_attendees_global']) ? (bool)$rsvp_options['rsvp_min_attendees_global'] : true;
		if(!$rsvp_min_attendees_global){

			$rsvp_min_attendees = isset($rsvp_options['rsvp_display_rsvp_report']) ? (int)$rsvp_options['rsvp_display_rsvp_report'] : false;
		}

		if(!is_null($occurrence_timestamp)){

			$rsvp_min_attendees_global = \MEC_feature_occurrences::param($event_id,$occurrence_timestamp,'rsvp_min_attendees_global');
			if(!is_null($rsvp_min_attendees_global) && !$rsvp_min_attendees_global){

				$rsvp_min_attendees = \MEC_feature_occurrences::param($event_id,$occurrence_timestamp,'rsvp_min_attendees');
			}
		}

		return $rsvp_min_attendees;
	}

	public function can_send_verify_email($event_id,$mode){

		$auto_verify = $this->get_auto_verification_status($event_id);
		$auto_verify_send_mail = Settings::getInstance()->get_settings('rsvp_auto_verify_send_email');
        if($mode == 'auto' && $auto_verify && !$auto_verify_send_mail){

            return false;
        }

		return true;
	}

	public function can_send_confirm_email($event_id,$mode){

		$auto_confirm = $this->get_auto_confirmation_status($event_id);
		$auto_confirm_send_mail = Settings::getInstance()->get_settings('rsvp_auto_confirm_send_email');
        if($mode == 'auto' && $auto_confirm && !$auto_confirm_send_mail){

            return false;
        }

		return true;
	}

	public function can_display_attendees_list( $answer_id, $event_id ){

		$can = true;
		$display_attendees_list = Settings::getInstance()->get_settings('rsvp_attendees_list');

		$rsvp_options = $this->get_rsvp_options($event_id);
		if( isset($rsvp_options['rsvp_attendees_list']) && !in_array('global',$rsvp_options['rsvp_attendees_list']) ){

			$display_attendees_list = $rsvp_options['rsvp_attendees_list'];
		}

		if(!in_array($answer_id, (array)$display_attendees_list)){

			$can = false;
		}

		return $can;
	}

	public function get_rsvp_status($event_id){

		$status = (bool)Settings::getInstance()->get_settings('rsvp_status');
		if(!$status){

			return false;
		}

		$event_rsvp_status = (bool)get_post_meta($event_id,'mec_rsvp_status',true);
		if(!$event_rsvp_status){

			return false;
		}

		return true;
	}

	public function get_total_attendees_in_each_rsvp_limit( $event_id, $event_date ){

		$limit = Settings::getInstance()->get_settings('rsvp_total_attendees_in_each_rsvp_limit');
		$rsvp_options = $this->get_rsvp_options($event_id);

		$unlimited = isset($rsvp_options['rsvp_total_attendees_in_each_rsvp_limit_unlimited']) ? (bool)$rsvp_options['rsvp_total_attendees_in_each_rsvp_limit_unlimited'] : true;
		if(!$unlimited){

			$limit = isset($rsvp_options['rsvp_total_attendees_in_each_rsvp_limit']) && !empty($rsvp_options['rsvp_total_attendees_in_each_rsvp_limit']) ? (int)$rsvp_options['rsvp_total_attendees_in_each_rsvp_limit'] : $limit;
		}else{

			$limit = '';//unlimited
		}

		return $limit;
	}

	public function get_total_rsvp_limit( $event_id, $event_date ){

		$limit = false;
		$rsvp_options = $this->get_rsvp_options($event_id);

		$unlimited = isset($rsvp_options['rsvp_limit_unlimited']) ? (bool)$rsvp_options['rsvp_limit_unlimited'] : true;
		if(!$unlimited){

			$limit = isset($rsvp_options['rsvp_limit']) && !empty($rsvp_options['rsvp_limit']) ? (int)$rsvp_options['rsvp_limit'] : 100;
		}else{

			$limit = '';//unlimited
		}

		return $limit;
	}

	public function get_total_rsvp_limit_by_ip( $event_id, $event_date ){

		$limit = Settings::getInstance()->get_settings('rsvp_limit');
		$rsvp_options = $this->get_rsvp_options($event_id);

		$unlimited = isset($rsvp_options['rsvps_user_limit_unlimited']) ? (bool)$rsvp_options['rsvps_user_limit_unlimited'] : true;
		if(!$unlimited){

			$limit = isset($rsvp_options['rsvps_user_limit']) && !empty($rsvp_options['rsvps_user_limit']) ? (int)$rsvp_options['rsvps_user_limit'] : 12;
		}else{

			$limit = '';//unlimited
		}

		return $limit;
	}

	public function get_rsvp_limit_by_email( $event_id, $event_date = null ){

		$limit = Settings::getInstance()->get_settings('rsvp_limit_by_email');

		$rsvp_options = $this->get_rsvp_options($event_id);
		$event_limit_global = isset($rsvp_options['rsvp_limit_by_email_global']) ? (bool)$rsvp_options['rsvp_limit_by_email_global'] : true;
		if(!$event_limit_global){

			$limit = isset($rsvp_options['rsvp_limit_by_email']) && !empty($rsvp_options['rsvp_limit_by_email']) ? (int)$rsvp_options['rsvp_limit_by_email'] : $limit;
		}

		return $limit;
	}

	/**
	 * @param int $event_id
	 * @param int $event_date
	 * @return int|string unlimited
	 */
	public function get_max_attendees_to_create_a_rsvp( $event_id, $event_date ){

		$total_attendees = $this->get_total_attendees( $event_id, $event_date );
		$total_attendees_limit = $this->get_total_rsvp_limit( $event_id, $event_date );
		$total_attendees_limit = !empty($total_attendees_limit) ? (int) $total_attendees_limit : null;
		$max_attendees_in_each_rsvp = $this->get_total_attendees_in_each_rsvp_limit( $event_id, $event_date );
		$max_attendees_in_each_rsvp = !empty($max_attendees_in_each_rsvp) ? (int) $max_attendees_in_each_rsvp : null;

		if( !is_null( $total_attendees_limit ) ){

			$max_allowed = $total_attendees_limit - $total_attendees;
			$max_allowed = $max_allowed > 0 ? $max_allowed : 0;

			if(!$max_allowed){

				return 0;
			}else{

				return (is_null($max_attendees_in_each_rsvp) || $max_allowed < $max_attendees_in_each_rsvp) ? (int) $max_allowed : (int) $max_attendees_in_each_rsvp;
			}
		}

		return !is_null($max_attendees_in_each_rsvp) ? $max_attendees_in_each_rsvp : 'unlimited';
	}

	/**
	 * @param int $event_id
	 * @param int $event_date
	 * @param string $email
	 * @param int $email_attendee_count
	 * @param array|int $exclude_rsvp_ids
	 *
	 * @return boolean
	 */
	public function is_allowed_email_for_create_rsvp($event_id, $event_date, $email, $email_attendee_count = 1, $exclude_rsvp_ids = []){

		if(empty($email)){

			return new \WP_Error( 'empty-email', __('Email not entered','mec-rsvp') );
		}

		$limit_by_email = $this->get_rsvp_limit_by_email($event_id,$event_date);
		$total_used = Attendees::getInstance()->get_total_attendees_group_by_email( $email, null, $event_id, $event_date, $exclude_rsvp_ids );

		if( $limit_by_email && $limit_by_email < ($total_used + $email_attendee_count) ){

			$message = sprintf(
				__('You can use the email %1s to participate in %2s RSVPs, So far you have participated in %3s RSVP','mec-rsvp'),
				$email,
				$limit_by_email,
				$total_used
			);

			return new \WP_Error( 'error-email-limit', $message );
		}

		return true;
	}

	public function get_total_attendees( $event_id, $event_date, $exclude_rsvp_id = 0 ){

		$total_used_group_by_email = Attendees::getInstance()->get_total_attendees_group_by_email( null, null, $event_id, $event_date,$exclude_rsvp_id);

		return array_sum($total_used_group_by_email);
	}

	public function user_can_create_rsvp( $event_id, $event_date, $attendees ){

		$can = true;
		if( empty($email) || !is_email($email) ){

			return false;
		}



		$can = $can && $this->is_allowed_email_for_create_rsvp( $event_id, $event_date, $email );


		return true;
	}

	public function get_show_rsvp_form_interval($event_id){

		$interval = Settings::getInstance()->get_settings('show_rsvp_form_interval');

		$rsvp_options = $this->get_rsvp_options($event_id);

		$event_interval_global = isset($rsvp_options['show_rsvp_form_interval_global']) ? (bool)$rsvp_options['show_rsvp_form_interval_global'] : true;
		if(!$event_interval_global){

			$interval = isset($rsvp_options['show_rsvp_form_interval']) ? (int)$rsvp_options['show_rsvp_form_interval'] : $interval;
		}

		return $interval;
	}

	public function can_display_rsvp_form($event_id){

		$rsvp_status = $this->get_rsvp_status($event_id);
		if(!$rsvp_status){

			return false;
		}

		$can = true;
		$display_only_for_logged_in_users = (bool)Settings::getInstance()->get_settings('rsvp_display_form_only_for_logged_in_users');


		$rsvp_options = $this->get_rsvp_options($event_id);

		$event_rsvp_display_form_only_for_logged_in_users = isset($rsvp_options['rsvp_display_form_only_for_logged_in_users']) ? $rsvp_options['rsvp_display_form_only_for_logged_in_users'] : 'global';

		if('global' !== $event_rsvp_display_form_only_for_logged_in_users){

			$display_only_for_logged_in_users = $event_rsvp_display_form_only_for_logged_in_users;
		}

		if($display_only_for_logged_in_users && !is_user_logged_in()){

			$can = new \WP_Error('not-logged-in', __('You are not logged in','mec-rsvp'));
		}

		return $can;
	}

	public function can_display_rsvp_report_in_rsvp_form($event_id){

		$can = true;
		$rsvp_display_rsvp_report = (bool)Settings::getInstance()->get_settings('rsvp_display_rsvp_report');

		$rsvp_options = $this->get_rsvp_options($event_id);

		$event_rsvp_display_rsvp_report = isset($rsvp_options['rsvp_display_rsvp_report']) ? $rsvp_options['rsvp_display_rsvp_report'] : 'global';

		if('global' !== $event_rsvp_display_rsvp_report){

			$rsvp_display_rsvp_report = $event_rsvp_display_rsvp_report;
		}

		if(!$rsvp_display_rsvp_report){

			$can = false;
		}

		return $can;
	}

	public function can_display_rsvp_display_conversation($event_id){

		$can = true;
		$rsvp_display_conversation = (bool)Settings::getInstance()->get_settings('rsvp_display_conversation');

		$rsvp_options = $this->get_rsvp_options($event_id);

		$event_rsvp_display_conversation = isset($rsvp_options['rsvp_display_conversation']) ? $rsvp_options['rsvp_display_conversation'] : 'global';

		if('global' !== $event_rsvp_display_conversation){

			$rsvp_display_conversation = $event_rsvp_display_conversation;
		}

		if(!$rsvp_display_conversation){

			$can = false;
		}

		return $can;
	}

	public function can_display_rsvp_modification($event_id){

		$can = true;
		$rsvp_modification = (bool)Settings::getInstance()->get_settings('rsvp_display_rsvp_modification');

		$rsvp_options = $this->get_rsvp_options($event_id);

		$event_rsvp_modification = isset($rsvp_options['rsvp_display_rsvp_modification']) ? $rsvp_options['rsvp_display_rsvp_modification'] : 'global';

		if('global' !== $event_rsvp_modification){

			$rsvp_modification = $event_rsvp_modification;
		}

		if(!$rsvp_modification){

			$can = false;
		}

		return $can;
	}

	public function can_rsvp_modification_without_email_verification($event_id){

		$can = true;
		$rsvp_modification_without_email_verification = (bool)Settings::getInstance()->get_settings('rsvp_modification_without_email_verification');

		$rsvp_options = $this->get_rsvp_options($event_id);

		$event_rsvp_modification_without_email_verification = isset($rsvp_options['rsvp_modification_without_email_verification']) ? $rsvp_options['rsvp_modification_without_email_verification'] : 'global';

		if('global' !== $event_rsvp_modification_without_email_verification){

			$rsvp_modification_without_email_verification = $event_rsvp_modification_without_email_verification;
		}

		if(!$rsvp_modification_without_email_verification){

			$can = false;
		}

		return $can;
	}

	public function get_rsvp_modification_form_location($event_id){

		$location = Settings::getInstance()->get_settings('rsvp_display_rsvp_modification_location');

		$rsvp_options = $this->get_rsvp_options($event_id);

		$event_location = isset($rsvp_options['rsvp_display_rsvp_modification_location']) ? $rsvp_options['rsvp_display_rsvp_modification_location'] : 'global';

		if('global' !== $event_location){

			$location = $event_location;
		}

		return $location;
	}

}