<?php

namespace MEC_RSVP\RSVP;

use MEC\Singleton;
use MEC_RSVP\User;
use MEC\Forms\CustomForm;


class ImportExport extends Singleton {

    public function init() {

        add_action('admin_init', [$this, 'admin_init']);

        add_action('mec_import_export_page', [__CLASS__, 'rsvp_export_page']);
        add_action('mec_import_export_page', [__CLASS__, 'rsvp_import_page']);
    }

    public function admin_init() {

        $ix_action = isset($_REQUEST['mec-ix-action']) ? sanitize_text_field( $_REQUEST['mec-ix-action'] ) : '';
        if ( $ix_action && 'export-rsvps' === $ix_action ) {

            $format = isset($_REQUEST['format']) ? sanitize_text_field($_REQUEST['format']) : 'csv';
            $this->export_rsvps(null, $format);
        }

        if( $ix_action && 'import-start-rsvps' === $ix_action ){

            global $MEC_Import_Result;
            $MEC_Import_Result = $this->import_rsvps_from_csv();
        }
    }

    public function export_rsvps($object_ids = null, $format = 'csv') {

        switch ($format) {
            case 'ms-excel':

                header('Content-Type: application/vnd.ms-excel; charset=utf-8');
                header('Content-Disposition: attachment; filename=rsvps-' . md5(time() . mt_rand(100, 999)) . '.xls');

                $this->export_as_csv_or_excel($object_ids);

                exit;
                break;

            case 'csv':

                header('Content-Type: text/csv; charset=utf-8');
                header('Content-Disposition: attachment; filename=rsvps-' . md5(time() . mt_rand(100, 999)) . '.csv');

                $this->export_as_csv_or_excel($object_ids);

                exit;
                break;
        }
    }

    private function get_all_events_form_fields( $event_ids ){

        $types = array(
            // 'general',
            'yes',
            'no',
            'maybe',
        );

        foreach( $event_ids as $event_id ) {
            foreach( $types as $form_type ) {

                $group_id = "rsvp_{$form_type}";
                $fixed_fields = CustomForm::getInstance()->get_fixed_fields($group_id, $event_id);
                $reg_fields = CustomForm::getInstance()->get_reg_fields($group_id, $event_id);

                foreach ($fixed_fields as $fixed_field_id => $fixed_field) {

                    if (in_array($fixed_field_id, [':i:', ':fi:', '_i_', '_fi_',], true)) {
                        unset( $fixed_fields[ $fixed_field_id ] );
                        continue;
                    }

                    $type = isset($fixed_field['type']) ? $fixed_field['type'] : '';
                    $label = isset($fixed_field['label']) ? __($fixed_field['label'], 'mec-rsvp') : '';

                    if ($type == 'agreement') $label = sprintf($label, get_the_title($fixed_field['page']));
                    if (trim($label) == '') {
                        unset( $fixed_fields[ $fixed_field_id ] );
                        continue;
                    }

                    $fixed_fields[ $fixed_field_id ] = stripslashes($label);
                    $columns[ stripslashes($label) ][ $event_id ][ $form_type ] = array(
                        'key' => $fixed_field_id,
                        'group' => 'fixed'
                    );
                }

                foreach ($reg_fields as $fixed_field_id => $reg_field) {
                    // Placeholder Keys
                    if (in_array($fixed_field_id, [':i:', ':fi:', '_i_', '_fi_',], true)) {
                        unset( $reg_fields[ $fixed_field_id ] );
                        continue;
                    }

                    $type = isset($reg_field['type']) ? $reg_field['type'] : '';
                    $label = isset($reg_field['label']) ? __($reg_field['label'], 'mec-rsvp') : '';

                    if (trim($label) == '' or in_array($type,['last_name','first_name','mec_email'],false)){
                        unset( $reg_fields[ $fixed_field_id ] );
                        continue;
                    }
                    if ($type == 'agreement') $label = sprintf($label, get_the_title($reg_field['page']));

                    $reg_fields[ $fixed_field_id ] = stripslashes($label);
                    $columns[ stripslashes($label) ][ $event_id ][ $form_type ] = array(
                        'key' => $fixed_field_id,
                        'group' => 'reg'
                    );
                }

                $event_forms[ $event_id ][$form_type]['fixed'] = $fixed_fields;
                $event_forms[ $event_id ][$form_type]['reg'] = $reg_fields;
            }
        }

        return array(
            'columns' => $columns,
            'forms' => $event_forms,
        );
    }

    private function get_columns( $fixed_fields = null, $reg_fields = null , $main_event_id = 0 ){

        //Custom Fields start
        if(is_null($fixed_fields)){

            $group_id = 'rsvp_general';
            $fixed_fields = CustomForm::getInstance()->get_fixed_fields($group_id, $main_event_id);
        }

        if(is_null($reg_fields)){

            $group_id = 'rsvp_general';
            $reg_fields = CustomForm::getInstance()->get_reg_fields($group_id, $main_event_id);
        }
        //Custom Fields end

        $columns = array(
            __('ID', 'mec-rsvp'),
            __('Event', 'mec-rsvp'),
            __('Start Date & Time', 'mec-rsvp'),
            __('End Date & Time', 'mec-rsvp'),
            __('Order Time', 'mec-rsvp'),
            __('First Name', 'mec-rsvp'),
            __('Last Name', 'mec-rsvp'),
            __('Email', 'mec-rsvp'),
            __('Attendees Count', 'mec-rsvp'),
            __('Confirmation', 'mec-rsvp'),
            __('Verification', 'mec-rsvp'),
            __('Response', 'mec-rsvp'),
            __('Type of creation', 'mec-rsvp'),
        );
        $columns = apply_filters('mec_rsvp_csv_export_columns', $columns);


        foreach ($fixed_fields as $fixed_field_id => $fixed_field) {

            if (in_array($fixed_field_id, [':i:', ':fi:', '_i_', '_fi_',], true)) {

                continue;
            }

            $type = isset($fixed_field['type']) ? $fixed_field['type'] : '';
            $label = isset($fixed_field['label']) ? __($fixed_field['label'], 'mec-rsvp') : '';

            if ($type == 'agreement') $label = sprintf($label, get_the_title($fixed_field['page']));
            if (trim($label) == '') continue;

            $columns[] = stripslashes($label);
        }

        foreach ($reg_fields as $fixed_field_id => $reg_field) {
            // Placeholder Keys
            if (in_array($fixed_field_id, [':i:', ':fi:', '_i_', '_fi_',], true)) {

                continue;
            }

            $type = isset($reg_field['type']) ? $reg_field['type'] : '';
            $label = isset($reg_field['label']) ? __($reg_field['label'], 'mec-rsvp') : '';

            if (trim($label) == '' or in_array($type,['last_name','first_name','mec_email'],false)) continue;
            if ($type == 'agreement') $label = sprintf($label, get_the_title($reg_field['page']));

            $columns[] = stripslashes($label);
        }

        $columns[] = 'Attachments';

        return $columns;
    }

    public function export_as_csv_or_excel($post_ids = null) {

        if (!$post_ids) {
            $post_ids = (isset($_REQUEST['post']) and is_array($_REQUEST['post'])) ? $_REQUEST['post'] : array();
        }

        if (empty($post_ids) || !is_array($post_ids)) {

            $post_ids = RSVPsQuery::getInstance()->get_rsvps_ids([]);
        }

        $event_ids = array();
        foreach ($post_ids as $post_id) {

            $event_ids[] = get_post_meta($post_id, 'mec_event_id', true);
        }
        $event_ids = array_unique($event_ids);

        $events_form_fields = $this->get_all_events_form_fields( $event_ids );
        $events_forms = $events_form_fields['forms'] ?? array();
        $events_columns = $events_form_fields['columns'] ?? array();

        //Custom Fields end

        $columns = array(
            __('ID', 'mec-rsvp'),
            __('Event', 'mec-rsvp'),
            __('Start Date & Time', 'mec-rsvp'),
            __('End Date & Time', 'mec-rsvp'),
            __('Order Time', 'mec-rsvp'),
            __('First Name', 'mec-rsvp'),
            __('Last Name', 'mec-rsvp'),
            __('Email', 'mec-rsvp'),
            __('Attendees Count', 'mec-rsvp'),
            __('Confirmation', 'mec-rsvp'),
            __('Verification', 'mec-rsvp'),
            __('Response', 'mec-rsvp'),
            __('Type of creation', 'mec-rsvp'),
        );

        $columns = array_merge(
            $columns,
            array_keys( $events_columns )
        );

        $columns[] = 'Attachments';

        $columns = apply_filters('mec_rsvp_csv_export_columns', $columns);

        $output = fopen('php://output', 'w');
        fprintf($output, chr(0xEF) . chr(0xBB) . chr(0xBF));
        fputcsv($output, $columns);

        // Date & Time Format
        $datetime_format = get_option('date_format') . ' ' . get_option('time_format');

        // MEC User
        $u = User::instance();

        foreach ($post_ids as $post_id) {

            $post_id = (int) $post_id;
            $rsvp = new RSVP($post_id);
            $event_id = $rsvp->get_event_id();
            $order_time = $rsvp->get_create_datetime();
            $timestamps = $rsvp->get_event_times();
            $rsvp_answer = $rsvp->get_meta( 'mec_answer' );
            $timestamps = explode(':', $timestamps);
            $v_fixed_fields = $rsvp->get_fixed_fields();

            $attendees = $rsvp->get_attendees();

            $rsvp_creator = $u->rsvp($post_id);

            $confirmed = \MEC\Base::get_main()->get_confirmation_label(get_post_meta($post_id, 'mec_confirmed', true));
            $verified = \MEC\Base::get_main()->get_verification_label(get_post_meta($post_id, 'mec_verified', true));

            $attachments = '';
            if (isset($attendees['attachments'])) {

                foreach ($attendees['attachments'] as $attachment) {

                    $attachments .= @$attachment['url'] . "\n";
                }
            }

            $rsvps = array();
            $counter = 0;
            foreach ($attendees as $key => $attendee) {

                if ($key === 'attachments') continue;
                if (isset($attendee[0]['MEC_TYPE_OF_DATA'])) continue;

                $start_datetime = isset($timestamps[0]) && $timestamps[0] ? date($datetime_format, $timestamps[0]) : '';
                $end_datetime = isset($timestamps[1]) && $timestamps[1] ? date($datetime_format, $timestamps[1]) : '';
                $rsvp_data = array(
                    $post_id,
                    html_entity_decode(get_the_title($event_id), ENT_QUOTES | ENT_HTML5),
                    $start_datetime,
                    $end_datetime,
                    date($datetime_format, strtotime($order_time)),
                    (isset($attendee['first_name']) ? $attendee['first_name'] : (isset($rsvp_creator->first_name) ? trim($rsvp_creator->first_name) : '')),
                    (isset($attendee['last_name']) ? $attendee['last_name'] : (isset($rsvp_creator->last_name) ? trim($rsvp_creator->last_name) : '')),
                    (isset($attendee['email']) ? $attendee['email'] : @$rsvp_creator->user_email),
                    (isset($attendee['count']) ? $attendee['count'] : 1),
                    $confirmed,
                    $verified,
                    $rsvp->get_answer_text(),
                    $rsvp->get_creation_type_text(),
                );

                $rsvp_data = apply_filters('mec_csv_export_rsvp', $rsvp_data, $post_id, $event_id);

                $reg_form = isset($attendee['reg']) ? $attendee['reg'] : array();

                foreach( $events_columns as $column_label => $column_data ) {
                    $v_key = $events_columns[ $column_label ][ $event_id ][ $rsvp_answer ]['key'] ?? null;
                    $v_group = $events_columns[ $column_label ][ $event_id ][ $rsvp_answer ]['group'] ?? null;
                    $value = '';
                    if( 'reg' == $v_group ) {
                        $value = isset($reg_form[$v_key]) ? ((is_string($reg_form[$v_key]) and trim($reg_form[$v_key])) ? stripslashes($reg_form[$v_key]) : (is_array($reg_form[$v_key]) ? implode(' | ', $reg_form[$v_key]) : '---')) : '';
                    }elseif( 'fixed' == $v_group ) {
                        $value = isset($v_fixed_fields[$v_key]) ? ((is_string($v_fixed_fields[$v_key]) and trim($v_fixed_fields[$v_key])) ? stripslashes($v_fixed_fields[$v_key]) : (is_array($v_fixed_fields[$v_key]) ? implode(' | ', $v_fixed_fields[$v_key]) : '---')) : '';
                    }
                    $rsvp_data[] = $value;
                }

                $rsvp_data[]  = $attachments;
                $attachments = '';

                $rsvps[] = $rsvp_data;
                $counter++;
            }

            $rsvps = apply_filters('mec_csv_export_rsvp_all', $rsvps);
            foreach ($rsvps as $rsvp) {
                fputcsv($output, $rsvp);
            }
        }
    }


    public function import_rsvps_from_csv() {

        $nonce = (isset($_POST['_wpnonce']) ? $_POST['_wpnonce'] : '');
        if (!$nonce || !wp_verify_nonce($nonce, 'mec_import_start_upload')) {

            return;
        }

        $import_action = isset($_POST['mec-ix-action']) ? sanitize_text_field($_POST['mec-ix-action']) : '';
        if ('import-start-rsvps' !== $import_action) {

            return;
        }


        $feed_file = $_FILES['feed'];

        // File is not uploaded
        if (!isset($feed_file['name']) or (isset($feed_file['name']) and trim($feed_file['name']) == '')) return array('success' => 0, 'message' => __('Please upload a CSV file.', 'mec-rsvp'));

        // File name validation
        $name_ex = explode('.', $feed_file['name']);
        $name_end = end($name_ex);
        if ($name_end != 'csv') return array('success' => 0, 'message' => __('Please upload a CSV file.', 'mec-rsvp'));

        // Upload the File
        $upload_dir = wp_upload_dir();

        $target_path = $upload_dir['basedir'] . '/' . basename($feed_file['name']);
        $uploaded = move_uploaded_file($feed_file['tmp_name'], $target_path);

        // Error on Upload
        if (!$uploaded) return array('success' => 0, 'message' => __("An error occurred during the file upload! Please check permissions!", 'mec-rsvp'));

        if ($type = mime_content_type($target_path) and $type == 'text/x-php') {
            unlink($target_path);
            return array('success' => 0, 'message' => __("Please upload a CSV file.", 'mec-rsvp'));
        }

        $field_keys = [];
        $rsvps = array();
        if (($h = fopen($target_path, 'r')) !== false) {

            $r = 0;
            while (($data = fgetcsv($h, 1000, ",")) !== false) {
                $r++;

                $cell_1 = $data[0];
                if ($r === 1 && !is_numeric($cell_1)){

                    $columns = $this->get_columns([], [], 0);
                    $field_keys['ID'] = 0;
                    foreach($columns as $k => $title){

                        $id = array_search( $title, $data );
                        if(false !== $id){

                            $field_keys[$title] = $id;
                        }
                    }

                    $main_event_id = 0;

                    $group_id = 'rsvp_general';
                    $fixed_fields = CustomForm::getInstance()->get_fixed_fields($group_id, $main_event_id);
                    foreach($fixed_fields as $fixed_field_id => $fixed_field){

                        if (in_array($fixed_field_id, [':i:', ':fi:', '_i_', '_fi_',], true)) {

                            continue;
                        }

                        $type = isset($fixed_field['type']) ? $fixed_field['type'] : '';
                        $label = isset($fixed_field['label']) ? __($fixed_field['label'], 'mec-rsvp') : '';

                        if (trim($label) == '' or in_array($type,['last_name','first_name','mec_email'],false)){

                            continue;
                        }
                        if ($type == 'agreement') $label = sprintf($label, get_the_title($fixed_field['page']));

                        $title = stripslashes($label);

                        $id = array_search( $title, $data );
                        if(false !== $id){

                            $field_id = isset($reg_fields['key']) ? $reg_fields['key'] : $fixed_field_id;
                            $field_keys['fixed'][$title] = [
                                'column_id' => $id,
                                'key' => $field_id,
                            ];
                        }
                    }


                    $group_id = 'rsvp_general';
                    $reg_fields = CustomForm::getInstance()->get_reg_fields($group_id, $main_event_id);

                    foreach($reg_fields as $reg_field_id => $reg_field){

                        if (in_array($reg_field_id, [':i:', ':fi:', '_i_', '_fi_',], true)) {

                            continue;
                        }

                        $type = isset($reg_field['type']) ? $reg_field['type'] : '';
                        $label = isset($reg_field['label']) ? __($reg_field['label'], 'mec-rsvp') : '';

                        if (trim($label) == '' or in_array($type,['last_name','first_name','mec_email'],false)){

                            continue;
                        }
                        if ($type == 'agreement') $label = sprintf($label, get_the_title($reg_field['page']));

                        $title = stripslashes($label);

                        $id = array_search( $title, $data );
                        if(false !== $id){

                            $field_id = isset($reg_fields['key']) ? $reg_fields['key'] : $reg_field_id;
                            $field_keys['reg'][$title] = [
                                'column_id' => $id,
                                'key' => $field_id,
                            ];
                        }
                    }
                    continue;
                }

                $rsvp = [];

                $rsvp_id = isset($data[$field_keys['ID']]) ? (int)$data[$field_keys['ID']] : 0;
                $event_title = $data[$field_keys['Event']];
                $event_id = post_exists($event_title, '', '', \MEC\Base::get_main()->get_main_post_type());
                // Event not Found
                if (!$event_id) {

                    continue;
                }

                /** Attendee start */
                $first_name = $data[$field_keys['First Name']];
                $last_name = $data[$field_keys['Last Name']];
                $email = $data[$field_keys['Email']];
                $attendees_count = $data[$field_keys['Attendees Count']];

                $attendee = array(
                    'email' => $email,
                    'first_name' => $first_name,
                    'last_name' => $last_name,
                    'count' => $attendees_count,
                );

                foreach($field_keys['reg'] as $title => $args){

                    $field_column_id = $args['column_id'];
                    $field_id = $args['key'];

                    $attendee['reg'][$field_id] = isset($data['reg'][$field_column_id]) ? $data['reg'][$field_column_id] : '';
                }

                if($rsvp_id && isset($rsvps[$rsvp_id])){

                    $rsvps[$rsvp_id]['attendees'][] = $attendee;

                    continue;
                }else{

                    $rsvp['attendees'][] = $attendee;
                }
                /** Attendee end */


                $rsvp['event_id'] = $event_id;

                $start_datetime = $data[$field_keys['Start Date & Time']];
                $start_datetime = !empty($start_datetime) ? $start_datetime : false;
                $rsvp['event_date'] = $start_datetime && !is_numeric($start_datetime) ? strtotime($start_datetime) : $start_datetime;

                $end_datetime = $data[$field_keys['End Date & Time']];

                $answer = $data[$field_keys['Response']];
                if ($answer == __('Yes', 'mec-rsvp')) {
                    $answer = 'yes';
                } elseif ($answer == __('Maybe', 'mec-rsvp')){
                    $answer = 'maybe';
                }elseif ($answer == __('No', 'mec-rsvp')){
                    $answer = 'no';
                }
                $rsvp['answer'] = $answer;

                $rsvp['creation_by_invite'] = $data[$field_keys['Type of creation']];

                $confirmed_label = $data[$field_keys['Confirmation']];
                if ($confirmed_label == __('Confirmed', 'mec-rsvp')) $confirmed = 1;
                elseif ($confirmed_label == __('Rejected', 'mec-rsvp')) $confirmed = -1;
                else $confirmed = 0;

                $rsvp['confirm_status'] = $confirmed;

                $verified_label = $data[$field_keys['Verification']];
                if ($verified_label == __('Verified', 'mec-rsvp')) $verified = 1;
                elseif ($verified_label == __('Canceled', 'mec-rsvp')) $verified = -1;
                else $verified = 0;

                $rsvp['verification_status'] = $verified;

                foreach($field_keys['fixed'] as $title => $args){

                    $field_column_id = $args['column_id'];
                    $field_id = $args['key'];

                    $rsvp['fixed'][$field_id] = isset($data['reg'][$field_column_id]) ? $data['reg'][$field_column_id] : '';
                }

                if( $rsvp_id ){

                    $rsvp['ID'] = $rsvp_id;
                    $rsvps[$rsvp_id] = $rsvp;
                }else{

                    $rsvps[] = $rsvp;
                }

            }

            fclose($h);

            foreach ($rsvps as $rsvp_id => $rsvp_vars) {

                if(count($rsvp_vars['attendees']) === 1){

                    $rsvp_vars['first_for_all'] = 1;
                }

                RSVPs::getInstance()->add_or_update_rsvp($rsvp_vars);
            }
        }

        // Delete File
        unlink($target_path);

        return array('success' => (count($rsvps) ? 1 : 0), 'message' => (count($rsvps) ? __('The RSVPs are imported successfully!', 'mec-rsvp') : __('No RSVPs found to import!', 'mec-rsvp')));
    }

    public static function rsvp_export_page($tab) {

        if ('MEC-export' !== $tab) {
            return;
        }
?>
        <div class="mec-export-all-rsvps">
            <h3><?php _e('Export all RSVPs to file', 'mec-rsvp'); ?></h3>
            <p class="description"><?php _e("This will export all of your website's RSVP data into your desired format.", 'mec-rsvp'); ?></p>
            <ul>
                <li><a href="<?php echo \MEC\Base::get_main()->add_qs_vars(array('mec-ix-action' => 'export-rsvps', 'format' => 'csv')); ?>"><?php _e('CSV', 'mec-rsvp'); ?></a></li>
                <li><a href="<?php echo \MEC\Base::get_main()->add_qs_vars(array('mec-ix-action' => 'export-rsvps', 'format' => 'ms-excel')); ?>"><?php _e('MS Excel', 'mec-rsvp'); ?></a></li>
            </ul>
        </div>
    <?php
    }

    public static function rsvp_import_page($tab) {

        if ('MEC-import' !== $tab) {
            return;
        }

        $ix_action = isset($_REQUEST['mec-ix-action']) ? sanitize_text_field( $_REQUEST['mec-ix-action'] ) : '';
        ?>
        <div class="mec-import-rsvps">
            <h3><?php _e('Import RSVP CSV File', 'mec-rsvp'); ?></h3>
            <form id="mec_import_csv_rsvp_form" action="<?php echo \MEC\Base::get_main()->get_full_url(); ?>" method="POST" enctype="multipart/form-data">
                <div class="mec-form-row">
                    <p><?php echo sprintf(__("You can export RSVPs from %s using the RSVP menu in source website. You need a CSV export and then you're able to simply import it using this form in to your target website.", 'mec-rsvp'), '<strong>' . __('Modern Events Calendar', 'mec-rsvp') . '</strong>'); ?></p>
                    <p style="color: red;"><?php echo __("Please note that you should create (or imports) events before importing the RSVPs otherwise RSVP won't import due to lack of data.", 'mec-rsvp'); ?></p>
                </div>
                <div class="mec-form-row">
                    <input type="file" name="feed" id="feed" title="<?php esc_attr_e('CSV File', 'mec-rsvp'); ?>">
                    <input type="hidden" name="mec-ix-action" value="import-start-rsvps">
                    <?php wp_nonce_field('mec_import_start_upload'); ?>
                    <button class="button button-primary mec-button-primary mec-btn-2"><?php _e('Upload & Import', 'mec-rsvp'); ?></button>
                </div>
            </form>
        </div>

        <?php if( $ix_action == 'import-start-rsvps' ):

            global $MEC_Import_Result;
            ?>
            <div class="mec-ix-import-started">
                <?php if($MEC_Import_Result['success'] == 0): ?>
                <div class="mec-error"><?php echo $MEC_Import_Result['message']; ?></div>
                <?php else: ?>
                <div class="mec-success"><?php echo $MEC_Import_Result['message']; ?></div>
                <?php endif; ?>
            </div>
        <?php endif;
    }
}
