<?php

namespace MEC_RSVP\RSVP;

use DateInterval;
use MEC\Singleton;
use MEC\Events\Event;
use MEC\Forms\CustomForm;
use MEC\Settings\Settings;

class MetaBoxDetail extends Singleton {

	public function ajax_handler(){

		add_action('wp_ajax_mec_rsvp_edit_event_options',[$this,'rsvp_event_edit_options']);

		add_action('wp_ajax_mec_rsvp_edit_event_add_attendee',[$this,'rsvp_edit_event_add_attendee']);
	}

	public function init() {

		add_action( 'save_post_mec_rsvp', array( __CLASS__, 'save_rsvp' ) );
		add_action( 'edit_post_mec_rsvp', array( __CLASS__, 'save_rsvp' ) );

		if(wp_doing_ajax()){

			$this->ajax_handler();
		}
	}

    /**
	 * @param array
	 */
	public static function save_rsvp( $rsvp_id ) {

        if(!isset($_POST['mec_rsvp_nonce'])) return;
        if(!wp_verify_nonce(sanitize_text_field($_POST['mec_rsvp_nonce']), 'mec_rsvp_data')) return;
        if(defined('DOING_AUTOSAVE') and DOING_AUTOSAVE) return;

		$event_id        = isset( $_POST['mec_event_id'] ) ? $_POST['mec_event_id'] : 0;

		$rsvp_vars       = isset( $_POST['rsvp'] ) ? $_POST['rsvp'] : array();
		$rsvp_vars['ID'] = $rsvp_id;
		$rsvp_vars['event_id'] = $event_id;

		$rsvp_id = RSVPs::getInstance()->update_meta($rsvp_id,$rsvp_vars);
	}

	public function rsvp_edit_event_add_attendee() {

        $event_id = isset($_REQUEST['event_id']) ? sanitize_text_field($_REQUEST['event_id']) : '';
		$answer = isset($_REQUEST['answer']) ? sanitize_text_field($_REQUEST['answer']) : '';
        $key = isset($_REQUEST['key']) ? sanitize_text_field($_REQUEST['key']) : '';

        // Event is invalid!
        if(!trim($event_id)){
			\MEC\Base::get_main()->response(array('success'=>0, 'output'=>'<div class="warning-msg">'.__('Event is invalid. Please select an event.', 'mec-rsvp').'</div>'));
		}

		if(!trim($answer)){
			\MEC\Base::get_main()->response(array('success'=>0, 'output'=>'<div class="warning-msg">'.__('Response is invalid. Please select a Response.', 'mec-rsvp').'</div>'));
		}

        $output = $this->display_attendee_fields( $event_id, $answer, $key );

        \MEC\Base::get_main()->response(array(
			'success' => 1,
			'output' => $output
		));
    }

	public function display_attendee_fields($event_id,$answer, $attendee_id, $attendee = array()){

		$group_id = 'rsvp_'.$answer;
		$rsvp_form_options = '<hr>
							<div class="mec-form-row">
								<div class="mec-col-2">
									<h4>'. __( 'Attendee', 'mec-rsvp' ).'</h4>
								</div>
								<div class="mec-col-8" style="text-align: right;">
									<button type="button" class="button mec-remove-attendee" data-key="' . $attendee_id . '">'. __('Remove Attendee', 'mec-rsvp') .'</button>
								</div>
							</div>';

		$rsvp_form_options .= CustomForm::getInstance()->display_reg_fields( $group_id, $event_id, $attendee_id, null, $attendee );

		return '<div class="mec-attendee" id="mec_attendee'.$attendee_id.'">'
					.($rsvp_form_options)
				.'</div>';
	}

    public function get_dates($event_id){

        $event = new Event( $event_id );

        $datetime = new \DateTime("today -6 months");
        $start_timestamp = $datetime->getTimestamp();
        return $event->get_occurrences_times( $start_timestamp, 200 );
    }

    public function get_dates_options( $event_id, $event_date, $date_format ){

        ob_start();
        $occurrences = $this->get_dates($event_id);
        foreach($occurrences as $occurrence):
            $occ_timestamp = $occurrence->tstart;
            if(($event_date == $occ_timestamp || $event_date == $occurrence->tstart.':'.$occurrence->tend)){
                $selected = true;
            }else{
                $selected = false;
            }
            ?>
            <option value="<?php echo $occ_timestamp; ?>" <?php selected($selected,true) ?>>
                <?php echo date_i18n( $date_format, $occ_timestamp ); ?>
            </option>
        <?php endforeach;

        return ob_get_clean();
    }

	public function rsvp_event_edit_options() {

        $event_id = isset($_REQUEST['event_id']) ? sanitize_text_field($_REQUEST['event_id']) : '';
        $rsvp_id = isset($_REQUEST['rsvp_id']) ? sanitize_text_field($_REQUEST['rsvp_id']) : '';
		$answer = isset($_REQUEST['answer']) ? sanitize_text_field($_REQUEST['answer']) : '';

		if(empty($answer)){
			return;
		}

		$rsvp = new RSVP( $rsvp_id );

        // Event is invalid!
        if(!trim($event_id)) {
            \MEC\Base::get_main()->response(array('success'=>0, 'output'=>'<div class="warning-msg">'.__('Event is invalid. Please select an event.', 'mec-rsvp').'</div>'));
        }

        $date_format = Settings::getInstance()->get_settings('rsvp_date_format1');
		$date_format = !empty($date_format) ? $date_format : 'Y-m-d';

        $repeat_type = get_post_meta($event_id, 'mec_repeat_type', true);
        if($repeat_type === 'custom_days') {
			$date_format .= ' '.get_option('time_format');
		}

        $event_date = '';
        $date_options = $this->get_dates_options( $event_id,$event_date,$date_format );

        // Booking Form Options
		$group_id = 'rsvp_'.$answer;
        $rsvp_form_options = CustomForm::getInstance()->display_reg_fields( $group_id, $event_id );

        \MEC\Base::get_main()->response(array(
			'success' => 1,
			'dates' => $date_options,
			'reg_fields' => $rsvp_form_options
		));
    }

	public function meta_box_rsvp_info($post){

		$rsvp_id = $post->ID;
		$rsvp = new RSVP($rsvp_id);

        $event_id = $rsvp->get_event_id();

        // // The rsvp is not saved so we will skip this and show rsvp form instead.
        // if(!$event_id) return false;

        $date_format = Settings::getInstance()->get_settings('rsvp_date_format1');
        $time_format = get_option('time_format');

		$event_date = $rsvp->get_event_times();
        $dates = explode(':',$event_date);
        $event_start_timestamp = $rsvp->get_event_times('start');
        if(is_numeric($dates[0]) and is_numeric($dates[1])){

            $start_datetime = date($date_format.' '.$time_format, $dates[0]);
            $end_datetime = date($date_format.' '.$time_format, $dates[1]);
        } else {
            $start_datetime = isset($dates[0]) ? $dates[0] : '';
            $end_datetime = isset($dates[1]) ? $dates[1] : '';
        }

        $attendees = $rsvp->get_attendees_by_detail_for_each();
		$answer = $rsvp->get_answer();
		$group_id = 'rsvp_'.$answer;
        $reg_fields = CustomForm::getInstance()->get_reg_fields($group_id,$event_id);
        $fixed_fields = CustomForm::getInstance()->get_fixed_fields($group_id,$event_id);
		$v_fixed_fields = $rsvp->get_fixed_fields();

        $status = $rsvp->get_verification_status();

        $event_rsvp_options = get_post_meta($event_id, 'mec_rsvp', true);
        if(!is_array($event_rsvp_options)) $event_rsvp_options = array();

        $rsvp_all_occurrences = 0;
        if(isset($event_rsvp_options['rsvps_all_occurrences'])) {
			$rsvp_all_occurrences = (int) $event_rsvp_options['rsvps_all_occurrences'];
		}

		$maximum_dates = Settings::getInstance()->get_settings('rsvp_maximum_dates');
		$maximum_dates = !empty($maximum_dates) ? $maximum_dates : 6;

		wp_nonce_field('mec_rsvp_data', 'mec_rsvp_nonce');
        ?>
        <input type="hidden" name="mec_event_id" value="<?php echo $event_id; ?>" />
        <input type="hidden" name="rsvp[answer]" value="<?php echo $answer; ?>" />
        <input type="hidden" name="rsvp[event_date]" value="<?php echo $event_start_timestamp; ?>" />
        <?php

        global $pagenow;
        $edit_mode = !empty($event_id) && 'post-new.php' !== $pagenow;
        if($edit_mode):
            ?>
            <div class="mec-rsvp-details">
                <h3><?php echo __('RSVP', 'mec-rsvp'); ?></h3>
                <div class="mec-row">
                    <strong><?php _e('Event', 'mec-rsvp'); ?>: </strong>
                    <span><?php echo ($event_id ? '<a href="'.get_permalink($event_id).'">'.get_the_title($event_id).'</a>' : __('Unknown', 'mec-rsvp')); ?></span>
                </div>
                <div class="mec-row">
                    <strong><?php _e('Date & Time', 'mec-rsvp'); ?>: </strong>

                    <?php if($rsvp_all_occurrences):
                        $next_occurrences = \MEC\Base::get_main()->getRender()->dates($event_id, NULL, $maximum_dates, date('Y-m-d', strtotime('-1 day', strtotime($start_datetime)))); ?>
                    <div class="mec-next-occ-rsvp-p">
                        <?php esc_html_e('This is a RSVP for all occurrences. Some of them are listed below but there might be more.', 'mec-rsvp'); ?>
                        <div>
                            <?php
                            foreach($next_occurrences as $next_occurrence){
                                echo \MEC\Base::get_main()->date_label($next_occurrence['start'], $next_occurrence['end'], $date_format.' '.$time_format, ' - ', false)."<br>";
                            }
                            ?>
                        </div>
                    </div>
                    <?php else: ?>
                    <span><?php echo ((isset($dates[0]) and isset($dates[1])) ? sprintf(__('%s to %s', 'mec-rsvp'), $start_datetime, $end_datetime) : __('Unknown', 'mec-rsvp')); ?></span>
                    <?php endif; ?>
                </div>

                <div class="mec-row">
                    <strong><?php _e('Response', 'mec-rsvp'); ?>: </strong>
                    <span><?php echo $rsvp->get_answer_text() ?></span>
                </div>

                <div class="mec-row">
                    <strong><?php _e('Creation', 'mec-rsvp'); ?>: </strong>
                    <span><?php echo $rsvp->get_creation_type_text() ?></span>
                </div>

                <?php if($status == '-1'): ?>
                <div class="mec-row">
                    <strong><?php _e('Cancellation Date', 'mec-rsvp'); ?>: </strong>
                    <span>
                        <?php
                            $mec_cancellation_date = get_post_meta($rsvp_id, 'mec_cancelled_date', true);
                            echo trim($mec_cancellation_date) ? $mec_cancellation_date : __('Unknown', 'mec-rsvp');
                        ?>
                    </span>
                </div>
                <?php endif; ?>

                <div class="mec-row">
                    <strong><?php _e('Total Attendees', 'mec-rsvp'); ?>: </strong>
                    <span><?php echo $rsvp->get_attendees_count(); ?></span>
                </div>

                <?php
                if( is_array($fixed_fields) and count($fixed_fields) && !empty($v_fixed_fields) ): ?>
                    <h3><?php echo __('RSVP Fields', 'mec-rsvp'); ?></h3>
                    <hr>

                    <?php foreach($fixed_fields as $fixed_field_id => $fixed_field):
                        if(in_array($fixed_field_id, [':i:',':fi:','_i_','_fi_',], true)){

                            continue;
                        }

                        $fixed_value = isset($v_fixed_fields[$fixed_field_id]) ? $v_fixed_fields[$fixed_field_id] : NULL;

                        if(!$fixed_value) {
                            continue;
                        }
                        $fixed_type = isset($fixed_field['type']) ? $fixed_field['type'] : NULL;
                        $fixed_label = isset($fixed_field['label']) ? $fixed_field['label'] : '';
                        ?>
                        <?php if($fixed_type == 'agreement'): ?>
                            <div class="mec-row">
                                <strong><?php echo sprintf(__($fixed_label, 'mec-rsvp'), '<a href="'.get_the_permalink($fixed_field['page']).'">'.get_the_title($fixed_field['page']).'</a>'); ?>: </strong>
                                <span><?php echo ($fixed_value == '1' ? __('Yes', 'mec-rsvp') : __('No', 'mec-rsvp')); ?></span>
                            </div>
                        <?php else: ?>
                            <div class="mec-row">
                                <strong><?php _e($fixed_label, 'mec-rsvp'); ?>: </strong>
                                <span><?php echo (is_array($fixed_value) ? stripslashes(implode(',', $fixed_value)) : stripslashes($fixed_value)); ?></span>
                            </div>
                        <?php endif; ?>
                    <?php endforeach; ?>
                    <?php endif; ?>

                <?php if(isset($attendees['attachments']) && !empty($attendees['attachments'])): ?>
                <h3><?php _e('Attachments', 'mec-rsvp'); ?></h3>
                <hr>
                <?php foreach($attendees['attachments'] as $attachment): ?>
                <div class="mec-attendee">
                    <?php if(!isset($attachment['error']) && $attachment['response'] === 'SUCCESS'): ?>
                        <?php
                            @$a = getimagesize($attachment['url']);
                            $image_type = $a[2];
                            if(in_array($image_type, array(IMAGETYPE_GIF, IMAGETYPE_JPEG, IMAGETYPE_PNG, IMAGETYPE_BMP))):
                        ?>
                            <a href="<?php echo $attachment['url'] ?>" target="_blank">
                                <img src="<?php echo $attachment['url'] ?>" alt="<?php echo $attachment['filename'] ?>" title="<?php echo $attachment['filename'] ?>" style="max-width:250px;float: left;margin: 5px;">
                            </a>
                        <?php else: ?>
                            <a href="<?php echo $attachment['url'] ?>" target="_blank"><?php echo $attachment['filename'] ?></a>
                        <?php endif; ?>
                    <?php endif; ?>
                </div>
                <?php endforeach; ?>
                <div class="clear"></div>
                <?php endif; ?>

                <h3><?php _e('Attendees', 'mec-rsvp'); ?></h3>
                <?php foreach((array)$attendees as $key => $attendee):
                    $reg_form = isset($attendee['reg']) ? $attendee['reg'] : array(); ?>
                    <?php
                        if($key === 'attachments') continue;
                        if(isset($attendee[0]['MEC_TYPE_OF_DATA'])) continue;
                    ?>
                    <hr>
                    <div class="mec-attendee">
                        <h4><strong><?php echo ((isset($attendee['name']) and trim($attendee['name'])) ? $attendee['name'] : '---'); ?></strong></h4>
                        <div class="mec-row">
                            <strong><?php _e('Email', 'mec-rsvp'); ?>: </strong>
                            <span><?php echo ((isset($attendee['email']) and trim($attendee['email'])) ? $attendee['email'] : '---'); ?></span>
                        </div>
                        <?php
                        $reg_fields = apply_filters('mec_rsvp_reg_form', $reg_fields, $event_id, $post);

                        if(isset($reg_form) && !empty($reg_form)):
                            foreach($reg_form as $field_id=>$value):
                                $label = isset($reg_fields[$field_id]) ? $reg_fields[$field_id]['label'] : '';
                                $type = isset($reg_fields[$field_id]) ? $reg_fields[$field_id]['type'] : '';
                                if($label==""){
                                    foreach($reg_fields as $reg_field){
                                        if(isset($reg_field['key']) && $field_id==$reg_field['key']){
                                            $label = isset($reg_field['label']) ? $reg_field['label'] : '';
                                        }
                                    }
                                }
                            ?>
                                <?php if($type == 'agreement'): ?>
                                    <div class="mec-row">
                                        <strong><?php echo sprintf(__($label, 'mec-rsvp'), '<a href="'.get_the_permalink($reg_fields[$field_id]['page']).'">'.get_the_title($reg_fields[$field_id]['page']).'</a>'); ?>: </strong>
                                        <span><?php echo ($value == '1' ? __('Yes', 'mec-rsvp') : __('No', 'mec-rsvp')); ?></span>
                                    </div>
                                <?php else: ?>
                                    <div class="mec-row">
                                        <strong><?php _e($label, 'mec-rsvp'); ?>: </strong>
                                        <span><?php echo (is_string($value) ? $value : (is_array($value) ? implode(', ', $value) : '---')); ?></span>
                                    </div>
                                <?php endif; ?>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php
        endif;

        // Events
        $events = \MEC\Base::get_main()->get_events();

        $date_format = Settings::getInstance()->get_settings('rsvp_date_format1');
		$date_format = !empty($date_format) ? $date_format : 'Y-m-d';

        if($edit_mode){

            $occurrences = $this->get_dates( $event_id );

            $repeat_type = get_post_meta($event_id, 'mec_repeat_type', true);
            if($repeat_type === 'custom_days') {
                $date_format .= ' '.get_option('time_format');
            }
            ?>
            <div class="mec-rsvp-edit">
                <h1 id="mec_rsvp_edit_heading"><?php _e('Edit RSVP', 'mec-rsvp'); ?></h1>
                <div class="info-msg"><?php _e('Do not edit the RSVP unless it is really needed!', 'mec-rsvp'); ?></div>
                <input type="hidden" name="mec_rsvp_edit_status" value="0">
                <input type="checkbox" name="mec_rsvp_edit_status" id="mec_rsvp_edit_status" value="1" onchange="jQuery('#mec_rsvp_edit_form').toggleClass('mec-util-hidden');">
                <label for="mec_rsvp_edit_status"><?php _e('I need to edit the details of a RSVP', 'mec-rsvp'); ?></label>
            <?php
        }
        ?>
                <div id="mec_rsvp_edit_form_event_message"></div>
                <div id="mec_rsvp_edit_form" class="mec-rsvp-form mec-util-hidden" style="margin-top: 30px;">
                    <div class="mec-form-row">
                        <div class="mec-col-2">
                            <label for="mec_rsvp_form_event_id"><?php _e('Event', 'mec-rsvp'); ?></label>
                        </div>
                        <div class="mec-col-6">
                            <select id="mec_rsvp_form_event_id" class="widefat" name="mec_event_id">
                                <option value="">-----</option>
                                <?php foreach($events as $event): ?>
                                    <option value="<?php echo $event->ID; ?>" <?php echo ($event_id == $event->ID ? 'selected="selected"' : ''); ?>><?php echo $event->post_title; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                    <div class="mec-form-row">
                        <div class="mec-col-2">
                            <label for="mec_rsvp_form_answer"><?php _e('Response', 'mec-rsvp'); ?></label>
                        </div>
                        <div class="mec-col-6">
                            <?php $selected_answer = $rsvp->get_answer(); ?>
                            <select id="mec_rsvp_form_answer" class="widefat" name="mec_answer" <?php echo !empty($selected_answer) ? 'disabled="disabled"' : '' ?>>
                                <option value="">-----</option>

                                <?php
                                $answers = array(
                                    'yes'   => __( 'Yes', 'mec-rsvp' ),
                                    'no'    => __( 'No', 'mec-rsvp' ),
                                    'maybe' => __( 'Maybe', 'mec-rsvp' ),
                                );

                                foreach($answers as $k_answer => $answer_text): ?>
                                    <option value="<?php echo $k_answer; ?>" <?php echo ($k_answer == $selected_answer ? 'selected="selected"' : ''); ?>><?php echo $answer_text; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>

                    <div id="mec_rsvp_edit_form_event_options">
                        <div class="mec-form-row">
                            <div class="mec-col-2">
                                <label for="mec_rsvp_form_date"><?php _e('Date', 'mec-rsvp'); ?></label>
                            </div>
                            <div class="mec-col-6">
                                <select id="mec_rsvp_form_date" class="widefat mec-rsvp-edit-form-dates" name="mec_event_date">
                                    <option value="">-----</option>
                                    <?php
                                        echo $this->get_dates_options( $event_id, $event_date, $date_format );
                                    ?>
                                </select>
                            </div>
                        </div>
                        <div class="mec-form-row">
                            <div class="mec-col-8" style="text-align: right;">
                                <button type="button" class="button mec-add-attendee"><?php _e('Add Attendee', 'mec-rsvp'); ?></button>
                            </div>
                        </div>

                        <div id="mec_date_tickets_rsvp_form_fixed_fields">
                            <h3><?php _e('RSVP Fields', 'mec-rsvp'); ?></h3>
                            <hr>
                            <div id="mec_date_tickets_rsvp_form_fixed_list">
                                <?php
                                    $group_id = 'rsvp_'.$rsvp->get_answer();
                                    echo CustomForm::getInstance()->display_fixed_fields( $group_id, $event_id, null, $v_fixed_fields );
                                ?>
                            </div>
                        </div>

                        <div id="mec_date_tickets_rsvp_form_attendees">
                            <h3><?php _e('Attendees', 'mec-rsvp'); ?></h3>
                            <div id="mec_date_tickets_rsvp_form_attendees_list">
                                <?php
                                    $i = 0;
                                    if(!empty($attendees) && is_array($attendees)){

                                        foreach((array)$attendees as $key => $attendee){

                                            $i = max($i, $key);
                                            $attachments = (isset($attendees['attachments']) and is_array($attendees['attachments'])) ? $attendees['attachments'] : NULL;

                                            if($key === 'attachments') continue;
                                            if(isset($attendee[0]['MEC_TYPE_OF_DATA'])) continue;

                                            $answer = $rsvp->get_answer();
                                            $attendee_id = $key;
                                            echo $this->display_attendee_fields( $event_id, $answer, $attendee_id, $attendee );
                                        }
                                    }
                                ?>
                            </div>
                            <input type="hidden" id="mec_rsvp_edit_new_key" value="<?php echo $i+1; ?>">
                        </div>
                    </div>
                </div>
        <?php if($edit_mode): ?>
        </div>
        <?php endif; ?>
        <script type="text/javascript">
        function mec_init_rsvp_media_file(){
            jQuery('.mec-choose-file').off('click').on('click', function(event){
                event.preventDefault();

                var _for = jQuery(this).data('for');

                var frame;
                if(frame)
                {
                    frame.open();
                    return;
                }

                frame = wp.media();
                frame.on('select', function()
                {
                    // Grab the selected attachment.
                    var attachment = frame.state().get('selection').first();

                    jQuery('#'+_for).val(attachment.id);
                    console.log('#'+_for, attachment.id);
                    frame.close();
                });

                frame.open();
            });
        }

        function mec_toggle_required(){

            var status = jQuery('#mec_rsvp_edit_status').length == 0 || jQuery('#mec_rsvp_edit_status').is(':checked');

            if(!status){

                jQuery('#mec_date_tickets_rsvp_form_attendees').find(jQuery(':input[required]')).attr('data-should-require', '1').removeAttr('required');
            } else {

                jQuery('#mec_date_tickets_rsvp_form_attendees').find(jQuery(':input[data-should-require="1"]')).attr('required', 'required');
            }
        }

        jQuery(document).ready(function($){

            if($('#mec_rsvp_edit_status').length == 0){

                $('#mec_rsvp_edit_form').toggleClass('mec-util-hidden');
                $('#mec_rsvp_edit_form_event_options').hide();
            }
            // Init File Media
            mec_init_rsvp_media_file();

			function mec_attendee_form_init(){
				jQuery('.mec-remove-attendee').on('click', function(){
					var key = jQuery(this).data('key');
					jQuery('#mec_attendee'+key).remove();

					mec_attendee_form_init();
				});


				var attendees = $('#mec_date_tickets_rsvp_form_attendees_list').find('div.mec-attendee');
				if(attendees.length > 0){

                    $('#mec_rsvp_form_event_id').prop('disabled',true);
					$('#mec_rsvp_form_answer').prop('disabled',true);
                    if( $('#mec_rsvp_form_date').val().length > 0 ) {

                        $('#mec_rsvp_form_date').prop('disabled',true);
                    }
				}else{
                    $('#mec_rsvp_form_event_id').prop('disabled',false);
					$('#mec_rsvp_form_answer').prop('disabled',false);
					$('#mec_rsvp_form_date').prop('disabled',false);
				}

                $('#mec_rsvp_form_answer').on('change',function(){
                    $('input[name="rsvp[answer]"]').val($(this).val());
                });

                $('#mec_rsvp_form_event_id').on('change',function(){
                    $('input[name="mec_event_id"]').val($(this).val());
                });

                $('#mec_rsvp_form_date').on('change',function(){
                    $('input[name="rsvp[event_date]"]').val($(this).val());
                });

                if( false === $('#mec_rsvp_form_date').prop('disabled') ){

                    $('#mec_rsvp_form_date').trigger('change');
                }
			}

			mec_attendee_form_init();



            jQuery('.mec-add-attendee').on('click', function(){

                var key = jQuery('#mec_rsvp_edit_new_key').val();
                var event_id = jQuery('#mec_rsvp_form_event_id').val();
                var rsvp_id = jQuery('#post_ID').val();
				var answer = jQuery('#mec_rsvp_form_answer').val();

                jQuery('#mec_rsvp_edit_form_event_message').html('');

                jQuery.ajax({
                    url: "<?php echo admin_url('admin-ajax.php', NULL); ?>",
                    data: "action=mec_rsvp_edit_event_add_attendee&event_id="+event_id+"&key="+key+"&answer="+answer+"&rsvp_id="+rsvp_id,
                    dataType: "json",
                    type: "GET",
                    success: function(response)
                    {
                        if(response.success === 1)
                        {
                            jQuery('#mec_date_tickets_rsvp_form_attendees_list').append(response.output);
                            jQuery('#mec_rsvp_edit_new_key').val(parseInt(key)+1);

                            jQuery('html, body').animate(
                            {
                                scrollTop: jQuery("#mec_attendee"+key).offset().top
                            }, 500);

                            // Init File Media
                            mec_init_rsvp_media_file();

							mec_attendee_form_init();
                            jQuery('.mec-attendee > div').addClass('mec-form-row');
                        }
                        else
                        {
                            jQuery('#mec_rsvp_edit_form_event_message').html(response.output);
                        }
                    },
                    error: function()
                    {
                    }
                });
            });

            jQuery('#mec_rsvp_form_event_id, #mec_rsvp_form_answer').on('change', function() {

                var event_id = $('#mec_rsvp_form_event_id').val();
				var answer = jQuery('#mec_rsvp_form_answer').val();
                var rsvp_id = jQuery('#post_ID').val();

                jQuery('#mec_rsvp_edit_form_event_message').html('');

                jQuery.ajax(
                {
                    url: "<?php echo admin_url('admin-ajax.php', NULL); ?>",
                    data: "action=mec_rsvp_edit_event_options&event_id="+event_id+"&answer="+answer+"&rsvp_id="+rsvp_id,
                    dataType: "json",
                    type: "GET",
                    success: function(response)
                    {
                        if(response.success === 1)
                        {
                            jQuery('.mec-rsvp-edit-form-dates').html(response.dates);


                            jQuery(".mec-rsvp-reg-fields").each(function()
                            {
                                var key = jQuery(this).data('key');
                                jQuery(this).html(response.reg_fields.replace(/:key:/g, key));
                            });

                            jQuery('#mec_rsvp_edit_form_event_options').show();

                            // Init File Media
                            mec_init_rsvp_media_file();

                            mec_attendee_form_init();
                        }
                        else
                        {
                            jQuery('#mec_rsvp_edit_form_event_message').html(response.output);
                            jQuery('#mec_rsvp_edit_form_event_options').hide();
                        }
                    },
                    error: function()
                    {
                    }
                });
            });

            jQuery('#mec_rsvp_edit_status').on('change', function()
            {
                mec_toggle_required();
            });

            mec_toggle_required();
        });
        </script>
    <?php
	}
}

