<?php

namespace MEC_RSVP\RSVP\Notifications;

use MEC_RSVP\RSVP\EventRSVP;
use MEC_RSVP\RSVP\RSVPNotification;

class EmailCancellation extends RSVPNotification{

    public $group_id = 'rsvp_cancellation_notification';

    public function can_send_notification( $rsvp_id, $mode = 'auto', $resend = false ){

        $can = parent::can_send_notification( $rsvp_id, $mode, $resend );
        if( !$can ){

            return $can;
        }

        return $can;
    }

    public function render_content($content, $rsvp_id, $attendee = array(), $timestamps = NULL){

        $content = parent::render_content( $content, $rsvp_id, $attendee, $timestamps );

        $link = $this->link(
            array('post_type'=> 'mec-events'),
            \MEC\Base::get_main()->URL('admin').'edit.php'
        );

        $content = str_replace('%%admin_link%%', $link, $content);

        return $content;
    }

    public function link($vars = array(), $url = NULL){

        if(!trim($url)) {

            $url = \MEC\Base::get_main()->URL('site').\MEC\Base::get_main()->get_main_slug().'/';
        }

        foreach($vars as $key=>$value){

            $url = \MEC\Base::get_main()->add_qs_var($key, $value, $url);
        }

        return $url;
    }

}