<?php

namespace MEC_RSVP\RSVP\Notifications;

use MEC_RSVP\RSVP\EventRSVP;
use MEC_RSVP\RSVP\RSVPNotification;

class EmailConfirmation extends RSVPNotification{

    public $group_id = 'rsvp_confirmation_notification';

    public function can_send_notification( $rsvp_id, $mode = 'auto', $resend = false ){

        $can = parent::can_send_notification($rsvp_id, $mode, $resend);
        if( !$can ){

            return $can;
        }

        $can_send_confirm_email = EventRSVP::getInstance()->can_send_confirm_email($this->event_id,$mode);
        if(!$can_send_confirm_email){

            $can = false;
        }

        return $can;
    }

    public function render_content($content, $rsvp_id, $attendee = array(), $timestamps = NULL){

        $content = parent::render_content( $content, $rsvp_id, $attendee, $timestamps );

        return $content;
    }
}