<?php

namespace MEC_RSVP\RSVP\Notifications;

use MEC_RSVP\RSVP\EventRSVP;
use MEC_RSVP\RSVP\RSVPNotification;

class EmailCreation extends RSVPNotification{

    public $group_id = 'rsvp_notification';

    public function can_send_notification( $rsvp_id, $mode = 'auto', $resend = false ){

        $can = parent::can_send_notification($rsvp_id,$mode,$resend);
        if( !$can ){

            return $can;
        }

        return $can;
    }

    public function render_content($content, $rsvp_id, $attendee = array(), $timestamps = NULL){

        $content = parent::render_content( $content, $rsvp_id, $attendee, $timestamps );

        $answer_id = $this->rsvp->get_answer();
        $content = str_replace(
            '%%rsvp_custom_text%%',
            $this->get_rsvp_custom_text_for_answer($answer_id),
            $content
        );

        $content = str_replace(
            '%%rsvp_is_creation_by_invite%%',
            $this->is_creation_by_invite(),
            $content
        );

        return $content;
    }
}
