<?php

namespace MEC_RSVP\RSVP\Notifications;

use MEC\Notifications\SendEmail;
use MEC\Settings\Settings;

class EmailCustom extends SendEmail{

    public $group_id = 'rsvp_custom_notification';

    public function mec_sender_email_notification_filter(){

        // MEC Notification Sender Email
        add_filter('wp_mail_from_name', array($this, 'notification_sender_name'));
        add_filter('wp_mail_from', array($this, 'notification_sender_email'));
    }

    public function notification_sender_name($sender_name){

        $s_sender_name = Settings::getInstance()->get_settings('booking_sender_name');

        return !empty($s_sender_name) ? $s_sender_name : $sender_name;
    }

    public function notification_sender_email($sender_email){

        $s_sender_email = Settings::getInstance()->get_settings('booking_sender_email');

        return !empty($s_sender_email) ? $s_sender_email : $sender_email;
    }

    public function render_content( $text, $attendee ){

        $this->render_site_data( $text, $attendee );

        foreach( $attendee as $k => $v ){

            if( is_array($v) ){

                continue;
            }

            $text = str_replace( "%%{$k}%%", $v, $text );
        }

        return $text;
    }

    public function send( $base_args, $users ){

        if(!is_array($users)){

            return false;
        }

        $subject = $base_args['subject'];
        $content = $base_args['message'];;

        $this->mec_sender_email_notification_filter();
        // Do not send email twice!
        $done_emails = array();

        $headers = '';

        // Set Email Type to HTML
        add_filter('wp_mail_content_type', array(\MEC\Base::get_main(), 'html_email_type'));

        // Send the emails
        $mails = [];
        foreach($users as $attendee_or_email) {

            $attendee = is_array($attendee_or_email) ? $attendee_or_email : [
                'email' => $attendee_or_email
            ];
            $to = isset($attendee['email']) ? trim($attendee['email']) : $attendee_or_email;

            if(!trim($to) or in_array($to, $done_emails) or !filter_var($to, FILTER_VALIDATE_EMAIL)) {

                continue;
            }
            $message = $this->render_content( $content, $attendee );

            // Remove remained placeholders
            $message = preg_replace('/%%.*%%/', '', $message);

            $message = $this->add_template($message);

            // Filter the email
            $mail_arg = array(
                'to'            => $to,
                'subject'       => $subject,
                'message'       => $message,
                'headers'       => $headers,
                'attachments'   => array(),
            );

            $mail_arg = apply_filters('mec_rsvp_before_send_email', $mail_arg, null, $this->group_id);

            $this->send_mail( $mail_arg );

            // $mails[] = $mail_arg;

            // For prevention of email repeat send
            $done_emails[] = $to;
        }

        // Remove the HTML Email filter
        remove_filter('wp_mail_content_type', array(\MEC\Base::get_main(), 'html_email_type'));

        return !empty($mails) ? $mails : $done_emails;
    }
}