<?php

namespace MEC_RSVP\RSVP\Notifications;

use MEC\Notifications\SendEmail;
use MEC_RSVP\RSVP\NotificationsSettings;
use MEC\Settings\Settings;

class EmailInvite extends SendEmail{

    public $group_id = 'rsvp_invite_notification';
    public $event_id;
    public $event_date;
    public $event_start;
    public $event_end;
    public $nonce_base;

    public function get_default_notification_settings(){

        return NotificationsSettings::getInstance()->get_default_settings($this->group_id) ;
    }

    public function prepare( $event_id, $event_date ){

        $this->event_id = $event_id;
        $this->event_date = $event_date;
        $ex = explode(':',$event_date);
        $this->event_start = isset($ex[0]) ? $ex[0] : '';
        $this->event_end = isset($ex[1]) ? $ex[1] : '';

        $this->nonce_base = get_post_meta($event_id,'mec_rsvp_nonce_base',true);
        if(empty($this->nonce_base)){

            $this->nonce_base = md5(time() * mt_rand(1000000,9999999));
            update_post_meta($event_id,'mec_rsvp_nonce_base',$this->nonce_base);
        }
    }

    public function get_event_times(){

        return $this->event_date;
    }

    public function can_send_notification( $event_id, $event_date, $users ){

        $can = true;

        if(!$this->get_enabled_status()){

            $can = false;
        }

        return apply_filters( 'mec_can_send_rsvp_invite_by_email', $can, $this->group_id, $event_id, $event_date, $users, $this );
    }

    public function get_cc_bcc_method(){

        $recipients_method = Settings::getInstance()->get_settings('booking_recipients_method');

        return trim($recipients_method) ? strtoupper($recipients_method) : 'BCC';
    }

    public function get_headers($recipients){

        $headers = array(
            'Content-Type: text/html; charset=UTF-8'
        );
        // Recipient Type
        $CCBCC = $this->get_cc_bcc_method();

        foreach($recipients as $recipient){
            // Skip if it's not a valid email
            if(trim($recipient) == '' or !filter_var($recipient, FILTER_VALIDATE_EMAIL)) continue;

            $headers[] = $CCBCC.': '.$recipient;
        }

        return $headers;
    }

    public function mec_sender_email_notification_filter(){

        // MEC Notification Sender Email
        add_filter('wp_mail_from_name', array($this, 'notification_sender_name'));
        add_filter('wp_mail_from', array($this, 'notification_sender_email'));
    }

    public function notification_sender_name($sender_name){

        $s_sender_name = Settings::getInstance()->get_settings('booking_sender_name');

        return !empty($s_sender_name) ? $s_sender_name : $sender_name;
    }

    public function notification_sender_email($sender_email){

        $s_sender_email = Settings::getInstance()->get_settings('booking_sender_email');

        return !empty($s_sender_email) ? $s_sender_email : $sender_email;
    }

    public function send( $event_id,$event_date, $users ){

        $rsvp_id = 0;
        if(!is_array($users)){

            return false;
        }

        $this->prepare( $event_id, $event_date);

        if(!$this->can_send_notification( $event_id, $event_date, $users )){

            return false;
        }

        $subject = $this->get_subject();
        $content = $this->get_content();
        $recipients = $this->get_all_recipients_emails();
        $headers = $this->get_headers($recipients);

        $this->mec_sender_email_notification_filter();
        // Do not send email twice!
        $done_emails = array();

        // Set Email Type to HTML
        add_filter('wp_mail_content_type', array(\MEC\Base::get_main(), 'html_email_type'));

        // Send the emails
        $mails = [];
        foreach($users as $attendee_or_email) {

            $attendee = is_array($attendee_or_email) ? $attendee_or_email : [
                'email' => $attendee_or_email
            ];
            $to = isset($attendee['email']) ? trim($attendee['email']) : $attendee_or_email;

            if(!trim($to) or in_array($to, $done_emails) or !filter_var($to, FILTER_VALIDATE_EMAIL)) {

                continue;
            }
            $message = $this->render_content($content, $rsvp_id, $attendee, $event_date);


            // Remove remained placeholders
            $message = preg_replace('/%%.*%%/', '', $message);

            $message = $this->add_template($message);

            // Filter the email
            $mail_arg = array(
                'to'            => $to,
                'subject'       => $subject,
                'message'       => $message,
                'headers'       => $headers,
                'attachments'   => array(),
            );

            $mail_arg = apply_filters('mec_rsvp_before_send_email', $mail_arg, $event_id, $this->group_id);

            $this->send_mail( $mail_arg );

            // $mails[] = $mail_arg;

            // For prevention of email repeat send
            $done_emails[] = $to;
        }

        // Remove the HTML Email filter
        remove_filter('wp_mail_content_type', array(\MEC\Base::get_main(), 'html_email_type'));

        return !empty($mails) ? $mails : $done_emails;
    }

    public function render_content($content, $rsvp_id, $attendee = array(), $timestamps = NULL){

        $rsvp_id = 0;

        $event_id = $this->event_id;
        $this->render_author($content,$rsvp_id,$attendee);

        // Site Data
        $this->render_site_data($content,$rsvp_id);

        // Event Data
        $this->render_event_data($content,$rsvp_id,$timestamps);

        $content = str_replace(
            '%%response_yes_link%%',
            $this->get_response_link('yes',$attendee),
            $content
        );

        $content = str_replace(
            '%%response_no_link%%',
            $this->get_response_link('no',$attendee),
            $content
        );

        $content = str_replace(
            '%%response_maybe_link%%',
            $this->get_response_link('maybe',$attendee),
            $content
        );

        return apply_filters( 'mec_render_content_email', $content, $this );
    }

    public function is_fill_form_required(){

        $status = $this->get_notification_settings( 'fill_form_is_required' );

        return (bool)$status;
    }

    public function get_response_link( $answer, $attendee ){

        $fill_form_is_required = $this->is_fill_form_required();

        $url = trim(get_permalink( $this->event_id ), '/');
        if($fill_form_is_required){

            $url .= '?rsvp_response='.$answer;

        }else{

            if(is_array($attendee)){

                $email = isset($attendee['email']) ? $attendee['email'] : '';
                $name = isset($attendee['name']) ? $attendee['name'] : '';

                $action = $this->event_id.$this->event_start.$answer.$email;
                $nonce = md5($this->nonce_base.$action);
                $data = $answer.'&&'.$this->event_id.'&&'.$this->event_start.'&&'.$email.'&&'.$name.'&&'.$nonce;
                $url .= '/rsvp-response/'.$data.'/';
            }else{

                $email = $attendee['email'];
                $url .= '/rsvp-response/'.$email.'/';
            }
        }

        return $url;
    }

}