<?php

namespace MEC_RSVP\RSVP\Notifications;

use MEC_RSVP\RSVP\EventRSVP;
use MEC_RSVP\RSVP\RSVPNotification;

class EmailVerification extends RSVPNotification{

    public $group_id = 'rsvp_verification_notification';

    public function get_verification_link(){

        $key = get_post_meta($this->rsvp_id, 'mec_verification_key', true);

        return trim(get_permalink($this->event_id), '/').'/rsvp-verify/'.$key.'/';
    }

    public function can_send_notification( $rsvp_id, $mode = 'auto', $resend = false ){

        $can = parent::can_send_notification($rsvp_id,$mode,$resend);
        if( !$can ){

            return $can;
        }

        $can_send_verify_email = EventRSVP::getInstance()->can_send_verify_email($this->event_id,$mode);
        if(!$can_send_verify_email){

            $can = false;
        }

        return $can;
    }

    public function render_content($content, $rsvp_id, $attendee = array(), $timestamps = NULL){

        $content = parent::render_content( $content, $rsvp_id, $attendee, $timestamps );

        $link = $this->get_verification_link();
        $content = str_replace('%%verification_link%%', $link, $content);
        $content = str_replace('%%link%%', $link, $content);

        return $content;
    }

}