<?php

namespace MEC_RSVP\RSVP;

use MEC\Singleton;
use MEC\Notifications\DisplayNotificationSettings;

class NotificationsSettings extends Singleton{

    public $base_field_name = "mec[notifications]";

    public function init(){

        add_action('mec_notifications_settings_before_editor',[ $this, 'custom_settings_fields_before_editor' ], 10, 2 );

        add_filter('mec-settings-item-notifications',[$this,'display_menu']);
        add_filter('mec_event_notifications',[$this,'display_event_settings']);
        add_filter('mec_settings_notifications_js_notifications',[$this,'global_js_render_textarea_settings']);
        add_action('mec_notifications_tabs_content',[$this,'display_settings']);


    }

    public function custom_settings_fields_before_editor( $group_id, $options ){

        $group_id = $group_id .'_notification';
        $send_to_admin = array(
            'rsvp_admin_notification',
            'rsvp_cancellation_notification',
            'rsvp_rejection_notification',
        );
        if(in_array($group_id,$send_to_admin)):
            ?>
                <div class="mec-form-row">
                    <div class="mec-col-12">
                        <input type="hidden" name="<?php echo $this->base_field_name ?>[<?php echo $group_id; ?>][send_to_admin]" value="0" />
                        <input type="checkbox" name="<?php echo $this->base_field_name ?>[<?php echo $group_id; ?>][send_to_admin]" value="1" id="mec_notifications_<?php echo $group_id; ?>_send_to_admin" <?php echo ((!isset($options['send_to_admin']) or (isset($options['send_to_admin']) and $options['send_to_admin'] == 1)) ? 'checked="checked"' : ''); ?> />
                        <label for="mec_notifications_<?php echo $group_id; ?>_send_to_admin"><?php _e('Send the email to admin', 'mec-rsvp'); ?></label>
                    </div>
                </div>
            <?php
        endif;

        $send_to_author = array(
            'rsvp_notification',
            'rsvp_admin_notification',
            'rsvp_cancellation_notification',
            'rsvp_rejection_notification',
        );
        if(in_array($group_id,$send_to_author)):
            ?>
                <div class="mec-form-row">
                    <div class="mec-col-12">
                        <input type="checkbox" name="<?php echo $this->base_field_name ?>[<?php echo $group_id; ?>][send_to_author]" value="1" id="mec_notifications_<?php echo $group_id; ?>_send_to_author" <?php echo ((isset($options['send_to_author']) and $options['send_to_author'] == 1) ? 'checked="checked"' : ''); ?> />
                        <label for="mec_notifications_<?php echo $group_id; ?>_send_to_author"><?php _e('Send the email to event author', 'mec-rsvp'); ?></label>
                    </div>
                </div>
            <?php
        endif;

        $send_to_organizer = array(
            'rsvp_notification',
            'rsvp_admin_notification',
            'rsvp_cancellation_notification',
            'rsvp_rejection_notification',
        );
        if(in_array($group_id,$send_to_organizer)):
            ?>
                <div class="mec-form-row">
                    <div class="mec-col-12">
                        <input type="checkbox" name="<?php echo $this->base_field_name ?>[<?php echo $group_id; ?>][send_to_organizer]" value="1" id="mec_notifications_<?php echo $group_id; ?>_send_to_organizer" <?php echo ((isset($options['send_to_organizer']) and $options['send_to_organizer'] == 1) ? 'checked="checked"' : ''); ?> />
                        <label for="mec_notifications_<?php echo $group_id; ?>_send_to_organizer"><?php _e('Send the email to event organizer', 'mec-rsvp'); ?></label>
                    </div>
                </div>
            <?php
        endif;

        $send_to_user = array(
            'rsvp_cancellation_notification',
            'rsvp_rejection_notification',
        );
        if(in_array($group_id,$send_to_user)):
            ?>
                <div class="mec-form-row">
                    <div class="mec-col-12">
                        <input type="checkbox" name="<?php echo $this->base_field_name ?>[<?php echo $group_id; ?>][send_to_user]" value="1" id="mec_notifications_<?php echo $group_id; ?>_send_to_user" <?php echo ((isset($options['send_to_user']) and $options['send_to_user'] == 1) ? 'checked="checked"' : ''); ?> />
                        <label for="mec_notifications_<?php echo $group_id; ?>_send_to_user"><?php _e('Send the email to the booked user', 'mec-rsvp'); ?></label>
                    </div>
                </div>
            <?php
        endif;

        $fill_form_is_required = array(
            'rsvp_invite_notification',
        );
        if(in_array($group_id,$fill_form_is_required)):
            ?>
                <div class="mec-form-row">
                    <div class="mec-col-12">
                        <input type="checkbox" name="<?php echo $this->base_field_name ?>[<?php echo $group_id; ?>][fill_form_is_required]" value="1" id="mec_notifications_<?php echo $group_id; ?>_fill_form_is_required" <?php echo ((isset($options['fill_form_is_required']) and $options['fill_form_is_required'] == 1) ? 'checked="checked"' : ''); ?> />
                        <label for="mec_notifications_<?php echo $group_id; ?>_fill_form_is_required"><?php _e('Force to fill out the form', 'mec-rsvp'); ?></label>
                    </div>
                </div>
            <?php
        endif;

        $answers = array(
			'yes' => __('Yes','mec-rsvp'),
			'no' => __('No','mec-rsvp'),
			'maybe' => __('Maybe','mec-rsvp'),
		);
        $custom_rsvp_text_for_answers = array(
            'rsvp_notification',
            'rsvp_admin_notification',
        );
        if(in_array($group_id,$custom_rsvp_text_for_answers)):
            foreach($answers as $answer_id => $answer_text):
                $k = 'custom_text_'.$answer_id;
                $content = isset($options[$k]) ? $options[$k] : '';
            ?>
                <div class="mec-form-row">
                    <div class="mec-col-3">
                        <label for="mec_notifications_<?php echo $group_id; ?>_custom_text_<?php echo $answer_id ?>"><?php echo __('Custom text for', 'mec-rsvp').' '.$answer_text; ?></label>
                    </div>
                    <div class="mec-col-9">
                        <textarea name="<?php echo $this->base_field_name ?>[<?php echo $group_id; ?>][<?php echo $k ?>]"><?php echo $content; ?></textarea>
                        <span class="mec-tooltip">
                            <div class="box left">
                                <h5 class="title"><?php _e('Custom text', 'mec-rsvp'); ?></h5>
                                <div class="content"><p><?php esc_attr_e('Your text will be replaced based on %%rsvp_custom_text%% and the user\'s response', 'mec-rsvp'); ?></p></div>
                            </div>
                            <i title="" class="dashicons-before dashicons-editor-help"></i>
                        </span>
                    </div>

                </div>
            <?php
            endforeach;
        endif;
    }

    public function get_placeholders($group_id){

        $placeholders = array(
            '%%blog_name%%' => __('Your website title', 'mec-rsvp'),
            '%%blog_url%%' => __('Your website URL', 'mec-rsvp'),
            '%%blog_description%%' => __('Your website description', 'mec-rsvp'),

            '%%first_name%%' => __('First name of attendee', 'mec-rsvp'),
            '%%last_name%%' => __('Last name of attendee', 'mec-rsvp'),
            '%%user_email%%' => __('Email of attendee', 'mec-rsvp'),

            '%%rsvp_id%%' => __('RSVP ID', 'mec-rsvp'),
            '%%rsvp_response%%' => __('RSVP Response', 'mec-rsvp'),
            '%%rsvp_order_time%%' => __('Date and time of RSVP', 'mec-rsvp'),
            '%%rsvp_date%%' => __('RSVP date of event', 'mec-rsvp'),
            '%%rsvp_time%%' => __('RSVP time of event', 'mec-rsvp'),
            '%%rsvp_datetime%%' => __('RSVP date and time of event', 'mec-rsvp'),

            '%%event_title%%' => __('Event title', 'mec-rsvp'),
            '%%event_description%%' => __('Event Description', 'mec-rsvp'),
            '%%event_tags%%' => __('Event Tags', 'mec-rsvp'),
            '%%event_labels%%' => __('Event Labels', 'mec-rsvp'),
            '%%event_categories%%' => __('Event Categories', 'mec-rsvp'),
            '%%event_cost%%' => __('Event Cost', 'mec-rsvp'),
            '%%event_link%%' => __('Event link', 'mec-rsvp'),
            '%%event_start_date%%' => __('Event Start Date', 'mec-rsvp'),
            '%%event_end_date%%' => __('Event End Date', 'mec-rsvp'),
            '%%event_start_time%%' => __('Event Start Time', 'mec-rsvp'),
            '%%event_end_time%%' => __('Event End Time', 'mec-rsvp'),
            '%%event_timezone%%' => __('Event Timezone', 'mec-rsvp'),
            '%%event_speaker_name%%' => __('Speaker name of RSVP event', 'mec-rsvp'),
            '%%event_organizer_name%%' => __('Organizer name of RSVP event', 'mec-rsvp'),
            '%%event_organizer_tel%%' => __('Organizer tel of RSVP event', 'mec-rsvp'),
            '%%event_organizer_email%%' => __('Organizer email of RSVP event', 'mec-rsvp'),
            '%%event_organizer_url%%' => __('Organizer url of RSVP event', 'mec-rsvp'),
            '%%event_other_organizers_name%%' => __('Additional organizers name of RSVP event', 'mec-rsvp'),
            '%%event_other_organizers_tel%%' => __('Additional organizers tel of RSVP event', 'mec-rsvp'),
            '%%event_other_organizers_email%%' => __('Additional organizers email of RSVP event', 'mec-rsvp'),
            '%%event_other_organizers_url%%' => __('Additional organizers url of RSVP event', 'mec-rsvp'),
            '%%event_location_name%%' => __('Location name of RSVP event', 'mec-rsvp'),
            '%%event_location_address%%' => __('Location address of RSVP event', 'mec-rsvp'),
            '%%event_other_locations_name%%' => __('Additional locations name of RSVP event', 'mec-rsvp'),
            '%%event_other_locations_address%%' => __('Additional locations address of RSVP event', 'mec-rsvp'),
            '%%event_featured_image%%' => __('Featured image of RSVP event', 'mec-rsvp'),
            '%%event_more_info%%' => __('Event more info link', 'mec-rsvp'),
            '%%event_other_info%%' => __('Event other info link', 'mec-rsvp'),
            '%%online_link%%' => __('Event online link', 'mec-rsvp'),

            '%%attendees_full_info%%' => __('Full Attendee info such as RSVP form data, name, email etc.', 'mec-rsvp'),

            '%%total_attendees%%' => __('Total attendees of current RSVP', 'mec-rsvp'),

            '%%cancellation_link%%' => __('RSVP cancellation link.', 'mec-rsvp'),
        );

        switch( $group_id ){

            case 'rsvp':
            case 'rsvp_admin':

                $placeholders['%%rsvp_custom_text%%']   = __('RSVP Custom text based on user response.', 'mec-rsvp');
                $placeholders['%%rsvp_is_creation_by_invite%%']   = __('RSVP created by invitation? yes|no.', 'mec-rsvp');

                break;
            case 'rsvp_verification':

                $placeholders['%%verification_link%%'] = __('RSVP verification link.', 'mec-rsvp');

                break;
            case 'rsvp_cancellation':

                $placeholders['%%admin_link%%'] = __('Admin RSVP management link.', 'mec-rsvp');

                break;
            case 'rsvp_invite':

                unset($placeholders['%%rsvp_id%%']);
                unset($placeholders['%%rsvp_response%%']);
                unset($placeholders['%%rsvp_order_time%%']);
                unset($placeholders['%%rsvp_date%%']);
                unset($placeholders['%%rsvp_time%%']);
                unset($placeholders['%%rsvp_datetime%%']);
                unset($placeholders['%%attendees_full_info%%']);
                unset($placeholders['%%cancellation_link%%']);
                unset($placeholders['%%total_attendees%%']);

                $placeholders['%%response_yes_link%%']   = __('RSVP set Response Yes link.', 'mec-rsvp');
                $placeholders['%%response_no_link%%']    = __('RSVP set Response No link.', 'mec-rsvp');
                $placeholders['%%response_maybe_link%%'] = __('RSVP set Response Maybe link.', 'mec-rsvp');

                break;

        }

        return $placeholders;
    }

    public function get_default_settings($group_id){

        if(!$group_id){

            return [];
        }

        $group_id = str_replace('_notification','',$group_id);
        $settings_groups = $this->get_sections_settings();

        return $settings_groups[$group_id]['default_options'] ? $settings_groups[$group_id]['default_options'] : [];
    }

    public function get_sections_settings(){

        return array(
            'rsvp' => array(
                'group_id' => 'rsvp',
                'section_title' => __('RSVP', 'mec-rsvp'),
                'enable_options_text' => __('Enable RSVP notification', 'mec-rsvp'),
                'enable_options_description' => __('Sent to attendee after RSVP to notify them.', 'mec-rsvp'),
                'base_field_name' => $this->base_field_name,
                'default_options' => [
                    'status'=>'1',

                    'subject' => __('Your RSVP is received.','mec-rsvp'),
                    'recipients'=>'',
                    'content'=>__("Hello %%name%%,

                        Your RSVP is received. We will check and confirm your RSVP as soon as possible.
                        Thank you for your patience.

                        Regards,
                        %%blog_name%%",
                        'mec-rsvp'
                    ),
                ],
            ),
            'rsvp_admin' => array(
                'group_id' => 'rsvp_admin',
                'section_title' => __('RSVP Admin', 'mec-rsvp'),
                'enable_options_text' => __('Enable RSVP Admin notification', 'mec-rsvp'),
                'enable_options_description' => __('Sent to attendee after RSVP Admin to notify them.', 'mec-rsvp'),
                'base_field_name' => $this->base_field_name,
                'default_options' => [
                    'status'=>'1',

                    'subject' => __('A new RSVP is received.','mec-rsvp'),
                    'recipients'=>'',
                    'content'=>__("Dear Admin,

                        A new RSVP is received. Please check and confirm it as soon as possible.

                        %%admin_link%%

                        %%attendees_full_info%%

                        Regards,
                        %%blog_name%%",
                        'mec-rsvp'
                    ),
                ],
            ),
            'rsvp_confirmation' => array(
                'group_id' => 'rsvp_confirmation',
                'section_title' => __('RSVP Confirmation', 'mec-rsvp'),
                'enable_options_text' => __('Enable RSVP Confirmation notification', 'mec-rsvp'),
                'enable_options_description' => __('Sent to attendee after RSVP Confirmation to notify them.', 'mec-rsvp'),
                'base_field_name' => $this->base_field_name,
                'default_options' => [
                    'status'=>'1',

                    'subject' => __('Your RSVP is confirmed.','mec-rsvp'),
                    'recipients'=>'',
                    'content'=>__("Hi %%name%%,

                        Your booking is confirmed. You should be available at %%rsvp_date%% in %%event_location_address%%.

                        You can contact the event organizer by calling %%event_organizer_tel%%.

                        Regards,
                        %%blog_name%%",
                        'mec-rsvp'
                    ),
                ],
            ),
            'rsvp_rejection' => array(
                'group_id' => 'rsvp_rejection',
                'section_title' => __('RSVP Rejection', 'mec-rsvp'),
                'enable_options_text' => __('Enable RSVP Rejection notification', 'mec-rsvp'),
                'enable_options_description' => __('Sent to attendee after RSVP Rejection to notify them.', 'mec-rsvp'),
                'base_field_name' => $this->base_field_name,
                'default_options' => [
                    'status'=>'0',

                    'send_to_admin'=>'0',
                    'send_to_organizer'=>'1',
                    'send_to_user'=>'1',

                    'subject' => __('Your RSVP got rejected!','mec-rsvp'),
                    'recipients'=>'',
                    'content'=>__("Hi %%name%%,

                        For your information, your RSVP for %%event_title%% at %%rsvp_date%% is rejected.

                        Regards,
                        %%blog_name%%",
                        'mec-rsvp'
                    ),
                ],
            ),
            'rsvp_verification' => array(
                'group_id' => 'rsvp_verification',
                'section_title' => __('RSVP Verification', 'mec-rsvp'),
                'enable_options_text' => __('Enable RSVP Verification notification', 'mec-rsvp'),
                'enable_options_description' => __('Sent to attendee after RSVP Verification to notify them.', 'mec-rsvp'),
                'base_field_name' => $this->base_field_name,
                'default_options' => [
                    'status'=>'1',

                    'subject' => __('Please verify your RSVP.','mec-rsvp'),
                    'recipients'=>'',
                    'content'=>__("Hi %%name%%,

                        Please verify your RSVP by clicking on the following link:

                        %%verification_link%%

                        Regards,
                        %%blog_name%%",
                        'mec-rsvp'
                    ),
                ],
            ),
            'rsvp_cancellation' => array(
                'group_id' => 'rsvp_cancellation',
                'section_title' => __('RSVP Cancellation', 'mec-rsvp'),
                'enable_options_text' => __('Enable RSVP Cancellation notification', 'mec-rsvp'),
                'enable_options_description' => __('Sent to attendee after RSVP Cancellation to notify them.', 'mec-rsvp'),
                'base_field_name' => $this->base_field_name,
                'default_options' => [
                    'status' => '0',

                    'send_to_admin' => '1',
                    'send_to_organizer' => '0',
                    'send_to_user' => '0',

                    'subject' => __('Your RSVP is canceled.','mec-rsvp'),
                    'recipients'=>'',
                    'content'=>__("Hi %%name%%,

                        For your information, your RSVP for %%event_title%% at %%rsvp_date%% is canceled.

                        Regards,
                        %%blog_name%%",
                        'mec-rsvp'
                    ),
                ],
            ),
            'rsvp_invite' => array(
                'group_id' => 'rsvp_invite',
                'section_title' => __('RSVP Invite', 'mec-rsvp'),
                'enable_options_text' => __('Enable RSVP Invite notification', 'mec-rsvp'),
                'enable_options_description' => __('Sent to attendee after RSVP Invitation to notify them.', 'mec-rsvp'),
                'base_field_name' => $this->base_field_name,
                'default_options' => [
                    'status' => '1',

                    'fill_form_is_required' => '0',

                    'subject' => __('RSVP Invite.','mec-rsvp'),
                    'recipients'=>'',
                    'content'=>__("Hi %%name%%,

                        You have been invited to %%event_title%%.
                        Please click on the links below to submit a response

                        yes:
                        %%response_yes_link%%

                        no:
                        %%response_no_link%%

                        maybe:
                        %%response_maybe_link%%

                        Regards,
                        %%blog_name%%",
                        'mec-rsvp'
                    ),
                ],
            ),
        );
    }

    public function display_menu($notifications_items){

        $settings_sections = $this->get_sections_settings();
        foreach($settings_sections as $group_id => $section_args){

            $title = $section_args['section_title'];
            $group_id = $group_id . '_notification_section';
            $notifications_items[$title] = $group_id;
        }

        return $notifications_items;
    }

    public function display_event_settings($notifications_items){

        $settings_sections = $this->get_sections_settings();
        foreach($settings_sections as $group_id => $section_args){

            $title = $section_args['section_title'];
            $group_id = $group_id . '_notification';
            $notifications_items[$group_id] = array(
                'label' => $title,
            );
        }

        return $notifications_items;
    }

    public function global_js_render_textarea_settings($notifications_items){

        $settings_sections = $this->get_sections_settings();
        foreach($settings_sections as $group_id => $section_args){

            $group_id = $group_id . '_notification';
            $notifications_items[$group_id] = $group_id;
        }

        return $notifications_items;
    }

    public function display_settings($notifications){

        $settings_sections = $this->get_sections_settings();

        $factory = new DisplayNotificationSettings();
        foreach($settings_sections as $group_id => $atts){

            $default_options = isset($atts['default_options']) && is_array($atts['default_options']) ? $atts['default_options'] : [];
            $atts['options'] = isset($notifications[$group_id . '_notification']) ? $notifications[$group_id . '_notification'] : $default_options;
            $atts['placeholders'] = $this->get_placeholders( $group_id );
            $factory->output($atts);
        }
    }
}