<?php

namespace MEC_RSVP\RSVP;

use MEC\Singleton;

class PostTypeFactory extends Singleton {

	public function init() {

		add_action( 'init', array( $this, 'register_post_type' ) );
		add_action( 'admin_head', array( $this, 'enqueue' ) );
		add_action( 'mec_rsvp_meta_created_or_updated', [ __CLASS__, 'remove_rsvp_emails' ], 99, 3 );

		add_filter( 'mec_rsvp_confirmed_status_value', [ __CLASS__, 'filter_confirmation_status' ], 99, 4 );
		add_filter( 'mec_rsvp_verified_status_value', [ __CLASS__, 'filter_verification_status' ], 99, 4 );

		add_action( 'mec_rsvp_verified', [ $this, 'update_attendee_status' ], 10, 4 );
        add_action( 'mec_rsvp_confirmed', [ $this, 'update_attendee_status' ], 10, 4 );

		add_action( 'wp_trash_post', [ $this, 'delete_attendees' ] );
		add_action( 'delete_post', [ $this, 'delete_attendees' ] );
	}

	public function enqueue(){

		?>
		<style>
			.menu-icon-mec_rsvp img{
				width:20px;
			}
		</style>

		<?php
	}

	public function register_post_type() {

		$labels = array(
			'name'               => esc_html__( 'MEC RSVPs', 'mec-rsvp' ),
			'all_items'          => esc_html__( 'RSVPs', 'mec-rsvp' ),
			'singular_name'      => esc_html__( 'RSVP', 'mec-rsvp' ),
			'add_new'            => esc_html__( 'Add New', 'mec-rsvp' ),
			'add_new_item'       => esc_html__( 'Add New RSVP', 'mec-rsvp' ),
			'edit_item'          => esc_html__( 'Edit RSVP', 'mec-rsvp' ),
			'new_item'           => esc_html__( 'New RSVP', 'mec-rsvp' ),
			'view_item'          => esc_html__( 'View RSVP', 'mec-rsvp' ),
			'search_items'       => esc_html__( 'Search RSVP', 'mec-rsvp' ),
			'not_found'          => esc_html__( 'No RSVP found', 'mec-rsvp' ),
			'not_found_in_trash' => esc_html__( 'No RSVP found in Trash', 'mec-rsvp' ),
			'show_in_rest'       => true,
		);

		$capabilities = array(
			'read'                   => 'mec_rsvp',
			'read_post'              => 'mec_rsvp',
			'read_private_posts'     => 'mec_rsvp',
			'create_post'            => 'mec_add_rsvp',
			'create_posts'           => 'mec_add_rsvp',
			'edit_post'              => 'mec_rsvp',
			'edit_posts'             => 'mec_rsvp',
			'edit_private_posts'     => 'mec_rsvp',
			'edit_published_posts'   => 'mec_rsvp',
			'edit_others_posts'      => 'mec_rsvp',
			'publish_posts'          => 'mec_rsvp',
			'delete_post'            => 'mec_rsvp',
			'delete_posts'           => 'mec_rsvp',
			'delete_private_posts'   => 'mec_rsvp',
			'delete_published_posts' => 'mec_rsvp',
			'delete_others_posts'    => 'mec_rsvp',
		);

		$args = array(
			'public'              => false,
			'show_ui'             => true,
			'show_in_menu'        => true,
			'show_in_admin_bar'   => false,
			'has_archive'         => false,
			'exclude_from_search' => true,
			'publicly_queryable'  => false,
			'rewrite'             => array( 'slug' => 'mec_rsvp' ),
			'supports'            => array( 'title', 'author' ),
			'show_in_rest'        => true,
			'show_in_menu'        => true,
			'labels'              => $labels,
			// 'capabilities'        => $capabilities,
			// 'map_meta_cap'        => false,
			'menu_icon' => MEC_RSVP_PU_IMG.'/menu-icon.svg',
			'menu_position' => 27,
		);

		$args = apply_filters( 'mec_rsvp_register_post_type_args', $args );

		register_post_type( 'mec_rsvp', $args );
	}

	public static function remove_rsvp_emails($rsvp_id, $rsvp, $new_rsvp){

		$event_id = isset($rsvp['event_id']) ? $rsvp['event_id'] : 0;
		$event_date = isset($rsvp['event_date']) ? $rsvp['event_date'] : 0;

		if(!$event_id || !$event_date){

			return;
		}

		$cache_key = $event_id .'-'.$event_date;
		$group_id = 'mec-rsvp-emails-for-event';
		$transient = $group_id .'-'.$cache_key;
		$p_transient = $group_id.'-'.$event_id.'-';

		delete_transient( $transient );
		delete_transient( $p_transient );
	}

	public static function filter_confirmation_status( $status, $mode, $rsvp_id , $rsvp_class ){

		if('auto' !== $mode){

			return $status;
		}

		$event_id = $rsvp_class->get_event_id();

		$can_auto_confirm = EventRSVP::getInstance()->get_auto_confirmation_status($event_id);

		if($can_auto_confirm){

			return 1;
		}

		return $status;
	}

	public static function filter_verification_status( $status, $mode, $rsvp_id , $rsvp_class ){

		if('auto' !== $mode){

			return $status;
		}

		$event_id = $rsvp_class->get_event_id();

		$can_auto_verify = EventRSVP::getInstance()->get_auto_verification_status($event_id);

		if($can_auto_verify){

			return 1;
		}

		return $status;
	}

	public function update_attendee_status( $rsvp_id, $old_status, $status, $mode ){

		$action = current_action();

		switch( $action ){

			case 'mec_rsvp_verified':

				\MEC\Attendees\Attendees::getInstance()->update_verification_status( $status, $rsvp_id );

				break;
			case 'mec_rsvp_confirmed':

				\MEC\Attendees\Attendees::getInstance()->update_confirmation_status( $status, $rsvp_id );

			break;
		}
	}

	public function delete_attendees( $post_id ){

		if( 'mec_rsvp' !== get_post_type( $post_id ) ){

			return;
		}

		$action = current_action();

		switch( $action ){

			case 'wp_trash_post':

				\MEC\Attendees\Attendees::getInstance()->update_verification_status( '-1', $post_id );
				\MEC\Attendees\Attendees::getInstance()->update_confirmation_status( '-1', $post_id );

				break;

			case 'delete_post':

				\MEC\Attendees\Attendees::getInstance()->delete( $post_id );

				break;
		}
	}

}
