<?php

namespace MEC_RSVP\RSVP;

use MEC\Books\Book;
use MEC\Singleton;
use MEC\Attendees\Attendees;

class RSVP extends Book{

    /**
	 * Constructor
	 *
	 * @param int|\WP_Post|array $data
	 */
    public function __construct( $data, $load_post = true  ) {

		parent::__construct( $data, $load_post );
		$this->type = 'rsvp';
	}



	/**
	 * @return string
	 */
	public function get_answer() {

		return $this->get_meta( 'mec_answer' );
	}

	/**
	 * @return string
	 */
	public function get_answer_text() {

		$answer = $this->get_meta( 'mec_answer' );

		$answer_text = $answer;
		switch($answer){
			case 'no':
				$answer_text = __('No','mec-rsvp');
				break;
			case 'yes':
				$answer_text = __('Yes','mec-rsvp');
				break;
			case 'maybe':
				$answer_text = __('Maybe','mec-rsvp');
				break;
		}

		return $answer_text;
	}

	public function get_creation_type(){

		return $this->get_meta( 'mec_creation_by_invite' );
	}

	public function get_creation_type_text(){

		$creation_by_invite = $this->get_creation_type();

		$answer_text = '';
		switch($creation_by_invite){
			case 'yes':
				$answer_text = __('Created by invitation','mec-rsvp');
				break;
			case 'no':
			default:
				$answer_text = '';
				break;
		}

		return $answer_text;
	}



	/**
	 * @return int
	 */
	public function get_attendees_count() {

		$attendees = $this->get_attendees();
		return (int)array_sum(array_column($attendees,'count'));
	}

	/**
	 * @return bool
	 */
	public function get_attendee_first_for_all() {

		return (bool)$this->get_meta( 'mec_first_for_all' );
	}

	/**
	 * @return array
	 */
	public function get_fixed_fields() {

		return $this->get_meta( 'mec_fixed_fields' );
	}

	/**
	 * @return string
	 */
	public function get_create_datetime() {

		return $this->get_meta( 'mec_create_datetime' );
	}

	/**
	 * @return string $start_timestamp:$end_timestamp | ['start'=> '','end' => '']
	 */
	public function get_event_times( $type = null ) {

		$data = $this->get_meta( 'mec_event_time' );
		if ( !is_null( $type ) ) {

			$data = explode( ':', $data );
		}

		if ( 'start' === $type ) {

			$data = isset( $data[0] ) ? $data[0] : '';
		} elseif ( 'end' === $type ) {

			$data = isset( $data[1] ) ? $data[1] : '';
		}

		return $data;
	}

	public function get_options(){

		$rsvp_options = get_post_meta($this->ID, 'mec_rsvp', true);

		return is_array($rsvp_options) ? $rsvp_options : [];
	}

	/**
	 * @return array //TODO: Convert to Attendee[]
	 */
	public function get_attendees() {

		$rsvp_id = $this->get_id();
		$event_id = $this->get_event_id();
		$occurrence = $this->get_event_times('start');
		return Attendees::getInstance()->get_attendees($rsvp_id,$event_id,$occurrence);
	}

	public function get_attendees_by_detail_for_each(){

		$attendees = $this->get_attendees();

		if( !empty($attendees) && is_array($attendees)){

			foreach($attendees as $attendee){

				$count = $attendee['count'];
				$attendee['count'] = 1;
				for($i = 1; $i <= $count; $i++){

					$new_attendees[] = $attendee;
				}
			}

			$attendees = $new_attendees;
		}

		return $attendees;
	}

	/**
	 * @return string
	 */
	public function get_creator_email(){

		return $this->get_meta( 'mec_primary_attendee_email' );
	}

}