<?php

namespace MEC_RSVP\RSVP;

use MEC\Singleton;
use MEC_RSVP\RSVP\Notifications\EmailAdmin;
use MEC_RSVP\RSVP\Notifications\EmailCancellation;
use MEC_RSVP\RSVP\Notifications\EmailConfirmation;
use MEC_RSVP\RSVP\Notifications\EmailCreation;
use MEC_RSVP\RSVP\Notifications\EmailRejection;
use MEC_RSVP\RSVP\Notifications\EmailVerification;

class RSVPNotifications extends Singleton {

    public function init(){

        add_action( 'mec_rsvp_verified', [ $this, 'send_notification_verification' ], 10, 4 );
        add_action( 'mec_rsvp_confirmed', [ $this, 'send_notification_confirmation' ], 10, 4 );

        add_action( 'mec_rsvp_created', [ $this, 'send_notification_rsvp_creation' ] );
        add_action( 'mec_rsvp_meta_created_or_updated', [ $this, 'send_notification_rsvp_creation' ] );

        add_action( 'mec_rsvp_created', [ $this, 'send_notification_rsvp_creation_to_admin' ] );
        add_action( 'mec_rsvp_meta_created_or_updated', [ $this, 'send_notification_rsvp_creation_to_admin' ] );

    }

    public function send_notification_verification($rsvp_id, $old_status, $status, $mode){

        $resend_verification_email = isset($_POST['resend_verification_email']) ? sanitize_text_field($_POST['resend_verification_email']) : false;

        switch ( $status ) {
			case 'canceled':
			case '-1':

                $send_notification_handler = new EmailCancellation();
                $send_notification_handler->send( $rsvp_id, $mode, $resend_verification_email );

				break;
            case 'verified':
                case '1':

                    $send_notification_handler = new EmailVerification();
                    $send_notification_handler->send( $rsvp_id, $mode, $resend_verification_email );

                    break;
			case 'waiting':
			case '0':
                    $send_notification_handler = new EmailVerification();
                    $send_notification_handler->send( $rsvp_id, $mode, $resend_verification_email );
				break;

		}

    }

    public function send_notification_confirmation( $rsvp_id, $old_status, $status, $mode ){

        $resend_confirmation_email = isset($_POST['resend_confirmation_email']) ? sanitize_text_field($_POST['resend_confirmation_email']) : false;
        switch ( $status ) {
			case 'reject':
			case '-1':

				$send_notification_handler = new EmailRejection();
                $send_notification_handler->send( $rsvp_id, $mode, $resend_confirmation_email );

				break;
            case 'confirm':
            case '1':

                $send_notification_handler = new EmailConfirmation();
                $send_notification_handler->send( $rsvp_id, $mode, $resend_confirmation_email );

                break;
			case 'pending':
			case '0':

				break;

		}
    }

    public function send_notification_rsvp_creation( $rsvp_id ){

        $resend_confirmation_email = false;
        if('mec_rsvp_meta_created_or_updated' === current_action()){

            $resend_confirmation_email = isset($_POST['resend_confirmation_email']) ? sanitize_text_field($_POST['resend_confirmation_email']) : false;
        }

        $send_notification_handler = new EmailCreation();
        $send_notification_handler->send( $rsvp_id, 'auto', $resend_confirmation_email);
    }

    public function send_notification_rsvp_creation_to_admin( $rsvp_id ){

        $resend_confirmation_email = false;
        if('mec_rsvp_meta_created_or_updated' === current_action()){

            $resend_confirmation_email = isset($_POST['resend_confirmation_email']) ? sanitize_text_field($_POST['resend_confirmation_email']) : false;
        }

        $send_notification_handler = new EmailAdmin();
        $send_notification_handler->send( $rsvp_id, 'auto', $resend_confirmation_email );
    }
}
