<?php


namespace MEC_RSVP\RSVP;

use MEC\Events\Event;
use MEC\Attendees\Attendees;
use MEC\Settings\Settings;
use MEC\Singleton;
use MEC\Forms\CustomForm;
use MEC_RSVP\User;

class RSVPs extends Singleton {

	public function get_user_rsvp_limit($event_id){

        $unlimited = false;
        $limit = 12;
        $mec_settings = Settings::getInstance()->get_settings();
        $rsvp_options = get_post_meta($event_id, 'mec_rsvp', true);

        if(isset($rsvp_options['rsvp_user_limit_unlimited']) and !trim($rsvp_options['rsvp_user_limit_unlimited'])){
            $limit = (isset($rsvp_options['rsvp_user_limit']) and trim($rsvp_options['rsvp_user_limit'])) ? trim($rsvp_options['rsvp_user_limit']) : $limit;
        } else {
            if(!isset($mec_settings['rsvp_limit']) or (isset($mec_settings['rsvp_limit']) and !trim($mec_settings['rsvp_limit']))){
				$unlimited = true;
			} else {
				$limit = trim($mec_settings['rsvp_limit']);
			}
        }

        return array($limit, $unlimited);
    }

	public function add_rsvp($rsvp){
		unset($rsvp['ID']);

		return $this->add_or_update_rsvp($rsvp);
	}

	public function update_meta($rsvp_id, $rsvp, $new_rsvp = 0){

		$first_for_all = isset($rsvp['first_for_all']) ? $rsvp['first_for_all'] : 0;
		$attendees = isset($rsvp['attendees']) && is_array($rsvp['attendees']) ? $rsvp['attendees'] : array();
		$fixed_fields = isset($rsvp['fixed']) && is_array($rsvp['fixed']) ? $rsvp['fixed'] : array();
		$event_date = isset($rsvp['event_date']) ? $rsvp['event_date'] : '';
		$answer = isset($rsvp['answer']) ? $rsvp['answer'] : '';
		$attendee_ip = \MEC\Base::get_main()->get_client_ip();
		$creation_by_invite = isset($rsvp['creation_by_invite']) ? $rsvp['creation_by_invite'] : false;

		$event_id = isset($rsvp['event_id']) ? $rsvp['event_id'] : '';
		$event = new Event( $event_id );
		$event_end_date = $event->get_end_timestamp_occurrence( $event_date );

		foreach($attendees as $attendee_id => $attendee){

			$attendees[$attendee_id] = array(
				'first_name' => isset($attendee['first_name']) ? $attendee['first_name'] : '',
				'last_name' => isset($attendee['last_name']) ? $attendee['last_name'] : '',
				'email' => isset($attendee['mec_email']) ? $attendee['mec_email'] : $attendee['email'],
				'data' => isset($attendee['reg']) ? $attendee['reg'] : [],
			);
		}

		Attendees::getInstance()->update_attendees( $rsvp_id, $event_id, $event_date, $attendees );

		$first_attendee = current($attendees);
		$primary_attendee_email = isset($first_attendee['email']) ? sanitize_email($first_attendee['email']) : '';

		$meta = array(
			'mec_event_id' => $event_id,
			'mec_event_date' => $event_date,
			'mec_event_time' => $event_date.':'.$event_end_date,
			'mec_first_for_all' => $first_for_all,
			'mec_answer' => $answer,
			'mec_create_datetime' => date('YmdHis', current_time('timestamp', 0)),
			//mec_attention_time
			'mec_user_ip' => $attendee_ip,
			'mec_fixed_fields' => $fixed_fields,
			'mec_primary_attendee_email' => $primary_attendee_email,
		);

		if($creation_by_invite){
			$meta['mec_creation_by_invite'] = $creation_by_invite;
		}

		$verification_key = get_post_meta($rsvp_id, 'mec_verification_key', true);
		if(!$verification_key){

			update_post_meta($rsvp_id, 'mec_verification_key', md5(time().mt_rand(10000, 99999)));
		}

		$cancellation_key = get_post_meta($rsvp_id, 'mec_cancellation_key', true);
		if(!$cancellation_key){

			update_post_meta($rsvp_id, 'mec_cancellation_key', md5(time().mt_rand(10000, 99999)));
		}

		foreach($meta as $k => $v){

			update_post_meta( $rsvp_id, $k, $v );
		}

		// Map Data
		$user = User::instance()->rsvp($rsvp_id);
		$user_id = is_a($user,\WP_User::class) ? $user->ID : 0;
		if($user_id){

			if($event_id){

				$group_id = 'rsvp_'.$answer;
				$reg_fields = CustomForm::getInstance()->get_reg_fields($group_id);
				$reg = isset($first_attendee['data']) ? $first_attendee['data'] : [];
				foreach($reg as $reg_id => $reg_value){

					$reg_field = (isset($reg_fields[$reg_id]) ? $reg_fields[$reg_id] : array());
					if(isset($reg_field['mapping']) and trim($reg_field['mapping'])){

						update_user_meta($user_id, $reg_field['mapping'], (is_array($reg_value) ? implode(',', $reg_value) : $reg_value));
					}
				}
			}
		}

		do_action('mec_rsvp_meta_created_or_updated',$rsvp_id, $rsvp, $new_rsvp );
	}

	public function add_or_update_rsvp($rsvp, $mode = 'auto'){

		$attendees = isset($rsvp['attendees']) && is_array($rsvp['attendees']) ? $rsvp['attendees'] : array();
		foreach($attendees as $k => $attendee){

			$email = isset($attendee['mec_email']) ? $attendee['mec_email'] : '';
			$email = empty($email) && isset($attendee['email']) ? $attendee['email'] : $email;
			$first_name = isset($attendee['first_name']) ? $attendee['first_name'] : '';
			$last_name = isset($attendee['last_name']) ? $attendee['last_name'] : '';
			$attendees[$k] = array(
				'email' => $email,
				'first_name' => $first_name,
				'last_name' => $last_name,
				'name' => $first_name . ' ' . $last_name,
				'reg' => isset($attendee['reg']) ? $attendee['reg'] : [],
			);
		}

		$first_attendee = current($attendees);
		$first_attendee['name'] = $first_attendee['first_name'] .' '.$first_attendee['last_name'];
		$rsvp['attendees'] = $attendees;

        if(!isset( $rsvp['author'] ) || $rsvp['author'] == null || get_current_user_id() ==0){
            $user = get_user_by( 'email', $email );
            if( isset($user->ID) && $user->ID!=null ){
                $rsvp['author'] = $user->ID;
            } else{
                $password = wp_generate_password( 12, false );
                $rsvp['author'] = wp_create_user( $email, $password, $email );
            }
        }

		$post_arr = array(
			'post_status' => 'publish',
			'post_title'  => isset( $rsvp['title'] ) ? $rsvp['title'] : $first_attendee['name'] .' '.$first_attendee['email'],
			'post_type'   => 'mec_rsvp',
			'post_author' => isset( $rsvp['author'] ) ? $rsvp['author'] : get_current_user_id(),
		);

		$confirm_status = isset($rsvp['confirm_status']) ? $rsvp['confirm_status'] : null;
		$verification_status = isset($rsvp['verification_status']) ? $rsvp['verification_status'] : null;

		if ( isset( $rsvp['ID'] ) && $rsvp['ID'] ) {
			//Update RSVP
			$post_arr['ID'] = $rsvp['ID'];
			$rsvp_id = wp_update_post( $post_arr );

			$this->update_meta($rsvp_id,$rsvp);
		} else {
			//Insert RSVP
			$rsvp_id = wp_insert_post( $post_arr );
			$this->update_meta($rsvp_id,$rsvp);

			if( is_null( $confirm_status ) ){

				$confirm_status = 0;
			}

			if( is_null( $verification_status ) ){

				$verification_status = 0;
			}
		}

		if($rsvp_id && is_numeric($rsvp_id)){

			$event_id = isset($rsvp['event_id']) ? $rsvp['event_id'] : '';
			$user_id = User::instance()->register($first_attendee,['event_id' => $event_id]);
			update_user_meta( $user_id, 'first_name', $first_attendee['first_name'] );
			update_user_meta( $user_id, 'last_name', $first_attendee['last_name'] );

			User::instance()->assign($rsvp_id, $user_id);

			$rsvpObject = new RSVP($rsvp_id);
			if(!is_null($confirm_status)){
				$rsvpObject->set_confirm_status($confirm_status,$mode);
			}

			if(!is_null($verification_status)){
				$rsvpObject->set_verification_status($verification_status,$mode);
			}
		}

		if(isset( $rsvp['ID'] ) && $rsvp['ID']){

			do_action('mec_rsvp_updated',$rsvp_id);
		}else{

			do_action('mec_rsvp_created',$rsvp_id);
		}

		return $rsvp_id;
	}
}
