<?php

namespace MEC_RSVP\RSVP;

use MEC\Events\EventsQuery;
use MEC_RSVP\RSVP\Notifications\EmailInvite;

class SendInvitationPage{

    public static function send_invitation_emails_by_ajax(){

        $r = array(
            'success' => false,
        );
        $nonce = isset($_POST['nonce']) ? sanitize_text_field( $_POST['nonce'] ) : false;
        if(!$nonce || !wp_verify_nonce( $nonce, 'mec_send_invitation_email_nonce' )){

            $r['error_message'] = __('Please refresh the page and try again','mec-rsvp');
            wp_send_json( $r );
        }

        $event_id = isset($_POST['event_id']) && is_numeric($_POST['event_id']) ? (int)$_POST['event_id'] : false;
        $event_date = isset($_POST['occurrence']) ? sanitize_text_field($_POST['occurrence']) : false;
        $invitation_information = isset($_POST['invitation_information']) && !empty($_POST['invitation_information']) ? sanitize_textarea_field( $_POST['invitation_information'] ) : false;

        if(!$event_id || !$event_date || !$invitation_information){

            $r['error_message'] = __( 'Please enter all fields correctly', 'mec-rsvp' );
            wp_send_json( $r );
        }

        $invitation_information = explode(PHP_EOL,$invitation_information);

        $invites = array();
        foreach($invitation_information as $invitation){

            if(empty($invitation)){

                continue;
            }

            $invite = explode(',',$invitation);
            $email = isset($invite[0]) && !empty($invite[0]) ? $invite[0] : false;
            if(1 === count($invite)){

                $invites[$email] = $email;
            }else{

                $invites[$email]['email'] = $email;
                $name = isset($invite[1]) && !empty($invite[1]) ? $invite[1] : false;
                if($name){

                    $invites[$email]['name'] = $name;
                }
            }
        }

        if(!empty($invites)){

            $email_notification_handler = new EmailInvite();
            $success = $email_notification_handler->send( $event_id, $event_date, $invites );
            if($success){

                $r['success_message'] = count($success) .' '. __('Emails were sent','mec-rsvp');
                $r['success'] = (bool)$success;
            }
        }

        if(!isset($r['success']) || !$r['success']){
            $r['error_message'] = __( 'Failed.', 'mec-rsvp' );
        }

        wp_send_json($r);
    }

    public static function enqueue(){

        wp_enqueue_script('mec-select2-script');
        wp_enqueue_style('mec-select2-style');

        ?>
        <script>
            jQuery(document).ready(function($){

                var mec_rsvp = {
                    ajax_url : "<?php echo admin_url('admin-ajax.php'); ?>",
                    error_params : "<?php esc_html_e( 'Please enter all fields correctly', 'mec-rsvp' ); ?>"
                };

                $(".mec-select2").select2();

                $('#mec-events').on('change', function (e) {
                    e.preventDefault();
                    var form = $(this).parents('form').get(0);
                    var id = $('#mec-events').val();
                    $.ajax({
                        url: mec_rsvp.ajax_url,
                        type: 'POST',
                        data: {
                            action: 'report_event_dates',
                            nonce: $('#_mecnonce',form).val(),
                            event_id: id,
                        },
                        success: function (r) {
                            var options_html = $(r).html();
                            if(options_html.length > 0){

                                $('#mec-event-occurrences option',form).remove();
                                $('#mec-event-occurrences',form).append(options_html);
                                $('.mec-event-occurrences-row',form).removeClass('hidden');
                            }else{

                                $('.mec-event-occurrences-row',form).addClass('hidden');
                            }
                        },
                    });
                });

                $('#mec-rsvp-send-invitation-emails').on('click',function(e){

                    e.preventDefault();
                    var btn = $(this);
                    var form = $(this).parents('form').get(0);
                    var event_id = $('#mec-events',form).val();
                    var occurrence = $('#mec-event-occurrences',form).val();
                    var invitation_information = $('#mec-invitation-information',form).val();

                    if( event_id.length == 0 || occurrence.length == 0 || invitation_information.length == 0 ){
                        alert(mec_rsvp.error_params);

                        return false;
                    }

                    var data = {
                        action: 'mec_rsvp_send_invitation_emails',
                        nonce: $('#_mec_sie_nonce',form).val(),
                        event_id: event_id,
                        occurrence: occurrence,
                        invitation_information : invitation_information,
                    };

                    $(btn).prop('disabled',true);
                    $.ajax({
                        url: mec_rsvp.ajax_url,
                        type: 'POST',
                        data: data,
                        success: function (r) {

                            if(true === r.success){

                                if(r.success_message){

                                    $('.mec-message-box',form).html(
                                        '<div class="notice notice-success is-dismissible"><p>'+r.success_message+'</p></div>'
                                    );
                                }
                            }else{

                                if(r.error_message){

                                    $('.mec-message-box',form).html(
                                        '<div class="notice notice-error is-dismissible"><p>'+r.error_message+'</p></div>'
                                    );
                                }
                            }

                            $(btn).prop('disabled',false);
                        },
                    });

                    return false;
                });
            });
        </script>
        <style>
            #webnus-dashboard #mec-rsvp-send-invitation-emails{
                background: #19cde9;
                border: none;
                color: #fff;
                font-size: 13px!important;
                padding: 6px 16px;
                border-radius: 2px;
                cursor: pointer;
                box-shadow: 0 1px 2px rgb(25 205 233 / 25%);
                transition: all .2s ease;
            }

            #webnus-dashboard{
                max-width: 1040px;
                margin: 25px auto 20px;
            }
        </style>
        <?php
    }

    public static function display_page(){

        self::enqueue();

        ?>
        <div id="webnus-dashboard" class="wrap mec-addons">
            <h1 class="mec-form-subtitle"><?php echo get_admin_page_title() ?></h1>

            <form action="" method="post">
                <div class="mec-message-box"></div>
                <?php wp_nonce_field( 'mec_settings_nonce', '_mecnonce' ) ?>
                <?php wp_nonce_field( 'mec_send_invitation_email_nonce', '_mec_sie_nonce' ) ?>
                <div class="mec-form-row mec-events-row">
                    <div class="mec-col-4 mec-select-wrap">
                        <select id="mec-events" class="mec-select2">
                            <option value=""><?php esc_html_e('Select an event','mec-rsvp'); ?></option>
                            <?php
                                $events = EventsQuery::getInstance()->get_events(array(
                                    'posts_per_page' => -1
                                ));

                                foreach($events as $event){

                                    echo '<option value="'.$event->ID.'">'.$event->post_title.'</option>';
                                }
                            ?>
                        </select>
                    </div>

                    <div class="mec-col-4 mec-select-wrap mec-event-occurrences-row hidden" style="margin:0 5px">
                        <select id="mec-event-occurrences" class="mec-select2"></select>
                    </div>
                </div>

                <div class="mec-form-row mec-invitation-information">
                    <label class="mec-col-12" for="mec-invitation-information"><?php esc_html_e('Invitation information','mec-rsvp') ?></label>
                    <div class="mec-col-12">
                        <textarea style="padding:20px; margin-top: 10px;" id="mec-invitation-information" class="mec-col-11" placeholder="<?php esc_attr_e('Email1 , Name1 '.PHP_EOL.'Email2 , Name2','mec-rsvp') ?>"></textarea>
                        <span class="mec-tooltip">
                            <div class="box left">
                                <h5 class="title"><?php esc_html_e('Invitation information','mec-rsvp') ?></h5>
                                <div class="content">
                                    <p>
                                        <?php esc_html_e('Write the information about each invitation in one line as follows.','mec-rsvp') ?>
                                        <br>
                                        <?php esc_html_e('Email , Name','mec-rsvp') ?>
                                    </p>
                                </div>
                            </div>
                            <i title="" class="dashicons-before dashicons-editor-help"></i>
                        </span>
                    </div>
                </div>
                <?php submit_button( __('Send','mec-rsvp'), 'primary', 'mec-rsvp-send-invitation-emails'); ?>
            </form>
        </div>
        <?php
    }
}