<?php

namespace MEC_RSVP\RSVP;

use MEC\Events\EventsQuery;
use MEC_RSVP\RSVP\Notifications\EmailCustom;

class SendRSVPMailPage{

    public static function send_rsvp_mail_by_ajax(){

        $r = array(
            'success' => false,
        );
        $nonce = isset($_POST['nonce']) ? sanitize_text_field( $_POST['nonce'] ) : false;
        if(!$nonce || !wp_verify_nonce( $nonce, 'mec_rsvp_email_nonce' )){

            $r['error_message'] = __('Please refresh the page and try again','mec-rsvp');
            wp_send_json( $r );
        }

        $event_id = isset($_POST['event_id']) && is_numeric($_POST['event_id']) ? (int)$_POST['event_id'] : false;
        $event_date = isset($_POST['occurrence']) ? sanitize_text_field($_POST['occurrence']) : false;
        $answer = isset($_POST['answer']) && !empty($_POST['answer']) ? sanitize_textarea_field( $_POST['answer'] ) : false;
        $message = isset($_POST['message']) && !empty($_POST['message']) ? sanitize_textarea_field( $_POST['message'] ) : false;
        $subject = isset($_POST['subject']) && !empty($_POST['subject']) ? sanitize_textarea_field( $_POST['subject'] ) : false;

        if(!$event_id || !$event_date || !$message || !$answer || !$subject){

            $r['error_message'] = __( 'Please enter all fields correctly', 'mec-rsvp' );
            wp_send_json( $r );
        }

        $attendees = EventRSVP::getInstance()->get_attendees(
            $event_id,
            $event_date,
            $answer,
            ''
        );

        $email_notification_handler = new EmailCustom();

        $mail_arg = array(
            'subject' => $subject,
            'message' => $message,
        );
        $success = $email_notification_handler->send( $mail_arg ,$attendees );

        if($success){

            $r['success_message'] = count($success) .' '. __('Emails were sent','mec-rsvp');
            $r['success'] = (bool)$success;
        }


        if(!isset($r['success']) || !$r['success']){
            $r['error_message'] = __( 'Failed.', 'mec-rsvp' );
        }

        wp_send_json($r);
    }

    public static function get_report_answers_by_ajax(){

        $r = array(
            'success' => false,
        );
        $nonce = isset($_POST['nonce']) ? sanitize_text_field( $_POST['nonce'] ) : false;
        if(!$nonce || !wp_verify_nonce( $nonce, 'mec_settings_nonce' )){

            $r['error_message'] = __('Please refresh the page and try again','mec-rsvp');
            wp_send_json( $r );
        }

        $event_id = isset($_POST['event_id']) && is_numeric($_POST['event_id']) ? (int)$_POST['event_id'] : false;
        $event_date = isset($_POST['occurrence']) ? sanitize_text_field($_POST['occurrence']) : false;

        if( !$event_id || !$event_date ){

            $r['error_message'] = __( 'Please enter all fields correctly', 'mec-rsvp' );
            wp_send_json( $r );
        }

        $answers = array(
            'yes'   => __( 'Yes', 'mec-rsvp' ),
            'maybe' => __( 'Maybe', 'mec-rsvp' ),
            'no'    => __( 'No', 'mec-rsvp' ),
        );

        $all = 0;
        $options = '';
        $reports = EventRSVP::getInstance()->get_rsvp_reports( $event_id, $event_date );
        foreach( $reports as $answer_id => $attendees_data ){

            $answer_text = $answers[ $answer_id ];
            //TODO: Convert RSVP count to email count
            $total_attendees = count( $attendees_data );
            $all += $total_attendees;
            $options .= '<option value="'. esc_attr( $answer_id ) .'">' . $answer_text . ' ( '. $total_attendees .' )</option>';
        }

        $r['success'] = true;
        if( !empty( $options ) ){

            $options =
                '<option value="all">' . esc_html__( 'All', 'mec-rsvp' ) . ' ( '. (int)$all .' )</option>'
                . $options;
        }else{

            $r['error_message'] = __( 'No Attendees Found!', 'mec-rsvp' );
        }

        $r['options_html'] = $options;

        wp_send_json( $r );
    }

    public static function enqueue(){

        wp_enqueue_script('mec-select2-script');
        wp_enqueue_style('mec-select2-style');

        ?>
        <script>
            jQuery(document).ready(function($){

                var mec_rsvp = {
                    ajax_url : "<?php echo admin_url('admin-ajax.php'); ?>",
                    error_params : "<?php esc_html_e( 'Please enter all fields correctly', 'mec-rsvp' ); ?>"
                };

                $(".mec-select2").select2();

                $('#mec-events').on('change', function (e) {
                    e.preventDefault();
                    var form = $(this).parents('form').get(0);
                    var id = $('#mec-events').val();

                    $('.mec-message-box div',form).remove();
                    $('.mec-send-mail-notice *',form).remove();

                    $.ajax({
                        url: mec_rsvp.ajax_url,
                        type: 'POST',
                        data: {
                            action: 'report_event_dates',
                            nonce: $('#_mecnonce',form).val(),
                            event_id: id,
                        },
                        success: function (r) {
                            var options_html = $(r).html();
                            if(options_html.length > 0){

                                $('#mec-event-occurrences option',form).remove();
                                $('#mec-event-occurrences',form).append(options_html);
                                $('.mec-event-occurrences-row',form).removeClass('hidden');
                            }else{

                                $('.mec-event-occurrences-row',form).addClass('hidden');
                            }

                            $('.mec-rsvp-answer-row',form).addClass('hidden');
                            $('.mec-send-mail-inputs',form).addClass('hidden');

                            if(r.error_message){

                                $('.mec-message-box',form).html(
                                    '<div class="notice notice-error is-dismissible"><p>'+r.error_message+'</p></div>'
                                );
                            }

                        },
                    });
                });

                $('#mec-event-occurrences').on('change', function (e) {
                    e.preventDefault();
                    var form = $(this).parents('form').get(0);
                    var event_id = $('#mec-events',form).val();
                    var occurrence = $('#mec-event-occurrences',form).val();

                    $('.mec-message-box div',form).remove();
                    $('.mec-send-mail-notice *',form).remove();

                    $.ajax({
                        url: mec_rsvp.ajax_url,
                        type: 'POST',
                        data: {
                            action: 'mec_rsvp_event_answers',
                            nonce: $('#_mecnonce',form).val(),
                            event_id: event_id,
                            occurrence: occurrence,
                        },
                        success: function (r) {

                            var options_html = r.options_html;

                            if(r.success_message){

                                $('.mec-message-box',form).html(
                                    '<div class="notice notice-success is-dismissible"><p>'+r.success_message+'</p></div>'
                                );
                            }

                            if(r.error_message){

                                $('.mec-send-mail-notice',form).html(
                                    '<p>'+r.error_message+'</p>'
                                );
                            }


                            if(options_html.length > 0){

                                $('#mec-rsvp-answer option',form).remove();
                                $('#mec-rsvp-answer',form).append(options_html);
                                $('.mec-rsvp-answer-row',form).removeClass('hidden');
                                $('.mec-send-mail-inputs',form).removeClass('hidden');
                                $('.mec-send-mail-notice',form).addClass('hidden');
                            }else{

                                $('.mec-rsvp-answer-row',form).addClass('hidden');
                                $('.mec-send-mail-inputs',form).addClass('hidden');
                                $('.mec-send-mail-notice',form).removeClass('hidden');
                            }

                        },
                    });
                });

                $('#mec-rsvp-send-mail').on('click',function(e){

                    e.preventDefault();
                    var btn = $(this);
                    jQuery("#mec-email-content-html").click();
                    jQuery("#mec-email-content-tmce").click();

                    var form = $(this).parents('form').get(0);
                    var event_id = $('#mec-events',form).val();
                    var occurrence = $('#mec-event-occurrences',form).val();
                    var answer = $('#mec-rsvp-answer',form).val();
                    var subject = $('#mec-email-subject',form).val();
                    var message = $('#mec-email-content',form).val();

                    if( event_id.length == 0 || occurrence.length == 0 || message.length == 0 || subject.length == 0 ){

                        alert(mec_rsvp.error_params);
                        return false;
                    }

                    var data = {
                        action: 'mec_rsvp_send_mail',
                        nonce: $('#_mec_sie_nonce',form).val(),
                        event_id: event_id,
                        occurrence: occurrence,
                        answer : answer,
                        subject : subject,
                        message : message,
                    };

                    $('.mec-message-box div',form).remove();

                    $(btn).prop('disabled',true);
                    $.ajax({
                        url: mec_rsvp.ajax_url,
                        type: 'POST',
                        data: data,
                        success: function (r) {

                            if(true === r.success){

                                if(r.success_message){

                                    $('.mec-message-box',form).html(
                                        '<div class="notice notice-success is-dismissible"><p>'+r.success_message+'</p></div>'
                                    );
                                }
                            }else{

                                if(r.error_message){

                                    $('.mec-message-box',form).html(
                                        '<div class="notice notice-error is-dismissible"><p>'+r.error_message+'</p></div>'
                                    );
                                }
                            }

                            $('html, body').animate({
                                scrollTop: $("#mec-message-box").offset().top - 50
                            }, 1000);

                            $(btn).prop('disabled',false);
                        },
                    });

                    return false;
                });
            });
        </script>
        <style>
            #webnus-dashboard #mec-rsvp-send-mail{
                background: #19cde9;
                border: none;
                color: #fff;
                font-size: 13px!important;
                padding: 6px 16px;
                border-radius: 2px;
                cursor: pointer;
                box-shadow: 0 1px 2px rgb(25 205 233 / 25%);
                transition: all .2s ease;
            }

            #webnus-dashboard{
                max-width: 1040px;
                margin: 25px auto 20px;
            }

            .mec-send-mail-notice{
                padding: 0 10px;
                background-color: #fff;
                border: 1px solid #96e3ef;
                margin: 20px 0;
                border-radius: 3px;
                box-shadow: 0 2px 14px rgb(25 205 233 / 10%);
            }
        </style>
        <?php
    }

    public static function display_page(){

        self::enqueue();

        $placeholders = array(
            '%%blog_name%%' => __('Your website title', 'mec-rsvp'),
            '%%blog_url%%' => __('Your website URL', 'mec-rsvp'),
            '%%blog_description%%' => __('Your website description', 'mec-rsvp'),

            '%%first_name%%' => __('First name of attendee', 'mec-rsvp'),
            '%%last_name%%' => __('Last name of attendee', 'mec-rsvp'),
        );

        ?>
        <div id="webnus-dashboard" class="wrap mec-addons">
            <h1 class="mec-form-subtitle"><?php echo get_admin_page_title() ?></h1>

            <form action="" method="post">
                <div class="mec-message-box" id="mec-message-box"></div>
                <?php wp_nonce_field( 'mec_settings_nonce', '_mecnonce' ) ?>
                <?php wp_nonce_field( 'mec_rsvp_email_nonce', '_mec_sie_nonce' ) ?>
                <div class="mec-form-row mec-events-row">
                    <div class="mec-col-4 mec-select-wrap">
                        <select id="mec-events" class="mec-select2">
                            <option value=""><?php esc_html_e('Select an event','mec-rsvp'); ?></option>
                            <?php
                                $events = EventsQuery::getInstance()->get_events(array(
                                    'posts_per_page' => -1
                                ));

                                foreach($events as $event){

                                    echo '<option value="'.$event->ID.'">'.$event->post_title.'</option>';
                                }
                            ?>
                        </select>
                    </div>

                    <div class="mec-col-4 mec-select-wrap mec-event-occurrences-row hidden" style="margin:0 5px">
                        <select id="mec-event-occurrences" class="mec-select2"></select>
                    </div>

                    <div class="mec-col-4 mec-select-wrap mec-rsvp-answer-row hidden" style="margin:0 5px">
                        <select id="mec-rsvp-answer" class="mec-select2"></select>
                    </div>
                </div>

                <div class="mec-send-mail-notice hidden"></div>

                <div class="mec-send-mail-inputs hidden">
                    <div class="mec-form-row mec-email-subject-row">
                        <label class="mec-col-12" for="mec-email-subject"><?php esc_html_e('Subject','mec-rsvp') ?></label>
                        <div class="mec-col-12">
                            <input type="text" name="mec-email-subject" id="mec-email-subject" placeholder="<?php esc_html_e( 'Subject' ,'mec-rsvp') ?>">
                        </div>
                    </div>

                    <div class="mec-form-row mec-email-content-row">
                        <label class="mec-col-12" for="mec-email-content"><?php esc_html_e('Message','mec-rsvp') ?></label>
                        <div class="mec-col-12">
                            <?php
                                $content = '';
                                wp_editor( $content, 'mec-email-content' );
                            ?>
                        </div>
                    </div>

                    <div class="mec-form-row">
                        <div class="mec-col-12">
                            <p class="description"><?php _e('You can use the following placeholders', 'mec'); ?></p>
                            <ul>
                                <?php foreach($placeholders as $p_key => $p_text): ?>
                                    <li><span><?php echo $p_key ?></span>: <?php echo $p_text; ?></li>
                                <?php endforeach; ?>
                                <?php do_action( 'mec_extra_field_notifications', 'rsvp_custom_email' ); ?>
                            </ul>
                        </div>
                    </div>
                    <?php submit_button( __('Send','mec-rsvp'), 'primary', 'mec-rsvp-send-mail'); ?>
                </div>
            </form>
        </div>
        <?php
    }
}