<?php

namespace MEC_RSVP\RSVP;

use MEC\Events\Event;
use MEC\Settings\Settings;
use MEC\Singleton;

class ShortcodeRSVPForm{

    public static $enqueue;

    public static function enqueue(){
        if(self::$enqueue){
            return;
        }
        self::$enqueue = true;
        ?>

        <?php
    }

    public static function render($atts = []){

        $atts = shortcode_atts(array(
            'event-id' => get_the_ID(),
            'show-event-title' => 'hide',
        ), $atts );

        $event_id = $atts['event-id'];
        if('mec-events' !== get_post_type($event_id)){

            return;
        }

		$can_display = EventRSVP::getInstance()->can_display_rsvp_form($event_id);
		if(is_wp_error( $can_display )){

            $login_url = wp_login_url();
            $e_code = $can_display->get_error_code();
            return 'not-logged-in' === $e_code ? '<div class="mec-events-meta-group-booking mec-custom-form-box mec-rsvp-form-box"><div class="mec-error">'. __('You must be logged in to participate in RSVP.','mec-rsvp').'  <a href="'.$login_url.'">'.__('Login','mec-rsvp').'</a></div></div>' : '';
        }

        if(!$can_display){

			return;
		}

        $html = '';
        if( 'show' === $atts['show-event-title'] ){

            $html .= '<h2>'. get_the_title( $atts['event-id'] ) .'</h2>';
        }

        return $html . DisplayForm::getInstance()->output( (int)$event_id );
    }
}