<?php

namespace MEC_RSVP\RSVP;

use MEC\Singleton;
use MEC\Events\Event;
use MEC\Settings\Settings;

class ShortcodeRSVPList{

    public static $enqueue;

    public static function enqueue(){
        if(self::$enqueue){
            return;
        }
        self::$enqueue = true;
        ?>
        <style>

            .mec-rsvps .mec-profile {
                overflow: visible;
            }

            .mec-profile .mec-profile-rsvps {
                border: 2px solid #e6e6e6;
                text-align: center;
            }

            .mec-profile .mec-profile-rsvps tbody tr:first-child {
                background: #f7f7f7;
                font-weight: bold;
                text-transform: capitalize;
            }

            .mec-profile .mec-profile-rsvps tbody tr {
                border-bottom: 1px solid #e6e6e6;
                font-size: 14px;
            }

            .mec-profile .mec-profile-rsvps tbody tr td {
                border: 1px solid #e6e6e6;
                padding: 10px;
                text-align: center;
                word-break: initial;
            }

            .mec-profile .mec-profile-rsvps tbody tr td:nth-child(1) {
                width: 5%;
            }

            .mec-profile .mec-profile-rsvps tbody tr td:nth-child(2) {
                width: 53%;
                text-align: left;
            }

            .mec-profile .mec-profile-rsvps tbody tr td:nth-child(3) {
                width: 7%;
            }

            .mec-profile .mec-profile-rsvps tbody tr td:nth-child(4) {
                width: 7%;
            }

            .mec-profile .mec-profile-rsvps tbody tr td:nth-child(5) {
                width: 7%;
            }

            .mec-profile .mec-profile-rsvps tbody tr td:nth-child(6) {
                width: 7%;
            }

            .mec-profile .mec-profile-rsvps tbody tr td:nth-child(7) {
                width: 7%;
            }

            .mec-profile .mec-profile-rsvps tbody tr td:nth-child(8) {
                width: 7%;
            }

            .mec-profile .mec-profile-rsvps tbody tr td:nth-child(8) i {
                color: #fe686a;
            }

            .mec-profile .mec-event-status {
                padding: 5px 10px;
                color: #fff;
                border-radius: 2px;
                font-size: 12px;
                line-height: 12px;
                letter-spacing: 0.4px;
            }

            .mec-profile .mec-event-status.mec-rsvp-confirmed {
                background: #50d477;
            }

            .mec-profile .mec-event-status.mec-rsvp-pending {
                background: #fcbe69;
            }

            .mec-profile .mec-event-status.mec-rsvp-rejected {
                background: #fe686a;
            }

            .mec-profile .mec-event-date {
                font-size: 12px;
                color: #888;
            }

            /* MEC Profile date and status with icon */
            .mec-event-status,
            .mec-event-date {
                text-align: center;
            }

            .mec-event-status .mec-tooltip,
            .mec-event-date .mec-tooltip {
                position: relative;
                width: fit-content;
                margin: auto;
            }

            .mec-profile i {
                font-size: 15px;
                color: #008aff;
                vertical-align: text-bottom;
                margin-right: 4px;
            }

            .mec-event-status .mec-tooltip .box,
            .mec-event-date .mec-tooltip .box {
                min-width: 250px;
                max-width: 300px;
                display: inline-block;
                top: -8px;
                left: 50%;
                margin-top: 0;
                transform: translate(-50%, -100%);
                padding: 0;
                background-color: #000;
                color: #fff;
                font-weight: 400;
                font-size: 14px;
                letter-spacing: 0.5px;
                line-height: 1.5;
                position: absolute;
                z-index: 99999999;
                box-sizing: border-box;
                border-radius: 6px;
                box-shadow: 0 4px 45px -8px #535a61;
                padding: 5px 10px 6px;
                border-radius: 8px;
                text-align: center;
                font-style: normal;
                opacity: 0;
                visibility: hidden;
                display: none;
            }

            .mec-event-date .mec-tooltip .box,
            .mec-event-status .mec-tooltip .box {
                font-size: 13px;
                font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto,
                    sans-serif !important;
                letter-spacing: 1.1px;
                font-weight: 500;
            }

            .mec-event-status .mec-tooltip:hover .box:after,
            .mec-event-date .mec-tooltip:hover .box:after {
                content: "";
                position: absolute;
                width: 12px;
                height: 12px;
                left: calc(50% - 12px);
                bottom: -12px;
                transform: translate(50%, -50%) rotate(-45deg);
                background-color: #000;
                box-shadow: 0 8px 9px -4px #535a61;
            }

            .mec-event-status .mec-tooltip .box {
                min-width: 100px;
            }

            .mec-event-status.mec-rsvp-confirmed .mec-tooltip:hover .box:after,
            .mec-event-status.mec-rsvp-confirmed .mec-tooltip .box {
                background-color: #50d477;
            }

            .mec-event-status.mec-rsvp-rejected .mec-tooltip:hover .box:after,
            .mec-event-status.mec-rsvp-rejected .mec-tooltip .box {
                background-color: #fe686a;
            }

            .mec-event-status.mec-rsvp-pending .mec-tooltip:hover .box:after,
            .mec-event-status.mec-rsvp-pending .mec-tooltip .box {
                background-color: #fcbe69;
            }

            .mec-event-status .mec-tooltip:hover .box,
            .mec-event-date .mec-tooltip:hover .box {
                opacity: 1;
                visibility: visible;
                display: block;
            }

            .mec-profile .mec-event-status {
                padding: 0;
            }

            .mec-profile .mec-rsvp-number-of-attendees {
                font-size: 13px;
                color: #888;
            }

            .mec-profile .mec-rsvp-number-of-attendees i,
            .mec-profile .mec-profile-rsvps-view-invoice i {
                font-size: 15px;
                color: #008aff;
                vertical-align: text-bottom;
                margin-right: 4px;
            }

            .mec-rsvp-attendees {
                overflow-x: auto;
                max-width: 850px;
                width: 100%;
                text-align: center;
                background: #fff;
                padding: 10px;
            }

            .mec-rsvp-attendees-wrapper {
                border: 2px solid #e6e6e6;
                font-size: 14px;
            }

            .mec-rsvp-attendees-head {
                display: table;
                width: 100%;
                background: #f7f7f7;
                border-bottom: 1px solid #e6e6e6;
                font-weight: bold;
            }

            .mec-rsvp-attendees-head span,
            .mec-rsvp-attendees-head-content > span {
                vertical-align: middle;
                display: table-cell;
                padding: 7px;
                border-right: 1px solid #e6e6e6;
                font-size: 12px;
            }

            .mec-rsvp-attendees-head-content {
                display: table;
                width: 100%;
                border-bottom: 1px solid #e6e6e6;
            }

            .mec-rsvp-attendees-wrapper .mec-rsvp-attendees-head-content:last-child {
                border: none;
            }

            .mec-rsvp-attendees-head span:nth-child(1),
            .mec-rsvp-attendees-head-content > span:nth-child(1) {
                width: 4%;
            }

            .mec-rsvp-attendees-head span:nth-child(2),
            .mec-rsvp-attendees-head-content > span:nth-child(2) {
                width: 20%;
            }

            .mec-rsvp-attendees-head span:nth-child(3),
            .mec-rsvp-attendees-head-content > span:nth-child(3) {
                width: 24%;
            }

            .mec-rsvp-attendees-head span:nth-child(4),
            .mec-rsvp-attendees-head-content > span:nth-child(4) {
                width: 26%;
            }

            .mec-rsvp-attendees-head span:nth-child(5),
            .mec-rsvp-attendees-head-content > span:nth-child(5) {
                width: 26%;
            }

            @media only screen and (max-width: 759px) {

                .mec-rsvp-attendees-head span,
                .mec-rsvp-attendees-head-content > span {
                    word-break: break-all;
                }
            }

            /* User Profile Responsive */
            @media (max-width: 1366px) {
                .mec-profile .mec-profile-rsvps tbody tr td:nth-child(1) {
                    width: 6%;
                }

                .mec-profile .mec-profile-rsvps tbody tr td:nth-child(2) {
                    width: 40%;
                }

                .mec-profile .mec-profile-rsvps tbody tr td:nth-child(3) {
                    width: 8%;
                }

                .mec-profile .mec-profile-rsvps tbody tr td:nth-child(4) {
                    width: 8%;
                }

                .mec-profile .mec-profile-rsvps tbody tr td:nth-child(5) {
                    width: 12%;
                }

                .mec-profile .mec-profile-rsvps tbody tr td:nth-child(6) {
                    width: 10%;
                }

                .mec-profile .mec-profile-rsvps tbody tr td:nth-child(7) {
                    width: 8%;
                }

                .mec-profile .mec-profile-rsvps tbody tr td:nth-child(8) {
                    width: 8%;
                }
            }

            @media (max-width: 1024px) {
                .mec-profile .mec-profile-rsvps tbody tr td:nth-child(1) {
                    width: 5%;
                }

                .mec-profile .mec-profile-rsvps tbody tr td:nth-child(2) {
                    width: 30%;
                }

                .mec-profile .mec-profile-rsvps tbody tr td:nth-child(3) {
                    width: 10%;
                }

                .mec-profile .mec-profile-rsvps tbody tr td:nth-child(4) {
                    width: 10%;
                }

                .mec-profile .mec-profile-rsvps tbody tr td:nth-child(5) {
                    width: 15%;
                }

                .mec-profile .mec-profile-rsvps tbody tr td:nth-child(6) {
                    width: 10%;
                }

                .mec-profile .mec-profile-rsvps tbody tr td:nth-child(7) {
                    width: 10%;
                }

                .mec-profile .mec-profile-rsvps tbody tr td:nth-child(8) {
                    width: 10%;
                }
            }

            @media (max-width: 780px) {
                .mec-rsvps .mec-profile {
                    overflow-x: auto;
                }

                .mec-profile i,
                .mec-profile .mec-profile-rsvps tbody tr {
                    font-size: 12px;
                }

                .mec-event-date .mec-tooltip .box {
                    min-width: 200px;
                }

                .mec-event-status .mec-tooltip .box {
                    min-width: 90px;
                }

                .mec-event-date .mec-tooltip .box,
                .mec-event-status .mec-tooltip .box {
                    padding: 4px 5px !important;
                }

                .mec-profile .mec-profile-rsvps tbody tr {
                    font-size: 12px;
                }
            }

            @media (max-width: 480px) {
                .mec-profile .mec-rsvp-number-of-attendees,
                .mec-profile i,
                .mec-profile .mec-profile-rsvps tbody tr {
                    font-size: 8px !important;
                }

                .mec-profile .mec-profile-rsvps tbody tr td {
                    padding: 3px;
                }

                .mec-profile .mec-profile-rsvps tbody tr td:nth-child(1) {
                    width: 5%;
                }

                .mec-profile .mec-profile-rsvps tbody tr td:nth-child(2) {
                    width: 19%;
                }

                .mec-profile .mec-profile-rsvps tbody tr td:nth-child(3) {
                    width: 10%;
                }

                .mec-profile .mec-profile-rsvps tbody tr td:nth-child(4) {
                    width: 12%;
                }

                .mec-profile .mec-profile-rsvps tbody tr td:nth-child(5) {
                    width: 18%;
                }

                .mec-profile .mec-profile-rsvps tbody tr td:nth-child(6) {
                    width: 13%;
                }

                .mec-profile .mec-profile-rsvps tbody tr td:nth-child(7) {
                    width: 10%;
                }

                .mec-profile .mec-profile-rsvps tbody tr td:nth-child(8) {
                    width: 13%;
                }

                .mec-event-date .mec-tooltip .box,
                .mec-event-status .mec-tooltip .box {
                    font-size: 8px;
                }

                .mec-event-date .mec-tooltip .box {
                    min-width: 75px;
                }

                .mec-event-status .mec-tooltip .box {
                    min-width: 70px;
                }

                .mec-event-date .mec-tooltip .box,
                .mec-event-status .mec-tooltip .box {
                    padding: 4px 5px !important;
                }
            }

            .mec-fa-rsvp-edit::before{
                content: "\f044";
            }

            .single-mec-events .lity-container {
                max-width: none;
                width: auto;
            }

        </style>
        <?php
    }

    public static function render($atts = []){

        $atts = shortcode_atts(array(
            'event_id' => false,
            'user_id' =>  get_current_user_id(),
            'hide_actions' => 'no'
        ), $atts );

        if(!is_user_logged_in()){

            return self::display_login_form_or_message();
        }

        return self::display_rsvps($atts);
    }

    public static function display_rsvps( $atts ){

        $q_args = self::get_rsvps_query_args( $atts );

        $date_format = Settings::getInstance()->get_settings('rsvp_date_format1');
        $time_format = get_option('time_format');

        $datetime_format = $date_format .' '.$time_format;

        $query = new \WP_Query($q_args);

        $id = 1;
        ob_start();
        self::enqueue();
        ?>
        <div class="mec-profile">
            <?php if($query->have_posts()): ?>
            <table class="mec-profile-rsvps">
                <tr>
                    <td><?php esc_html_e('#' , 'mec-rsvp'); ?></td>
                    <td><?php esc_html_e('Event' , 'mec-rsvp'); ?></td>
                    <td><?php esc_html_e('Date' , 'mec-rsvp'); ?></td>
                    <td><?php esc_html_e('Status' , 'mec-rsvp'); ?></td>
                    <td><?php esc_html_e('Attendees' , 'mec-rsvp'); ?></td>
                    <td><?php esc_html_e('Response' , 'mec-rsvp'); ?></td>
                    <?php if( 'yes' !== $atts['hide_actions'] ): ?>
                        <td><?php esc_html_e('Actions' , 'mec-rsvp'); ?></td>
                    <?php endif; ?>
                </tr>

                <?php
                while($query->have_posts()):

                    $query->the_post();
                    $rsvp_id = get_the_ID();

                    $rsvp = new RSVP($rsvp_id);
                    $event_id = $rsvp->get_event_id();
                    $answer_id = $rsvp->get_answer();
                    $answer = $rsvp->get_answer_text();
                    $total_attendees = $rsvp->get_attendees_count();
                    $event_date = $rsvp->get_event_times('start');
                    $creator_email = $rsvp->get_creator_email();


                    $confirmed = $rsvp->get_confirm_status();
                    $verified = $rsvp->get_verification_status();

                    if($confirmed == '1') {
                        $status_class = 'mec-rsvp-confirmed';
                    } elseif($confirmed == '-1') {
                        $status_class = 'mec-rsvp-rejected';
                    } else{
                        $status_class = 'mec-rsvp-pending';
                    }

                    $timestamps = explode(':', $rsvp->get_event_times());
                    $start_time = isset($timestamps[0]) ? $timestamps[0] : '';
                    $end_time = isset($timestamps[1]) ? $timestamps[1] : '';

                    $rsvp_options = $rsvp->get_options();
                    $event = new Event($event_id);
                    $event_title = $event->get_title();
                ?>
                    <tr id="mec_profile_rsvp_<?php echo $rsvp_id; ?>">
                        <td>
                            <span class="mec-event-id"><?php echo $event_id; ?></span>
                        </td>
                        <td>
                            <?php if( !$event_id || !$event_title ): ?>
                                <span class="mec-event-title"><?php _e('N/A', 'mec-rsvp'); ?></span>
                            <?php else : ?>
                                <a class="mec-event-title" href="<?php echo get_the_permalink($event_id); ?>"><?php echo $event_title; ?></a>
                            <?php endif; ?>
                        </td>
                        <td>
                            <span class="mec-event-date">
                                <div class="mec-tooltip">
                                    <div class="box">
                                        <?php echo trim(date_i18n($datetime_format, $start_time).' - '.date_i18n($datetime_format, $end_time), '- '); ?>
                                    </div>
                                    <i class="mec-sl-calendar"></i>
                                </div>
                            </span>
                        </td>
                        <td>
                            <span class="mec-event-status <?php echo $status_class;?>">
                                <div class="mec-tooltip">
                                    <div class="box">
                                        <?php echo $rsvp->get_confirm_status_text(); ?>
                                    </div>
                                    <i class="mec-sl-layers"></i>
                                </div>
                            </span>
                        </td>
                        <td>
                            <a class="mec-rsvp-number-of-attendees"  href="#mec_profile_rsvp_<?php echo $rsvp_id; ?>">
                                <?php echo sprintf(__('<i class="mec-sl-eye"></i> %s', 'mec-rsvp'), $total_attendees ); ?>
                            </a>
                        </td>
                        <td>
                            <span class="mec-profile-rsvps-answer">
                                <?php echo $answer; ?>
                            </span>
                        </td>
                        <?php if( 'yes' !== $atts['hide_actions'] ): ?>
                            <td>

                                <span class="mec-profile-rsvps-modification">
                                    <?php if(intval($confirmed) == 0):
                                        $nonce = wp_create_nonce('mec-rsvp-edit-na'.$rsvp_id.$event_date);
                                        ?>
                                        <a href="#" class="mec-edit-rsvp" data-rsvp_id="<?php echo $rsvp_id ?>" data-nonce="<?php echo $nonce; ?>" data-answer_id="<?php echo $answer_id; ?>" data-event_date="<?php echo $event_date; ?>" data-total_attendees="<?php echo $total_attendees; ?>" data-creator_email="<?php echo $creator_email; ?>"><i class="mec-fa-rsvp-edit"></i></a>
                                    <?php endif; ?>
                                </span>

                                <span class="mec-profile-rsvps-cancelation">
                                    <?php if(intval($verified) != -1): ?>
                                    <a href="<?php echo trim(get_permalink($event_id), '/').'/rsvp-cancel/'.get_post_meta($rsvp_id, 'mec_cancellation_key', true).'/'; ?>"><i class="mec-fa-calendar-times-o"></i></a>
                                    <?php else: ?>
                                    <i class="mec-sl-close mec-profile-cancel-rsvp"></i>
                                    <?php endif; ?>
                                </span>
                            </td>
                        <?php endif; ?>
                    </tr>

                    <div id="mec_profile_rsvp_<?php echo $rsvp_id; ?>" class="mec-rsvp-attendees lity-hide">
                        <div class="mec-rsvp-attendees-wrapper">
                            <div class="mec-rsvp-attendees-head">
                                <span class="mec-rsvp-attendee-id">
                                    <?php esc_html_e('#' , 'mec-rsvp'); ?>
                                </span>
                                <span class="mec-rsvp-attendee-name">
                                    <?php esc_html_e('Name' , 'mec-rsvp'); ?>
                                </span>
                                <span class="mec-rsvp-attendee-email">
                                    <?php esc_html_e('Email' , 'mec-rsvp'); ?>
                                </span>
                            </div>
                            <?php

                            $attendees = $rsvp->get_attendees_by_detail_for_each();

                            $person_id = 1;
                            foreach($attendees as $k => $attendee){

                                if(!is_numeric($k)) {

                                    continue;
                                }

                                echo '<div class="mec-rsvp-attendees-head-content">';
                                    echo '<span class="mec-rsvp-attendee-id">'.$person_id.'</span>';
                                    echo '<span class="mec-rsvp-attendee-name">'. $attendee['name'] .'</span>';
                                    echo '<span class="mec-rsvp-attendee-email">'. $attendee['email'] .'</span>';
                                echo '</div>';
                                    $person_id++;
                            }
                            ?>
                        </div>
                    </div>
                    <?php $id++;
                endwhile;
            wp_reset_postdata(); // Restore original Post Data
            ?>
            </table>
            <?php else: ?>
            <p><?php echo __('No RSVPs found!', 'mec-rsvp'); ?></p>
            <?php endif; ?>
        </div>
        <script>
        jQuery( ".mec-rsvp-number-of-attendees" ).on('click',function(e){
            e.preventDefault();
            var attendee_id =  jQuery(this).attr('href');
            lity(attendee_id);
        });
        </script>
        <?php

        return ob_get_clean();
    }

    public static function get_rsvps_query_args( $atts ){

        $q_args = array(
            'post_type' => 'mec_rsvp',
            'fields' => '',
            'posts_per_page' => -1,
            'post_status' => array('publish','pending','draft','future','private'),
            'meta_query' => array(
                'relation' => 'AND',
            ),
        );

        if(!empty($atts['user_id'])){

            $q_args['author'] = $atts['user_id'];
        }

        if(array_key_exists('event_id',$atts) && !empty($atts['event_id'])){

            $q_args['meta_query']['event_id'] = array(
                'key' => 'mec_event_id',
                'value' => $atts['event_id'],
                'compare' => '=',
            );
        }

        if(array_key_exists('email',$atts) && !empty(trim($atts['email']))){

            $q_args['meta_query']['email'] = array(
                'key' => 'mec_primary_attendee_email',
                'value' => $atts['email'],
                'compare' => '=',
            );
        }

        return $q_args;
    }

    public function display_login_form_or_message(){

        return 'user not logged in';//TODO: change
    }
}